/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input to <a>ModifyGlobalCluster</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyGlobalClusterRequest extends DocDbRequest implements
        ToCopyableBuilder<ModifyGlobalClusterRequest.Builder, ModifyGlobalClusterRequest> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalClusterIdentifier").getter(getter(ModifyGlobalClusterRequest::globalClusterIdentifier))
            .setter(setter(Builder::globalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build())
            .build();

    private static final SdkField<String> NEW_GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewGlobalClusterIdentifier")
            .getter(getter(ModifyGlobalClusterRequest::newGlobalClusterIdentifier))
            .setter(setter(Builder::newGlobalClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGlobalClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(ModifyGlobalClusterRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GLOBAL_CLUSTER_IDENTIFIER_FIELD, NEW_GLOBAL_CLUSTER_IDENTIFIER_FIELD, DELETION_PROTECTION_FIELD));

    private final String globalClusterIdentifier;

    private final String newGlobalClusterIdentifier;

    private final Boolean deletionProtection;

    private ModifyGlobalClusterRequest(BuilderImpl builder) {
        super(builder);
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.newGlobalClusterIdentifier = builder.newGlobalClusterIdentifier;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * The identifier for the global cluster being modified. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing global cluster.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing global cluster.
     *         </p>
     *         </li>
     */
    public final String globalClusterIdentifier() {
        return globalClusterIdentifier;
    }

    /**
     * <p>
     * The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase
     * string.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * </p>
     * <p>
     * The first character must be a letter
     * </p>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster2</code>
     * </p>
     * 
     * @return The new identifier for a global cluster when you modify a global cluster. This value is stored as a
     *         lowercase string.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens
     *         </p>
     *         <p>
     *         The first character must be a letter
     *         </p>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster2</code>
     */
    public final String newGlobalClusterIdentifier() {
        return newGlobalClusterIdentifier;
    }

    /**
     * <p>
     * Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when
     * deletion protection is enabled.
     * </p>
     * 
     * @return Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when
     *         deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newGlobalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyGlobalClusterRequest)) {
            return false;
        }
        ModifyGlobalClusterRequest other = (ModifyGlobalClusterRequest) obj;
        return Objects.equals(globalClusterIdentifier(), other.globalClusterIdentifier())
                && Objects.equals(newGlobalClusterIdentifier(), other.newGlobalClusterIdentifier())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyGlobalClusterRequest").add("GlobalClusterIdentifier", globalClusterIdentifier())
                .add("NewGlobalClusterIdentifier", newGlobalClusterIdentifier()).add("DeletionProtection", deletionProtection())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(globalClusterIdentifier()));
        case "NewGlobalClusterIdentifier":
            return Optional.ofNullable(clazz.cast(newGlobalClusterIdentifier()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyGlobalClusterRequest, T> g) {
        return obj -> g.apply((ModifyGlobalClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyGlobalClusterRequest> {
        /**
         * <p>
         * The identifier for the global cluster being modified. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing global cluster.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalClusterIdentifier
         *        The identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing global cluster.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalClusterIdentifier(String globalClusterIdentifier);

        /**
         * <p>
         * The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase
         * string.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * </p>
         * <p>
         * The first character must be a letter
         * </p>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster2</code>
         * </p>
         * 
         * @param newGlobalClusterIdentifier
         *        The new identifier for a global cluster when you modify a global cluster. This value is stored as a
         *        lowercase string.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens
         *        </p>
         *        <p>
         *        The first character must be a letter
         *        </p>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newGlobalClusterIdentifier(String newGlobalClusterIdentifier);

        /**
         * <p>
         * Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when
         * deletion protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted
         *        when deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbRequest.BuilderImpl implements Builder {
        private String globalClusterIdentifier;

        private String newGlobalClusterIdentifier;

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyGlobalClusterRequest model) {
            super(model);
            globalClusterIdentifier(model.globalClusterIdentifier);
            newGlobalClusterIdentifier(model.newGlobalClusterIdentifier);
            deletionProtection(model.deletionProtection);
        }

        public final String getGlobalClusterIdentifier() {
            return globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getNewGlobalClusterIdentifier() {
            return newGlobalClusterIdentifier;
        }

        public final void setNewGlobalClusterIdentifier(String newGlobalClusterIdentifier) {
            this.newGlobalClusterIdentifier = newGlobalClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder newGlobalClusterIdentifier(String newGlobalClusterIdentifier) {
            this.newGlobalClusterIdentifier = newGlobalClusterIdentifier;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        @Transient
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyGlobalClusterRequest build() {
            return new ModifyGlobalClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
