/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dsql.model.DsqlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutClusterPolicyResponse
extends DsqlResponse
implements ToCopyableBuilder<Builder, PutClusterPolicyResponse> {
    private static final SdkField<String> POLICY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyVersion").getter(PutClusterPolicyResponse.getter(PutClusterPolicyResponse::policyVersion)).setter(PutClusterPolicyResponse.setter(Builder::policyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutClusterPolicyResponse.memberNameToFieldInitializer();
    private final String policyVersion;

    private PutClusterPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyVersion = builder.policyVersion;
    }

    public final String policyVersion() {
        return this.policyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutClusterPolicyResponse)) {
            return false;
        }
        PutClusterPolicyResponse other = (PutClusterPolicyResponse)((Object)obj);
        return Objects.equals(this.policyVersion(), other.policyVersion());
    }

    public final String toString() {
        return ToString.builder((String)"PutClusterPolicyResponse").add("PolicyVersion", (Object)this.policyVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyVersion": {
                return Optional.ofNullable(clazz.cast(this.policyVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("policyVersion", POLICY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutClusterPolicyResponse, T> g) {
        return obj -> g.apply((PutClusterPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlResponse.BuilderImpl
    implements Builder {
        private String policyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutClusterPolicyResponse model) {
            super(model);
            this.policyVersion(model.policyVersion);
        }

        public final String getPolicyVersion() {
            return this.policyVersion;
        }

        public final void setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
        }

        @Override
        public final Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        @Override
        public PutClusterPolicyResponse build() {
            return new PutClusterPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DsqlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutClusterPolicyResponse> {
        public Builder policyVersion(String var1);
    }
}

