/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.QueryConditionalUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class BetweenConditional
implements QueryConditional {
    private static final String BETWEEN_NULL_SORT_KEY_ERROR = "Attempt to query using a 'between' condition operator where one of the keys has a null sort key. Index: %s";
    private final Key key1;
    private final Key key2;

    public BetweenConditional(Key key1, Key key2) {
        this.key1 = key1;
        this.key2 = key2;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        QueryConditionalUtils.KeyResolution keyResolution1 = QueryConditionalUtils.resolveKeys(this.key1, tableSchema, indexName);
        QueryConditionalUtils.KeyResolution keyResolution2 = QueryConditionalUtils.resolveKeys(this.key2, tableSchema, indexName);
        this.validateBetweenConstraints(keyResolution1, keyResolution2, indexName);
        return this.buildBetweenExpression(keyResolution1, keyResolution2);
    }

    private void validateBetweenConstraints(QueryConditionalUtils.KeyResolution keyResolution1, QueryConditionalUtils.KeyResolution keyResolution2, String indexName) {
        QueryConditionalUtils.validatePartitionKeyConstraints(keyResolution1, indexName);
        QueryConditionalUtils.validateSortKeyConstraints(keyResolution1, indexName);
        if (!keyResolution1.hasSortValues() || !keyResolution2.hasSortValues() || keyResolution2.sortValues.contains(AttributeValues.nullAttributeValue())) {
            throw new IllegalArgumentException(String.format(BETWEEN_NULL_SORT_KEY_ERROR, indexName));
        }
    }

    private Expression buildBetweenExpression(QueryConditionalUtils.KeyResolution keyResolution1, QueryConditionalUtils.KeyResolution keyResolution2) {
        StringBuilder expression = new StringBuilder();
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        QueryConditionalUtils.addPartitionKeyConditions(expression, names, values, keyResolution1.partitionKeys, keyResolution1.partitionValues);
        QueryConditionalUtils.addNonRightmostSortKeyConditions(expression, names, values, keyResolution1.sortKeys, keyResolution1.sortValues);
        this.addBetweenCondition(expression, names, values, keyResolution1, keyResolution2);
        return QueryConditionalUtils.buildExpression(expression, names, values);
    }

    private void addBetweenCondition(StringBuilder expression, Map<String, String> names, Map<String, AttributeValue> values, QueryConditionalUtils.KeyResolution keyResolution1, QueryConditionalUtils.KeyResolution keyResolution2) {
        String rightmostSortKey = keyResolution1.getRightmostSortKey();
        AttributeValue rightmostSortValue1 = keyResolution1.getRightmostSortValue();
        AttributeValue rightmostSortValue2 = keyResolution2.getRightmostSortValue();
        String keyToken = EnhancedClientUtils.keyRef(rightmostSortKey);
        String valueToken1 = EnhancedClientUtils.valueRef(rightmostSortKey);
        String valueToken2 = (String)QueryConditionalUtils.SECOND_VALUE_TOKEN_MAPPER.apply(rightmostSortKey);
        expression.append(" AND ").append(keyToken).append(" BETWEEN ").append(valueToken1).append(" AND ").append(valueToken2);
        names.put(keyToken, rightmostSortKey);
        values.put(valueToken1, rightmostSortValue1);
        values.put(valueToken2, rightmostSortValue2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenConditional that = (BetweenConditional)o;
        if (this.key1 != null ? !this.key1.equals(that.key1) : that.key1 != null) {
            return false;
        }
        return this.key2 != null ? this.key2.equals(that.key2) : that.key2 == null;
    }

    public int hashCode() {
        int result = this.key1 != null ? this.key1.hashCode() : 0;
        result = 31 * result + (this.key2 != null ? this.key2.hashCode() : 0);
        return result;
    }
}

