/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableKinesisStreamingDestinationRequest extends DynamoDbRequest implements
        ToCopyableBuilder<EnableKinesisStreamingDestinationRequest.Builder, EnableKinesisStreamingDestinationRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(EnableKinesisStreamingDestinationRequest::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(EnableKinesisStreamingDestinationRequest::streamArn))
            .setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<EnableKinesisStreamingConfiguration> ENABLE_KINESIS_STREAMING_CONFIGURATION_FIELD = SdkField
            .<EnableKinesisStreamingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EnableKinesisStreamingConfiguration")
            .getter(getter(EnableKinesisStreamingDestinationRequest::enableKinesisStreamingConfiguration))
            .setter(setter(Builder::enableKinesisStreamingConfiguration))
            .constructor(EnableKinesisStreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableKinesisStreamingConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            STREAM_ARN_FIELD, ENABLE_KINESIS_STREAMING_CONFIGURATION_FIELD));

    private final String tableName;

    private final String streamArn;

    private final EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration;

    private EnableKinesisStreamingDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.streamArn = builder.streamArn;
        this.enableKinesisStreamingConfiguration = builder.enableKinesisStreamingConfiguration;
    }

    /**
     * <p>
     * The name of the DynamoDB table.
     * </p>
     * 
     * @return The name of the DynamoDB table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The ARN for a Kinesis data stream.
     * </p>
     * 
     * @return The ARN for a Kinesis data stream.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The source for the Kinesis streaming information that is being enabled.
     * </p>
     * 
     * @return The source for the Kinesis streaming information that is being enabled.
     */
    public final EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration() {
        return enableKinesisStreamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableKinesisStreamingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableKinesisStreamingDestinationRequest)) {
            return false;
        }
        EnableKinesisStreamingDestinationRequest other = (EnableKinesisStreamingDestinationRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(enableKinesisStreamingConfiguration(), other.enableKinesisStreamingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableKinesisStreamingDestinationRequest").add("TableName", tableName())
                .add("StreamArn", streamArn()).add("EnableKinesisStreamingConfiguration", enableKinesisStreamingConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "EnableKinesisStreamingConfiguration":
            return Optional.ofNullable(clazz.cast(enableKinesisStreamingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableKinesisStreamingDestinationRequest, T> g) {
        return obj -> g.apply((EnableKinesisStreamingDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableKinesisStreamingDestinationRequest> {
        /**
         * <p>
         * The name of the DynamoDB table.
         * </p>
         * 
         * @param tableName
         *        The name of the DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The ARN for a Kinesis data stream.
         * </p>
         * 
         * @param streamArn
         *        The ARN for a Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The source for the Kinesis streaming information that is being enabled.
         * </p>
         * 
         * @param enableKinesisStreamingConfiguration
         *        The source for the Kinesis streaming information that is being enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration);

        /**
         * <p>
         * The source for the Kinesis streaming information that is being enabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnableKinesisStreamingConfiguration.Builder} avoiding the need to create one manually via
         * {@link EnableKinesisStreamingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnableKinesisStreamingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration)}.
         * 
         * @param enableKinesisStreamingConfiguration
         *        a consumer that will call methods on {@link EnableKinesisStreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration)
         */
        default Builder enableKinesisStreamingConfiguration(
                Consumer<EnableKinesisStreamingConfiguration.Builder> enableKinesisStreamingConfiguration) {
            return enableKinesisStreamingConfiguration(EnableKinesisStreamingConfiguration.builder()
                    .applyMutation(enableKinesisStreamingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private String streamArn;

        private EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableKinesisStreamingDestinationRequest model) {
            super(model);
            tableName(model.tableName);
            streamArn(model.streamArn);
            enableKinesisStreamingConfiguration(model.enableKinesisStreamingConfiguration);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final EnableKinesisStreamingConfiguration.Builder getEnableKinesisStreamingConfiguration() {
            return enableKinesisStreamingConfiguration != null ? enableKinesisStreamingConfiguration.toBuilder() : null;
        }

        public final void setEnableKinesisStreamingConfiguration(
                EnableKinesisStreamingConfiguration.BuilderImpl enableKinesisStreamingConfiguration) {
            this.enableKinesisStreamingConfiguration = enableKinesisStreamingConfiguration != null ? enableKinesisStreamingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder enableKinesisStreamingConfiguration(
                EnableKinesisStreamingConfiguration enableKinesisStreamingConfiguration) {
            this.enableKinesisStreamingConfiguration = enableKinesisStreamingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableKinesisStreamingDestinationRequest build() {
            return new EnableKinesisStreamingDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
