/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeExportResponse.Builder, DescribeExportResponse> {
    private static final SdkField<ExportDescription> EXPORT_DESCRIPTION_FIELD = SdkField
            .<ExportDescription> builder(MarshallingType.SDK_POJO).memberName("ExportDescription")
            .getter(getter(DescribeExportResponse::exportDescription)).setter(setter(Builder::exportDescription))
            .constructor(ExportDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ExportDescription", EXPORT_DESCRIPTION_FIELD);
                }
            });

    private final ExportDescription exportDescription;

    private DescribeExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportDescription = builder.exportDescription;
    }

    /**
     * <p>
     * Represents the properties of the export.
     * </p>
     * 
     * @return Represents the properties of the export.
     */
    public final ExportDescription exportDescription() {
        return exportDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportResponse)) {
            return false;
        }
        DescribeExportResponse other = (DescribeExportResponse) obj;
        return Objects.equals(exportDescription(), other.exportDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExportResponse").add("ExportDescription", exportDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportDescription":
            return Optional.ofNullable(clazz.cast(exportDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportResponse, T> g) {
        return obj -> g.apply((DescribeExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExportResponse> {
        /**
         * <p>
         * Represents the properties of the export.
         * </p>
         * 
         * @param exportDescription
         *        Represents the properties of the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDescription(ExportDescription exportDescription);

        /**
         * <p>
         * Represents the properties of the export.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDescription.Builder} avoiding the
         * need to create one manually via {@link ExportDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #exportDescription(ExportDescription)}.
         * 
         * @param exportDescription
         *        a consumer that will call methods on {@link ExportDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportDescription(ExportDescription)
         */
        default Builder exportDescription(Consumer<ExportDescription.Builder> exportDescription) {
            return exportDescription(ExportDescription.builder().applyMutation(exportDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private ExportDescription exportDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportResponse model) {
            super(model);
            exportDescription(model.exportDescription);
        }

        public final ExportDescription.Builder getExportDescription() {
            return exportDescription != null ? exportDescription.toBuilder() : null;
        }

        public final void setExportDescription(ExportDescription.BuilderImpl exportDescription) {
            this.exportDescription = exportDescription != null ? exportDescription.build() : null;
        }

        @Override
        public final Builder exportDescription(ExportDescription exportDescription) {
            this.exportDescription = exportDescription;
            return this;
        }

        @Override
        public DescribeExportResponse build() {
            return new DescribeExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
