/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTableRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ImportTableRequest.Builder, ImportTableRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ImportTableRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField
            .<S3BucketSource> builder(MarshallingType.SDK_POJO).memberName("S3BucketSource")
            .getter(getter(ImportTableRequest::s3BucketSource)).setter(setter(Builder::s3BucketSource))
            .constructor(S3BucketSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketSource").build()).build();

    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFormat").getter(getter(ImportTableRequest::inputFormatAsString))
            .setter(setter(Builder::inputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()).build();

    private static final SdkField<InputFormatOptions> INPUT_FORMAT_OPTIONS_FIELD = SdkField
            .<InputFormatOptions> builder(MarshallingType.SDK_POJO).memberName("InputFormatOptions")
            .getter(getter(ImportTableRequest::inputFormatOptions)).setter(setter(Builder::inputFormatOptions))
            .constructor(InputFormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormatOptions").build())
            .build();

    private static final SdkField<String> INPUT_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputCompressionType").getter(getter(ImportTableRequest::inputCompressionTypeAsString))
            .setter(setter(Builder::inputCompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputCompressionType").build())
            .build();

    private static final SdkField<TableCreationParameters> TABLE_CREATION_PARAMETERS_FIELD = SdkField
            .<TableCreationParameters> builder(MarshallingType.SDK_POJO).memberName("TableCreationParameters")
            .getter(getter(ImportTableRequest::tableCreationParameters)).setter(setter(Builder::tableCreationParameters))
            .constructor(TableCreationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCreationParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            S3_BUCKET_SOURCE_FIELD, INPUT_FORMAT_FIELD, INPUT_FORMAT_OPTIONS_FIELD, INPUT_COMPRESSION_TYPE_FIELD,
            TABLE_CREATION_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                    put("S3BucketSource", S3_BUCKET_SOURCE_FIELD);
                    put("InputFormat", INPUT_FORMAT_FIELD);
                    put("InputFormatOptions", INPUT_FORMAT_OPTIONS_FIELD);
                    put("InputCompressionType", INPUT_COMPRESSION_TYPE_FIELD);
                    put("TableCreationParameters", TABLE_CREATION_PARAMETERS_FIELD);
                }
            });

    private final String clientToken;

    private final S3BucketSource s3BucketSource;

    private final String inputFormat;

    private final InputFormatOptions inputFormatOptions;

    private final String inputCompressionType;

    private final TableCreationParameters tableCreationParameters;

    private ImportTableRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.s3BucketSource = builder.s3BucketSource;
        this.inputFormat = builder.inputFormat;
        this.inputFormatOptions = builder.inputFormatOptions;
        this.inputCompressionType = builder.inputCompressionType;
        this.tableCreationParameters = builder.tableCreationParameters;
    }

    /**
     * <p>
     * Providing a <code>ClientToken</code> makes the call to <code>ImportTableInput</code> idempotent, meaning that
     * multiple identical calls have the same effect as one single call.
     * </p>
     * <p>
     * A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request
     * with the same client token is treated as a new request. Do not resubmit the same request with the same client
     * token for more than 8 hours, or the result might not be idempotent.
     * </p>
     * <p>
     * If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency
     * window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
     * </p>
     * 
     * @return Providing a <code>ClientToken</code> makes the call to <code>ImportTableInput</code> idempotent, meaning
     *         that multiple identical calls have the same effect as one single call.</p>
     *         <p>
     *         A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any
     *         request with the same client token is treated as a new request. Do not resubmit the same request with the
     *         same client token for more than 8 hours, or the result might not be idempotent.
     *         </p>
     *         <p>
     *         If you submit a request with the same client token but a change in other parameters within the 8-hour
     *         idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The S3 bucket that provides the source for the import.
     * </p>
     * 
     * @return The S3 bucket that provides the source for the import.
     */
    public final S3BucketSource s3BucketSource() {
        return s3BucketSource;
    }

    /**
     * <p>
     * The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
     * <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
     *         <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * @see InputFormat
     */
    public final InputFormat inputFormat() {
        return InputFormat.fromValue(inputFormat);
    }

    /**
     * <p>
     * The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
     * <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
     *         <code>DYNAMODB_JSON</code> or <code>ION</code>.
     * @see InputFormat
     */
    public final String inputFormatAsString() {
        return inputFormat;
    }

    /**
     * <p>
     * Additional properties that specify how the input is formatted,
     * </p>
     * 
     * @return Additional properties that specify how the input is formatted,
     */
    public final InputFormatOptions inputFormatOptions() {
        return inputFormatOptions;
    }

    /**
     * <p>
     * Type of compression to be used on the input coming from the imported table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputCompressionType} will return {@link InputCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputCompressionTypeAsString}.
     * </p>
     * 
     * @return Type of compression to be used on the input coming from the imported table.
     * @see InputCompressionType
     */
    public final InputCompressionType inputCompressionType() {
        return InputCompressionType.fromValue(inputCompressionType);
    }

    /**
     * <p>
     * Type of compression to be used on the input coming from the imported table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputCompressionType} will return {@link InputCompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputCompressionTypeAsString}.
     * </p>
     * 
     * @return Type of compression to be used on the input coming from the imported table.
     * @see InputCompressionType
     */
    public final String inputCompressionTypeAsString() {
        return inputCompressionType;
    }

    /**
     * <p>
     * Parameters for the table to import the data into.
     * </p>
     * 
     * @return Parameters for the table to import the data into.
     */
    public final TableCreationParameters tableCreationParameters() {
        return tableCreationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(inputCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableCreationParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTableRequest)) {
            return false;
        }
        ImportTableRequest other = (ImportTableRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(s3BucketSource(), other.s3BucketSource())
                && Objects.equals(inputFormatAsString(), other.inputFormatAsString())
                && Objects.equals(inputFormatOptions(), other.inputFormatOptions())
                && Objects.equals(inputCompressionTypeAsString(), other.inputCompressionTypeAsString())
                && Objects.equals(tableCreationParameters(), other.tableCreationParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTableRequest").add("ClientToken", clientToken()).add("S3BucketSource", s3BucketSource())
                .add("InputFormat", inputFormatAsString()).add("InputFormatOptions", inputFormatOptions())
                .add("InputCompressionType", inputCompressionTypeAsString())
                .add("TableCreationParameters", tableCreationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "S3BucketSource":
            return Optional.ofNullable(clazz.cast(s3BucketSource()));
        case "InputFormat":
            return Optional.ofNullable(clazz.cast(inputFormatAsString()));
        case "InputFormatOptions":
            return Optional.ofNullable(clazz.cast(inputFormatOptions()));
        case "InputCompressionType":
            return Optional.ofNullable(clazz.cast(inputCompressionTypeAsString()));
        case "TableCreationParameters":
            return Optional.ofNullable(clazz.cast(tableCreationParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportTableRequest, T> g) {
        return obj -> g.apply((ImportTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportTableRequest> {
        /**
         * <p>
         * Providing a <code>ClientToken</code> makes the call to <code>ImportTableInput</code> idempotent, meaning that
         * multiple identical calls have the same effect as one single call.
         * </p>
         * <p>
         * A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any
         * request with the same client token is treated as a new request. Do not resubmit the same request with the
         * same client token for more than 8 hours, or the result might not be idempotent.
         * </p>
         * <p>
         * If you submit a request with the same client token but a change in other parameters within the 8-hour
         * idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
         * </p>
         * 
         * @param clientToken
         *        Providing a <code>ClientToken</code> makes the call to <code>ImportTableInput</code> idempotent,
         *        meaning that multiple identical calls have the same effect as one single call.</p>
         *        <p>
         *        A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours,
         *        any request with the same client token is treated as a new request. Do not resubmit the same request
         *        with the same client token for more than 8 hours, or the result might not be idempotent.
         *        </p>
         *        <p>
         *        If you submit a request with the same client token but a change in other parameters within the 8-hour
         *        idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The S3 bucket that provides the source for the import.
         * </p>
         * 
         * @param s3BucketSource
         *        The S3 bucket that provides the source for the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketSource(S3BucketSource s3BucketSource);

        /**
         * <p>
         * The S3 bucket that provides the source for the import.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketSource.Builder} avoiding the need
         * to create one manually via {@link S3BucketSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3BucketSource(S3BucketSource)}.
         * 
         * @param s3BucketSource
         *        a consumer that will call methods on {@link S3BucketSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketSource(S3BucketSource)
         */
        default Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return s3BucketSource(S3BucketSource.builder().applyMutation(s3BucketSource).build());
        }

        /**
         * <p>
         * The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
         * <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * </p>
         * 
         * @param inputFormat
         *        The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
         *        <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(String inputFormat);

        /**
         * <p>
         * The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
         * <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * </p>
         * 
         * @param inputFormat
         *        The format of the source data. Valid values for <code>ImportFormat</code> are <code>CSV</code>,
         *        <code>DYNAMODB_JSON</code> or <code>ION</code>.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(InputFormat inputFormat);

        /**
         * <p>
         * Additional properties that specify how the input is formatted,
         * </p>
         * 
         * @param inputFormatOptions
         *        Additional properties that specify how the input is formatted,
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFormatOptions(InputFormatOptions inputFormatOptions);

        /**
         * <p>
         * Additional properties that specify how the input is formatted,
         * </p>
         * This is a convenience method that creates an instance of the {@link InputFormatOptions.Builder} avoiding the
         * need to create one manually via {@link InputFormatOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputFormatOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #inputFormatOptions(InputFormatOptions)}.
         * 
         * @param inputFormatOptions
         *        a consumer that will call methods on {@link InputFormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputFormatOptions(InputFormatOptions)
         */
        default Builder inputFormatOptions(Consumer<InputFormatOptions.Builder> inputFormatOptions) {
            return inputFormatOptions(InputFormatOptions.builder().applyMutation(inputFormatOptions).build());
        }

        /**
         * <p>
         * Type of compression to be used on the input coming from the imported table.
         * </p>
         * 
         * @param inputCompressionType
         *        Type of compression to be used on the input coming from the imported table.
         * @see InputCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCompressionType
         */
        Builder inputCompressionType(String inputCompressionType);

        /**
         * <p>
         * Type of compression to be used on the input coming from the imported table.
         * </p>
         * 
         * @param inputCompressionType
         *        Type of compression to be used on the input coming from the imported table.
         * @see InputCompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCompressionType
         */
        Builder inputCompressionType(InputCompressionType inputCompressionType);

        /**
         * <p>
         * Parameters for the table to import the data into.
         * </p>
         * 
         * @param tableCreationParameters
         *        Parameters for the table to import the data into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableCreationParameters(TableCreationParameters tableCreationParameters);

        /**
         * <p>
         * Parameters for the table to import the data into.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCreationParameters.Builder} avoiding
         * the need to create one manually via {@link TableCreationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCreationParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #tableCreationParameters(TableCreationParameters)}.
         * 
         * @param tableCreationParameters
         *        a consumer that will call methods on {@link TableCreationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableCreationParameters(TableCreationParameters)
         */
        default Builder tableCreationParameters(Consumer<TableCreationParameters.Builder> tableCreationParameters) {
            return tableCreationParameters(TableCreationParameters.builder().applyMutation(tableCreationParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String clientToken;

        private S3BucketSource s3BucketSource;

        private String inputFormat;

        private InputFormatOptions inputFormatOptions;

        private String inputCompressionType;

        private TableCreationParameters tableCreationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTableRequest model) {
            super(model);
            clientToken(model.clientToken);
            s3BucketSource(model.s3BucketSource);
            inputFormat(model.inputFormat);
            inputFormatOptions(model.inputFormatOptions);
            inputCompressionType(model.inputCompressionType);
            tableCreationParameters(model.tableCreationParameters);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return s3BucketSource != null ? s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final String getInputFormat() {
            return inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final InputFormatOptions.Builder getInputFormatOptions() {
            return inputFormatOptions != null ? inputFormatOptions.toBuilder() : null;
        }

        public final void setInputFormatOptions(InputFormatOptions.BuilderImpl inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions != null ? inputFormatOptions.build() : null;
        }

        @Override
        public final Builder inputFormatOptions(InputFormatOptions inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions;
            return this;
        }

        public final String getInputCompressionType() {
            return inputCompressionType;
        }

        public final void setInputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
        }

        @Override
        public final Builder inputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
            return this;
        }

        @Override
        public final Builder inputCompressionType(InputCompressionType inputCompressionType) {
            this.inputCompressionType(inputCompressionType == null ? null : inputCompressionType.toString());
            return this;
        }

        public final TableCreationParameters.Builder getTableCreationParameters() {
            return tableCreationParameters != null ? tableCreationParameters.toBuilder() : null;
        }

        public final void setTableCreationParameters(TableCreationParameters.BuilderImpl tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters != null ? tableCreationParameters.build() : null;
        }

        @Override
        public final Builder tableCreationParameters(TableCreationParameters tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportTableRequest build() {
            return new ImportTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
