/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of the table class.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableClassSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TableClassSummary.Builder, TableClassSummary> {
    private static final SdkField<String> TABLE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableClass").getter(getter(TableClassSummary::tableClassAsString)).setter(setter(Builder::tableClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClass").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateDateTime").getter(getter(TableClassSummary::lastUpdateDateTime))
            .setter(setter(Builder::lastUpdateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_CLASS_FIELD,
            LAST_UPDATE_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TableClass", TABLE_CLASS_FIELD);
                    put("LastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String tableClass;

    private final Instant lastUpdateDateTime;

    private TableClassSummary(BuilderImpl builder) {
        this.tableClass = builder.tableClass;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
    }

    /**
     * <p>
     * The table class of the specified table. Valid values are <code>STANDARD</code> and
     * <code>STANDARD_INFREQUENT_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableClass} will
     * return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableClassAsString}.
     * </p>
     * 
     * @return The table class of the specified table. Valid values are <code>STANDARD</code> and
     *         <code>STANDARD_INFREQUENT_ACCESS</code>.
     * @see TableClass
     */
    public final TableClass tableClass() {
        return TableClass.fromValue(tableClass);
    }

    /**
     * <p>
     * The table class of the specified table. Valid values are <code>STANDARD</code> and
     * <code>STANDARD_INFREQUENT_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableClass} will
     * return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableClassAsString}.
     * </p>
     * 
     * @return The table class of the specified table. Valid values are <code>STANDARD</code> and
     *         <code>STANDARD_INFREQUENT_ACCESS</code>.
     * @see TableClass
     */
    public final String tableClassAsString() {
        return tableClass;
    }

    /**
     * <p>
     * The date and time at which the table class was last updated.
     * </p>
     * 
     * @return The date and time at which the table class was last updated.
     */
    public final Instant lastUpdateDateTime() {
        return lastUpdateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableClassSummary)) {
            return false;
        }
        TableClassSummary other = (TableClassSummary) obj;
        return Objects.equals(tableClassAsString(), other.tableClassAsString())
                && Objects.equals(lastUpdateDateTime(), other.lastUpdateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableClassSummary").add("TableClass", tableClassAsString())
                .add("LastUpdateDateTime", lastUpdateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableClass":
            return Optional.ofNullable(clazz.cast(tableClassAsString()));
        case "LastUpdateDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableClassSummary, T> g) {
        return obj -> g.apply((TableClassSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableClassSummary> {
        /**
         * <p>
         * The table class of the specified table. Valid values are <code>STANDARD</code> and
         * <code>STANDARD_INFREQUENT_ACCESS</code>.
         * </p>
         * 
         * @param tableClass
         *        The table class of the specified table. Valid values are <code>STANDARD</code> and
         *        <code>STANDARD_INFREQUENT_ACCESS</code>.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClass(String tableClass);

        /**
         * <p>
         * The table class of the specified table. Valid values are <code>STANDARD</code> and
         * <code>STANDARD_INFREQUENT_ACCESS</code>.
         * </p>
         * 
         * @param tableClass
         *        The table class of the specified table. Valid values are <code>STANDARD</code> and
         *        <code>STANDARD_INFREQUENT_ACCESS</code>.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClass(TableClass tableClass);

        /**
         * <p>
         * The date and time at which the table class was last updated.
         * </p>
         * 
         * @param lastUpdateDateTime
         *        The date and time at which the table class was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDateTime(Instant lastUpdateDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String tableClass;

        private Instant lastUpdateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TableClassSummary model) {
            tableClass(model.tableClass);
            lastUpdateDateTime(model.lastUpdateDateTime);
        }

        public final String getTableClass() {
            return tableClass;
        }

        public final void setTableClass(String tableClass) {
            this.tableClass = tableClass;
        }

        @Override
        public final Builder tableClass(String tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        @Override
        public final Builder tableClass(TableClass tableClass) {
            this.tableClass(tableClass == null ? null : tableClass.toString());
            return this;
        }

        public final Instant getLastUpdateDateTime() {
            return lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        @Override
        public TableClassSummary build() {
            return new TableClassSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
