/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSnapshotBlockRequest extends EbsRequest implements
        ToCopyableBuilder<PutSnapshotBlockRequest.Builder, PutSnapshotBlockRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(PutSnapshotBlockRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotId").build()).build();

    private static final SdkField<Integer> BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockIndex").getter(getter(PutSnapshotBlockRequest::blockIndex)).setter(setter(Builder::blockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("blockIndex").build()).build();

    private static final SdkField<Integer> DATA_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataLength").getter(getter(PutSnapshotBlockRequest::dataLength)).setter(setter(Builder::dataLength))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Data-Length").build()).build();

    private static final SdkField<Integer> PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Progress").getter(getter(PutSnapshotBlockRequest::progress)).setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Progress").build()).build();

    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Checksum").getter(getter(PutSnapshotBlockRequest::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum").build()).build();

    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChecksumAlgorithm").getter(getter(PutSnapshotBlockRequest::checksumAlgorithmAsString))
            .setter(setter(Builder::checksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum-Algorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            BLOCK_INDEX_FIELD, DATA_LENGTH_FIELD, PROGRESS_FIELD, CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD));

    private final String snapshotId;

    private final Integer blockIndex;

    private final Integer dataLength;

    private final Integer progress;

    private final String checksum;

    private final String checksumAlgorithm;

    private PutSnapshotBlockRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.blockIndex = builder.blockIndex;
        this.dataLength = builder.dataLength;
        this.progress = builder.progress;
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The block index of the block in which to write the data. A block index is a logical index in units of
     * <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the logical
     * volume by the block size (logical offset of data/<code>524288</code>). The logical offset of the data must be
     * <code>512</code> KiB aligned.
     * </p>
     * 
     * @return The block index of the block in which to write the data. A block index is a logical index in units of
     *         <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the
     *         logical volume by the block size (logical offset of data/<code>524288</code>). The logical offset of the
     *         data must be <code>512</code> KiB aligned.
     */
    public final Integer blockIndex() {
        return blockIndex;
    }

    /**
     * <p>
     * The size of the data to write to the block, in bytes. Currently, the only supported size is <code>524288</code>
     * bytes.
     * </p>
     * <p>
     * Valid values: <code>524288</code>
     * </p>
     * 
     * @return The size of the data to write to the block, in bytes. Currently, the only supported size is
     *         <code>524288</code> bytes.</p>
     *         <p>
     *         Valid values: <code>524288</code>
     */
    public final Integer dataLength() {
        return dataLength;
    }

    /**
     * <p>
     * The progress of the write process, as a percentage.
     * </p>
     * 
     * @return The progress of the write process, as a percentage.
     */
    public final Integer progress() {
        return progress;
    }

    /**
     * <p>
     * A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.
     * </p>
     * 
     * @return A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checksumAlgorithm}
     * will return {@link ChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #checksumAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm used to generate the checksum. Currently, the only supported algorithm is
     *         <code>SHA256</code>.
     * @see ChecksumAlgorithm
     */
    public final ChecksumAlgorithm checksumAlgorithm() {
        return ChecksumAlgorithm.fromValue(checksumAlgorithm);
    }

    /**
     * <p>
     * The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checksumAlgorithm}
     * will return {@link ChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #checksumAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm used to generate the checksum. Currently, the only supported algorithm is
     *         <code>SHA256</code>.
     * @see ChecksumAlgorithm
     */
    public final String checksumAlgorithmAsString() {
        return checksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(blockIndex());
        hashCode = 31 * hashCode + Objects.hashCode(dataLength());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(checksumAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSnapshotBlockRequest)) {
            return false;
        }
        PutSnapshotBlockRequest other = (PutSnapshotBlockRequest) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(blockIndex(), other.blockIndex())
                && Objects.equals(dataLength(), other.dataLength()) && Objects.equals(progress(), other.progress())
                && Objects.equals(checksum(), other.checksum())
                && Objects.equals(checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSnapshotBlockRequest").add("SnapshotId", snapshotId()).add("BlockIndex", blockIndex())
                .add("DataLength", dataLength()).add("Progress", progress()).add("Checksum", checksum())
                .add("ChecksumAlgorithm", checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "BlockIndex":
            return Optional.ofNullable(clazz.cast(blockIndex()));
        case "DataLength":
            return Optional.ofNullable(clazz.cast(dataLength()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "Checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "ChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(checksumAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSnapshotBlockRequest, T> g) {
        return obj -> g.apply((PutSnapshotBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutSnapshotBlockRequest> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The block index of the block in which to write the data. A block index is a logical index in units of
         * <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the
         * logical volume by the block size (logical offset of data/<code>524288</code>). The logical offset of the data
         * must be <code>512</code> KiB aligned.
         * </p>
         * 
         * @param blockIndex
         *        The block index of the block in which to write the data. A block index is a logical index in units of
         *        <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the
         *        logical volume by the block size (logical offset of data/<code>524288</code>). The logical offset of
         *        the data must be <code>512</code> KiB aligned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockIndex(Integer blockIndex);

        /**
         * <p>
         * The size of the data to write to the block, in bytes. Currently, the only supported size is
         * <code>524288</code> bytes.
         * </p>
         * <p>
         * Valid values: <code>524288</code>
         * </p>
         * 
         * @param dataLength
         *        The size of the data to write to the block, in bytes. Currently, the only supported size is
         *        <code>524288</code> bytes.</p>
         *        <p>
         *        Valid values: <code>524288</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLength(Integer dataLength);

        /**
         * <p>
         * The progress of the write process, as a percentage.
         * </p>
         * 
         * @param progress
         *        The progress of the write process, as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Integer progress);

        /**
         * <p>
         * A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.
         * </p>
         * 
         * @param checksum
         *        A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.
         * </p>
         * 
         * @param checksumAlgorithm
         *        The algorithm used to generate the checksum. Currently, the only supported algorithm is
         *        <code>SHA256</code>.
         * @see ChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChecksumAlgorithm
         */
        Builder checksumAlgorithm(String checksumAlgorithm);

        /**
         * <p>
         * The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.
         * </p>
         * 
         * @param checksumAlgorithm
         *        The algorithm used to generate the checksum. Currently, the only supported algorithm is
         *        <code>SHA256</code>.
         * @see ChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChecksumAlgorithm
         */
        Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EbsRequest.BuilderImpl implements Builder {
        private String snapshotId;

        private Integer blockIndex;

        private Integer dataLength;

        private Integer progress;

        private String checksum;

        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSnapshotBlockRequest model) {
            super(model);
            snapshotId(model.snapshotId);
            blockIndex(model.blockIndex);
            dataLength(model.dataLength);
            progress(model.progress);
            checksum(model.checksum);
            checksumAlgorithm(model.checksumAlgorithm);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        @Transient
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Integer getBlockIndex() {
            return blockIndex;
        }

        public final void setBlockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
        }

        @Override
        @Transient
        public final Builder blockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
            return this;
        }

        public final Integer getDataLength() {
            return dataLength;
        }

        public final void setDataLength(Integer dataLength) {
            this.dataLength = dataLength;
        }

        @Override
        @Transient
        public final Builder dataLength(Integer dataLength) {
            this.dataLength = dataLength;
            return this;
        }

        public final Integer getProgress() {
            return progress;
        }

        public final void setProgress(Integer progress) {
            this.progress = progress;
        }

        @Override
        @Transient
        public final Builder progress(Integer progress) {
            this.progress = progress;
            return this;
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        @Transient
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        @Transient
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        @Transient
        public final Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSnapshotBlockRequest build() {
            return new PutSnapshotBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
