/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrafficMirrorTargetResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteTrafficMirrorTargetResponse.Builder, DeleteTrafficMirrorTargetResponse> {
    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorTargetId")
            .getter(getter(DeleteTrafficMirrorTargetResponse::trafficMirrorTargetId))
            .setter(setter(Builder::trafficMirrorTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId")
                    .unmarshallLocationName("trafficMirrorTargetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRAFFIC_MIRROR_TARGET_ID_FIELD));

    private final String trafficMirrorTargetId;

    private DeleteTrafficMirrorTargetResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
    }

    /**
     * <p>
     * The ID of the deleted Traffic Mirror target.
     * </p>
     * 
     * @return The ID of the deleted Traffic Mirror target.
     */
    public final String trafficMirrorTargetId() {
        return trafficMirrorTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorTargetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrafficMirrorTargetResponse)) {
            return false;
        }
        DeleteTrafficMirrorTargetResponse other = (DeleteTrafficMirrorTargetResponse) obj;
        return Objects.equals(trafficMirrorTargetId(), other.trafficMirrorTargetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTrafficMirrorTargetResponse").add("TrafficMirrorTargetId", trafficMirrorTargetId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorTargetId":
            return Optional.ofNullable(clazz.cast(trafficMirrorTargetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrafficMirrorTargetResponse, T> g) {
        return obj -> g.apply((DeleteTrafficMirrorTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTrafficMirrorTargetResponse> {
        /**
         * <p>
         * The ID of the deleted Traffic Mirror target.
         * </p>
         * 
         * @param trafficMirrorTargetId
         *        The ID of the deleted Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorTargetId(String trafficMirrorTargetId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String trafficMirrorTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrafficMirrorTargetResponse model) {
            super(model);
            trafficMirrorTargetId(model.trafficMirrorTargetId);
        }

        public final String getTrafficMirrorTargetId() {
            return trafficMirrorTargetId;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        @Override
        public DeleteTrafficMirrorTargetResponse build() {
            return new DeleteTrafficMirrorTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
