/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a bundle task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BundleTask implements SdkPojo, Serializable, ToCopyableBuilder<BundleTask.Builder, BundleTask> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BundleId")
            .getter(getter(BundleTask::bundleId))
            .setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId")
                    .unmarshallLocationName("bundleId").build()).build();

    private static final SdkField<BundleTaskError> BUNDLE_TASK_ERROR_FIELD = SdkField
            .<BundleTaskError> builder(MarshallingType.SDK_POJO)
            .memberName("BundleTaskError")
            .getter(getter(BundleTask::bundleTaskError))
            .setter(setter(Builder::bundleTaskError))
            .constructor(BundleTaskError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(BundleTask::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Progress")
            .getter(getter(BundleTask::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(BundleTask::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(BundleTask::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Storage> STORAGE_FIELD = SdkField
            .<Storage> builder(MarshallingType.SDK_POJO)
            .memberName("Storage")
            .getter(getter(BundleTask::storage))
            .setter(setter(Builder::storage))
            .constructor(Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage")
                    .unmarshallLocationName("storage").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(BundleTask::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime")
                    .unmarshallLocationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD,
            BUNDLE_TASK_ERROR_FIELD, INSTANCE_ID_FIELD, PROGRESS_FIELD, START_TIME_FIELD, STATE_FIELD, STORAGE_FIELD,
            UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bundleId;

    private final BundleTaskError bundleTaskError;

    private final String instanceId;

    private final String progress;

    private final Instant startTime;

    private final String state;

    private final Storage storage;

    private final Instant updateTime;

    private BundleTask(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.bundleTaskError = builder.bundleTaskError;
        this.instanceId = builder.instanceId;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.storage = builder.storage;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The ID of the bundle task.
     * </p>
     * 
     * @return The ID of the bundle task.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * If the task fails, a description of the error.
     * </p>
     * 
     * @return If the task fails, a description of the error.
     */
    public final BundleTaskError bundleTaskError() {
        return bundleTaskError;
    }

    /**
     * <p>
     * The ID of the instance associated with this bundle task.
     * </p>
     * 
     * @return The ID of the instance associated with this bundle task.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The level of task completion, as a percent (for example, 20%).
     * </p>
     * 
     * @return The level of task completion, as a percent (for example, 20%).
     */
    public final String progress() {
        return progress;
    }

    /**
     * <p>
     * The time this task started.
     * </p>
     * 
     * @return The time this task started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The state of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BundleTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the task.
     * @see BundleTaskState
     */
    public final BundleTaskState state() {
        return BundleTaskState.fromValue(state);
    }

    /**
     * <p>
     * The state of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BundleTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the task.
     * @see BundleTaskState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The Amazon S3 storage locations.
     * </p>
     * 
     * @return The Amazon S3 storage locations.
     */
    public final Storage storage() {
        return storage;
    }

    /**
     * <p>
     * The time of the most recent update for the task.
     * </p>
     * 
     * @return The time of the most recent update for the task.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(bundleTaskError());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleTask)) {
            return false;
        }
        BundleTask other = (BundleTask) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(bundleTaskError(), other.bundleTaskError())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(progress(), other.progress())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(storage(), other.storage()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BundleTask").add("BundleId", bundleId()).add("BundleTaskError", bundleTaskError())
                .add("InstanceId", instanceId()).add("Progress", progress()).add("StartTime", startTime())
                .add("State", stateAsString()).add("Storage", storage()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "BundleTaskError":
            return Optional.ofNullable(clazz.cast(bundleTaskError()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Storage":
            return Optional.ofNullable(clazz.cast(storage()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BundleTask, T> g) {
        return obj -> g.apply((BundleTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BundleTask> {
        /**
         * <p>
         * The ID of the bundle task.
         * </p>
         * 
         * @param bundleId
         *        The ID of the bundle task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * If the task fails, a description of the error.
         * </p>
         * 
         * @param bundleTaskError
         *        If the task fails, a description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTaskError(BundleTaskError bundleTaskError);

        /**
         * <p>
         * If the task fails, a description of the error.
         * </p>
         * This is a convenience method that creates an instance of the {@link BundleTaskError.Builder} avoiding the
         * need to create one manually via {@link BundleTaskError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BundleTaskError.Builder#build()} is called immediately and its
         * result is passed to {@link #bundleTaskError(BundleTaskError)}.
         * 
         * @param bundleTaskError
         *        a consumer that will call methods on {@link BundleTaskError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundleTaskError(BundleTaskError)
         */
        default Builder bundleTaskError(Consumer<BundleTaskError.Builder> bundleTaskError) {
            return bundleTaskError(BundleTaskError.builder().applyMutation(bundleTaskError).build());
        }

        /**
         * <p>
         * The ID of the instance associated with this bundle task.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance associated with this bundle task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The level of task completion, as a percent (for example, 20%).
         * </p>
         * 
         * @param progress
         *        The level of task completion, as a percent (for example, 20%).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The time this task started.
         * </p>
         * 
         * @param startTime
         *        The time this task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The state of the task.
         * </p>
         * 
         * @param state
         *        The state of the task.
         * @see BundleTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleTaskState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the task.
         * </p>
         * 
         * @param state
         *        The state of the task.
         * @see BundleTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleTaskState
         */
        Builder state(BundleTaskState state);

        /**
         * <p>
         * The Amazon S3 storage locations.
         * </p>
         * 
         * @param storage
         *        The Amazon S3 storage locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(Storage storage);

        /**
         * <p>
         * The Amazon S3 storage locations.
         * </p>
         * This is a convenience method that creates an instance of the {@link Storage.Builder} avoiding the need to
         * create one manually via {@link Storage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Storage.Builder#build()} is called immediately and its result is
         * passed to {@link #storage(Storage)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(Storage)
         */
        default Builder storage(Consumer<Storage.Builder> storage) {
            return storage(Storage.builder().applyMutation(storage).build());
        }

        /**
         * <p>
         * The time of the most recent update for the task.
         * </p>
         * 
         * @param updateTime
         *        The time of the most recent update for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private BundleTaskError bundleTaskError;

        private String instanceId;

        private String progress;

        private Instant startTime;

        private String state;

        private Storage storage;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleTask model) {
            bundleId(model.bundleId);
            bundleTaskError(model.bundleTaskError);
            instanceId(model.instanceId);
            progress(model.progress);
            startTime(model.startTime);
            state(model.state);
            storage(model.storage);
            updateTime(model.updateTime);
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final BundleTaskError.Builder getBundleTaskError() {
            return bundleTaskError != null ? bundleTaskError.toBuilder() : null;
        }

        public final void setBundleTaskError(BundleTaskError.BuilderImpl bundleTaskError) {
            this.bundleTaskError = bundleTaskError != null ? bundleTaskError.build() : null;
        }

        @Override
        public final Builder bundleTaskError(BundleTaskError bundleTaskError) {
            this.bundleTaskError = bundleTaskError;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getProgress() {
            return progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BundleTaskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Storage.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(Storage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public BundleTask build() {
            return new BundleTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
