/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachVerifiedAccessTrustProviderResponse extends Ec2Response implements
        ToCopyableBuilder<DetachVerifiedAccessTrustProviderResponse.Builder, DetachVerifiedAccessTrustProviderResponse> {
    private static final SdkField<VerifiedAccessTrustProvider> VERIFIED_ACCESS_TRUST_PROVIDER_FIELD = SdkField
            .<VerifiedAccessTrustProvider> builder(MarshallingType.SDK_POJO)
            .memberName("VerifiedAccessTrustProvider")
            .getter(getter(DetachVerifiedAccessTrustProviderResponse::verifiedAccessTrustProvider))
            .setter(setter(Builder::verifiedAccessTrustProvider))
            .constructor(VerifiedAccessTrustProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProvider")
                    .unmarshallLocationName("verifiedAccessTrustProvider").build()).build();

    private static final SdkField<VerifiedAccessInstance> VERIFIED_ACCESS_INSTANCE_FIELD = SdkField
            .<VerifiedAccessInstance> builder(MarshallingType.SDK_POJO)
            .memberName("VerifiedAccessInstance")
            .getter(getter(DetachVerifiedAccessTrustProviderResponse::verifiedAccessInstance))
            .setter(setter(Builder::verifiedAccessInstance))
            .constructor(VerifiedAccessInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstance")
                    .unmarshallLocationName("verifiedAccessInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_TRUST_PROVIDER_FIELD, VERIFIED_ACCESS_INSTANCE_FIELD));

    private final VerifiedAccessTrustProvider verifiedAccessTrustProvider;

    private final VerifiedAccessInstance verifiedAccessInstance;

    private DetachVerifiedAccessTrustProviderResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessTrustProvider = builder.verifiedAccessTrustProvider;
        this.verifiedAccessInstance = builder.verifiedAccessInstance;
    }

    /**
     * <p>
     * Details about the Verified Access trust provider.
     * </p>
     * 
     * @return Details about the Verified Access trust provider.
     */
    public final VerifiedAccessTrustProvider verifiedAccessTrustProvider() {
        return verifiedAccessTrustProvider;
    }

    /**
     * <p>
     * Details about the Verified Access instance.
     * </p>
     * 
     * @return Details about the Verified Access instance.
     */
    public final VerifiedAccessInstance verifiedAccessInstance() {
        return verifiedAccessInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessTrustProvider());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVerifiedAccessTrustProviderResponse)) {
            return false;
        }
        DetachVerifiedAccessTrustProviderResponse other = (DetachVerifiedAccessTrustProviderResponse) obj;
        return Objects.equals(verifiedAccessTrustProvider(), other.verifiedAccessTrustProvider())
                && Objects.equals(verifiedAccessInstance(), other.verifiedAccessInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachVerifiedAccessTrustProviderResponse")
                .add("VerifiedAccessTrustProvider", verifiedAccessTrustProvider())
                .add("VerifiedAccessInstance", verifiedAccessInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessTrustProvider":
            return Optional.ofNullable(clazz.cast(verifiedAccessTrustProvider()));
        case "VerifiedAccessInstance":
            return Optional.ofNullable(clazz.cast(verifiedAccessInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachVerifiedAccessTrustProviderResponse, T> g) {
        return obj -> g.apply((DetachVerifiedAccessTrustProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DetachVerifiedAccessTrustProviderResponse> {
        /**
         * <p>
         * Details about the Verified Access trust provider.
         * </p>
         * 
         * @param verifiedAccessTrustProvider
         *        Details about the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProvider(VerifiedAccessTrustProvider verifiedAccessTrustProvider);

        /**
         * <p>
         * Details about the Verified Access trust provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerifiedAccessTrustProvider.Builder}
         * avoiding the need to create one manually via {@link VerifiedAccessTrustProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessTrustProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #verifiedAccessTrustProvider(VerifiedAccessTrustProvider)}.
         * 
         * @param verifiedAccessTrustProvider
         *        a consumer that will call methods on {@link VerifiedAccessTrustProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedAccessTrustProvider(VerifiedAccessTrustProvider)
         */
        default Builder verifiedAccessTrustProvider(Consumer<VerifiedAccessTrustProvider.Builder> verifiedAccessTrustProvider) {
            return verifiedAccessTrustProvider(VerifiedAccessTrustProvider.builder().applyMutation(verifiedAccessTrustProvider)
                    .build());
        }

        /**
         * <p>
         * Details about the Verified Access instance.
         * </p>
         * 
         * @param verifiedAccessInstance
         *        Details about the Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessInstance(VerifiedAccessInstance verifiedAccessInstance);

        /**
         * <p>
         * Details about the Verified Access instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerifiedAccessInstance.Builder} avoiding
         * the need to create one manually via {@link VerifiedAccessInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessInstance.Builder#build()} is called immediately and
         * its result is passed to {@link #verifiedAccessInstance(VerifiedAccessInstance)}.
         * 
         * @param verifiedAccessInstance
         *        a consumer that will call methods on {@link VerifiedAccessInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedAccessInstance(VerifiedAccessInstance)
         */
        default Builder verifiedAccessInstance(Consumer<VerifiedAccessInstance.Builder> verifiedAccessInstance) {
            return verifiedAccessInstance(VerifiedAccessInstance.builder().applyMutation(verifiedAccessInstance).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VerifiedAccessTrustProvider verifiedAccessTrustProvider;

        private VerifiedAccessInstance verifiedAccessInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVerifiedAccessTrustProviderResponse model) {
            super(model);
            verifiedAccessTrustProvider(model.verifiedAccessTrustProvider);
            verifiedAccessInstance(model.verifiedAccessInstance);
        }

        public final VerifiedAccessTrustProvider.Builder getVerifiedAccessTrustProvider() {
            return verifiedAccessTrustProvider != null ? verifiedAccessTrustProvider.toBuilder() : null;
        }

        public final void setVerifiedAccessTrustProvider(VerifiedAccessTrustProvider.BuilderImpl verifiedAccessTrustProvider) {
            this.verifiedAccessTrustProvider = verifiedAccessTrustProvider != null ? verifiedAccessTrustProvider.build() : null;
        }

        @Override
        public final Builder verifiedAccessTrustProvider(VerifiedAccessTrustProvider verifiedAccessTrustProvider) {
            this.verifiedAccessTrustProvider = verifiedAccessTrustProvider;
            return this;
        }

        public final VerifiedAccessInstance.Builder getVerifiedAccessInstance() {
            return verifiedAccessInstance != null ? verifiedAccessInstance.toBuilder() : null;
        }

        public final void setVerifiedAccessInstance(VerifiedAccessInstance.BuilderImpl verifiedAccessInstance) {
            this.verifiedAccessInstance = verifiedAccessInstance != null ? verifiedAccessInstance.build() : null;
        }

        @Override
        public final Builder verifiedAccessInstance(VerifiedAccessInstance verifiedAccessInstance) {
            this.verifiedAccessInstance = verifiedAccessInstance;
            return this;
        }

        @Override
        public DetachVerifiedAccessTrustProviderResponse build() {
            return new DetachVerifiedAccessTrustProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
