/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch request for one or more instances, and includes owner, requester, and security group information
 * that applies to all instances in the launch request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Reservation implements SdkPojo, Serializable, ToCopyableBuilder<Reservation.Builder, Reservation> {
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField
            .<List<GroupIdentifier>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(Reservation::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet")
                    .unmarshallLocationName("groupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField
            .<List<Instance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(Reservation::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Instance> builder(MarshallingType.SDK_POJO)
                                            .constructor(Instance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(Reservation::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> REQUESTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequesterId")
            .getter(getter(Reservation::requesterId))
            .setter(setter(Builder::requesterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterId")
                    .unmarshallLocationName("requesterId").build()).build();

    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservationId")
            .getter(getter(Reservation::reservationId))
            .setter(setter(Builder::reservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationId")
                    .unmarshallLocationName("reservationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD, INSTANCES_FIELD,
            OWNER_ID_FIELD, REQUESTER_ID_FIELD, RESERVATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<GroupIdentifier> groups;

    private final List<Instance> instances;

    private final String ownerId;

    private final String requesterId;

    private final String reservationId;

    private Reservation(BuilderImpl builder) {
        this.groups = builder.groups;
        this.instances = builder.instances;
        this.ownerId = builder.ownerId;
        this.requesterId = builder.requesterId;
        this.reservationId = builder.reservationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return Not supported.
     */
    public final List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return The instances.
     */
    public final List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the reservation.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the reservation.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the requester that launched the instances on your behalf (for example, Amazon Web Services Management
     * Console or Auto Scaling).
     * </p>
     * 
     * @return The ID of the requester that launched the instances on your behalf (for example, Amazon Web Services
     *         Management Console or Auto Scaling).
     */
    public final String requesterId() {
        return requesterId;
    }

    /**
     * <p>
     * The ID of the reservation.
     * </p>
     * 
     * @return The ID of the reservation.
     */
    public final String reservationId() {
        return reservationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(requesterId());
        hashCode = 31 * hashCode + Objects.hashCode(reservationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation) obj;
        return hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(requesterId(), other.requesterId())
                && Objects.equals(reservationId(), other.reservationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Reservation").add("Groups", hasGroups() ? groups() : null)
                .add("Instances", hasInstances() ? instances() : null).add("OwnerId", ownerId())
                .add("RequesterId", requesterId()).add("ReservationId", reservationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "RequesterId":
            return Optional.ofNullable(clazz.cast(requesterId()));
        case "ReservationId":
            return Optional.ofNullable(clazz.cast(reservationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Reservation, T> g) {
        return obj -> g.apply((Reservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Reservation> {
        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param groups
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * Not supported.
         * </p>
         * 
         * @param groups
         *        Not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * Not supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupIdentifier>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.GroupIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<GroupIdentifier>)
         */
        Builder groups(Consumer<GroupIdentifier.Builder>... groups);

        /**
         * <p>
         * The instances.
         * </p>
         * 
         * @param instances
         *        The instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * The instances.
         * </p>
         * 
         * @param instances
         *        The instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Instance.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ec2.model.Instance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.Instance.Builder#build()} is called immediately and its
         * result is passed to {@link #instances(List<Instance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(java.util.Collection<Instance>)
         */
        Builder instances(Consumer<Instance.Builder>... instances);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the reservation.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the requester that launched the instances on your behalf (for example, Amazon Web Services
         * Management Console or Auto Scaling).
         * </p>
         * 
         * @param requesterId
         *        The ID of the requester that launched the instances on your behalf (for example, Amazon Web Services
         *        Management Console or Auto Scaling).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterId(String requesterId);

        /**
         * <p>
         * The ID of the reservation.
         * </p>
         * 
         * @param reservationId
         *        The ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationId(String reservationId);
    }

    static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();

        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private String ownerId;

        private String requesterId;

        private String reservationId;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            groups(model.groups);
            instances(model.instances);
            ownerId(model.ownerId);
            requesterId(model.requesterId);
            reservationId(model.reservationId);
        }

        public final List<GroupIdentifier.Builder> getGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Instance.Builder> getInstances() {
            List<Instance.Builder> result = InstanceListCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> Instance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getRequesterId() {
            return requesterId;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final String getReservationId() {
            return reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        @Override
        public Reservation build() {
            return new Reservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
