/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreSnapshotFromRecycleBinResponse extends Ec2Response implements
        ToCopyableBuilder<RestoreSnapshotFromRecycleBinResponse.Builder, RestoreSnapshotFromRecycleBinResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Progress")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize")
                    .unmarshallLocationName("volumeSize").build()).build();

    private static final SdkField<String> SSE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SseType")
            .getter(getter(RestoreSnapshotFromRecycleBinResponse::sseTypeAsString))
            .setter(setter(Builder::sseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseType")
                    .unmarshallLocationName("sseType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            OUTPOST_ARN_FIELD, DESCRIPTION_FIELD, ENCRYPTED_FIELD, OWNER_ID_FIELD, PROGRESS_FIELD, START_TIME_FIELD, STATE_FIELD,
            VOLUME_ID_FIELD, VOLUME_SIZE_FIELD, SSE_TYPE_FIELD));

    private final String snapshotId;

    private final String outpostArn;

    private final String description;

    private final Boolean encrypted;

    private final String ownerId;

    private final String progress;

    private final Instant startTime;

    private final String state;

    private final String volumeId;

    private final Integer volumeSize;

    private final String sseType;

    private RestoreSnapshotFromRecycleBinResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.outpostArn = builder.outpostArn;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.ownerId = builder.ownerId;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.volumeSize = builder.volumeSize;
        this.sseType = builder.sseType;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The ARN of the Outpost on which the snapshot is stored. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local snapshots on
     * Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @return The ARN of the Outpost on which the snapshot is stored. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local
     *         snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The description for the snapshot.
     * </p>
     * 
     * @return The description for the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the snapshot is encrypted.
     * </p>
     * 
     * @return Indicates whether the snapshot is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the EBS snapshot.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the EBS snapshot.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The progress of the snapshot, as a percentage.
     * </p>
     * 
     * @return The progress of the snapshot, as a percentage.
     */
    public final String progress() {
        return progress;
    }

    /**
     * <p>
     * The time stamp when the snapshot was initiated.
     * </p>
     * 
     * @return The time stamp when the snapshot was initiated.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The state of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the snapshot.
     * @see SnapshotState
     */
    public final SnapshotState state() {
        return SnapshotState.fromValue(state);
    }

    /**
     * <p>
     * The state of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the snapshot.
     * @see SnapshotState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of the volume that was used to create the snapshot.
     * </p>
     * 
     * @return The ID of the volume that was used to create the snapshot.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see SSEType
     */
    public final SSEType sseType() {
        return SSEType.fromValue(sseType);
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseType} will
     * return {@link SSEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseTypeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see SSEType
     */
    public final String sseTypeAsString() {
        return sseType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(sseTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSnapshotFromRecycleBinResponse)) {
            return false;
        }
        RestoreSnapshotFromRecycleBinResponse other = (RestoreSnapshotFromRecycleBinResponse) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(description(), other.description()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(progress(), other.progress())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(volumeId(), other.volumeId()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(sseTypeAsString(), other.sseTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreSnapshotFromRecycleBinResponse").add("SnapshotId", snapshotId())
                .add("OutpostArn", outpostArn()).add("Description", description()).add("Encrypted", encrypted())
                .add("OwnerId", ownerId()).add("Progress", progress()).add("StartTime", startTime())
                .add("State", stateAsString()).add("VolumeId", volumeId()).add("VolumeSize", volumeSize())
                .add("SseType", sseTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "SseType":
            return Optional.ofNullable(clazz.cast(sseTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreSnapshotFromRecycleBinResponse, T> g) {
        return obj -> g.apply((RestoreSnapshotFromRecycleBinResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreSnapshotFromRecycleBinResponse> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The ARN of the Outpost on which the snapshot is stored. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local snapshots on
         * Outposts</a> in the <i>Amazon EBS User Guide</i>.
         * </p>
         * 
         * @param outpostArn
         *        The ARN of the Outpost on which the snapshot is stored. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html">Amazon EBS local
         *        snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The description for the snapshot.
         * </p>
         * 
         * @param description
         *        The description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the snapshot is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the snapshot is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the EBS snapshot.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The progress of the snapshot, as a percentage.
         * </p>
         * 
         * @param progress
         *        The progress of the snapshot, as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The time stamp when the snapshot was initiated.
         * </p>
         * 
         * @param startTime
         *        The time stamp when the snapshot was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The state of the snapshot.
         * </p>
         * 
         * @param state
         *        The state of the snapshot.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the snapshot.
         * </p>
         * 
         * @param state
         *        The state of the snapshot.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(SnapshotState state);

        /**
         * <p>
         * The ID of the volume that was used to create the snapshot.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that was used to create the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(String sseType);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param sseType
         *        Reserved for future use.
         * @see SSEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SSEType
         */
        Builder sseType(SSEType sseType);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String snapshotId;

        private String outpostArn;

        private String description;

        private Boolean encrypted;

        private String ownerId;

        private String progress;

        private Instant startTime;

        private String state;

        private String volumeId;

        private Integer volumeSize;

        private String sseType;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSnapshotFromRecycleBinResponse model) {
            super(model);
            snapshotId(model.snapshotId);
            outpostArn(model.outpostArn);
            description(model.description);
            encrypted(model.encrypted);
            ownerId(model.ownerId);
            progress(model.progress);
            startTime(model.startTime);
            state(model.state);
            volumeId(model.volumeId);
            volumeSize(model.volumeSize);
            sseType(model.sseType);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProgress() {
            return progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getSseType() {
            return sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        @Override
        public RestoreSnapshotFromRecycleBinResponse build() {
            return new RestoreSnapshotFromRecycleBinResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
