/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIpamResourceDiscoveriesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeIpamResourceDiscoveriesResponse.Builder, DescribeIpamResourceDiscoveriesResponse> {
    private static final SdkField<List<IpamResourceDiscovery>> IPAM_RESOURCE_DISCOVERIES_FIELD = SdkField
            .<List<IpamResourceDiscovery>> builder(MarshallingType.LIST)
            .memberName("IpamResourceDiscoveries")
            .getter(getter(DescribeIpamResourceDiscoveriesResponse::ipamResourceDiscoveries))
            .setter(setter(Builder::ipamResourceDiscoveries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoverySet")
                    .unmarshallLocationName("ipamResourceDiscoverySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamResourceDiscovery> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamResourceDiscovery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeIpamResourceDiscoveriesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IPAM_RESOURCE_DISCOVERIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<IpamResourceDiscovery> ipamResourceDiscoveries;

    private final String nextToken;

    private DescribeIpamResourceDiscoveriesResponse(BuilderImpl builder) {
        super(builder);
        this.ipamResourceDiscoveries = builder.ipamResourceDiscoveries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamResourceDiscoveries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpamResourceDiscoveries() {
        return ipamResourceDiscoveries != null && !(ipamResourceDiscoveries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource discoveries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamResourceDiscoveries} method.
     * </p>
     * 
     * @return The resource discoveries.
     */
    public final List<IpamResourceDiscovery> ipamResourceDiscoveries() {
        return ipamResourceDiscoveries;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpamResourceDiscoveries() ? ipamResourceDiscoveries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamResourceDiscoveriesResponse)) {
            return false;
        }
        DescribeIpamResourceDiscoveriesResponse other = (DescribeIpamResourceDiscoveriesResponse) obj;
        return hasIpamResourceDiscoveries() == other.hasIpamResourceDiscoveries()
                && Objects.equals(ipamResourceDiscoveries(), other.ipamResourceDiscoveries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIpamResourceDiscoveriesResponse")
                .add("IpamResourceDiscoveries", hasIpamResourceDiscoveries() ? ipamResourceDiscoveries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamResourceDiscoveries":
            return Optional.ofNullable(clazz.cast(ipamResourceDiscoveries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamResourceDiscoveriesResponse, T> g) {
        return obj -> g.apply((DescribeIpamResourceDiscoveriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIpamResourceDiscoveriesResponse> {
        /**
         * <p>
         * The resource discoveries.
         * </p>
         * 
         * @param ipamResourceDiscoveries
         *        The resource discoveries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceDiscoveries(Collection<IpamResourceDiscovery> ipamResourceDiscoveries);

        /**
         * <p>
         * The resource discoveries.
         * </p>
         * 
         * @param ipamResourceDiscoveries
         *        The resource discoveries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceDiscoveries(IpamResourceDiscovery... ipamResourceDiscoveries);

        /**
         * <p>
         * The resource discoveries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery.Builder#build()} is called immediately
         * and its result is passed to {@link #ipamResourceDiscoveries(List<IpamResourceDiscovery>)}.
         * 
         * @param ipamResourceDiscoveries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamResourceDiscoveries(java.util.Collection<IpamResourceDiscovery>)
         */
        Builder ipamResourceDiscoveries(Consumer<IpamResourceDiscovery.Builder>... ipamResourceDiscoveries);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<IpamResourceDiscovery> ipamResourceDiscoveries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamResourceDiscoveriesResponse model) {
            super(model);
            ipamResourceDiscoveries(model.ipamResourceDiscoveries);
            nextToken(model.nextToken);
        }

        public final List<IpamResourceDiscovery.Builder> getIpamResourceDiscoveries() {
            List<IpamResourceDiscovery.Builder> result = IpamResourceDiscoverySetCopier
                    .copyToBuilder(this.ipamResourceDiscoveries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamResourceDiscoveries(Collection<IpamResourceDiscovery.BuilderImpl> ipamResourceDiscoveries) {
            this.ipamResourceDiscoveries = IpamResourceDiscoverySetCopier.copyFromBuilder(ipamResourceDiscoveries);
        }

        @Override
        public final Builder ipamResourceDiscoveries(Collection<IpamResourceDiscovery> ipamResourceDiscoveries) {
            this.ipamResourceDiscoveries = IpamResourceDiscoverySetCopier.copy(ipamResourceDiscoveries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceDiscoveries(IpamResourceDiscovery... ipamResourceDiscoveries) {
            ipamResourceDiscoveries(Arrays.asList(ipamResourceDiscoveries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceDiscoveries(Consumer<IpamResourceDiscovery.Builder>... ipamResourceDiscoveries) {
            ipamResourceDiscoveries(Stream.of(ipamResourceDiscoveries)
                    .map(c -> IpamResourceDiscovery.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIpamResourceDiscoveriesResponse build() {
            return new DescribeIpamResourceDiscoveriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
