/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConsoleScreenshotResponse extends Ec2Response implements
        ToCopyableBuilder<GetConsoleScreenshotResponse.Builder, GetConsoleScreenshotResponse> {
    private static final SdkField<String> IMAGE_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageData")
            .getter(getter(GetConsoleScreenshotResponse::imageData))
            .setter(setter(Builder::imageData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageData")
                    .unmarshallLocationName("imageData").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(GetConsoleScreenshotResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DATA_FIELD,
            INSTANCE_ID_FIELD));

    private final String imageData;

    private final String instanceId;

    private GetConsoleScreenshotResponse(BuilderImpl builder) {
        super(builder);
        this.imageData = builder.imageData;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The data that comprises the image.
     * </p>
     * 
     * @return The data that comprises the image.
     */
    public final String imageData() {
        return imageData;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageData());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleScreenshotResponse)) {
            return false;
        }
        GetConsoleScreenshotResponse other = (GetConsoleScreenshotResponse) obj;
        return Objects.equals(imageData(), other.imageData()) && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConsoleScreenshotResponse").add("ImageData", imageData()).add("InstanceId", instanceId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageData":
            return Optional.ofNullable(clazz.cast(imageData()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConsoleScreenshotResponse, T> g) {
        return obj -> g.apply((GetConsoleScreenshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetConsoleScreenshotResponse> {
        /**
         * <p>
         * The data that comprises the image.
         * </p>
         * 
         * @param imageData
         *        The data that comprises the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageData(String imageData);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String imageData;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleScreenshotResponse model) {
            super(model);
            imageData(model.imageData);
            instanceId(model.instanceId);
        }

        public final String getImageData() {
            return imageData;
        }

        public final void setImageData(String imageData) {
            this.imageData = imageData;
        }

        @Override
        public final Builder imageData(String imageData) {
            this.imageData = imageData;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public GetConsoleScreenshotResponse build() {
            return new GetConsoleScreenshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
