/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MoveCapacityReservationInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<MoveCapacityReservationInstancesRequest.Builder, MoveCapacityReservationInstancesRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(MoveCapacityReservationInstancesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(MoveCapacityReservationInstancesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SOURCE_CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCapacityReservationId")
            .getter(getter(MoveCapacityReservationInstancesRequest::sourceCapacityReservationId))
            .setter(setter(Builder::sourceCapacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservationId")
                    .unmarshallLocationName("SourceCapacityReservationId").build()).build();

    private static final SdkField<String> DESTINATION_CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCapacityReservationId")
            .getter(getter(MoveCapacityReservationInstancesRequest::destinationCapacityReservationId))
            .setter(setter(Builder::destinationCapacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCapacityReservationId")
                    .unmarshallLocationName("DestinationCapacityReservationId").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(MoveCapacityReservationInstancesRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            CLIENT_TOKEN_FIELD, SOURCE_CAPACITY_RESERVATION_ID_FIELD, DESTINATION_CAPACITY_RESERVATION_ID_FIELD,
            INSTANCE_COUNT_FIELD));

    private final Boolean dryRun;

    private final String clientToken;

    private final String sourceCapacityReservationId;

    private final String destinationCapacityReservationId;

    private final Integer instanceCount;

    private MoveCapacityReservationInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.sourceCapacityReservationId = builder.sourceCapacityReservationId;
        this.destinationCapacityReservationId = builder.destinationCapacityReservationId;
        this.instanceCount = builder.instanceCount;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation from which you want to move capacity.
     * </p>
     * 
     * @return The ID of the Capacity Reservation from which you want to move capacity.
     */
    public final String sourceCapacityReservationId() {
        return sourceCapacityReservationId;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation that you want to move capacity into.
     * </p>
     * 
     * @return The ID of the Capacity Reservation that you want to move capacity into.
     */
    public final String destinationCapacityReservationId() {
        return destinationCapacityReservationId;
    }

    /**
     * <p>
     * The number of instances that you want to move from the source Capacity Reservation.
     * </p>
     * 
     * @return The number of instances that you want to move from the source Capacity Reservation.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveCapacityReservationInstancesRequest)) {
            return false;
        }
        MoveCapacityReservationInstancesRequest other = (MoveCapacityReservationInstancesRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(sourceCapacityReservationId(), other.sourceCapacityReservationId())
                && Objects.equals(destinationCapacityReservationId(), other.destinationCapacityReservationId())
                && Objects.equals(instanceCount(), other.instanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MoveCapacityReservationInstancesRequest").add("DryRun", dryRun())
                .add("ClientToken", clientToken()).add("SourceCapacityReservationId", sourceCapacityReservationId())
                .add("DestinationCapacityReservationId", destinationCapacityReservationId())
                .add("InstanceCount", instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SourceCapacityReservationId":
            return Optional.ofNullable(clazz.cast(sourceCapacityReservationId()));
        case "DestinationCapacityReservationId":
            return Optional.ofNullable(clazz.cast(destinationCapacityReservationId()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MoveCapacityReservationInstancesRequest, T> g) {
        return obj -> g.apply((MoveCapacityReservationInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, MoveCapacityReservationInstancesRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Capacity Reservation from which you want to move capacity.
         * </p>
         * 
         * @param sourceCapacityReservationId
         *        The ID of the Capacity Reservation from which you want to move capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCapacityReservationId(String sourceCapacityReservationId);

        /**
         * <p>
         * The ID of the Capacity Reservation that you want to move capacity into.
         * </p>
         * 
         * @param destinationCapacityReservationId
         *        The ID of the Capacity Reservation that you want to move capacity into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCapacityReservationId(String destinationCapacityReservationId);

        /**
         * <p>
         * The number of instances that you want to move from the source Capacity Reservation.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that you want to move from the source Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String clientToken;

        private String sourceCapacityReservationId;

        private String destinationCapacityReservationId;

        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveCapacityReservationInstancesRequest model) {
            super(model);
            dryRun(model.dryRun);
            clientToken(model.clientToken);
            sourceCapacityReservationId(model.sourceCapacityReservationId);
            destinationCapacityReservationId(model.destinationCapacityReservationId);
            instanceCount(model.instanceCount);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceCapacityReservationId() {
            return sourceCapacityReservationId;
        }

        public final void setSourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
        }

        @Override
        public final Builder sourceCapacityReservationId(String sourceCapacityReservationId) {
            this.sourceCapacityReservationId = sourceCapacityReservationId;
            return this;
        }

        public final String getDestinationCapacityReservationId() {
            return destinationCapacityReservationId;
        }

        public final void setDestinationCapacityReservationId(String destinationCapacityReservationId) {
            this.destinationCapacityReservationId = destinationCapacityReservationId;
        }

        @Override
        public final Builder destinationCapacityReservationId(String destinationCapacityReservationId) {
            this.destinationCapacityReservationId = destinationCapacityReservationId;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MoveCapacityReservationInstancesRequest build() {
            return new MoveCapacityReservationInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
