/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of VPC Block Public Access (BPA).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockPublicAccessStates implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockPublicAccessStates.Builder, BlockPublicAccessStates> {
    private static final SdkField<String> INTERNET_GATEWAY_BLOCK_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InternetGatewayBlockMode")
            .getter(getter(BlockPublicAccessStates::internetGatewayBlockModeAsString))
            .setter(setter(Builder::internetGatewayBlockMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayBlockMode")
                    .unmarshallLocationName("internetGatewayBlockMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INTERNET_GATEWAY_BLOCK_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InternetGatewayBlockMode", INTERNET_GATEWAY_BLOCK_MODE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String internetGatewayBlockMode;

    private BlockPublicAccessStates(BuilderImpl builder) {
        this.internetGatewayBlockMode = builder.internetGatewayBlockMode;
    }

    /**
     * <p>
     * The mode of VPC BPA.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
     * internet gateways in this Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
     * gateways in this Region (except for excluded VPCs and subnets).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
     * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed because
     * these gateways only allow outbound connections to be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayBlockMode} will return {@link BlockPublicAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #internetGatewayBlockModeAsString}.
     * </p>
     * 
     * @return The mode of VPC BPA.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
     *         egress-only internet gateways in this Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
     *         internet gateways in this Region (except for excluded VPCs and subnets).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
     *         subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is
     *         allowed because these gateways only allow outbound connections to be established.
     *         </p>
     *         </li>
     * @see BlockPublicAccessMode
     */
    public final BlockPublicAccessMode internetGatewayBlockMode() {
        return BlockPublicAccessMode.fromValue(internetGatewayBlockMode);
    }

    /**
     * <p>
     * The mode of VPC BPA.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
     * internet gateways in this Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
     * gateways in this Region (except for excluded VPCs and subnets).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
     * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed because
     * these gateways only allow outbound connections to be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #internetGatewayBlockMode} will return {@link BlockPublicAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #internetGatewayBlockModeAsString}.
     * </p>
     * 
     * @return The mode of VPC BPA.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
     *         egress-only internet gateways in this Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
     *         internet gateways in this Region (except for excluded VPCs and subnets).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
     *         subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is
     *         allowed because these gateways only allow outbound connections to be established.
     *         </p>
     *         </li>
     * @see BlockPublicAccessMode
     */
    public final String internetGatewayBlockModeAsString() {
        return internetGatewayBlockMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayBlockModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPublicAccessStates)) {
            return false;
        }
        BlockPublicAccessStates other = (BlockPublicAccessStates) obj;
        return Objects.equals(internetGatewayBlockModeAsString(), other.internetGatewayBlockModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockPublicAccessStates").add("InternetGatewayBlockMode", internetGatewayBlockModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InternetGatewayBlockMode":
            return Optional.ofNullable(clazz.cast(internetGatewayBlockModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BlockPublicAccessStates, T> g) {
        return obj -> g.apply((BlockPublicAccessStates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockPublicAccessStates> {
        /**
         * <p>
         * The mode of VPC BPA.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
         * internet gateways in this Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
         * gateways in this Region (except for excluded VPCs and subnets).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
         * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed
         * because these gateways only allow outbound connections to be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayBlockMode
         *        The mode of VPC BPA.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
         *        egress-only internet gateways in this Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
         *        internet gateways in this Region (except for excluded VPCs and subnets).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
         *        subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways
         *        is allowed because these gateways only allow outbound connections to be established.
         *        </p>
         *        </li>
         * @see BlockPublicAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockPublicAccessMode
         */
        Builder internetGatewayBlockMode(String internetGatewayBlockMode);

        /**
         * <p>
         * The mode of VPC BPA.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and egress-only
         * internet gateways in this Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only internet
         * gateways in this Region (except for excluded VPCs and subnets).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or subnets
         * which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways is allowed
         * because these gateways only allow outbound connections to be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param internetGatewayBlockMode
         *        The mode of VPC BPA.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>off</code>: VPC BPA is not enabled and traffic is allowed to and from internet gateways and
         *        egress-only internet gateways in this Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-bidirectional</code>: Block all traffic to and from internet gateways and egress-only
         *        internet gateways in this Region (except for excluded VPCs and subnets).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-ingress</code>: Block all internet traffic to the VPCs in this Region (except for VPCs or
         *        subnets which are excluded). Only traffic to and from NAT gateways and egress-only internet gateways
         *        is allowed because these gateways only allow outbound connections to be established.
         *        </p>
         *        </li>
         * @see BlockPublicAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockPublicAccessMode
         */
        Builder internetGatewayBlockMode(BlockPublicAccessMode internetGatewayBlockMode);
    }

    static final class BuilderImpl implements Builder {
        private String internetGatewayBlockMode;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockPublicAccessStates model) {
            internetGatewayBlockMode(model.internetGatewayBlockMode);
        }

        public final String getInternetGatewayBlockMode() {
            return internetGatewayBlockMode;
        }

        public final void setInternetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
        }

        @Override
        public final Builder internetGatewayBlockMode(String internetGatewayBlockMode) {
            this.internetGatewayBlockMode = internetGatewayBlockMode;
            return this;
        }

        @Override
        public final Builder internetGatewayBlockMode(BlockPublicAccessMode internetGatewayBlockMode) {
            this.internetGatewayBlockMode(internetGatewayBlockMode == null ? null : internetGatewayBlockMode.toString());
            return this;
        }

        @Override
        public BlockPublicAccessStates build() {
            return new BlockPublicAccessStates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
