/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelImportTaskResponse extends Ec2Response implements
        ToCopyableBuilder<CancelImportTaskResponse.Builder, CancelImportTaskResponse> {
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImportTaskId")
            .getter(getter(CancelImportTaskResponse::importTaskId))
            .setter(setter(Builder::importTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId")
                    .unmarshallLocationName("importTaskId").build()).build();

    private static final SdkField<String> PREVIOUS_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousState")
            .getter(getter(CancelImportTaskResponse::previousState))
            .setter(setter(Builder::previousState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousState")
                    .unmarshallLocationName("previousState").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(CancelImportTaskResponse::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_ID_FIELD,
            PREVIOUS_STATE_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ImportTaskId", IMPORT_TASK_ID_FIELD);
                    put("PreviousState", PREVIOUS_STATE_FIELD);
                    put("State", STATE_FIELD);
                }
            });

    private final String importTaskId;

    private final String previousState;

    private final String state;

    private CancelImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.importTaskId = builder.importTaskId;
        this.previousState = builder.previousState;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the task being canceled.
     * </p>
     * 
     * @return The ID of the task being canceled.
     */
    public final String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * The current state of the task being canceled.
     * </p>
     * 
     * @return The current state of the task being canceled.
     */
    public final String previousState() {
        return previousState;
    }

    /**
     * <p>
     * The current state of the task being canceled.
     * </p>
     * 
     * @return The current state of the task being canceled.
     */
    public final String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(previousState());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskResponse)) {
            return false;
        }
        CancelImportTaskResponse other = (CancelImportTaskResponse) obj;
        return Objects.equals(importTaskId(), other.importTaskId()) && Objects.equals(previousState(), other.previousState())
                && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelImportTaskResponse").add("ImportTaskId", importTaskId())
                .add("PreviousState", previousState()).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportTaskId":
            return Optional.ofNullable(clazz.cast(importTaskId()));
        case "PreviousState":
            return Optional.ofNullable(clazz.cast(previousState()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelImportTaskResponse, T> g) {
        return obj -> g.apply((CancelImportTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CancelImportTaskResponse> {
        /**
         * <p>
         * The ID of the task being canceled.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the task being canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * The current state of the task being canceled.
         * </p>
         * 
         * @param previousState
         *        The current state of the task being canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousState(String previousState);

        /**
         * <p>
         * The current state of the task being canceled.
         * </p>
         * 
         * @param state
         *        The current state of the task being canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String importTaskId;

        private String previousState;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskResponse model) {
            super(model);
            importTaskId(model.importTaskId);
            previousState(model.previousState);
            state(model.state);
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final String getPreviousState() {
            return previousState;
        }

        public final void setPreviousState(String previousState) {
            this.previousState = previousState;
        }

        @Override
        public final Builder previousState(String previousState) {
            this.previousState = previousState;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public CancelImportTaskResponse build() {
            return new CancelImportTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
