/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about your commitment for a future-dated Capacity Reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationCommitmentInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationCommitmentInfo.Builder, CapacityReservationCommitmentInfo> {
    private static final SdkField<Integer> COMMITTED_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CommittedInstanceCount")
            .getter(getter(CapacityReservationCommitmentInfo::committedInstanceCount))
            .setter(setter(Builder::committedInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommittedInstanceCount")
                    .unmarshallLocationName("committedInstanceCount").build()).build();

    private static final SdkField<Instant> COMMITMENT_END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CommitmentEndDate")
            .getter(getter(CapacityReservationCommitmentInfo::commitmentEndDate))
            .setter(setter(Builder::commitmentEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitmentEndDate")
                    .unmarshallLocationName("commitmentEndDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMMITTED_INSTANCE_COUNT_FIELD, COMMITMENT_END_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CommittedInstanceCount", COMMITTED_INSTANCE_COUNT_FIELD);
                    put("CommitmentEndDate", COMMITMENT_END_DATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer committedInstanceCount;

    private final Instant commitmentEndDate;

    private CapacityReservationCommitmentInfo(BuilderImpl builder) {
        this.committedInstanceCount = builder.committedInstanceCount;
        this.commitmentEndDate = builder.commitmentEndDate;
    }

    /**
     * <p>
     * The instance capacity that you committed to when you requested the future-dated Capacity Reservation.
     * </p>
     * 
     * @return The instance capacity that you committed to when you requested the future-dated Capacity Reservation.
     */
    public final Integer committedInstanceCount() {
        return committedInstanceCount;
    }

    /**
     * <p>
     * The date and time at which the commitment duration expires, in the ISO8601 format in the UTC time zone (
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>). You can't decrease the instance count or cancel the Capacity Reservation
     * before this date and time.
     * </p>
     * 
     * @return The date and time at which the commitment duration expires, in the ISO8601 format in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>). You can't decrease the instance count or cancel the Capacity
     *         Reservation before this date and time.
     */
    public final Instant commitmentEndDate() {
        return commitmentEndDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(committedInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentEndDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationCommitmentInfo)) {
            return false;
        }
        CapacityReservationCommitmentInfo other = (CapacityReservationCommitmentInfo) obj;
        return Objects.equals(committedInstanceCount(), other.committedInstanceCount())
                && Objects.equals(commitmentEndDate(), other.commitmentEndDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservationCommitmentInfo").add("CommittedInstanceCount", committedInstanceCount())
                .add("CommitmentEndDate", commitmentEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommittedInstanceCount":
            return Optional.ofNullable(clazz.cast(committedInstanceCount()));
        case "CommitmentEndDate":
            return Optional.ofNullable(clazz.cast(commitmentEndDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationCommitmentInfo, T> g) {
        return obj -> g.apply((CapacityReservationCommitmentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationCommitmentInfo> {
        /**
         * <p>
         * The instance capacity that you committed to when you requested the future-dated Capacity Reservation.
         * </p>
         * 
         * @param committedInstanceCount
         *        The instance capacity that you committed to when you requested the future-dated Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder committedInstanceCount(Integer committedInstanceCount);

        /**
         * <p>
         * The date and time at which the commitment duration expires, in the ISO8601 format in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>). You can't decrease the instance count or cancel the Capacity
         * Reservation before this date and time.
         * </p>
         * 
         * @param commitmentEndDate
         *        The date and time at which the commitment duration expires, in the ISO8601 format in the UTC time zone
         *        (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>). You can't decrease the instance count or cancel the Capacity
         *        Reservation before this date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentEndDate(Instant commitmentEndDate);
    }

    static final class BuilderImpl implements Builder {
        private Integer committedInstanceCount;

        private Instant commitmentEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationCommitmentInfo model) {
            committedInstanceCount(model.committedInstanceCount);
            commitmentEndDate(model.commitmentEndDate);
        }

        public final Integer getCommittedInstanceCount() {
            return committedInstanceCount;
        }

        public final void setCommittedInstanceCount(Integer committedInstanceCount) {
            this.committedInstanceCount = committedInstanceCount;
        }

        @Override
        public final Builder committedInstanceCount(Integer committedInstanceCount) {
            this.committedInstanceCount = committedInstanceCount;
            return this;
        }

        public final Instant getCommitmentEndDate() {
            return commitmentEndDate;
        }

        public final void setCommitmentEndDate(Instant commitmentEndDate) {
            this.commitmentEndDate = commitmentEndDate;
        }

        @Override
        public final Builder commitmentEndDate(Instant commitmentEndDate) {
            this.commitmentEndDate = commitmentEndDate;
            return this;
        }

        @Override
        public CapacityReservationCommitmentInfo build() {
            return new CapacityReservationCommitmentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
