/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityBlockExtensionOfferingsResponse extends Ec2Response
        implements
        ToCopyableBuilder<DescribeCapacityBlockExtensionOfferingsResponse.Builder, DescribeCapacityBlockExtensionOfferingsResponse> {
    private static final SdkField<List<CapacityBlockExtensionOffering>> CAPACITY_BLOCK_EXTENSION_OFFERINGS_FIELD = SdkField
            .<List<CapacityBlockExtensionOffering>> builder(MarshallingType.LIST)
            .memberName("CapacityBlockExtensionOfferings")
            .getter(getter(DescribeCapacityBlockExtensionOfferingsResponse::capacityBlockExtensionOfferings))
            .setter(setter(Builder::capacityBlockExtensionOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionOfferingSet")
                    .unmarshallLocationName("capacityBlockExtensionOfferingSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityBlockExtensionOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityBlockExtensionOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityBlockExtensionOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_BLOCK_EXTENSION_OFFERINGS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CapacityBlockExtensionOfferingSet", CAPACITY_BLOCK_EXTENSION_OFFERINGS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings;

    private final String nextToken;

    private DescribeCapacityBlockExtensionOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.capacityBlockExtensionOfferings = builder.capacityBlockExtensionOfferings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityBlockExtensionOfferings
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCapacityBlockExtensionOfferings() {
        return capacityBlockExtensionOfferings != null && !(capacityBlockExtensionOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommended Capacity Block extension offerings for the dates specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityBlockExtensionOfferings}
     * method.
     * </p>
     * 
     * @return The recommended Capacity Block extension offerings for the dates specified.
     */
    public final List<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings() {
        return capacityBlockExtensionOfferings;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCapacityBlockExtensionOfferings() ? capacityBlockExtensionOfferings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockExtensionOfferingsResponse)) {
            return false;
        }
        DescribeCapacityBlockExtensionOfferingsResponse other = (DescribeCapacityBlockExtensionOfferingsResponse) obj;
        return hasCapacityBlockExtensionOfferings() == other.hasCapacityBlockExtensionOfferings()
                && Objects.equals(capacityBlockExtensionOfferings(), other.capacityBlockExtensionOfferings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeCapacityBlockExtensionOfferingsResponse")
                .add("CapacityBlockExtensionOfferings",
                        hasCapacityBlockExtensionOfferings() ? capacityBlockExtensionOfferings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityBlockExtensionOfferings":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensionOfferings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockExtensionOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityBlockExtensionOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCapacityBlockExtensionOfferingsResponse> {
        /**
         * <p>
         * The recommended Capacity Block extension offerings for the dates specified.
         * </p>
         * 
         * @param capacityBlockExtensionOfferings
         *        The recommended Capacity Block extension offerings for the dates specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionOfferings(Collection<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings);

        /**
         * <p>
         * The recommended Capacity Block extension offerings for the dates specified.
         * </p>
         * 
         * @param capacityBlockExtensionOfferings
         *        The recommended Capacity Block extension offerings for the dates specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensionOfferings(CapacityBlockExtensionOffering... capacityBlockExtensionOfferings);

        /**
         * <p>
         * The recommended Capacity Block extension offerings for the dates specified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOffering.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOffering.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #capacityBlockExtensionOfferings(List<CapacityBlockExtensionOffering>)}.
         * 
         * @param capacityBlockExtensionOfferings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityBlockExtensionOfferings(java.util.Collection<CapacityBlockExtensionOffering>)
         */
        Builder capacityBlockExtensionOfferings(
                Consumer<CapacityBlockExtensionOffering.Builder>... capacityBlockExtensionOfferings);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockExtensionOfferingsResponse model) {
            super(model);
            capacityBlockExtensionOfferings(model.capacityBlockExtensionOfferings);
            nextToken(model.nextToken);
        }

        public final List<CapacityBlockExtensionOffering.Builder> getCapacityBlockExtensionOfferings() {
            List<CapacityBlockExtensionOffering.Builder> result = CapacityBlockExtensionOfferingSetCopier
                    .copyToBuilder(this.capacityBlockExtensionOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlockExtensionOfferings(
                Collection<CapacityBlockExtensionOffering.BuilderImpl> capacityBlockExtensionOfferings) {
            this.capacityBlockExtensionOfferings = CapacityBlockExtensionOfferingSetCopier
                    .copyFromBuilder(capacityBlockExtensionOfferings);
        }

        @Override
        public final Builder capacityBlockExtensionOfferings(
                Collection<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings) {
            this.capacityBlockExtensionOfferings = CapacityBlockExtensionOfferingSetCopier.copy(capacityBlockExtensionOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensionOfferings(CapacityBlockExtensionOffering... capacityBlockExtensionOfferings) {
            capacityBlockExtensionOfferings(Arrays.asList(capacityBlockExtensionOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensionOfferings(
                Consumer<CapacityBlockExtensionOffering.Builder>... capacityBlockExtensionOfferings) {
            capacityBlockExtensionOfferings(Stream.of(capacityBlockExtensionOfferings)
                    .map(c -> CapacityBlockExtensionOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityBlockExtensionOfferingsResponse build() {
            return new DescribeCapacityBlockExtensionOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
