/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures ENA Express for UDP network traffic from your launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnaSrdUdpSpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<EnaSrdUdpSpecificationRequest.Builder, EnaSrdUdpSpecificationRequest> {
    private static final SdkField<Boolean> ENA_SRD_UDP_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnaSrdUdpEnabled")
            .getter(getter(EnaSrdUdpSpecificationRequest::enaSrdUdpEnabled))
            .setter(setter(Builder::enaSrdUdpEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdUdpEnabled")
                    .unmarshallLocationName("EnaSrdUdpEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENA_SRD_UDP_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EnaSrdUdpEnabled", ENA_SRD_UDP_ENABLED_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean enaSrdUdpEnabled;

    private EnaSrdUdpSpecificationRequest(BuilderImpl builder) {
        this.enaSrdUdpEnabled = builder.enaSrdUdpEnabled;
    }

    /**
     * <p>
     * Indicates whether UDP traffic uses ENA Express for your instance. To ensure that UDP traffic can use ENA Express
     * when you launch an instance, you must also set <b>EnaSrdEnabled</b> in the <b>EnaSrdSpecificationRequest</b> to
     * <code>true</code> in your launch template.
     * </p>
     * 
     * @return Indicates whether UDP traffic uses ENA Express for your instance. To ensure that UDP traffic can use ENA
     *         Express when you launch an instance, you must also set <b>EnaSrdEnabled</b> in the
     *         <b>EnaSrdSpecificationRequest</b> to <code>true</code> in your launch template.
     */
    public final Boolean enaSrdUdpEnabled() {
        return enaSrdUdpEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdUdpEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnaSrdUdpSpecificationRequest)) {
            return false;
        }
        EnaSrdUdpSpecificationRequest other = (EnaSrdUdpSpecificationRequest) obj;
        return Objects.equals(enaSrdUdpEnabled(), other.enaSrdUdpEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnaSrdUdpSpecificationRequest").add("EnaSrdUdpEnabled", enaSrdUdpEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnaSrdUdpEnabled":
            return Optional.ofNullable(clazz.cast(enaSrdUdpEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnaSrdUdpSpecificationRequest, T> g) {
        return obj -> g.apply((EnaSrdUdpSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnaSrdUdpSpecificationRequest> {
        /**
         * <p>
         * Indicates whether UDP traffic uses ENA Express for your instance. To ensure that UDP traffic can use ENA
         * Express when you launch an instance, you must also set <b>EnaSrdEnabled</b> in the
         * <b>EnaSrdSpecificationRequest</b> to <code>true</code> in your launch template.
         * </p>
         * 
         * @param enaSrdUdpEnabled
         *        Indicates whether UDP traffic uses ENA Express for your instance. To ensure that UDP traffic can use
         *        ENA Express when you launch an instance, you must also set <b>EnaSrdEnabled</b> in the
         *        <b>EnaSrdSpecificationRequest</b> to <code>true</code> in your launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdUdpEnabled(Boolean enaSrdUdpEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enaSrdUdpEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EnaSrdUdpSpecificationRequest model) {
            enaSrdUdpEnabled(model.enaSrdUdpEnabled);
        }

        public final Boolean getEnaSrdUdpEnabled() {
            return enaSrdUdpEnabled;
        }

        public final void setEnaSrdUdpEnabled(Boolean enaSrdUdpEnabled) {
            this.enaSrdUdpEnabled = enaSrdUdpEnabled;
        }

        @Override
        public final Builder enaSrdUdpEnabled(Boolean enaSrdUdpEnabled) {
            this.enaSrdUdpEnabled = enaSrdUdpEnabled;
            return this;
        }

        @Override
        public EnaSrdUdpSpecificationRequest build() {
            return new EnaSrdUdpSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
