/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchPermission implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchPermission.Builder, LaunchPermission> {
    private static final SdkField<String> ORGANIZATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationArn")
            .getter(getter(LaunchPermission::organizationArn))
            .setter(setter(Builder::organizationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationArn")
                    .unmarshallLocationName("organizationArn").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitArn")
            .getter(getter(LaunchPermission::organizationalUnitArn))
            .setter(setter(Builder::organizationalUnitArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitArn")
                    .unmarshallLocationName("organizationalUnitArn").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserId")
            .getter(getter(LaunchPermission::userId))
            .setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId")
                    .unmarshallLocationName("userId").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Group")
            .getter(getter(LaunchPermission::groupAsString))
            .setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group")
                    .unmarshallLocationName("group").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ARN_FIELD,
            ORGANIZATIONAL_UNIT_ARN_FIELD, USER_ID_FIELD, GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OrganizationArn", ORGANIZATION_ARN_FIELD);
                    put("OrganizationalUnitArn", ORGANIZATIONAL_UNIT_ARN_FIELD);
                    put("UserId", USER_ID_FIELD);
                    put("Group", GROUP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String organizationArn;

    private final String organizationalUnitArn;

    private final String userId;

    private final String group;

    private LaunchPermission(BuilderImpl builder) {
        this.organizationArn = builder.organizationArn;
        this.organizationalUnitArn = builder.organizationalUnitArn;
        this.userId = builder.userId;
        this.group = builder.group;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an organization.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an organization.
     */
    public final String organizationArn() {
        return organizationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an organizational unit (OU).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an organizational unit (OU).
     */
    public final String organizationalUnitArn() {
        return organizationalUnitArn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * <p>
     * Constraints: Up to 10 000 account IDs can be specified in a single request.
     * </p>
     * 
     * @return The Amazon Web Services account ID.</p>
     *         <p>
     *         Constraints: Up to 10 000 account IDs can be specified in a single request.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public final PermissionGroup group() {
        return PermissionGroup.fromValue(group);
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The name of the group.
     * @see PermissionGroup
     */
    public final String groupAsString() {
        return group;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitArn());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(groupAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermission)) {
            return false;
        }
        LaunchPermission other = (LaunchPermission) obj;
        return Objects.equals(organizationArn(), other.organizationArn())
                && Objects.equals(organizationalUnitArn(), other.organizationalUnitArn())
                && Objects.equals(userId(), other.userId()) && Objects.equals(groupAsString(), other.groupAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchPermission").add("OrganizationArn", organizationArn())
                .add("OrganizationalUnitArn", organizationalUnitArn()).add("UserId", userId()).add("Group", groupAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationArn":
            return Optional.ofNullable(clazz.cast(organizationArn()));
        case "OrganizationalUnitArn":
            return Optional.ofNullable(clazz.cast(organizationalUnitArn()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Group":
            return Optional.ofNullable(clazz.cast(groupAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LaunchPermission, T> g) {
        return obj -> g.apply((LaunchPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchPermission> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an organization.
         * </p>
         * 
         * @param organizationArn
         *        The Amazon Resource Name (ARN) of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationArn(String organizationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an organizational unit (OU).
         * </p>
         * 
         * @param organizationalUnitArn
         *        The Amazon Resource Name (ARN) of an organizational unit (OU).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitArn(String organizationalUnitArn);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * <p>
         * Constraints: Up to 10 000 account IDs can be specified in a single request.
         * </p>
         * 
         * @param userId
         *        The Amazon Web Services account ID.</p>
         *        <p>
         *        Constraints: Up to 10 000 account IDs can be specified in a single request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(String group);

        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param group
         *        The name of the group.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(PermissionGroup group);
    }

    static final class BuilderImpl implements Builder {
        private String organizationArn;

        private String organizationalUnitArn;

        private String userId;

        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermission model) {
            organizationArn(model.organizationArn);
            organizationalUnitArn(model.organizationalUnitArn);
            userId(model.userId);
            group(model.group);
        }

        public final String getOrganizationArn() {
            return organizationArn;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final String getOrganizationalUnitArn() {
            return organizationalUnitArn;
        }

        public final void setOrganizationalUnitArn(String organizationalUnitArn) {
            this.organizationalUnitArn = organizationalUnitArn;
        }

        @Override
        public final Builder organizationalUnitArn(String organizationalUnitArn) {
            this.organizationalUnitArn = organizationalUnitArn;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group == null ? null : group.toString());
            return this;
        }

        @Override
        public LaunchPermission build() {
            return new LaunchPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
