/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceCreditSpecificationRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyInstanceCreditSpecificationRequest.Builder, ModifyInstanceCreditSpecificationRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyInstanceCreditSpecificationRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ModifyInstanceCreditSpecificationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<List<InstanceCreditSpecificationRequest>> INSTANCE_CREDIT_SPECIFICATIONS_FIELD = SdkField
            .<List<InstanceCreditSpecificationRequest>> builder(MarshallingType.LIST)
            .memberName("InstanceCreditSpecifications")
            .getter(getter(ModifyInstanceCreditSpecificationRequest::instanceCreditSpecifications))
            .setter(setter(Builder::instanceCreditSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreditSpecification")
                    .unmarshallLocationName("InstanceCreditSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceCreditSpecificationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceCreditSpecificationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            CLIENT_TOKEN_FIELD, INSTANCE_CREDIT_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                    put("InstanceCreditSpecification", INSTANCE_CREDIT_SPECIFICATIONS_FIELD);
                }
            });

    private final Boolean dryRun;

    private final String clientToken;

    private final List<InstanceCreditSpecificationRequest> instanceCreditSpecifications;

    private ModifyInstanceCreditSpecificationRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.instanceCreditSpecifications = builder.instanceCreditSpecifications;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the operation, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the operation, without actually making the request,
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceCreditSpecifications property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstanceCreditSpecifications() {
        return instanceCreditSpecifications != null && !(instanceCreditSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the credit option for CPU usage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceCreditSpecifications} method.
     * </p>
     * 
     * @return Information about the credit option for CPU usage.
     */
    public final List<InstanceCreditSpecificationRequest> instanceCreditSpecifications() {
        return instanceCreditSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceCreditSpecifications() ? instanceCreditSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCreditSpecificationRequest)) {
            return false;
        }
        ModifyInstanceCreditSpecificationRequest other = (ModifyInstanceCreditSpecificationRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(clientToken(), other.clientToken())
                && hasInstanceCreditSpecifications() == other.hasInstanceCreditSpecifications()
                && Objects.equals(instanceCreditSpecifications(), other.instanceCreditSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceCreditSpecificationRequest").add("DryRun", dryRun())
                .add("ClientToken", clientToken())
                .add("InstanceCreditSpecifications", hasInstanceCreditSpecifications() ? instanceCreditSpecifications() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceCreditSpecifications":
            return Optional.ofNullable(clazz.cast(instanceCreditSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCreditSpecificationRequest, T> g) {
        return obj -> g.apply((ModifyInstanceCreditSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyInstanceCreditSpecificationRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the operation, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the operation, without actually making the
         *        request, and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure idempotency of your modification request.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Information about the credit option for CPU usage.
         * </p>
         * 
         * @param instanceCreditSpecifications
         *        Information about the credit option for CPU usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreditSpecifications(Collection<InstanceCreditSpecificationRequest> instanceCreditSpecifications);

        /**
         * <p>
         * Information about the credit option for CPU usage.
         * </p>
         * 
         * @param instanceCreditSpecifications
         *        Information about the credit option for CPU usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreditSpecifications(InstanceCreditSpecificationRequest... instanceCreditSpecifications);

        /**
         * <p>
         * Information about the credit option for CPU usage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #instanceCreditSpecifications(List<InstanceCreditSpecificationRequest>)}.
         * 
         * @param instanceCreditSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceCreditSpecifications(java.util.Collection<InstanceCreditSpecificationRequest>)
         */
        Builder instanceCreditSpecifications(Consumer<InstanceCreditSpecificationRequest.Builder>... instanceCreditSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String clientToken;

        private List<InstanceCreditSpecificationRequest> instanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCreditSpecificationRequest model) {
            super(model);
            dryRun(model.dryRun);
            clientToken(model.clientToken);
            instanceCreditSpecifications(model.instanceCreditSpecifications);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<InstanceCreditSpecificationRequest.Builder> getInstanceCreditSpecifications() {
            List<InstanceCreditSpecificationRequest.Builder> result = InstanceCreditSpecificationListRequestCopier
                    .copyToBuilder(this.instanceCreditSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceCreditSpecifications(
                Collection<InstanceCreditSpecificationRequest.BuilderImpl> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListRequestCopier
                    .copyFromBuilder(instanceCreditSpecifications);
        }

        @Override
        public final Builder instanceCreditSpecifications(
                Collection<InstanceCreditSpecificationRequest> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListRequestCopier.copy(instanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(InstanceCreditSpecificationRequest... instanceCreditSpecifications) {
            instanceCreditSpecifications(Arrays.asList(instanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(
                Consumer<InstanceCreditSpecificationRequest.Builder>... instanceCreditSpecifications) {
            instanceCreditSpecifications(Stream.of(instanceCreditSpecifications)
                    .map(c -> InstanceCreditSpecificationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceCreditSpecificationRequest build() {
            return new ModifyInstanceCreditSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
