/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether the resource is managed by an entity and, if so, describes the entity that manages it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperatorResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<OperatorResponse.Builder, OperatorResponse> {
    private static final SdkField<Boolean> MANAGED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Managed")
            .getter(getter(OperatorResponse::managed))
            .setter(setter(Builder::managed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Managed")
                    .unmarshallLocationName("managed").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Principal")
            .getter(getter(OperatorResponse::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal")
                    .unmarshallLocationName("principal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MANAGED_FIELD, PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Managed", MANAGED_FIELD);
                    put("Principal", PRINCIPAL_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean managed;

    private final String principal;

    private OperatorResponse(BuilderImpl builder) {
        this.managed = builder.managed;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * If <code>true</code>, the resource is managed by an entity.
     * </p>
     * 
     * @return If <code>true</code>, the resource is managed by an entity.
     */
    public final Boolean managed() {
        return managed;
    }

    /**
     * <p>
     * If <code>managed</code> is <code>true</code>, then the principal is returned. The principal is the entity that
     * manages the resource.
     * </p>
     * 
     * @return If <code>managed</code> is <code>true</code>, then the principal is returned. The principal is the entity
     *         that manages the resource.
     */
    public final String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(managed());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatorResponse)) {
            return false;
        }
        OperatorResponse other = (OperatorResponse) obj;
        return Objects.equals(managed(), other.managed()) && Objects.equals(principal(), other.principal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperatorResponse").add("Managed", managed()).add("Principal", principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Managed":
            return Optional.ofNullable(clazz.cast(managed()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OperatorResponse, T> g) {
        return obj -> g.apply((OperatorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperatorResponse> {
        /**
         * <p>
         * If <code>true</code>, the resource is managed by an entity.
         * </p>
         * 
         * @param managed
         *        If <code>true</code>, the resource is managed by an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managed(Boolean managed);

        /**
         * <p>
         * If <code>managed</code> is <code>true</code>, then the principal is returned. The principal is the entity
         * that manages the resource.
         * </p>
         * 
         * @param principal
         *        If <code>managed</code> is <code>true</code>, then the principal is returned. The principal is the
         *        entity that manages the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);
    }

    static final class BuilderImpl implements Builder {
        private Boolean managed;

        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(OperatorResponse model) {
            managed(model.managed);
            principal(model.principal);
        }

        public final Boolean getManaged() {
            return managed;
        }

        public final void setManaged(Boolean managed) {
            this.managed = managed;
        }

        @Override
        public final Builder managed(Boolean managed) {
            this.managed = managed;
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public OperatorResponse build() {
            return new OperatorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
