/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a CIDR block for an address pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PoolCidrBlock implements SdkPojo, Serializable, ToCopyableBuilder<PoolCidrBlock.Builder, PoolCidrBlock> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(PoolCidrBlock::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolCidrBlock")
                    .unmarshallLocationName("poolCidrBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("PoolCidrBlock", CIDR_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private PoolCidrBlock(BuilderImpl builder) {
        this.cidr = builder.cidr;
    }

    /**
     * <p>
     * The CIDR block.
     * </p>
     * 
     * @return The CIDR block.
     */
    public final String cidr() {
        return cidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PoolCidrBlock)) {
            return false;
        }
        PoolCidrBlock other = (PoolCidrBlock) obj;
        return Objects.equals(cidr(), other.cidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PoolCidrBlock").add("Cidr", cidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PoolCidrBlock, T> g) {
        return obj -> g.apply((PoolCidrBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PoolCidrBlock> {
        /**
         * <p>
         * The CIDR block.
         * </p>
         * 
         * @param cidr
         *        The CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(PoolCidrBlock model) {
            cidr(model.cidr);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        @Override
        public PoolCidrBlock build() {
            return new PoolCidrBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
