/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AnalysisComponent;
import software.amazon.awssdk.services.ec2.model.AnalysisComponentListCopier;
import software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPair;
import software.amazon.awssdk.services.ec2.model.RuleGroupRuleOptionsPairListCopier;
import software.amazon.awssdk.services.ec2.model.RuleGroupTypePair;
import software.amazon.awssdk.services.ec2.model.RuleGroupTypePairListCopier;
import software.amazon.awssdk.services.ec2.model.RuleOption;
import software.amazon.awssdk.services.ec2.model.RuleOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalDetail> {
    private static final SdkField<String> ADDITIONAL_DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalDetailType").getter(AdditionalDetail.getter(AdditionalDetail::additionalDetailType)).setter(AdditionalDetail.setter(Builder::additionalDetailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetailType").unmarshallLocationName("additionalDetailType").build()}).build();
    private static final SdkField<AnalysisComponent> COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Component").getter(AdditionalDetail.getter(AdditionalDetail::component)).setter(AdditionalDetail.setter(Builder::component)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component").unmarshallLocationName("component").build()}).build();
    private static final SdkField<AnalysisComponent> VPC_ENDPOINT_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcEndpointService").getter(AdditionalDetail.getter(AdditionalDetail::vpcEndpointService)).setter(AdditionalDetail.setter(Builder::vpcEndpointService)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointService").unmarshallLocationName("vpcEndpointService").build()}).build();
    private static final SdkField<List<RuleOption>> RULE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleOptions").getter(AdditionalDetail.getter(AdditionalDetail::ruleOptions)).setter(AdditionalDetail.setter(Builder::ruleOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOptionSet").unmarshallLocationName("ruleOptionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<RuleGroupTypePair>> RULE_GROUP_TYPE_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroupTypePairs").getter(AdditionalDetail.getter(AdditionalDetail::ruleGroupTypePairs)).setter(AdditionalDetail.setter(Builder::ruleGroupTypePairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupTypePairSet").unmarshallLocationName("ruleGroupTypePairSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupTypePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<RuleGroupRuleOptionsPair>> RULE_GROUP_RULE_OPTIONS_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleGroupRuleOptionsPairs").getter(AdditionalDetail.getter(AdditionalDetail::ruleGroupRuleOptionsPairs)).setter(AdditionalDetail.setter(Builder::ruleGroupRuleOptionsPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupRuleOptionsPairSet").unmarshallLocationName("ruleGroupRuleOptionsPairSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupRuleOptionsPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(AdditionalDetail.getter(AdditionalDetail::serviceName)).setter(AdditionalDetail.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").unmarshallLocationName("serviceName").build()}).build();
    private static final SdkField<List<AnalysisComponent>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancers").getter(AdditionalDetail.getter(AdditionalDetail::loadBalancers)).setter(AdditionalDetail.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerSet").unmarshallLocationName("loadBalancerSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_DETAIL_TYPE_FIELD, COMPONENT_FIELD, VPC_ENDPOINT_SERVICE_FIELD, RULE_OPTIONS_FIELD, RULE_GROUP_TYPE_PAIRS_FIELD, RULE_GROUP_RULE_OPTIONS_PAIRS_FIELD, SERVICE_NAME_FIELD, LOAD_BALANCERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AdditionalDetailType", ADDITIONAL_DETAIL_TYPE_FIELD);
            this.put("Component", COMPONENT_FIELD);
            this.put("VpcEndpointService", VPC_ENDPOINT_SERVICE_FIELD);
            this.put("RuleOptionSet", RULE_OPTIONS_FIELD);
            this.put("RuleGroupTypePairSet", RULE_GROUP_TYPE_PAIRS_FIELD);
            this.put("RuleGroupRuleOptionsPairSet", RULE_GROUP_RULE_OPTIONS_PAIRS_FIELD);
            this.put("ServiceName", SERVICE_NAME_FIELD);
            this.put("LoadBalancerSet", LOAD_BALANCERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String additionalDetailType;
    private final AnalysisComponent component;
    private final AnalysisComponent vpcEndpointService;
    private final List<RuleOption> ruleOptions;
    private final List<RuleGroupTypePair> ruleGroupTypePairs;
    private final List<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs;
    private final String serviceName;
    private final List<AnalysisComponent> loadBalancers;

    private AdditionalDetail(BuilderImpl builder) {
        this.additionalDetailType = builder.additionalDetailType;
        this.component = builder.component;
        this.vpcEndpointService = builder.vpcEndpointService;
        this.ruleOptions = builder.ruleOptions;
        this.ruleGroupTypePairs = builder.ruleGroupTypePairs;
        this.ruleGroupRuleOptionsPairs = builder.ruleGroupRuleOptionsPairs;
        this.serviceName = builder.serviceName;
        this.loadBalancers = builder.loadBalancers;
    }

    public final String additionalDetailType() {
        return this.additionalDetailType;
    }

    public final AnalysisComponent component() {
        return this.component;
    }

    public final AnalysisComponent vpcEndpointService() {
        return this.vpcEndpointService;
    }

    public final boolean hasRuleOptions() {
        return this.ruleOptions != null && !(this.ruleOptions instanceof SdkAutoConstructList);
    }

    public final List<RuleOption> ruleOptions() {
        return this.ruleOptions;
    }

    public final boolean hasRuleGroupTypePairs() {
        return this.ruleGroupTypePairs != null && !(this.ruleGroupTypePairs instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupTypePair> ruleGroupTypePairs() {
        return this.ruleGroupTypePairs;
    }

    public final boolean hasRuleGroupRuleOptionsPairs() {
        return this.ruleGroupRuleOptionsPairs != null && !(this.ruleGroupRuleOptionsPairs instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs() {
        return this.ruleGroupRuleOptionsPairs;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public final List<AnalysisComponent> loadBalancers() {
        return this.loadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalDetailType());
        hashCode = 31 * hashCode + Objects.hashCode(this.component());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleOptions() ? this.ruleOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroupTypePairs() ? this.ruleGroupTypePairs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleGroupRuleOptionsPairs() ? this.ruleGroupRuleOptionsPairs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalDetail)) {
            return false;
        }
        AdditionalDetail other = (AdditionalDetail)obj;
        return Objects.equals(this.additionalDetailType(), other.additionalDetailType()) && Objects.equals(this.component(), other.component()) && Objects.equals(this.vpcEndpointService(), other.vpcEndpointService()) && this.hasRuleOptions() == other.hasRuleOptions() && Objects.equals(this.ruleOptions(), other.ruleOptions()) && this.hasRuleGroupTypePairs() == other.hasRuleGroupTypePairs() && Objects.equals(this.ruleGroupTypePairs(), other.ruleGroupTypePairs()) && this.hasRuleGroupRuleOptionsPairs() == other.hasRuleGroupRuleOptionsPairs() && Objects.equals(this.ruleGroupRuleOptionsPairs(), other.ruleGroupRuleOptionsPairs()) && Objects.equals(this.serviceName(), other.serviceName()) && this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers());
    }

    public final String toString() {
        return ToString.builder((String)"AdditionalDetail").add("AdditionalDetailType", (Object)this.additionalDetailType()).add("Component", (Object)this.component()).add("VpcEndpointService", (Object)this.vpcEndpointService()).add("RuleOptions", this.hasRuleOptions() ? this.ruleOptions() : null).add("RuleGroupTypePairs", this.hasRuleGroupTypePairs() ? this.ruleGroupTypePairs() : null).add("RuleGroupRuleOptionsPairs", this.hasRuleGroupRuleOptionsPairs() ? this.ruleGroupRuleOptionsPairs() : null).add("ServiceName", (Object)this.serviceName()).add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalDetailType": {
                return Optional.ofNullable(clazz.cast(this.additionalDetailType()));
            }
            case "Component": {
                return Optional.ofNullable(clazz.cast(this.component()));
            }
            case "VpcEndpointService": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointService()));
            }
            case "RuleOptions": {
                return Optional.ofNullable(clazz.cast(this.ruleOptions()));
            }
            case "RuleGroupTypePairs": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupTypePairs()));
            }
            case "RuleGroupRuleOptionsPairs": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupRuleOptionsPairs()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "LoadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalDetail, T> g) {
        return obj -> g.apply((AdditionalDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String additionalDetailType;
        private AnalysisComponent component;
        private AnalysisComponent vpcEndpointService;
        private List<RuleOption> ruleOptions = DefaultSdkAutoConstructList.getInstance();
        private List<RuleGroupTypePair> ruleGroupTypePairs = DefaultSdkAutoConstructList.getInstance();
        private List<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs = DefaultSdkAutoConstructList.getInstance();
        private String serviceName;
        private List<AnalysisComponent> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalDetail model) {
            this.additionalDetailType(model.additionalDetailType);
            this.component(model.component);
            this.vpcEndpointService(model.vpcEndpointService);
            this.ruleOptions(model.ruleOptions);
            this.ruleGroupTypePairs(model.ruleGroupTypePairs);
            this.ruleGroupRuleOptionsPairs(model.ruleGroupRuleOptionsPairs);
            this.serviceName(model.serviceName);
            this.loadBalancers(model.loadBalancers);
        }

        public final String getAdditionalDetailType() {
            return this.additionalDetailType;
        }

        public final void setAdditionalDetailType(String additionalDetailType) {
            this.additionalDetailType = additionalDetailType;
        }

        @Override
        public final Builder additionalDetailType(String additionalDetailType) {
            this.additionalDetailType = additionalDetailType;
            return this;
        }

        public final AnalysisComponent.Builder getComponent() {
            return this.component != null ? this.component.toBuilder() : null;
        }

        public final void setComponent(AnalysisComponent.BuilderImpl component) {
            this.component = component != null ? component.build() : null;
        }

        @Override
        public final Builder component(AnalysisComponent component) {
            this.component = component;
            return this;
        }

        public final AnalysisComponent.Builder getVpcEndpointService() {
            return this.vpcEndpointService != null ? this.vpcEndpointService.toBuilder() : null;
        }

        public final void setVpcEndpointService(AnalysisComponent.BuilderImpl vpcEndpointService) {
            this.vpcEndpointService = vpcEndpointService != null ? vpcEndpointService.build() : null;
        }

        @Override
        public final Builder vpcEndpointService(AnalysisComponent vpcEndpointService) {
            this.vpcEndpointService = vpcEndpointService;
            return this;
        }

        public final List<RuleOption.Builder> getRuleOptions() {
            List<RuleOption.Builder> result = RuleOptionListCopier.copyToBuilder(this.ruleOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleOptions(Collection<RuleOption.BuilderImpl> ruleOptions) {
            this.ruleOptions = RuleOptionListCopier.copyFromBuilder(ruleOptions);
        }

        @Override
        public final Builder ruleOptions(Collection<RuleOption> ruleOptions) {
            this.ruleOptions = RuleOptionListCopier.copy(ruleOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(RuleOption ... ruleOptions) {
            this.ruleOptions(Arrays.asList(ruleOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(Consumer<RuleOption.Builder> ... ruleOptions) {
            this.ruleOptions(Stream.of(ruleOptions).map(c -> (RuleOption)((RuleOption.Builder)RuleOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupTypePair.Builder> getRuleGroupTypePairs() {
            List<RuleGroupTypePair.Builder> result = RuleGroupTypePairListCopier.copyToBuilder(this.ruleGroupTypePairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroupTypePairs(Collection<RuleGroupTypePair.BuilderImpl> ruleGroupTypePairs) {
            this.ruleGroupTypePairs = RuleGroupTypePairListCopier.copyFromBuilder(ruleGroupTypePairs);
        }

        @Override
        public final Builder ruleGroupTypePairs(Collection<RuleGroupTypePair> ruleGroupTypePairs) {
            this.ruleGroupTypePairs = RuleGroupTypePairListCopier.copy(ruleGroupTypePairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupTypePairs(RuleGroupTypePair ... ruleGroupTypePairs) {
            this.ruleGroupTypePairs(Arrays.asList(ruleGroupTypePairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupTypePairs(Consumer<RuleGroupTypePair.Builder> ... ruleGroupTypePairs) {
            this.ruleGroupTypePairs(Stream.of(ruleGroupTypePairs).map(c -> (RuleGroupTypePair)((RuleGroupTypePair.Builder)RuleGroupTypePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupRuleOptionsPair.Builder> getRuleGroupRuleOptionsPairs() {
            List<RuleGroupRuleOptionsPair.Builder> result = RuleGroupRuleOptionsPairListCopier.copyToBuilder(this.ruleGroupRuleOptionsPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleGroupRuleOptionsPairs(Collection<RuleGroupRuleOptionsPair.BuilderImpl> ruleGroupRuleOptionsPairs) {
            this.ruleGroupRuleOptionsPairs = RuleGroupRuleOptionsPairListCopier.copyFromBuilder(ruleGroupRuleOptionsPairs);
        }

        @Override
        public final Builder ruleGroupRuleOptionsPairs(Collection<RuleGroupRuleOptionsPair> ruleGroupRuleOptionsPairs) {
            this.ruleGroupRuleOptionsPairs = RuleGroupRuleOptionsPairListCopier.copy(ruleGroupRuleOptionsPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupRuleOptionsPairs(RuleGroupRuleOptionsPair ... ruleGroupRuleOptionsPairs) {
            this.ruleGroupRuleOptionsPairs(Arrays.asList(ruleGroupRuleOptionsPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleGroupRuleOptionsPairs(Consumer<RuleGroupRuleOptionsPair.Builder> ... ruleGroupRuleOptionsPairs) {
            this.ruleGroupRuleOptionsPairs(Stream.of(ruleGroupRuleOptionsPairs).map(c -> (RuleGroupRuleOptionsPair)((RuleGroupRuleOptionsPair.Builder)RuleGroupRuleOptionsPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final List<AnalysisComponent.Builder> getLoadBalancers() {
            List<AnalysisComponent.Builder> result = AnalysisComponentListCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<AnalysisComponent.BuilderImpl> loadBalancers) {
            this.loadBalancers = AnalysisComponentListCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<AnalysisComponent> loadBalancers) {
            this.loadBalancers = AnalysisComponentListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(AnalysisComponent ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<AnalysisComponent.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AdditionalDetail build() {
            return new AdditionalDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalDetail> {
        public Builder additionalDetailType(String var1);

        public Builder component(AnalysisComponent var1);

        default public Builder component(Consumer<AnalysisComponent.Builder> component) {
            return this.component((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(component)).build());
        }

        public Builder vpcEndpointService(AnalysisComponent var1);

        default public Builder vpcEndpointService(Consumer<AnalysisComponent.Builder> vpcEndpointService) {
            return this.vpcEndpointService((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(vpcEndpointService)).build());
        }

        public Builder ruleOptions(Collection<RuleOption> var1);

        public Builder ruleOptions(RuleOption ... var1);

        public Builder ruleOptions(Consumer<RuleOption.Builder> ... var1);

        public Builder ruleGroupTypePairs(Collection<RuleGroupTypePair> var1);

        public Builder ruleGroupTypePairs(RuleGroupTypePair ... var1);

        public Builder ruleGroupTypePairs(Consumer<RuleGroupTypePair.Builder> ... var1);

        public Builder ruleGroupRuleOptionsPairs(Collection<RuleGroupRuleOptionsPair> var1);

        public Builder ruleGroupRuleOptionsPairs(RuleGroupRuleOptionsPair ... var1);

        public Builder ruleGroupRuleOptionsPairs(Consumer<RuleGroupRuleOptionsPair.Builder> ... var1);

        public Builder serviceName(String var1);

        public Builder loadBalancers(Collection<AnalysisComponent> var1);

        public Builder loadBalancers(AnalysisComponent ... var1);

        public Builder loadBalancers(Consumer<AnalysisComponent.Builder> ... var1);
    }
}

