/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPool;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpamPoolResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateIpamPoolResponse> {
    private static final SdkField<IpamPool> IPAM_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IpamPool").getter(CreateIpamPoolResponse.getter(CreateIpamPoolResponse::ipamPool)).setter(CreateIpamPoolResponse.setter(Builder::ipamPool)).constructor(IpamPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPool").unmarshallLocationName("ipamPool").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IpamPool", IPAM_POOL_FIELD);
        }
    });
    private final IpamPool ipamPool;

    private CreateIpamPoolResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPool = builder.ipamPool;
    }

    public final IpamPool ipamPool() {
        return this.ipamPool;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPool());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPoolResponse)) {
            return false;
        }
        CreateIpamPoolResponse other = (CreateIpamPoolResponse)((Object)obj);
        return Objects.equals(this.ipamPool(), other.ipamPool());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpamPoolResponse").add("IpamPool", (Object)this.ipamPool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamPool": {
                return Optional.ofNullable(clazz.cast(this.ipamPool()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPoolResponse, T> g) {
        return obj -> g.apply((CreateIpamPoolResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private IpamPool ipamPool;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPoolResponse model) {
            super(model);
            this.ipamPool(model.ipamPool);
        }

        public final IpamPool.Builder getIpamPool() {
            return this.ipamPool != null ? this.ipamPool.toBuilder() : null;
        }

        public final void setIpamPool(IpamPool.BuilderImpl ipamPool) {
            this.ipamPool = ipamPool != null ? ipamPool.build() : null;
        }

        @Override
        public final Builder ipamPool(IpamPool ipamPool) {
            this.ipamPool = ipamPool;
            return this;
        }

        @Override
        public CreateIpamPoolResponse build() {
            return new CreateIpamPoolResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpamPoolResponse> {
        public Builder ipamPool(IpamPool var1);

        default public Builder ipamPool(Consumer<IpamPool.Builder> ipamPool) {
            return this.ipamPool((IpamPool)((IpamPool.Builder)IpamPool.builder().applyMutation(ipamPool)).build());
        }
    }
}

