/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ExportTask;
import software.amazon.awssdk.services.ec2.model.ExportTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeExportTasksResponse> {
    private static final SdkField<List<ExportTask>> EXPORT_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportTasks").getter(DescribeExportTasksResponse.getter(DescribeExportTasksResponse::exportTasks)).setter(DescribeExportTasksResponse.setter(Builder::exportTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskSet").unmarshallLocationName("exportTaskSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExportTaskSet", EXPORT_TASKS_FIELD);
        }
    });
    private final List<ExportTask> exportTasks;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportTasks = builder.exportTasks;
    }

    public final boolean hasExportTasks() {
        return this.exportTasks != null && !(this.exportTasks instanceof SdkAutoConstructList);
    }

    public final List<ExportTask> exportTasks() {
        return this.exportTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportTasks() ? this.exportTasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse)((Object)obj);
        return this.hasExportTasks() == other.hasExportTasks() && Objects.equals(this.exportTasks(), other.exportTasks());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExportTasksResponse").add("ExportTasks", this.hasExportTasks() ? this.exportTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportTasks": {
                return Optional.ofNullable(clazz.cast(this.exportTasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ExportTask> exportTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            this.exportTasks(model.exportTasks);
        }

        public final List<ExportTask.Builder> getExportTasks() {
            List<ExportTask.Builder> result = ExportTaskListCopier.copyToBuilder(this.exportTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportTasks(Collection<ExportTask.BuilderImpl> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copyFromBuilder(exportTasks);
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask ... exportTasks) {
            this.exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(Consumer<ExportTask.Builder> ... exportTasks) {
            this.exportTasks(Stream.of(exportTasks).map(c -> (ExportTask)((ExportTask.Builder)ExportTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExportTasksResponse> {
        public Builder exportTasks(Collection<ExportTask> var1);

        public Builder exportTasks(ExportTask ... var1);

        public Builder exportTasks(Consumer<ExportTask.Builder> ... var1);
    }
}

