/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptTransitGatewayPeeringAttachmentResponse extends Ec2Response implements
        ToCopyableBuilder<AcceptTransitGatewayPeeringAttachmentResponse.Builder, AcceptTransitGatewayPeeringAttachmentResponse> {
    private static final SdkField<TransitGatewayPeeringAttachment> TRANSIT_GATEWAY_PEERING_ATTACHMENT_FIELD = SdkField
            .<TransitGatewayPeeringAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayPeeringAttachment")
            .getter(getter(AcceptTransitGatewayPeeringAttachmentResponse::transitGatewayPeeringAttachment))
            .setter(setter(Builder::transitGatewayPeeringAttachment))
            .constructor(TransitGatewayPeeringAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPeeringAttachment")
                    .unmarshallLocationName("transitGatewayPeeringAttachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_PEERING_ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransitGatewayPeeringAttachment transitGatewayPeeringAttachment;

    private AcceptTransitGatewayPeeringAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPeeringAttachment = builder.transitGatewayPeeringAttachment;
    }

    /**
     * <p>
     * The transit gateway peering attachment.
     * </p>
     * 
     * @return The transit gateway peering attachment.
     */
    public final TransitGatewayPeeringAttachment transitGatewayPeeringAttachment() {
        return transitGatewayPeeringAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayPeeringAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptTransitGatewayPeeringAttachmentResponse)) {
            return false;
        }
        AcceptTransitGatewayPeeringAttachmentResponse other = (AcceptTransitGatewayPeeringAttachmentResponse) obj;
        return Objects.equals(transitGatewayPeeringAttachment(), other.transitGatewayPeeringAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptTransitGatewayPeeringAttachmentResponse")
                .add("TransitGatewayPeeringAttachment", transitGatewayPeeringAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayPeeringAttachment":
            return Optional.ofNullable(clazz.cast(transitGatewayPeeringAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayPeeringAttachment", TRANSIT_GATEWAY_PEERING_ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptTransitGatewayPeeringAttachmentResponse, T> g) {
        return obj -> g.apply((AcceptTransitGatewayPeeringAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptTransitGatewayPeeringAttachmentResponse> {
        /**
         * <p>
         * The transit gateway peering attachment.
         * </p>
         * 
         * @param transitGatewayPeeringAttachment
         *        The transit gateway peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment transitGatewayPeeringAttachment);

        /**
         * <p>
         * The transit gateway peering attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayPeeringAttachment.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayPeeringAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayPeeringAttachment.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment)}.
         * 
         * @param transitGatewayPeeringAttachment
         *        a consumer that will call methods on {@link TransitGatewayPeeringAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment)
         */
        default Builder transitGatewayPeeringAttachment(
                Consumer<TransitGatewayPeeringAttachment.Builder> transitGatewayPeeringAttachment) {
            return transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment.builder()
                    .applyMutation(transitGatewayPeeringAttachment).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayPeeringAttachment transitGatewayPeeringAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptTransitGatewayPeeringAttachmentResponse model) {
            super(model);
            transitGatewayPeeringAttachment(model.transitGatewayPeeringAttachment);
        }

        public final TransitGatewayPeeringAttachment.Builder getTransitGatewayPeeringAttachment() {
            return transitGatewayPeeringAttachment != null ? transitGatewayPeeringAttachment.toBuilder() : null;
        }

        public final void setTransitGatewayPeeringAttachment(
                TransitGatewayPeeringAttachment.BuilderImpl transitGatewayPeeringAttachment) {
            this.transitGatewayPeeringAttachment = transitGatewayPeeringAttachment != null ? transitGatewayPeeringAttachment
                    .build() : null;
        }

        @Override
        public final Builder transitGatewayPeeringAttachment(TransitGatewayPeeringAttachment transitGatewayPeeringAttachment) {
            this.transitGatewayPeeringAttachment = transitGatewayPeeringAttachment;
            return this;
        }

        @Override
        public AcceptTransitGatewayPeeringAttachmentResponse build() {
            return new AcceptTransitGatewayPeeringAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
