/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch instances with ENA Express settings configured from your launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnaSrdSpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<EnaSrdSpecificationRequest.Builder, EnaSrdSpecificationRequest> {
    private static final SdkField<Boolean> ENA_SRD_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnaSrdEnabled")
            .getter(getter(EnaSrdSpecificationRequest::enaSrdEnabled))
            .setter(setter(Builder::enaSrdEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdEnabled")
                    .unmarshallLocationName("EnaSrdEnabled").build()).build();

    private static final SdkField<EnaSrdUdpSpecificationRequest> ENA_SRD_UDP_SPECIFICATION_FIELD = SdkField
            .<EnaSrdUdpSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("EnaSrdUdpSpecification")
            .getter(getter(EnaSrdSpecificationRequest::enaSrdUdpSpecification))
            .setter(setter(Builder::enaSrdUdpSpecification))
            .constructor(EnaSrdUdpSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdUdpSpecification")
                    .unmarshallLocationName("EnaSrdUdpSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENA_SRD_ENABLED_FIELD,
            ENA_SRD_UDP_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enaSrdEnabled;

    private final EnaSrdUdpSpecificationRequest enaSrdUdpSpecification;

    private EnaSrdSpecificationRequest(BuilderImpl builder) {
        this.enaSrdEnabled = builder.enaSrdEnabled;
        this.enaSrdUdpSpecification = builder.enaSrdUdpSpecification;
    }

    /**
     * <p>
     * Specifies whether ENA Express is enabled for the network interface when you launch an instance from your launch
     * template.
     * </p>
     * 
     * @return Specifies whether ENA Express is enabled for the network interface when you launch an instance from your
     *         launch template.
     */
    public final Boolean enaSrdEnabled() {
        return enaSrdEnabled;
    }

    /**
     * <p>
     * Contains ENA Express settings for UDP network traffic in your launch template.
     * </p>
     * 
     * @return Contains ENA Express settings for UDP network traffic in your launch template.
     */
    public final EnaSrdUdpSpecificationRequest enaSrdUdpSpecification() {
        return enaSrdUdpSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(enaSrdUdpSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnaSrdSpecificationRequest)) {
            return false;
        }
        EnaSrdSpecificationRequest other = (EnaSrdSpecificationRequest) obj;
        return Objects.equals(enaSrdEnabled(), other.enaSrdEnabled())
                && Objects.equals(enaSrdUdpSpecification(), other.enaSrdUdpSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnaSrdSpecificationRequest").add("EnaSrdEnabled", enaSrdEnabled())
                .add("EnaSrdUdpSpecification", enaSrdUdpSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnaSrdEnabled":
            return Optional.ofNullable(clazz.cast(enaSrdEnabled()));
        case "EnaSrdUdpSpecification":
            return Optional.ofNullable(clazz.cast(enaSrdUdpSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnaSrdEnabled", ENA_SRD_ENABLED_FIELD);
        map.put("EnaSrdUdpSpecification", ENA_SRD_UDP_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnaSrdSpecificationRequest, T> g) {
        return obj -> g.apply((EnaSrdSpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnaSrdSpecificationRequest> {
        /**
         * <p>
         * Specifies whether ENA Express is enabled for the network interface when you launch an instance from your
         * launch template.
         * </p>
         * 
         * @param enaSrdEnabled
         *        Specifies whether ENA Express is enabled for the network interface when you launch an instance from
         *        your launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdEnabled(Boolean enaSrdEnabled);

        /**
         * <p>
         * Contains ENA Express settings for UDP network traffic in your launch template.
         * </p>
         * 
         * @param enaSrdUdpSpecification
         *        Contains ENA Express settings for UDP network traffic in your launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSrdUdpSpecification(EnaSrdUdpSpecificationRequest enaSrdUdpSpecification);

        /**
         * <p>
         * Contains ENA Express settings for UDP network traffic in your launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnaSrdUdpSpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link EnaSrdUdpSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnaSrdUdpSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #enaSrdUdpSpecification(EnaSrdUdpSpecificationRequest)}.
         * 
         * @param enaSrdUdpSpecification
         *        a consumer that will call methods on {@link EnaSrdUdpSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enaSrdUdpSpecification(EnaSrdUdpSpecificationRequest)
         */
        default Builder enaSrdUdpSpecification(Consumer<EnaSrdUdpSpecificationRequest.Builder> enaSrdUdpSpecification) {
            return enaSrdUdpSpecification(EnaSrdUdpSpecificationRequest.builder().applyMutation(enaSrdUdpSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enaSrdEnabled;

        private EnaSrdUdpSpecificationRequest enaSrdUdpSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(EnaSrdSpecificationRequest model) {
            enaSrdEnabled(model.enaSrdEnabled);
            enaSrdUdpSpecification(model.enaSrdUdpSpecification);
        }

        public final Boolean getEnaSrdEnabled() {
            return enaSrdEnabled;
        }

        public final void setEnaSrdEnabled(Boolean enaSrdEnabled) {
            this.enaSrdEnabled = enaSrdEnabled;
        }

        @Override
        public final Builder enaSrdEnabled(Boolean enaSrdEnabled) {
            this.enaSrdEnabled = enaSrdEnabled;
            return this;
        }

        public final EnaSrdUdpSpecificationRequest.Builder getEnaSrdUdpSpecification() {
            return enaSrdUdpSpecification != null ? enaSrdUdpSpecification.toBuilder() : null;
        }

        public final void setEnaSrdUdpSpecification(EnaSrdUdpSpecificationRequest.BuilderImpl enaSrdUdpSpecification) {
            this.enaSrdUdpSpecification = enaSrdUdpSpecification != null ? enaSrdUdpSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdUdpSpecification(EnaSrdUdpSpecificationRequest enaSrdUdpSpecification) {
            this.enaSrdUdpSpecification = enaSrdUdpSpecification;
            return this;
        }

        @Override
        public EnaSrdSpecificationRequest build() {
            return new EnaSrdSpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
