/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If your IPAM is integrated with Amazon Web Services Organizations and you add an organizational unit (OU) exclusion,
 * IPAM will not manage the IP addresses in accounts in that OU exclusion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamOrganizationalUnitExclusion implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamOrganizationalUnitExclusion.Builder, IpamOrganizationalUnitExclusion> {
    private static final SdkField<String> ORGANIZATIONS_ENTITY_PATH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationsEntityPath")
            .getter(getter(IpamOrganizationalUnitExclusion::organizationsEntityPath))
            .setter(setter(Builder::organizationsEntityPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsEntityPath")
                    .unmarshallLocationName("organizationsEntityPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORGANIZATIONS_ENTITY_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String organizationsEntityPath;

    private IpamOrganizationalUnitExclusion(BuilderImpl builder) {
        this.organizationsEntityPath = builder.organizationsEntityPath;
    }

    /**
     * <p>
     * An Amazon Web Services Organizations entity path. For more information on the entity path, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path"
     * >Understand the Amazon Web Services Organizations entity path</a> in the <i>Amazon Web Services Identity and
     * Access Management User Guide</i>.
     * </p>
     * 
     * @return An Amazon Web Services Organizations entity path. For more information on the entity path, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path"
     *         >Understand the Amazon Web Services Organizations entity path</a> in the <i>Amazon Web Services Identity
     *         and Access Management User Guide</i>.
     */
    public final String organizationsEntityPath() {
        return organizationsEntityPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationsEntityPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamOrganizationalUnitExclusion)) {
            return false;
        }
        IpamOrganizationalUnitExclusion other = (IpamOrganizationalUnitExclusion) obj;
        return Objects.equals(organizationsEntityPath(), other.organizationsEntityPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamOrganizationalUnitExclusion").add("OrganizationsEntityPath", organizationsEntityPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationsEntityPath":
            return Optional.ofNullable(clazz.cast(organizationsEntityPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationsEntityPath", ORGANIZATIONS_ENTITY_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamOrganizationalUnitExclusion, T> g) {
        return obj -> g.apply((IpamOrganizationalUnitExclusion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamOrganizationalUnitExclusion> {
        /**
         * <p>
         * An Amazon Web Services Organizations entity path. For more information on the entity path, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path"
         * >Understand the Amazon Web Services Organizations entity path</a> in the <i>Amazon Web Services Identity and
         * Access Management User Guide</i>.
         * </p>
         * 
         * @param organizationsEntityPath
         *        An Amazon Web Services Organizations entity path. For more information on the entity path, see <a
         *        href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-view-data-orgs.html#access_policies_access-advisor-viewing-orgs-entity-path"
         *        >Understand the Amazon Web Services Organizations entity path</a> in the <i>Amazon Web Services
         *        Identity and Access Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationsEntityPath(String organizationsEntityPath);
    }

    static final class BuilderImpl implements Builder {
        private String organizationsEntityPath;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamOrganizationalUnitExclusion model) {
            organizationsEntityPath(model.organizationsEntityPath);
        }

        public final String getOrganizationsEntityPath() {
            return organizationsEntityPath;
        }

        public final void setOrganizationsEntityPath(String organizationsEntityPath) {
            this.organizationsEntityPath = organizationsEntityPath;
        }

        @Override
        public final Builder organizationsEntityPath(String organizationsEntityPath) {
            this.organizationsEntityPath = organizationsEntityPath;
            return this;
        }

        @Override
        public IpamOrganizationalUnitExclusion build() {
            return new IpamOrganizationalUnitExclusion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
