/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcEndpointRequest.Builder, ModifyVpcEndpointRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyVpcEndpointRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId")
            .getter(getter(ModifyVpcEndpointRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("VpcEndpointId").build()).build();

    private static final SdkField<Boolean> RESET_POLICY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ResetPolicy")
            .getter(getter(ModifyVpcEndpointRequest::resetPolicy))
            .setter(setter(Builder::resetPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetPolicy")
                    .unmarshallLocationName("ResetPolicy").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument")
            .getter(getter(ModifyVpcEndpointRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument")
                    .unmarshallLocationName("PolicyDocument").build()).build();

    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddRouteTableIds")
            .getter(getter(ModifyVpcEndpointRequest::addRouteTableIds))
            .setter(setter(Builder::addRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableId")
                    .unmarshallLocationName("AddRouteTableId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveRouteTableIds")
            .getter(getter(ModifyVpcEndpointRequest::removeRouteTableIds))
            .setter(setter(Builder::removeRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableId")
                    .unmarshallLocationName("RemoveRouteTableId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSubnetIds")
            .getter(getter(ModifyVpcEndpointRequest::addSubnetIds))
            .setter(setter(Builder::addSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetId")
                    .unmarshallLocationName("AddSubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSubnetIds")
            .getter(getter(ModifyVpcEndpointRequest::removeSubnetIds))
            .setter(setter(Builder::removeSubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetId")
                    .unmarshallLocationName("RemoveSubnetId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> ADD_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSecurityGroupIds")
            .getter(getter(ModifyVpcEndpointRequest::addSecurityGroupIds))
            .setter(setter(Builder::addSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSecurityGroupId")
                    .unmarshallLocationName("AddSecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSecurityGroupIds")
            .getter(getter(ModifyVpcEndpointRequest::removeSecurityGroupIds))
            .setter(setter(Builder::removeSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSecurityGroupId")
                    .unmarshallLocationName("RemoveSecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType")
            .getter(getter(ModifyVpcEndpointRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType")
                    .unmarshallLocationName("IpAddressType").build()).build();

    private static final SdkField<DnsOptionsSpecification> DNS_OPTIONS_FIELD = SdkField
            .<DnsOptionsSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("DnsOptions")
            .getter(getter(ModifyVpcEndpointRequest::dnsOptions))
            .setter(setter(Builder::dnsOptions))
            .constructor(DnsOptionsSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsOptions")
                    .unmarshallLocationName("DnsOptions").build()).build();

    private static final SdkField<Boolean> PRIVATE_DNS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivateDnsEnabled")
            .getter(getter(ModifyVpcEndpointRequest::privateDnsEnabled))
            .setter(setter(Builder::privateDnsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsEnabled")
                    .unmarshallLocationName("PrivateDnsEnabled").build()).build();

    private static final SdkField<List<SubnetConfiguration>> SUBNET_CONFIGURATIONS_FIELD = SdkField
            .<List<SubnetConfiguration>> builder(MarshallingType.LIST)
            .memberName("SubnetConfigurations")
            .getter(getter(ModifyVpcEndpointRequest::subnetConfigurations))
            .setter(setter(Builder::subnetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetConfiguration")
                    .unmarshallLocationName("SubnetConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SubnetConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubnetConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            VPC_ENDPOINT_ID_FIELD, RESET_POLICY_FIELD, POLICY_DOCUMENT_FIELD, ADD_ROUTE_TABLE_IDS_FIELD,
            REMOVE_ROUTE_TABLE_IDS_FIELD, ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, ADD_SECURITY_GROUP_IDS_FIELD,
            REMOVE_SECURITY_GROUP_IDS_FIELD, IP_ADDRESS_TYPE_FIELD, DNS_OPTIONS_FIELD, PRIVATE_DNS_ENABLED_FIELD,
            SUBNET_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String vpcEndpointId;

    private final Boolean resetPolicy;

    private final String policyDocument;

    private final List<String> addRouteTableIds;

    private final List<String> removeRouteTableIds;

    private final List<String> addSubnetIds;

    private final List<String> removeSubnetIds;

    private final List<String> addSecurityGroupIds;

    private final List<String> removeSecurityGroupIds;

    private final String ipAddressType;

    private final DnsOptionsSpecification dnsOptions;

    private final Boolean privateDnsEnabled;

    private final List<SubnetConfiguration> subnetConfigurations;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.resetPolicy = builder.resetPolicy;
        this.policyDocument = builder.policyDocument;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.ipAddressType = builder.ipAddressType;
        this.dnsOptions = builder.dnsOptions;
        this.privateDnsEnabled = builder.privateDnsEnabled;
        this.subnetConfigurations = builder.subnetConfigurations;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the endpoint.
     * </p>
     * 
     * @return The ID of the endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default
     * policy allows full access to the service.
     * </p>
     * 
     * @return (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The
     *         default policy allows full access to the service.
     */
    public final Boolean resetPolicy() {
        return resetPolicy;
    }

    /**
     * <p>
     * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The
     * policy must be in valid JSON format.
     * </p>
     * 
     * @return (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service.
     *         The policy must be in valid JSON format.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddRouteTableIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddRouteTableIds() {
        return addRouteTableIds != null && !(addRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Gateway endpoint) The IDs of the route tables to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddRouteTableIds} method.
     * </p>
     * 
     * @return (Gateway endpoint) The IDs of the route tables to associate with the endpoint.
     */
    public final List<String> addRouteTableIds() {
        return addRouteTableIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveRouteTableIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveRouteTableIds() {
        return removeRouteTableIds != null && !(removeRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Gateway endpoint) The IDs of the route tables to disassociate from the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveRouteTableIds} method.
     * </p>
     * 
     * @return (Gateway endpoint) The IDs of the route tables to disassociate from the endpoint.
     */
    public final List<String> removeRouteTableIds() {
        return removeRouteTableIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSubnetIds() {
        return addSubnetIds != null && !(addSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to serve the endpoint. For a
     * Gateway Load Balancer endpoint, you can specify only one subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSubnetIds} method.
     * </p>
     * 
     * @return (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to serve the endpoint.
     *         For a Gateway Load Balancer endpoint, you can specify only one subnet.
     */
    public final List<String> addSubnetIds() {
        return addSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveSubnetIds() {
        return removeSubnetIds != null && !(removeSubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) The IDs of the subnets from which to remove the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSubnetIds} method.
     * </p>
     * 
     * @return (Interface endpoint) The IDs of the subnets from which to remove the endpoint.
     */
    public final List<String> removeSubnetIds() {
        return removeSubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSecurityGroupIds() {
        return addSecurityGroupIds != null && !(addSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSecurityGroupIds} method.
     * </p>
     * 
     * @return (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
     */
    public final List<String> addSecurityGroupIds() {
        return addSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSecurityGroupIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveSecurityGroupIds() {
        return removeSecurityGroupIds != null && !(removeSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Interface endpoint) The IDs of the security groups to disassociate from the endpoint network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSecurityGroupIds} method.
     * </p>
     * 
     * @return (Interface endpoint) The IDs of the security groups to disassociate from the endpoint network interfaces.
     */
    public final List<String> removeSecurityGroupIds() {
        return removeSecurityGroupIds;
    }

    /**
     * <p>
     * The IP address type for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the endpoint.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the endpoint.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The DNS options for the endpoint.
     * </p>
     * 
     * @return The DNS options for the endpoint.
     */
    public final DnsOptionsSpecification dnsOptions() {
        return dnsOptions;
    }

    /**
     * <p>
     * (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
     * </p>
     * 
     * @return (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
     */
    public final Boolean privateDnsEnabled() {
        return privateDnsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetConfigurations() {
        return subnetConfigurations != null && !(subnetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet configurations for the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetConfigurations} method.
     * </p>
     * 
     * @return The subnet configurations for the endpoint.
     */
    public final List<SubnetConfiguration> subnetConfigurations() {
        return subnetConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(resetPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddRouteTableIds() ? addRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveRouteTableIds() ? removeRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSubnetIds() ? addSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSubnetIds() ? removeSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSecurityGroupIds() ? addSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSecurityGroupIds() ? removeSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dnsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetConfigurations() ? subnetConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(resetPolicy(), other.resetPolicy()) && Objects.equals(policyDocument(), other.policyDocument())
                && hasAddRouteTableIds() == other.hasAddRouteTableIds()
                && Objects.equals(addRouteTableIds(), other.addRouteTableIds())
                && hasRemoveRouteTableIds() == other.hasRemoveRouteTableIds()
                && Objects.equals(removeRouteTableIds(), other.removeRouteTableIds())
                && hasAddSubnetIds() == other.hasAddSubnetIds() && Objects.equals(addSubnetIds(), other.addSubnetIds())
                && hasRemoveSubnetIds() == other.hasRemoveSubnetIds()
                && Objects.equals(removeSubnetIds(), other.removeSubnetIds())
                && hasAddSecurityGroupIds() == other.hasAddSecurityGroupIds()
                && Objects.equals(addSecurityGroupIds(), other.addSecurityGroupIds())
                && hasRemoveSecurityGroupIds() == other.hasRemoveSecurityGroupIds()
                && Objects.equals(removeSecurityGroupIds(), other.removeSecurityGroupIds())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(dnsOptions(), other.dnsOptions())
                && Objects.equals(privateDnsEnabled(), other.privateDnsEnabled())
                && hasSubnetConfigurations() == other.hasSubnetConfigurations()
                && Objects.equals(subnetConfigurations(), other.subnetConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcEndpointRequest").add("DryRun", dryRun()).add("VpcEndpointId", vpcEndpointId())
                .add("ResetPolicy", resetPolicy()).add("PolicyDocument", policyDocument())
                .add("AddRouteTableIds", hasAddRouteTableIds() ? addRouteTableIds() : null)
                .add("RemoveRouteTableIds", hasRemoveRouteTableIds() ? removeRouteTableIds() : null)
                .add("AddSubnetIds", hasAddSubnetIds() ? addSubnetIds() : null)
                .add("RemoveSubnetIds", hasRemoveSubnetIds() ? removeSubnetIds() : null)
                .add("AddSecurityGroupIds", hasAddSecurityGroupIds() ? addSecurityGroupIds() : null)
                .add("RemoveSecurityGroupIds", hasRemoveSecurityGroupIds() ? removeSecurityGroupIds() : null)
                .add("IpAddressType", ipAddressTypeAsString()).add("DnsOptions", dnsOptions())
                .add("PrivateDnsEnabled", privateDnsEnabled())
                .add("SubnetConfigurations", hasSubnetConfigurations() ? subnetConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "ResetPolicy":
            return Optional.ofNullable(clazz.cast(resetPolicy()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "AddRouteTableIds":
            return Optional.ofNullable(clazz.cast(addRouteTableIds()));
        case "RemoveRouteTableIds":
            return Optional.ofNullable(clazz.cast(removeRouteTableIds()));
        case "AddSubnetIds":
            return Optional.ofNullable(clazz.cast(addSubnetIds()));
        case "RemoveSubnetIds":
            return Optional.ofNullable(clazz.cast(removeSubnetIds()));
        case "AddSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(addSecurityGroupIds()));
        case "RemoveSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(removeSecurityGroupIds()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "DnsOptions":
            return Optional.ofNullable(clazz.cast(dnsOptions()));
        case "PrivateDnsEnabled":
            return Optional.ofNullable(clazz.cast(privateDnsEnabled()));
        case "SubnetConfigurations":
            return Optional.ofNullable(clazz.cast(subnetConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("ResetPolicy", RESET_POLICY_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        map.put("AddRouteTableId", ADD_ROUTE_TABLE_IDS_FIELD);
        map.put("RemoveRouteTableId", REMOVE_ROUTE_TABLE_IDS_FIELD);
        map.put("AddSubnetId", ADD_SUBNET_IDS_FIELD);
        map.put("RemoveSubnetId", REMOVE_SUBNET_IDS_FIELD);
        map.put("AddSecurityGroupId", ADD_SECURITY_GROUP_IDS_FIELD);
        map.put("RemoveSecurityGroupId", REMOVE_SECURITY_GROUP_IDS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("DnsOptions", DNS_OPTIONS_FIELD);
        map.put("PrivateDnsEnabled", PRIVATE_DNS_ENABLED_FIELD);
        map.put("SubnetConfiguration", SUBNET_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default
         * policy allows full access to the service.
         * </p>
         * 
         * @param resetPolicy
         *        (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The
         *        default policy allows full access to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetPolicy(Boolean resetPolicy);

        /**
         * <p>
         * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The
         * policy must be in valid JSON format.
         * </p>
         * 
         * @param policyDocument
         *        (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the
         *        service. The policy must be in valid JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * (Gateway endpoint) The IDs of the route tables to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Gateway endpoint) The IDs of the route tables to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(Collection<String> addRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) The IDs of the route tables to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Gateway endpoint) The IDs of the route tables to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(String... addRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) The IDs of the route tables to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Gateway endpoint) The IDs of the route tables to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(Collection<String> removeRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) The IDs of the route tables to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Gateway endpoint) The IDs of the route tables to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(String... removeRouteTableIds);

        /**
         * <p>
         * (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to serve the endpoint. For a
         * Gateway Load Balancer endpoint, you can specify only one subnet.
         * </p>
         * 
         * @param addSubnetIds
         *        (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to serve the endpoint.
         *        For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(Collection<String> addSubnetIds);

        /**
         * <p>
         * (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to serve the endpoint. For a
         * Gateway Load Balancer endpoint, you can specify only one subnet.
         * </p>
         * 
         * @param addSubnetIds
         *        (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in which to serve the endpoint.
         *        For a Gateway Load Balancer endpoint, you can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(String... addSubnetIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the subnets from which to remove the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        (Interface endpoint) The IDs of the subnets from which to remove the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(Collection<String> removeSubnetIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the subnets from which to remove the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        (Interface endpoint) The IDs of the subnets from which to remove the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(String... removeSubnetIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        (Interface endpoint) The IDs of the security groups to associate with the endpoint network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(String... addSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the security groups to disassociate from the endpoint network interfaces.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        (Interface endpoint) The IDs of the security groups to disassociate from the endpoint network
         *        interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) The IDs of the security groups to disassociate from the endpoint network interfaces.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        (Interface endpoint) The IDs of the security groups to disassociate from the endpoint network
         *        interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(String... removeSecurityGroupIds);

        /**
         * <p>
         * The IP address type for the endpoint.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the endpoint.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the endpoint.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the endpoint.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The DNS options for the endpoint.
         * </p>
         * 
         * @param dnsOptions
         *        The DNS options for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsOptions(DnsOptionsSpecification dnsOptions);

        /**
         * <p>
         * The DNS options for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsOptionsSpecification.Builder} avoiding
         * the need to create one manually via {@link DnsOptionsSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsOptionsSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #dnsOptions(DnsOptionsSpecification)}.
         * 
         * @param dnsOptions
         *        a consumer that will call methods on {@link DnsOptionsSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsOptions(DnsOptionsSpecification)
         */
        default Builder dnsOptions(Consumer<DnsOptionsSpecification.Builder> dnsOptions) {
            return dnsOptions(DnsOptionsSpecification.builder().applyMutation(dnsOptions).build());
        }

        /**
         * <p>
         * (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
         * </p>
         * 
         * @param privateDnsEnabled
         *        (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEnabled(Boolean privateDnsEnabled);

        /**
         * <p>
         * The subnet configurations for the endpoint.
         * </p>
         * 
         * @param subnetConfigurations
         *        The subnet configurations for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetConfigurations(Collection<SubnetConfiguration> subnetConfigurations);

        /**
         * <p>
         * The subnet configurations for the endpoint.
         * </p>
         * 
         * @param subnetConfigurations
         *        The subnet configurations for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetConfigurations(SubnetConfiguration... subnetConfigurations);

        /**
         * <p>
         * The subnet configurations for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #subnetConfigurations(List<SubnetConfiguration>)}.
         * 
         * @param subnetConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SubnetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetConfigurations(java.util.Collection<SubnetConfiguration>)
         */
        Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder>... subnetConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String vpcEndpointId;

        private Boolean resetPolicy;

        private String policyDocument;

        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> addSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private DnsOptionsSpecification dnsOptions;

        private Boolean privateDnsEnabled;

        private List<SubnetConfiguration> subnetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            super(model);
            dryRun(model.dryRun);
            vpcEndpointId(model.vpcEndpointId);
            resetPolicy(model.resetPolicy);
            policyDocument(model.policyDocument);
            addRouteTableIds(model.addRouteTableIds);
            removeRouteTableIds(model.removeRouteTableIds);
            addSubnetIds(model.addSubnetIds);
            removeSubnetIds(model.removeSubnetIds);
            addSecurityGroupIds(model.addSecurityGroupIds);
            removeSecurityGroupIds(model.removeSecurityGroupIds);
            ipAddressType(model.ipAddressType);
            dnsOptions(model.dnsOptions);
            privateDnsEnabled(model.privateDnsEnabled);
            subnetConfigurations(model.subnetConfigurations);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final Boolean getResetPolicy() {
            return resetPolicy;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Collection<String> getAddRouteTableIds() {
            if (addRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addRouteTableIds;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String... addRouteTableIds) {
            addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            if (removeRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeRouteTableIds;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = VpcEndpointRouteTableIdListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String... removeRouteTableIds) {
            removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final Collection<String> getAddSubnetIds() {
            if (addSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addSubnetIds;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
        }

        @Override
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = VpcEndpointSubnetIdListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnetIds(String... addSubnetIds) {
            addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final Collection<String> getRemoveSubnetIds() {
            if (removeSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSubnetIds;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
        }

        @Override
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = VpcEndpointSubnetIdListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnetIds(String... removeSubnetIds) {
            removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final Collection<String> getAddSecurityGroupIds() {
            if (addSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addSecurityGroupIds;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
        }

        @Override
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSecurityGroupIds(String... addSecurityGroupIds) {
            addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            if (removeSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSecurityGroupIds;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
        }

        @Override
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = VpcEndpointSecurityGroupIdListCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String... removeSecurityGroupIds) {
            removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final DnsOptionsSpecification.Builder getDnsOptions() {
            return dnsOptions != null ? dnsOptions.toBuilder() : null;
        }

        public final void setDnsOptions(DnsOptionsSpecification.BuilderImpl dnsOptions) {
            this.dnsOptions = dnsOptions != null ? dnsOptions.build() : null;
        }

        @Override
        public final Builder dnsOptions(DnsOptionsSpecification dnsOptions) {
            this.dnsOptions = dnsOptions;
            return this;
        }

        public final Boolean getPrivateDnsEnabled() {
            return privateDnsEnabled;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final List<SubnetConfiguration.Builder> getSubnetConfigurations() {
            List<SubnetConfiguration.Builder> result = SubnetConfigurationsListCopier.copyToBuilder(this.subnetConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetConfigurations(Collection<SubnetConfiguration.BuilderImpl> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copyFromBuilder(subnetConfigurations);
        }

        @Override
        public final Builder subnetConfigurations(Collection<SubnetConfiguration> subnetConfigurations) {
            this.subnetConfigurations = SubnetConfigurationsListCopier.copy(subnetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(SubnetConfiguration... subnetConfigurations) {
            subnetConfigurations(Arrays.asList(subnetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetConfigurations(Consumer<SubnetConfiguration.Builder>... subnetConfigurations) {
            subnetConfigurations(Stream.of(subnetConfigurations).map(c -> SubnetConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
