/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the snapshot created from the imported disk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotDetail implements SdkPojo, Serializable, ToCopyableBuilder<SnapshotDetail.Builder, SnapshotDetail> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(SnapshotDetail::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceName")
            .getter(getter(SnapshotDetail::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName")
                    .unmarshallLocationName("deviceName").build()).build();

    private static final SdkField<Double> DISK_IMAGE_SIZE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("DiskImageSize")
            .getter(getter(SnapshotDetail::diskImageSize))
            .setter(setter(Builder::diskImageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageSize")
                    .unmarshallLocationName("diskImageSize").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Format")
            .getter(getter(SnapshotDetail::format))
            .setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format")
                    .unmarshallLocationName("format").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Progress")
            .getter(getter(SnapshotDetail::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(SnapshotDetail::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(SnapshotDetail::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(SnapshotDetail::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Url")
            .getter(getter(SnapshotDetail::url))
            .setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").unmarshallLocationName("url")
                    .build()).build();

    private static final SdkField<UserBucketDetails> USER_BUCKET_FIELD = SdkField
            .<UserBucketDetails> builder(MarshallingType.SDK_POJO)
            .memberName("UserBucket")
            .getter(getter(SnapshotDetail::userBucket))
            .setter(setter(Builder::userBucket))
            .constructor(UserBucketDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserBucket")
                    .unmarshallLocationName("userBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DEVICE_NAME_FIELD, DISK_IMAGE_SIZE_FIELD, FORMAT_FIELD, PROGRESS_FIELD, SNAPSHOT_ID_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD, URL_FIELD, USER_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String deviceName;

    private final Double diskImageSize;

    private final String format;

    private final String progress;

    private final String snapshotId;

    private final String status;

    private final String statusMessage;

    private final String url;

    private final UserBucketDetails userBucket;

    private SnapshotDetail(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.diskImageSize = builder.diskImageSize;
        this.format = builder.format;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @return A description for the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The block device mapping for the snapshot.
     * </p>
     * 
     * @return The block device mapping for the snapshot.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The size of the disk in the snapshot, in GiB.
     * </p>
     * 
     * @return The size of the disk in the snapshot, in GiB.
     */
    public final Double diskImageSize() {
        return diskImageSize;
    }

    /**
     * <p>
     * The format of the disk image from which the snapshot is created.
     * </p>
     * 
     * @return The format of the disk image from which the snapshot is created.
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The percentage of progress for the task.
     * </p>
     * 
     * @return The percentage of progress for the task.
     */
    public final String progress() {
        return progress;
    }

    /**
     * <p>
     * The snapshot ID of the disk being imported.
     * </p>
     * 
     * @return The snapshot ID of the disk being imported.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * A brief status of the snapshot creation.
     * </p>
     * 
     * @return A brief status of the snapshot creation.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status message for the snapshot creation.
     * </p>
     * 
     * @return A detailed status message for the snapshot creation.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The URL used to access the disk image.
     * </p>
     * 
     * @return The URL used to access the disk image.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The Amazon S3 bucket for the disk image.
     * </p>
     * 
     * @return The Amazon S3 bucket for the disk image.
     */
    public final UserBucketDetails userBucket() {
        return userBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageSize());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(userBucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetail)) {
            return false;
        }
        SnapshotDetail other = (SnapshotDetail) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(diskImageSize(), other.diskImageSize()) && Objects.equals(format(), other.format())
                && Objects.equals(progress(), other.progress()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(status(), other.status()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(url(), other.url()) && Objects.equals(userBucket(), other.userBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotDetail").add("Description", description()).add("DeviceName", deviceName())
                .add("DiskImageSize", diskImageSize()).add("Format", format()).add("Progress", progress())
                .add("SnapshotId", snapshotId()).add("Status", status()).add("StatusMessage", statusMessage())
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***").add("UserBucket", userBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "DiskImageSize":
            return Optional.ofNullable(clazz.cast(diskImageSize()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "UserBucket":
            return Optional.ofNullable(clazz.cast(userBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("DiskImageSize", DISK_IMAGE_SIZE_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("Url", URL_FIELD);
        map.put("UserBucket", USER_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDetail, T> g) {
        return obj -> g.apply((SnapshotDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotDetail> {
        /**
         * <p>
         * A description for the snapshot.
         * </p>
         * 
         * @param description
         *        A description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The block device mapping for the snapshot.
         * </p>
         * 
         * @param deviceName
         *        The block device mapping for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The size of the disk in the snapshot, in GiB.
         * </p>
         * 
         * @param diskImageSize
         *        The size of the disk in the snapshot, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskImageSize(Double diskImageSize);

        /**
         * <p>
         * The format of the disk image from which the snapshot is created.
         * </p>
         * 
         * @param format
         *        The format of the disk image from which the snapshot is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The percentage of progress for the task.
         * </p>
         * 
         * @param progress
         *        The percentage of progress for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The snapshot ID of the disk being imported.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID of the disk being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * A brief status of the snapshot creation.
         * </p>
         * 
         * @param status
         *        A brief status of the snapshot creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status message for the snapshot creation.
         * </p>
         * 
         * @param statusMessage
         *        A detailed status message for the snapshot creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The URL used to access the disk image.
         * </p>
         * 
         * @param url
         *        The URL used to access the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The Amazon S3 bucket for the disk image.
         * </p>
         * 
         * @param userBucket
         *        The Amazon S3 bucket for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBucket(UserBucketDetails userBucket);

        /**
         * <p>
         * The Amazon S3 bucket for the disk image.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserBucketDetails.Builder} avoiding the
         * need to create one manually via {@link UserBucketDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserBucketDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #userBucket(UserBucketDetails)}.
         * 
         * @param userBucket
         *        a consumer that will call methods on {@link UserBucketDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userBucket(UserBucketDetails)
         */
        default Builder userBucket(Consumer<UserBucketDetails.Builder> userBucket) {
            return userBucket(UserBucketDetails.builder().applyMutation(userBucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String deviceName;

        private Double diskImageSize;

        private String format;

        private String progress;

        private String snapshotId;

        private String status;

        private String statusMessage;

        private String url;

        private UserBucketDetails userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetail model) {
            description(model.description);
            deviceName(model.deviceName);
            diskImageSize(model.diskImageSize);
            format(model.format);
            progress(model.progress);
            snapshotId(model.snapshotId);
            status(model.status);
            statusMessage(model.statusMessage);
            url(model.url);
            userBucket(model.userBucket);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Double getDiskImageSize() {
            return diskImageSize;
        }

        public final void setDiskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
        }

        @Override
        public final Builder diskImageSize(Double diskImageSize) {
            this.diskImageSize = diskImageSize;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getProgress() {
            return progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final UserBucketDetails.Builder getUserBucket() {
            return userBucket != null ? userBucket.toBuilder() : null;
        }

        public final void setUserBucket(UserBucketDetails.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        @Override
        public final Builder userBucket(UserBucketDetails userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        @Override
        public SnapshotDetail build() {
            return new SnapshotDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
