/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a custom subdomain for a network CIDR endpoint for Verified Access.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessInstanceCustomSubDomain implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessInstanceCustomSubDomain.Builder, VerifiedAccessInstanceCustomSubDomain> {
    private static final SdkField<String> SUB_DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubDomain")
            .getter(getter(VerifiedAccessInstanceCustomSubDomain::subDomain))
            .setter(setter(Builder::subDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDomain")
                    .unmarshallLocationName("subDomain").build()).build();

    private static final SdkField<List<String>> NAMESERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Nameservers")
            .getter(getter(VerifiedAccessInstanceCustomSubDomain::nameservers))
            .setter(setter(Builder::nameservers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameserverSet")
                    .unmarshallLocationName("nameserverSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUB_DOMAIN_FIELD,
            NAMESERVERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subDomain;

    private final List<String> nameservers;

    private VerifiedAccessInstanceCustomSubDomain(BuilderImpl builder) {
        this.subDomain = builder.subDomain;
        this.nameservers = builder.nameservers;
    }

    /**
     * <p>
     * The subdomain.
     * </p>
     * 
     * @return The subdomain.
     */
    public final String subDomain() {
        return subDomain;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nameservers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNameservers() {
        return nameservers != null && !(nameservers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name servers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNameservers} method.
     * </p>
     * 
     * @return The name servers.
     */
    public final List<String> nameservers() {
        return nameservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subDomain());
        hashCode = 31 * hashCode + Objects.hashCode(hasNameservers() ? nameservers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstanceCustomSubDomain)) {
            return false;
        }
        VerifiedAccessInstanceCustomSubDomain other = (VerifiedAccessInstanceCustomSubDomain) obj;
        return Objects.equals(subDomain(), other.subDomain()) && hasNameservers() == other.hasNameservers()
                && Objects.equals(nameservers(), other.nameservers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessInstanceCustomSubDomain").add("SubDomain", subDomain())
                .add("Nameservers", hasNameservers() ? nameservers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubDomain":
            return Optional.ofNullable(clazz.cast(subDomain()));
        case "Nameservers":
            return Optional.ofNullable(clazz.cast(nameservers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubDomain", SUB_DOMAIN_FIELD);
        map.put("NameserverSet", NAMESERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstanceCustomSubDomain, T> g) {
        return obj -> g.apply((VerifiedAccessInstanceCustomSubDomain) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessInstanceCustomSubDomain> {
        /**
         * <p>
         * The subdomain.
         * </p>
         * 
         * @param subDomain
         *        The subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDomain(String subDomain);

        /**
         * <p>
         * The name servers.
         * </p>
         * 
         * @param nameservers
         *        The name servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Collection<String> nameservers);

        /**
         * <p>
         * The name servers.
         * </p>
         * 
         * @param nameservers
         *        The name servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(String... nameservers);
    }

    static final class BuilderImpl implements Builder {
        private String subDomain;

        private List<String> nameservers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstanceCustomSubDomain model) {
            subDomain(model.subDomain);
            nameservers(model.nameservers);
        }

        public final String getSubDomain() {
            return subDomain;
        }

        public final void setSubDomain(String subDomain) {
            this.subDomain = subDomain;
        }

        @Override
        public final Builder subDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }

        public final Collection<String> getNameservers() {
            if (nameservers instanceof SdkAutoConstructList) {
                return null;
            }
            return nameservers;
        }

        public final void setNameservers(Collection<String> nameservers) {
            this.nameservers = ValueStringListCopier.copy(nameservers);
        }

        @Override
        public final Builder nameservers(Collection<String> nameservers) {
            this.nameservers = ValueStringListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(String... nameservers) {
            nameservers(Arrays.asList(nameservers));
            return this;
        }

        @Override
        public VerifiedAccessInstanceCustomSubDomain build() {
            return new VerifiedAccessInstanceCustomSubDomain(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
