/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.AcceptAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.AcceptCapacityReservationBillingOwnershipRequest;
import software.amazon.awssdk.services.ec2.model.AcceptCapacityReservationBillingOwnershipResponse;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AllocateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;
import software.amazon.awssdk.services.ec2.model.AllocateHostsResponse;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateCapacityReservationBillingOwnerRequest;
import software.amazon.awssdk.services.ec2.model.AssociateCapacityReservationBillingOwnerResponse;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSecurityGroupVpcRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSecurityGroupVpcResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.AttachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.BundleInstanceRequest;
import software.amazon.awssdk.services.ec2.model.BundleInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelDeclarativePoliciesReportRequest;
import software.amazon.awssdk.services.ec2.model.CancelDeclarativePoliciesReportResponse;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest;
import software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionResponse;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyImageResponse;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CopySnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationBySplittingRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationBySplittingResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest;
import software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamExternalResourceVerificationTokenRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamExternalResourceVerificationTokenResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumeResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcBlockPublicAccessExclusionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcBlockPublicAccessExclusionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamExternalResourceVerificationTokenRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamExternalResourceVerificationTokenResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcBlockPublicAccessExclusionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcBlockPublicAccessExclusionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterImageRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterImageResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDeclarativePoliciesReportsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDeclarativePoliciesReportsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamExternalResourceVerificationTokensRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamExternalResourceVerificationTokensResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLockedSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLockedSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFilterRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFilterRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessExclusionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessExclusionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DetachVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.DetachVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DetachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.DisableAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.DisableAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.DisableAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageDeregistrationProtectionRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageDeregistrationProtectionResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageResponse;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableSnapshotBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableSnapshotBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateCapacityReservationBillingOwnerRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateCapacityReservationBillingOwnerResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSecurityGroupVpcRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSecurityGroupVpcResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.EnableAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.EnableAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageDeregistrationProtectionRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageDeregistrationProtectionResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageResponse;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.EnableReachabilityAnalyzerOrganizationSharingRequest;
import software.amazon.awssdk.services.ec2.model.EnableReachabilityAnalyzerOrganizationSharingResponse;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableSnapshotBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableSnapshotBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ExportImageRequest;
import software.amazon.awssdk.services.ec2.model.ExportImageResponse;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.ExportVerifiedAccessInstanceClientConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ExportVerifiedAccessInstanceClientConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.GetAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.GetAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse;
import software.amazon.awssdk.services.ec2.model.GetDeclarativePoliciesReportSummaryRequest;
import software.amazon.awssdk.services.ec2.model.GetDeclarativePoliciesReportSummaryResponse;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse;
import software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest;
import software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceMetadataDefaultsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceMetadataDefaultsResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceTpmEkPubRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTpmEkPubResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredPublicAddressesRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredPublicAddressesResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentResponse;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusRequest;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse;
import software.amazon.awssdk.services.ec2.model.GetSnapshotBlockPublicAccessStateRequest;
import software.amazon.awssdk.services.ec2.model.GetSnapshotBlockPublicAccessStateResponse;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointTargetsRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointTargetsResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.ImportImageResponse;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ImportInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ImportVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.LockSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.LockSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyHostsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCpuOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCpuOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataDefaultsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataDefaultsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceNetworkPerformanceOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceNetworkPerformanceOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestResponse;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessExclusionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessExclusionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamResponse;
import software.amazon.awssdk.services.ec2.model.MoveCapacityReservationInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MoveCapacityReservationInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockExtensionRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockExtensionResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RebootInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;
import software.amazon.awssdk.services.ec2.model.RegisterImageResponse;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.RejectCapacityReservationBillingOwnershipRequest;
import software.amazon.awssdk.services.ec2.model.RejectCapacityReservationBillingOwnershipResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceImageCriteriaInAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceImageCriteriaInAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelResponse;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptResponse;
import software.amazon.awssdk.services.ec2.model.StartDeclarativePoliciesReportRequest;
import software.amazon.awssdk.services.ec2.model.StartDeclarativePoliciesReportResponse;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.UnlockSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.UnlockSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.ec2.paginators.DescribeAddressTransfersIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeAddressesAttributeIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeAwsNetworkPerformanceMetricSubscriptionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeByoipCidrsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityBlockExtensionHistoryIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityBlockExtensionOfferingsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityBlockOfferingsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationBillingRequestsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationFleetsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCapacityReservationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCarrierGatewaysIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeClassicLinkInstancesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnAuthorizationRulesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnConnectionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnEndpointsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnRoutesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeClientVpnTargetNetworksIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeCoipPoolsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeDhcpOptionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeEgressOnlyInternetGatewaysIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeExportImageTasksIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeFastLaunchImagesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeFastSnapshotRestoresIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeFleetsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeFlowLogsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeFpgaImagesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationOfferingsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostReservationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeHostsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeIamInstanceProfileAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeImagesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeImportImageTasksIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeImportSnapshotTasksIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceConnectEndpointsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceCreditSpecificationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceEventWindowsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceImageMetadataIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceStatusIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTopologyIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypeOfferingsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstanceTypesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInstancesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeInternetGatewaysIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamPoolsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamResourceDiscoveriesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamResourceDiscoveryAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamScopesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpamsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeIpv6PoolsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplateVersionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLaunchTemplatesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTableVpcAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayRouteTablesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfaceGroupsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewayVirtualInterfacesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeLocalGatewaysIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeMacHostsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeManagedPrefixListsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeMovingAddressesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNatGatewaysIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkAclsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsAccessScopeAnalysesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsAccessScopesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsAnalysesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInsightsPathsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacePermissionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeNetworkInterfacesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribePrefixListsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribePrincipalIdFormatIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribePublicIpv4PoolsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeReplaceRootVolumeTasksIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesModificationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeReservedInstancesOfferingsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeRouteTablesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstanceAvailabilityIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeScheduledInstancesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupRulesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupVpcAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSecurityGroupsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSnapshotTierStatusIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSnapshotsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotFleetRequestsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotInstanceRequestsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSpotPriceHistoryIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeStaleSecurityGroupsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeStoreImageTasksIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeSubnetsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTagsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorFiltersIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorSessionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrafficMirrorTargetsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayAttachmentsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayConnectPeersIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayConnectsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayMulticastDomainsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayPeeringAttachmentsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayPolicyTablesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayRouteTableAnnouncementsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayRouteTablesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewayVpcAttachmentsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTransitGatewaysIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeTrunkInterfaceAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVerifiedAccessEndpointsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVerifiedAccessGroupsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVerifiedAccessInstanceLoggingConfigurationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVerifiedAccessInstancesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVerifiedAccessTrustProvidersIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumeStatusIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumesIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVolumesModificationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcClassicLinkDnsSupportIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointConnectionNotificationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointConnectionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointServiceConfigurationsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointServicePermissionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcEndpointsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcPeeringConnectionsIterable;
import software.amazon.awssdk.services.ec2.paginators.DescribeVpcsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetAssociatedIpv6PoolCidrsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetAwsNetworkPerformanceDataIterable;
import software.amazon.awssdk.services.ec2.paginators.GetGroupsForCapacityReservationIterable;
import software.amazon.awssdk.services.ec2.paginators.GetInstanceTypesFromInstanceRequirementsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetIpamAddressHistoryIterable;
import software.amazon.awssdk.services.ec2.paginators.GetIpamDiscoveredAccountsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetIpamDiscoveredResourceCidrsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetIpamPoolAllocationsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetIpamPoolCidrsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetIpamResourceCidrsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetManagedPrefixListAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetManagedPrefixListEntriesIterable;
import software.amazon.awssdk.services.ec2.paginators.GetNetworkInsightsAccessScopeAnalysisFindingsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetSecurityGroupsForVpcIterable;
import software.amazon.awssdk.services.ec2.paginators.GetSpotPlacementScoresIterable;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayAttachmentPropagationsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayMulticastDomainAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayPolicyTableAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayPrefixListReferencesIterable;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayRouteTableAssociationsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetTransitGatewayRouteTablePropagationsIterable;
import software.amazon.awssdk.services.ec2.paginators.GetVpnConnectionDeviceTypesIterable;
import software.amazon.awssdk.services.ec2.paginators.ListImagesInRecycleBinIterable;
import software.amazon.awssdk.services.ec2.paginators.ListSnapshotsInRecycleBinIterable;
import software.amazon.awssdk.services.ec2.paginators.SearchLocalGatewayRoutesIterable;
import software.amazon.awssdk.services.ec2.paginators.SearchTransitGatewayMulticastGroupsIterable;
import software.amazon.awssdk.services.ec2.waiters.Ec2Waiter;

/**
 * Service client for accessing Amazon EC2. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Elastic Compute Cloud</fullname>
 * <p>
 * You can access the features of Amazon Elastic Compute Cloud (Amazon EC2) programmatically. For more information, see
 * the <a href="https://docs.aws.amazon.com/ec2/latest/devguide">Amazon EC2 Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Ec2Client extends AwsClient {
    String SERVICE_NAME = "ec2";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ec2";

    /**
     * <p>
     * Accepts an Elastic IP address transfer. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept"
     * >Accept a transferred Elastic IP address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param acceptAddressTransferRequest
     * @return Result of the AcceptAddressTransfer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptAddressTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer" target="_top">AWS API
     *      Documentation</a>
     */
    default AcceptAddressTransferResponse acceptAddressTransfer(AcceptAddressTransferRequest acceptAddressTransferRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts an Elastic IP address transfer. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept"
     * >Accept a transferred Elastic IP address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAddressTransferRequest.Builder} avoiding the
     * need to create one manually via {@link AcceptAddressTransferRequest#builder()}
     * </p>
     *
     * @param acceptAddressTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest.Builder} to create a
     *        request.
     * @return Result of the AcceptAddressTransfer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptAddressTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer" target="_top">AWS API
     *      Documentation</a>
     */
    default AcceptAddressTransferResponse acceptAddressTransfer(
            Consumer<AcceptAddressTransferRequest.Builder> acceptAddressTransferRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return acceptAddressTransfer(AcceptAddressTransferRequest.builder().applyMutation(acceptAddressTransferRequest).build());
    }

    /**
     * <p>
     * Accepts a request to assign billing of the available capacity of a shared Capacity Reservation to your account.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html">
     * Billing assignment for shared Amazon EC2 Capacity Reservations</a>.
     * </p>
     *
     * @param acceptCapacityReservationBillingOwnershipRequest
     * @return Result of the AcceptCapacityReservationBillingOwnership operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptCapacityReservationBillingOwnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptCapacityReservationBillingOwnership"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptCapacityReservationBillingOwnershipResponse acceptCapacityReservationBillingOwnership(
            AcceptCapacityReservationBillingOwnershipRequest acceptCapacityReservationBillingOwnershipRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a request to assign billing of the available capacity of a shared Capacity Reservation to your account.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html">
     * Billing assignment for shared Amazon EC2 Capacity Reservations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptCapacityReservationBillingOwnershipRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptCapacityReservationBillingOwnershipRequest#builder()}
     * </p>
     *
     * @param acceptCapacityReservationBillingOwnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptCapacityReservationBillingOwnershipRequest.Builder}
     *        to create a request.
     * @return Result of the AcceptCapacityReservationBillingOwnership operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptCapacityReservationBillingOwnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptCapacityReservationBillingOwnership"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptCapacityReservationBillingOwnershipResponse acceptCapacityReservationBillingOwnership(
            Consumer<AcceptCapacityReservationBillingOwnershipRequest.Builder> acceptCapacityReservationBillingOwnershipRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return acceptCapacityReservationBillingOwnership(AcceptCapacityReservationBillingOwnershipRequest.builder()
                .applyMutation(acceptCapacityReservationBillingOwnershipRequest).build());
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @return Result of the AcceptReservedInstancesExchangeQuote operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptReservedInstancesExchangeQuote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptReservedInstancesExchangeQuoteResponse acceptReservedInstancesExchangeQuote(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptReservedInstancesExchangeQuoteRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptReservedInstancesExchangeQuoteRequest#builder()}
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest.Builder} to
     *        create a request. Contains the parameters for accepting the quote.
     * @return Result of the AcceptReservedInstancesExchangeQuote operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptReservedInstancesExchangeQuote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptReservedInstancesExchangeQuoteResponse acceptReservedInstancesExchangeQuote(
            Consumer<AcceptReservedInstancesExchangeQuoteRequest.Builder> acceptReservedInstancesExchangeQuoteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return acceptReservedInstancesExchangeQuote(AcceptReservedInstancesExchangeQuoteRequest.builder()
                .applyMutation(acceptReservedInstancesExchangeQuoteRequest).build());
    }

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     *
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     * @return Result of the AcceptTransitGatewayMulticastDomainAssociations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptTransitGatewayMulticastDomainAssociationsResponse acceptTransitGatewayMulticastDomainAssociations(
            AcceptTransitGatewayMulticastDomainAssociationsRequest acceptTransitGatewayMulticastDomainAssociationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptTransitGatewayMulticastDomainAssociationsRequest.Builder} avoiding the need to create one manually
     * via {@link AcceptTransitGatewayMulticastDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the AcceptTransitGatewayMulticastDomainAssociations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptTransitGatewayMulticastDomainAssociationsResponse acceptTransitGatewayMulticastDomainAssociations(
            Consumer<AcceptTransitGatewayMulticastDomainAssociationsRequest.Builder> acceptTransitGatewayMulticastDomainAssociationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return acceptTransitGatewayMulticastDomainAssociations(AcceptTransitGatewayMulticastDomainAssociationsRequest.builder()
                .applyMutation(acceptTransitGatewayMulticastDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     *
     * @param acceptTransitGatewayPeeringAttachmentRequest
     * @return Result of the AcceptTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptTransitGatewayPeeringAttachmentResponse acceptTransitGatewayPeeringAttachment(
            AcceptTransitGatewayPeeringAttachmentRequest acceptTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AcceptTransitGatewayPeeringAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link AcceptTransitGatewayPeeringAttachmentRequest#builder()}
     * </p>
     *
     * @param acceptTransitGatewayPeeringAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest.Builder} to
     *        create a request.
     * @return Result of the AcceptTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptTransitGatewayPeeringAttachmentResponse acceptTransitGatewayPeeringAttachment(
            Consumer<AcceptTransitGatewayPeeringAttachmentRequest.Builder> acceptTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return acceptTransitGatewayPeeringAttachment(AcceptTransitGatewayPeeringAttachmentRequest.builder()
                .applyMutation(acceptTransitGatewayPeeringAttachmentRequest).build());
    }

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     *
     * @param acceptTransitGatewayVpcAttachmentRequest
     * @return Result of the AcceptTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptTransitGatewayVpcAttachmentResponse acceptTransitGatewayVpcAttachment(
            AcceptTransitGatewayVpcAttachmentRequest acceptTransitGatewayVpcAttachmentRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptTransitGatewayVpcAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptTransitGatewayVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param acceptTransitGatewayVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest.Builder} to
     *        create a request.
     * @return Result of the AcceptTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptTransitGatewayVpcAttachmentResponse acceptTransitGatewayVpcAttachment(
            Consumer<AcceptTransitGatewayVpcAttachmentRequest.Builder> acceptTransitGatewayVpcAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return acceptTransitGatewayVpcAttachment(AcceptTransitGatewayVpcAttachmentRequest.builder()
                .applyMutation(acceptTransitGatewayVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Accepts connection requests to your VPC endpoint service.
     * </p>
     *
     * @param acceptVpcEndpointConnectionsRequest
     * @return Result of the AcceptVpcEndpointConnections operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptVpcEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptVpcEndpointConnectionsResponse acceptVpcEndpointConnections(
            AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts connection requests to your VPC endpoint service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptVpcEndpointConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptVpcEndpointConnectionsRequest#builder()}
     * </p>
     *
     * @param acceptVpcEndpointConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest.Builder} to create a
     *        request.
     * @return Result of the AcceptVpcEndpointConnections operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptVpcEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptVpcEndpointConnectionsResponse acceptVpcEndpointConnections(
            Consumer<AcceptVpcEndpointConnectionsRequest.Builder> acceptVpcEndpointConnectionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return acceptVpcEndpointConnections(AcceptVpcEndpointConnectionsRequest.builder()
                .applyMutation(acceptVpcEndpointConnectionsRequest).build());
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     * @return Result of the AcceptVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptVpcPeeringConnectionResponse acceptVpcPeeringConnection(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the AcceptVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptVpcPeeringConnectionResponse acceptVpcPeeringConnection(
            Consumer<AcceptVpcPeeringConnectionRequest.Builder> acceptVpcPeeringConnectionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return acceptVpcPeeringConnection(AcceptVpcPeeringConnectionRequest.builder()
                .applyMutation(acceptVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return Result of the AdvertiseByoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default AdvertiseByoipCidrResponse advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AdvertiseByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link AdvertiseByoipCidrRequest#builder()}
     * </p>
     *
     * @param advertiseByoipCidrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest.Builder} to create a request.
     * @return Result of the AdvertiseByoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default AdvertiseByoipCidrResponse advertiseByoipCidr(Consumer<AdvertiseByoipCidrRequest.Builder> advertiseByoipCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return advertiseByoipCidr(AdvertiseByoipCidrRequest.builder().applyMutation(advertiseByoipCidrRequest).build());
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address
     * that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic
     * IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     *
     * @param allocateAddressRequest
     * @return Result of the AllocateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateAddressResponse allocateAddress(AllocateAddressRequest allocateAddressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address
     * that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic
     * IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateAddressRequest.Builder} avoiding the need
     * to create one manually via {@link AllocateAddressRequest#builder()}
     * </p>
     *
     * @param allocateAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AllocateAddressRequest.Builder} to create a request.
     * @return Result of the AllocateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateAddressResponse allocateAddress(Consumer<AllocateAddressRequest.Builder> allocateAddressRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return allocateAddress(AllocateAddressRequest.builder().applyMutation(allocateAddressRequest).build());
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address
     * that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic
     * IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     *
     * @return Result of the AllocateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateAddress
     * @see #allocateAddress(AllocateAddressRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateAddressResponse allocateAddress() throws AwsServiceException, SdkClientException, Ec2Exception {
        return allocateAddress(AllocateAddressRequest.builder().build());
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     *
     * @param allocateHostsRequest
     * @return Result of the AllocateHosts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateHostsResponse allocateHosts(AllocateHostsRequest allocateHostsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateHostsRequest.Builder} avoiding the need to
     * create one manually via {@link AllocateHostsRequest#builder()}
     * </p>
     *
     * @param allocateHostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AllocateHostsRequest.Builder} to create a request.
     * @return Result of the AllocateHosts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateHostsResponse allocateHosts(Consumer<AllocateHostsRequest.Builder> allocateHostsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return allocateHosts(AllocateHostsRequest.builder().applyMutation(allocateHostsRequest).build());
    }

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon
     * Web Services Region where this IPAM pool is available for allocations.
     * </p>
     * <p>
     * In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action creates an allocation with strong consistency. The returned CIDR will not overlap with any other
     * allocations from the same pool.
     * </p>
     * </note>
     *
     * @param allocateIpamPoolCidrRequest
     * @return Result of the AllocateIpamPoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateIpamPoolCidrResponse allocateIpamPoolCidr(AllocateIpamPoolCidrRequest allocateIpamPoolCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon
     * Web Services Region where this IPAM pool is available for allocations.
     * </p>
     * <p>
     * In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action creates an allocation with strong consistency. The returned CIDR will not overlap with any other
     * allocations from the same pool.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllocateIpamPoolCidrRequest.Builder} avoiding the
     * need to create one manually via {@link AllocateIpamPoolCidrRequest#builder()}
     * </p>
     *
     * @param allocateIpamPoolCidrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest.Builder} to create a request.
     * @return Result of the AllocateIpamPoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default AllocateIpamPoolCidrResponse allocateIpamPoolCidr(
            Consumer<AllocateIpamPoolCidrRequest.Builder> allocateIpamPoolCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return allocateIpamPoolCidr(AllocateIpamPoolCidrRequest.builder().applyMutation(allocateIpamPoolCidrRequest).build());
    }

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     *
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     * @return Result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplySecurityGroupsToClientVpnTargetNetworkResponse applySecurityGroupsToClientVpnTargetNetwork(
            ApplySecurityGroupsToClientVpnTargetNetworkRequest applySecurityGroupsToClientVpnTargetNetworkRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ApplySecurityGroupsToClientVpnTargetNetworkRequest.Builder} avoiding the need to create one manually via
     * {@link ApplySecurityGroupsToClientVpnTargetNetworkRequest#builder()}
     * </p>
     *
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest.Builder}
     *        to create a request.
     * @return Result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplySecurityGroupsToClientVpnTargetNetworkResponse applySecurityGroupsToClientVpnTargetNetwork(
            Consumer<ApplySecurityGroupsToClientVpnTargetNetworkRequest.Builder> applySecurityGroupsToClientVpnTargetNetworkRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return applySecurityGroupsToClientVpnTargetNetwork(ApplySecurityGroupsToClientVpnTargetNetworkRequest.builder()
                .applyMutation(applySecurityGroupsToClientVpnTargetNetworkRequest).build());
    }

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network
     * interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param assignIpv6AddressesRequest
     * @return Result of the AssignIpv6Addresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignIpv6Addresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    default AssignIpv6AddressesResponse assignIpv6Addresses(AssignIpv6AddressesRequest assignIpv6AddressesRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network
     * interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssignIpv6AddressesRequest.Builder} avoiding the
     * need to create one manually via {@link AssignIpv6AddressesRequest#builder()}
     * </p>
     *
     * @param assignIpv6AddressesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest.Builder} to create a request.
     * @return Result of the AssignIpv6Addresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignIpv6Addresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    default AssignIpv6AddressesResponse assignIpv6Addresses(
            Consumer<AssignIpv6AddressesRequest.Builder> assignIpv6AddressesRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return assignIpv6Addresses(AssignIpv6AddressesRequest.builder().applyMutation(assignIpv6AddressesRequest).build());
    }

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For more information about Elastic IP addresses, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     * Addresses</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network
     * interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @return Result of the AssignPrivateIpAddresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignPrivateIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default AssignPrivateIpAddressesResponse assignPrivateIpAddresses(
            AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For more information about Elastic IP addresses, see
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     * Addresses</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network
     * interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssignPrivateIpAddressesRequest.Builder} avoiding
     * the need to create one manually via {@link AssignPrivateIpAddressesRequest#builder()}
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest.Builder} to create a
     *        request. Contains the parameters for AssignPrivateIpAddresses.
     * @return Result of the AssignPrivateIpAddresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignPrivateIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default AssignPrivateIpAddressesResponse assignPrivateIpAddresses(
            Consumer<AssignPrivateIpAddressesRequest.Builder> assignPrivateIpAddressesRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return assignPrivateIpAddresses(AssignPrivateIpAddressesRequest.builder().applyMutation(assignPrivateIpAddressesRequest)
                .build());
    }

    /**
     * <p>
     * Assigns private IPv4 addresses to a private NAT gateway. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Work with NAT gateways</a>
     * in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param assignPrivateNatGatewayAddressRequest
     * @return Result of the AssignPrivateNatGatewayAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignPrivateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default AssignPrivateNatGatewayAddressResponse assignPrivateNatGatewayAddress(
            AssignPrivateNatGatewayAddressRequest assignPrivateNatGatewayAddressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns private IPv4 addresses to a private NAT gateway. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Work with NAT gateways</a>
     * in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssignPrivateNatGatewayAddressRequest.Builder}
     * avoiding the need to create one manually via {@link AssignPrivateNatGatewayAddressRequest#builder()}
     * </p>
     *
     * @param assignPrivateNatGatewayAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest.Builder} to create
     *        a request.
     * @return Result of the AssignPrivateNatGatewayAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignPrivateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default AssignPrivateNatGatewayAddressResponse assignPrivateNatGatewayAddress(
            Consumer<AssignPrivateNatGatewayAddressRequest.Builder> assignPrivateNatGatewayAddressRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return assignPrivateNatGatewayAddress(AssignPrivateNatGatewayAddressRequest.builder()
                .applyMutation(assignPrivateNatGatewayAddressRequest).build());
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * If the Elastic IP address is already associated with a different instance, it is disassociated from that instance
     * and associated with the specified instance. If you associate an Elastic IP address with an instance that has an
     * existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to
     * your account.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @param associateAddressRequest
     * @return Result of the AssociateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateAddressResponse associateAddress(AssociateAddressRequest associateAddressRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * If the Elastic IP address is already associated with a different instance, it is disassociated from that instance
     * and associated with the specified instance. If you associate an Elastic IP address with an instance that has an
     * existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to
     * your account.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAddressRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateAddressRequest#builder()}
     * </p>
     *
     * @param associateAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateAddressRequest.Builder} to create a request.
     * @return Result of the AssociateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateAddressResponse associateAddress(Consumer<AssociateAddressRequest.Builder> associateAddressRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateAddress(AssociateAddressRequest.builder().applyMutation(associateAddressRequest).build());
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * If the Elastic IP address is already associated with a different instance, it is disassociated from that instance
     * and associated with the specified instance. If you associate an Elastic IP address with an instance that has an
     * existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to
     * your account.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @return Result of the AssociateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateAddress
     * @see #associateAddress(AssociateAddressRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateAddressResponse associateAddress() throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateAddress(AssociateAddressRequest.builder().build());
    }

    /**
     * <p>
     * Initiates a request to assign billing of the unused capacity of a shared Capacity Reservation to a consumer
     * account that is consolidated under the same Amazon Web Services organizations payer account. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html">Billing
     * assignment for shared Amazon EC2 Capacity Reservations</a>.
     * </p>
     *
     * @param associateCapacityReservationBillingOwnerRequest
     * @return Result of the AssociateCapacityReservationBillingOwner operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateCapacityReservationBillingOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateCapacityReservationBillingOwner"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCapacityReservationBillingOwnerResponse associateCapacityReservationBillingOwner(
            AssociateCapacityReservationBillingOwnerRequest associateCapacityReservationBillingOwnerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a request to assign billing of the unused capacity of a shared Capacity Reservation to a consumer
     * account that is consolidated under the same Amazon Web Services organizations payer account. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html">Billing
     * assignment for shared Amazon EC2 Capacity Reservations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateCapacityReservationBillingOwnerRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateCapacityReservationBillingOwnerRequest#builder()}
     * </p>
     *
     * @param associateCapacityReservationBillingOwnerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateCapacityReservationBillingOwnerRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateCapacityReservationBillingOwner operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateCapacityReservationBillingOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateCapacityReservationBillingOwner"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCapacityReservationBillingOwnerResponse associateCapacityReservationBillingOwner(
            Consumer<AssociateCapacityReservationBillingOwnerRequest.Builder> associateCapacityReservationBillingOwnerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateCapacityReservationBillingOwner(AssociateCapacityReservationBillingOwnerRequest.builder()
                .applyMutation(associateCapacityReservationBillingOwnerRequest).build());
    }

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     *
     * @param associateClientVpnTargetNetworkRequest
     * @return Result of the AssociateClientVpnTargetNetwork operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateClientVpnTargetNetworkResponse associateClientVpnTargetNetwork(
            AssociateClientVpnTargetNetworkRequest associateClientVpnTargetNetworkRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateClientVpnTargetNetworkRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateClientVpnTargetNetworkRequest#builder()}
     * </p>
     *
     * @param associateClientVpnTargetNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateClientVpnTargetNetwork operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateClientVpnTargetNetworkResponse associateClientVpnTargetNetwork(
            Consumer<AssociateClientVpnTargetNetworkRequest.Builder> associateClientVpnTargetNetworkRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateClientVpnTargetNetwork(AssociateClientVpnTargetNetworkRequest.builder()
                .applyMutation(associateClientVpnTargetNetworkRequest).build());
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * option sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateDhcpOptionsRequest
     * @return Result of the AssociateDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDhcpOptionsResponse associateDhcpOptions(AssociateDhcpOptionsRequest associateDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * option sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDhcpOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDhcpOptionsRequest#builder()}
     * </p>
     *
     * @param associateDhcpOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest.Builder} to create a request.
     * @return Result of the AssociateDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDhcpOptionsResponse associateDhcpOptions(
            Consumer<AssociateDhcpOptionsRequest.Builder> associateDhcpOptionsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateDhcpOptions(AssociateDhcpOptionsRequest.builder().applyMutation(associateDhcpOptionsRequest).build());
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     *
     * @param associateEnclaveCertificateIamRoleRequest
     * @return Result of the AssociateEnclaveCertificateIamRole operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateEnclaveCertificateIamRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEnclaveCertificateIamRoleResponse associateEnclaveCertificateIamRole(
            AssociateEnclaveCertificateIamRoleRequest associateEnclaveCertificateIamRoleRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEnclaveCertificateIamRoleRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateEnclaveCertificateIamRoleRequest#builder()}
     * </p>
     *
     * @param associateEnclaveCertificateIamRoleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateEnclaveCertificateIamRole operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateEnclaveCertificateIamRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEnclaveCertificateIamRoleResponse associateEnclaveCertificateIamRole(
            Consumer<AssociateEnclaveCertificateIamRoleRequest.Builder> associateEnclaveCertificateIamRoleRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateEnclaveCertificateIamRole(AssociateEnclaveCertificateIamRoleRequest.builder()
                .applyMutation(associateEnclaveCertificateIamRoleRequest).build());
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     * @return Result of the AssociateIamInstanceProfile operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIamInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIamInstanceProfileResponse associateIamInstanceProfile(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIamInstanceProfileRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateIamInstanceProfileRequest#builder()}
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateIamInstanceProfile operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIamInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIamInstanceProfileResponse associateIamInstanceProfile(
            Consumer<AssociateIamInstanceProfileRequest.Builder> associateIamInstanceProfileRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateIamInstanceProfile(AssociateIamInstanceProfileRequest.builder()
                .applyMutation(associateIamInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param associateInstanceEventWindowRequest
     * @return Result of the AssociateInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateInstanceEventWindowResponse associateInstanceEventWindow(
            AssociateInstanceEventWindowRequest associateInstanceEventWindowRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateInstanceEventWindowRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateInstanceEventWindowRequest#builder()}
     * </p>
     *
     * @param associateInstanceEventWindowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateInstanceEventWindowResponse associateInstanceEventWindow(
            Consumer<AssociateInstanceEventWindowRequest.Builder> associateInstanceEventWindowRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateInstanceEventWindow(AssociateInstanceEventWindowRequest.builder()
                .applyMutation(associateInstanceEventWindowRequest).build());
    }

    /**
     * <p>
     * Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services
     * Region. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * <p>
     * After the association succeeds, the ASN is eligible for advertisement. You can view the association with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html">DescribeByoipCidrs</a>.
     * You can advertise the CIDR with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html">AdvertiseByoipCidr</a>.
     * </p>
     *
     * @param associateIpamByoasnRequest
     * @return Result of the AssociateIpamByoasn operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIpamByoasn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateIpamByoasnResponse associateIpamByoasn(AssociateIpamByoasnRequest associateIpamByoasnRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services
     * Region. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * <p>
     * After the association succeeds, the ASN is eligible for advertisement. You can view the association with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html">DescribeByoipCidrs</a>.
     * You can advertise the CIDR with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html">AdvertiseByoipCidr</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIpamByoasnRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateIpamByoasnRequest#builder()}
     * </p>
     *
     * @param associateIpamByoasnRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateIpamByoasnRequest.Builder} to create a request.
     * @return Result of the AssociateIpamByoasn operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIpamByoasn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateIpamByoasnResponse associateIpamByoasn(
            Consumer<AssociateIpamByoasnRequest.Builder> associateIpamByoasnRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateIpamByoasn(AssociateIpamByoasnRequest.builder().applyMutation(associateIpamByoasnRequest).build());
    }

    /**
     * <p>
     * Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that
     * enables IPAM to manage and monitor resources that belong to the owning account.
     * </p>
     *
     * @param associateIpamResourceDiscoveryRequest
     * @return Result of the AssociateIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIpamResourceDiscoveryResponse associateIpamResourceDiscovery(
            AssociateIpamResourceDiscoveryRequest associateIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that
     * enables IPAM to manage and monitor resources that belong to the owning account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIpamResourceDiscoveryRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateIpamResourceDiscoveryRequest#builder()}
     * </p>
     *
     * @param associateIpamResourceDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIpamResourceDiscoveryResponse associateIpamResourceDiscovery(
            Consumer<AssociateIpamResourceDiscoveryRequest.Builder> associateIpamResourceDiscoveryRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateIpamResourceDiscovery(AssociateIpamResourceDiscoveryRequest.builder()
                .applyMutation(associateIpamResourceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Work
     * with NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * By default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can increase the limit by
     * requesting a quota adjustment. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips">Elastic IP address
     * quotas</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you associate an EIP or secondary EIPs with a public NAT gateway, the network border group of the EIPs must
     * match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not the
     * same, the EIP will fail to associate. You can see the network border group for the subnet's AZ by viewing the
     * details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the
     * EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html">Allocate an Elastic IP address</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     *
     * @param associateNatGatewayAddressRequest
     * @return Result of the AssociateNatGatewayAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateNatGatewayAddressResponse associateNatGatewayAddress(
            AssociateNatGatewayAddressRequest associateNatGatewayAddressRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Work
     * with NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * By default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can increase the limit by
     * requesting a quota adjustment. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips">Elastic IP address
     * quotas</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you associate an EIP or secondary EIPs with a public NAT gateway, the network border group of the EIPs must
     * match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not the
     * same, the EIP will fail to associate. You can see the network border group for the subnet's AZ by viewing the
     * details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the
     * EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html">Allocate an Elastic IP address</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateNatGatewayAddressRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateNatGatewayAddressRequest#builder()}
     * </p>
     *
     * @param associateNatGatewayAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateNatGatewayAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateNatGatewayAddressResponse associateNatGatewayAddress(
            Consumer<AssociateNatGatewayAddressRequest.Builder> associateNatGatewayAddressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateNatGatewayAddress(AssociateNatGatewayAddressRequest.builder()
                .applyMutation(associateNatGatewayAddressRequest).build());
    }

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateRouteTableRequest
     * @return Result of the AssociateRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateRouteTableResponse associateRouteTable(AssociateRouteTableRequest associateRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateRouteTableRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateRouteTableRequest#builder()}
     * </p>
     *
     * @param associateRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest.Builder} to create a request.
     * @return Result of the AssociateRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateRouteTableResponse associateRouteTable(
            Consumer<AssociateRouteTableRequest.Builder> associateRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateRouteTable(AssociateRouteTableRequest.builder().applyMutation(associateRouteTableRequest).build());
    }

    /**
     * <p>
     * Associates a security group with another VPC in the same Region. This enables you to use the same security group
     * with network interfaces and instances in the specified VPC.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The VPC you want to associate the security group with must be in the same Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate the security group with another VPC if your account owns the VPC or if the VPC was shared with
     * you.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must own the security group and the VPC that it was created in.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use this feature with default security groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use this feature with the default VPC.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param associateSecurityGroupVpcRequest
     * @return Result of the AssociateSecurityGroupVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateSecurityGroupVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSecurityGroupVpc" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSecurityGroupVpcResponse associateSecurityGroupVpc(
            AssociateSecurityGroupVpcRequest associateSecurityGroupVpcRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a security group with another VPC in the same Region. This enables you to use the same security group
     * with network interfaces and instances in the specified VPC.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The VPC you want to associate the security group with must be in the same Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate the security group with another VPC if your account owns the VPC or if the VPC was shared with
     * you.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must own the security group and the VPC that it was created in.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use this feature with default security groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use this feature with the default VPC.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSecurityGroupVpcRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateSecurityGroupVpcRequest#builder()}
     * </p>
     *
     * @param associateSecurityGroupVpcRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateSecurityGroupVpcRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSecurityGroupVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateSecurityGroupVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSecurityGroupVpc" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSecurityGroupVpcResponse associateSecurityGroupVpc(
            Consumer<AssociateSecurityGroupVpcRequest.Builder> associateSecurityGroupVpcRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateSecurityGroupVpc(AssociateSecurityGroupVpcRequest.builder()
                .applyMutation(associateSecurityGroupVpcRequest).build());
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     * @return Result of the AssociateSubnetCidrBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateSubnetCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSubnetCidrBlockResponse associateSubnetCidrBlock(
            AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSubnetCidrBlockRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateSubnetCidrBlockRequest#builder()}
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSubnetCidrBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateSubnetCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSubnetCidrBlockResponse associateSubnetCidrBlock(
            Consumer<AssociateSubnetCidrBlockRequest.Builder> associateSubnetCidrBlockRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateSubnetCidrBlock(AssociateSubnetCidrBlockRequest.builder().applyMutation(associateSubnetCidrBlockRequest)
                .build());
    }

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     *
     * @param associateTransitGatewayMulticastDomainRequest
     * @return Result of the AssociateTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayMulticastDomainResponse associateTransitGatewayMulticastDomain(
            AssociateTransitGatewayMulticastDomainRequest associateTransitGatewayMulticastDomainRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateTransitGatewayMulticastDomainRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateTransitGatewayMulticastDomainRequest#builder()}
     * </p>
     *
     * @param associateTransitGatewayMulticastDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayMulticastDomainResponse associateTransitGatewayMulticastDomain(
            Consumer<AssociateTransitGatewayMulticastDomainRequest.Builder> associateTransitGatewayMulticastDomainRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateTransitGatewayMulticastDomain(AssociateTransitGatewayMulticastDomainRequest.builder()
                .applyMutation(associateTransitGatewayMulticastDomainRequest).build());
    }

    /**
     * <p>
     * Associates the specified transit gateway attachment with a transit gateway policy table.
     * </p>
     *
     * @param associateTransitGatewayPolicyTableRequest
     * @return Result of the AssociateTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayPolicyTableResponse associateTransitGatewayPolicyTable(
            AssociateTransitGatewayPolicyTableRequest associateTransitGatewayPolicyTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified transit gateway attachment with a transit gateway policy table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTransitGatewayPolicyTableRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTransitGatewayPolicyTableRequest#builder()}
     * </p>
     *
     * @param associateTransitGatewayPolicyTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayPolicyTableResponse associateTransitGatewayPolicyTable(
            Consumer<AssociateTransitGatewayPolicyTableRequest.Builder> associateTransitGatewayPolicyTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateTransitGatewayPolicyTable(AssociateTransitGatewayPolicyTableRequest.builder()
                .applyMutation(associateTransitGatewayPolicyTableRequest).build());
    }

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     *
     * @param associateTransitGatewayRouteTableRequest
     * @return Result of the AssociateTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayRouteTableResponse associateTransitGatewayRouteTable(
            AssociateTransitGatewayRouteTableRequest associateTransitGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTransitGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateTransitGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param associateTransitGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTransitGatewayRouteTableResponse associateTransitGatewayRouteTable(
            Consumer<AssociateTransitGatewayRouteTableRequest.Builder> associateTransitGatewayRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return associateTransitGatewayRouteTable(AssociateTransitGatewayRouteTableRequest.builder()
                .applyMutation(associateTransitGatewayRouteTableRequest).build());
    }

    /**
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >CreateNetworkInterface</a> command and set the interface type to <code>trunk</code>. You must also create a
     * network interface for each branch network interface that you want to associate with the trunk network interface.
     * </p>
     *
     * @param associateTrunkInterfaceRequest
     * @return Result of the AssociateTrunkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTrunkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateTrunkInterfaceResponse associateTrunkInterface(AssociateTrunkInterfaceRequest associateTrunkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >CreateNetworkInterface</a> command and set the interface type to <code>trunk</code>. You must also create a
     * network interface for each branch network interface that you want to associate with the trunk network interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrunkInterfaceRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTrunkInterfaceRequest#builder()}
     * </p>
     *
     * @param associateTrunkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateTrunkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTrunkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateTrunkInterfaceResponse associateTrunkInterface(
            Consumer<AssociateTrunkInterfaceRequest.Builder> associateTrunkInterfaceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateTrunkInterface(AssociateTrunkInterfaceRequest.builder().applyMutation(associateTrunkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     * @return Result of the AssociateVpcCidrBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateVpcCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateVpcCidrBlockResponse associateVpcCidrBlock(AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVpcCidrBlockRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateVpcCidrBlockRequest#builder()}
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateVpcCidrBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateVpcCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateVpcCidrBlockResponse associateVpcCidrBlock(
            Consumer<AssociateVpcCidrBlockRequest.Builder> associateVpcCidrBlockRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return associateVpcCidrBlock(AssociateVpcCidrBlockRequest.builder().applyMutation(associateVpcCidrBlockRequest).build());
    }

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     * @return Result of the AttachClassicLinkVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachClassicLinkVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachClassicLinkVpcResponse attachClassicLinkVpc(AttachClassicLinkVpcRequest attachClassicLinkVpcRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachClassicLinkVpcRequest.Builder} avoiding the
     * need to create one manually via {@link AttachClassicLinkVpcRequest#builder()}
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest.Builder} to create a request.
     * @return Result of the AttachClassicLinkVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachClassicLinkVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachClassicLinkVpcResponse attachClassicLinkVpc(
            Consumer<AttachClassicLinkVpcRequest.Builder> attachClassicLinkVpcRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return attachClassicLinkVpc(AttachClassicLinkVpcRequest.builder().applyMutation(attachClassicLinkVpcRequest).build());
    }

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param attachInternetGatewayRequest
     * @return Result of the AttachInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachInternetGatewayResponse attachInternetGateway(AttachInternetGatewayRequest attachInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachInternetGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link AttachInternetGatewayRequest#builder()}
     * </p>
     *
     * @param attachInternetGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the AttachInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachInternetGatewayResponse attachInternetGateway(
            Consumer<AttachInternetGatewayRequest.Builder> attachInternetGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return attachInternetGateway(AttachInternetGatewayRequest.builder().applyMutation(attachInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @return Result of the AttachNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default AttachNetworkInterfaceResponse attachNetworkInterface(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachNetworkInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link AttachNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest.Builder} to create a
     *        request. Contains the parameters for AttachNetworkInterface.
     * @return Result of the AttachNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default AttachNetworkInterfaceResponse attachNetworkInterface(
            Consumer<AttachNetworkInterfaceRequest.Builder> attachNetworkInterfaceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return attachNetworkInterface(AttachNetworkInterfaceRequest.builder().applyMutation(attachNetworkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     *
     * @param attachVerifiedAccessTrustProviderRequest
     * @return Result of the AttachVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachVerifiedAccessTrustProviderResponse attachVerifiedAccessTrustProvider(
            AttachVerifiedAccessTrustProviderRequest attachVerifiedAccessTrustProviderRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachVerifiedAccessTrustProviderRequest.Builder}
     * avoiding the need to create one manually via {@link AttachVerifiedAccessTrustProviderRequest#builder()}
     * </p>
     *
     * @param attachVerifiedAccessTrustProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest.Builder} to
     *        create a request.
     * @return Result of the AttachVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachVerifiedAccessTrustProviderResponse attachVerifiedAccessTrustProvider(
            Consumer<AttachVerifiedAccessTrustProviderRequest.Builder> attachVerifiedAccessTrustProviderRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return attachVerifiedAccessTrustProvider(AttachVerifiedAccessTrustProviderRequest.builder()
                .applyMutation(attachVerifiedAccessTrustProviderRequest).build());
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html">Make an EBS volume available for
     * use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html">Attach an Amazon EBS volume to
     * an instance</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param attachVolumeRequest
     * @return Result of the AttachVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachVolumeResponse attachVolume(AttachVolumeRequest attachVolumeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html">Make an EBS volume available for
     * use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html">Attach an Amazon EBS volume to
     * an instance</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link AttachVolumeRequest#builder()}
     * </p>
     *
     * @param attachVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AttachVolumeRequest.Builder} to create a request.
     * @return Result of the AttachVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachVolumeResponse attachVolume(Consumer<AttachVolumeRequest.Builder> attachVolumeRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return attachVolume(AttachVolumeRequest.builder().applyMutation(attachVolumeRequest).build());
    }

    /**
     * <p>
     * Attaches an available virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at
     * a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @return Result of the AttachVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachVpnGatewayResponse attachVpnGateway(AttachVpnGatewayRequest attachVpnGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an available virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at
     * a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachVpnGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link AttachVpnGatewayRequest#builder()}
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest.Builder} to create a request.
     *        Contains the parameters for AttachVpnGateway.
     * @return Result of the AttachVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default AttachVpnGatewayResponse attachVpnGateway(Consumer<AttachVpnGatewayRequest.Builder> attachVpnGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return attachVpnGateway(AttachVpnGatewayRequest.builder().applyMutation(attachVpnGatewayRequest).build());
    }

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     *
     * @param authorizeClientVpnIngressRequest
     * @return Result of the AuthorizeClientVpnIngress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeClientVpnIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    default AuthorizeClientVpnIngressResponse authorizeClientVpnIngress(
            AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeClientVpnIngressRequest.Builder} avoiding
     * the need to create one manually via {@link AuthorizeClientVpnIngressRequest#builder()}
     * </p>
     *
     * @param authorizeClientVpnIngressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest.Builder} to create a
     *        request.
     * @return Result of the AuthorizeClientVpnIngress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeClientVpnIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    default AuthorizeClientVpnIngressResponse authorizeClientVpnIngress(
            Consumer<AuthorizeClientVpnIngressRequest.Builder> authorizeClientVpnIngressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return authorizeClientVpnIngress(AuthorizeClientVpnIngressRequest.builder()
                .applyMutation(authorizeClientVpnIngressRequest).build());
    }

    /**
     * <p>
     * Adds the specified outbound (egress) rules to a security group.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address
     * ranges specified by a prefix list, or the instances that are associated with a source security group. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security
     * group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP type
     * and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     * @return Result of the AuthorizeSecurityGroupEgress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeSecurityGroupEgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeSecurityGroupEgressResponse authorizeSecurityGroupEgress(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified outbound (egress) rules to a security group.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address
     * ranges specified by a prefix list, or the instances that are associated with a source security group. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security
     * group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP type
     * and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeSecurityGroupEgressRequest.Builder}
     * avoiding the need to create one manually via {@link AuthorizeSecurityGroupEgressRequest#builder()}
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest.Builder} to create a
     *        request.
     * @return Result of the AuthorizeSecurityGroupEgress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeSecurityGroupEgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeSecurityGroupEgressResponse authorizeSecurityGroupEgress(
            Consumer<AuthorizeSecurityGroupEgressRequest.Builder> authorizeSecurityGroupEgressRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return authorizeSecurityGroupEgress(AuthorizeSecurityGroupEgressRequest.builder()
                .applyMutation(authorizeSecurityGroupEgressRequest).build());
    }

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP
     * address ranges that are specified by a prefix list, or the instances that are associated with a destination
     * security group. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6
     * type and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     * @return Result of the AuthorizeSecurityGroupIngress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeSecurityGroupIngressResponse authorizeSecurityGroupIngress(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP
     * address ranges that are specified by a prefix list, or the instances that are associated with a destination
     * security group. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6
     * type and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeSecurityGroupIngressRequest.Builder}
     * avoiding the need to create one manually via {@link AuthorizeSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest.Builder} to create a
     *        request.
     * @return Result of the AuthorizeSecurityGroupIngress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeSecurityGroupIngressResponse authorizeSecurityGroupIngress(
            Consumer<AuthorizeSecurityGroupIngressRequest.Builder> authorizeSecurityGroupIngressRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return authorizeSecurityGroupIngress(AuthorizeSecurityGroupIngressRequest.builder()
                .applyMutation(authorizeSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     *
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @return Result of the BundleInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.BundleInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default BundleInstanceResponse bundleInstance(BundleInstanceRequest bundleInstanceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BundleInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link BundleInstanceRequest#builder()}
     * </p>
     *
     * @param bundleInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.BundleInstanceRequest.Builder} to create a request.
     *        Contains the parameters for BundleInstance.
     * @return Result of the BundleInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.BundleInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default BundleInstanceResponse bundleInstance(Consumer<BundleInstanceRequest.Builder> bundleInstanceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return bundleInstance(BundleInstanceRequest.builder().applyMutation(bundleInstanceRequest).build());
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @return Result of the CancelBundleTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelBundleTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelBundleTaskResponse cancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelBundleTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelBundleTaskRequest#builder()}
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest.Builder} to create a request.
     *        Contains the parameters for CancelBundleTask.
     * @return Result of the CancelBundleTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelBundleTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelBundleTaskResponse cancelBundleTask(Consumer<CancelBundleTaskRequest.Builder> cancelBundleTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return cancelBundleTask(CancelBundleTaskRequest.builder().applyMutation(cancelBundleTaskRequest).build());
    }

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * You can cancel a Capacity Reservation that is in the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assessing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>active</code> and there is no commitment duration or the commitment duration has elapsed. You can't cancel
     * a future-dated Capacity Reservation during the commitment duration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If a future-dated Capacity Reservation enters the <code>delayed</code> state, the commitment duration is waived,
     * and you can cancel it as soon as it enters the <code>active</code> state.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return Result of the CancelCapacityReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelCapacityReservationResponse cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * You can cancel a Capacity Reservation that is in the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assessing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>active</code> and there is no commitment duration or the commitment duration has elapsed. You can't cancel
     * a future-dated Capacity Reservation during the commitment duration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If a future-dated Capacity Reservation enters the <code>delayed</code> state, the commitment duration is waived,
     * and you can cancel it as soon as it enters the <code>active</code> state.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link CancelCapacityReservationRequest#builder()}
     * </p>
     *
     * @param cancelCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest.Builder} to create a
     *        request.
     * @return Result of the CancelCapacityReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelCapacityReservationResponse cancelCapacityReservation(
            Consumer<CancelCapacityReservationRequest.Builder> cancelCapacityReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return cancelCapacityReservation(CancelCapacityReservationRequest.builder()
                .applyMutation(cancelCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelCapacityReservationFleetsRequest
     * @return Result of the CancelCapacityReservationFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelCapacityReservationFleetsResponse cancelCapacityReservationFleets(
            CancelCapacityReservationFleetsRequest cancelCapacityReservationFleetsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCapacityReservationFleetsRequest.Builder}
     * avoiding the need to create one manually via {@link CancelCapacityReservationFleetsRequest#builder()}
     * </p>
     *
     * @param cancelCapacityReservationFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest.Builder} to create
     *        a request.
     * @return Result of the CancelCapacityReservationFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelCapacityReservationFleetsResponse cancelCapacityReservationFleets(
            Consumer<CancelCapacityReservationFleetsRequest.Builder> cancelCapacityReservationFleetsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return cancelCapacityReservationFleets(CancelCapacityReservationFleetsRequest.builder()
                .applyMutation(cancelCapacityReservationFleetsRequest).build());
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     *
     * @param cancelConversionTaskRequest
     * @return Result of the CancelConversionTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelConversionTaskResponse cancelConversionTask(CancelConversionTaskRequest cancelConversionTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelConversionTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CancelConversionTaskRequest#builder()}
     * </p>
     *
     * @param cancelConversionTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest.Builder} to create a request.
     * @return Result of the CancelConversionTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelConversionTaskResponse cancelConversionTask(
            Consumer<CancelConversionTaskRequest.Builder> cancelConversionTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return cancelConversionTask(CancelConversionTaskRequest.builder().applyMutation(cancelConversionTaskRequest).build());
    }

    /**
     * <p>
     * Cancels the generation of an account status report.
     * </p>
     * <p>
     * You can only cancel a report while it has the <code>running</code> status. Reports with other statuses (
     * <code>complete</code>, <code>cancelled</code>, or <code>error</code>) can't be canceled.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative_status-report.html"
     * >Generating the account status report for declarative policies</a> in the <i>Amazon Web Services Organizations
     * User Guide</i>.
     * </p>
     *
     * @param cancelDeclarativePoliciesReportRequest
     * @return Result of the CancelDeclarativePoliciesReport operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelDeclarativePoliciesReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelDeclarativePoliciesReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelDeclarativePoliciesReportResponse cancelDeclarativePoliciesReport(
            CancelDeclarativePoliciesReportRequest cancelDeclarativePoliciesReportRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the generation of an account status report.
     * </p>
     * <p>
     * You can only cancel a report while it has the <code>running</code> status. Reports with other statuses (
     * <code>complete</code>, <code>cancelled</code>, or <code>error</code>) can't be canceled.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative_status-report.html"
     * >Generating the account status report for declarative policies</a> in the <i>Amazon Web Services Organizations
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDeclarativePoliciesReportRequest.Builder}
     * avoiding the need to create one manually via {@link CancelDeclarativePoliciesReportRequest#builder()}
     * </p>
     *
     * @param cancelDeclarativePoliciesReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelDeclarativePoliciesReportRequest.Builder} to create
     *        a request.
     * @return Result of the CancelDeclarativePoliciesReport operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelDeclarativePoliciesReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelDeclarativePoliciesReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelDeclarativePoliciesReportResponse cancelDeclarativePoliciesReport(
            Consumer<CancelDeclarativePoliciesReportRequest.Builder> cancelDeclarativePoliciesReportRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return cancelDeclarativePoliciesReport(CancelDeclarativePoliciesReportRequest.builder()
                .applyMutation(cancelDeclarativePoliciesReportRequest).build());
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return Result of the CancelExportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelExportTaskResponse cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelExportTaskRequest#builder()}
     * </p>
     *
     * @param cancelExportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest.Builder} to create a request.
     * @return Result of the CancelExportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelExportTaskResponse cancelExportTask(Consumer<CancelExportTaskRequest.Builder> cancelExportTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return cancelExportTask(CancelExportTaskRequest.builder().applyMutation(cancelExportTaskRequest).build());
    }

    /**
     * <p>
     * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html"> Cancel having an
     * AMI shared with your Amazon Web Services account</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param cancelImageLaunchPermissionRequest
     * @return Result of the CancelImageLaunchPermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelImageLaunchPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelImageLaunchPermissionResponse cancelImageLaunchPermission(
            CancelImageLaunchPermissionRequest cancelImageLaunchPermissionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html"> Cancel having an
     * AMI shared with your Amazon Web Services account</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelImageLaunchPermissionRequest.Builder}
     * avoiding the need to create one manually via {@link CancelImageLaunchPermissionRequest#builder()}
     * </p>
     *
     * @param cancelImageLaunchPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest.Builder} to create a
     *        request.
     * @return Result of the CancelImageLaunchPermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelImageLaunchPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelImageLaunchPermissionResponse cancelImageLaunchPermission(
            Consumer<CancelImageLaunchPermissionRequest.Builder> cancelImageLaunchPermissionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return cancelImageLaunchPermission(CancelImageLaunchPermissionRequest.builder()
                .applyMutation(cancelImageLaunchPermissionRequest).build());
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     *
     * @param cancelImportTaskRequest
     * @return Result of the CancelImportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelImportTaskResponse cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelImportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelImportTaskRequest#builder()}
     * </p>
     *
     * @param cancelImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest.Builder} to create a request.
     * @return Result of the CancelImportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelImportTaskResponse cancelImportTask(Consumer<CancelImportTaskRequest.Builder> cancelImportTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return cancelImportTask(CancelImportTaskRequest.builder().applyMutation(cancelImportTaskRequest).build());
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @return Result of the CancelReservedInstancesListing operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelReservedInstancesListingResponse cancelReservedInstancesListing(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelReservedInstancesListingRequest.Builder}
     * avoiding the need to create one manually via {@link CancelReservedInstancesListingRequest#builder()}
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest.Builder} to create
     *        a request. Contains the parameters for CancelReservedInstancesListing.
     * @return Result of the CancelReservedInstancesListing operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelReservedInstancesListingResponse cancelReservedInstancesListing(
            Consumer<CancelReservedInstancesListingRequest.Builder> cancelReservedInstancesListingRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return cancelReservedInstancesListing(CancelReservedInstancesListingRequest.builder()
                .applyMutation(cancelReservedInstancesListingRequest).build());
    }

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a canceled Spot Fleet request should terminate its instances. If you choose to
     * terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise,
     * the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until
     * they are interrupted or you terminate them manually.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 100 fleets in a single request. If you exceed the specified number, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @return Result of the CancelSpotFleetRequests operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelSpotFleetRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSpotFleetRequestsResponse cancelSpotFleetRequests(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a canceled Spot Fleet request should terminate its instances. If you choose to
     * terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise,
     * the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until
     * they are interrupted or you terminate them manually.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 100 fleets in a single request. If you exceed the specified number, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSpotFleetRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSpotFleetRequestsRequest#builder()}
     * </p>
     *
     * @param cancelSpotFleetRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest.Builder} to create a
     *        request. Contains the parameters for CancelSpotFleetRequests.
     * @return Result of the CancelSpotFleetRequests operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelSpotFleetRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSpotFleetRequestsResponse cancelSpotFleetRequests(
            Consumer<CancelSpotFleetRequestsRequest.Builder> cancelSpotFleetRequestsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return cancelSpotFleetRequests(CancelSpotFleetRequestsRequest.builder().applyMutation(cancelSpotFleetRequestsRequest)
                .build());
    }

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @return Result of the CancelSpotInstanceRequests operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelSpotInstanceRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelSpotInstanceRequestsResponse cancelSpotInstanceRequests(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSpotInstanceRequestsRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSpotInstanceRequestsRequest#builder()}
     * </p>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest.Builder} to create a
     *        request. Contains the parameters for CancelSpotInstanceRequests.
     * @return Result of the CancelSpotInstanceRequests operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelSpotInstanceRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelSpotInstanceRequestsResponse cancelSpotInstanceRequests(
            Consumer<CancelSpotInstanceRequestsRequest.Builder> cancelSpotInstanceRequestsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return cancelSpotInstanceRequests(CancelSpotInstanceRequestsRequest.builder()
                .applyMutation(cancelSpotInstanceRequestsRequest).build());
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     *
     * @param confirmProductInstanceRequest
     * @return Result of the ConfirmProductInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.ConfirmProductInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default ConfirmProductInstanceResponse confirmProductInstance(ConfirmProductInstanceRequest confirmProductInstanceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmProductInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link ConfirmProductInstanceRequest#builder()}
     * </p>
     *
     * @param confirmProductInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the ConfirmProductInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.ConfirmProductInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default ConfirmProductInstanceResponse confirmProductInstance(
            Consumer<ConfirmProductInstanceRequest.Builder> confirmProductInstanceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return confirmProductInstance(ConfirmProductInstanceRequest.builder().applyMutation(confirmProductInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     *
     * @param copyFpgaImageRequest
     * @return Result of the CopyFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopyFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyFpgaImageResponse copyFpgaImage(CopyFpgaImageRequest copyFpgaImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyFpgaImageRequest.Builder} avoiding the need to
     * create one manually via {@link CopyFpgaImageRequest#builder()}
     * </p>
     *
     * @param copyFpgaImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest.Builder} to create a request.
     * @return Result of the CopyFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopyFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyFpgaImageResponse copyFpgaImage(Consumer<CopyFpgaImageRequest.Builder> copyFpgaImageRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return copyFpgaImage(CopyFpgaImageRequest.builder().applyMutation(copyFpgaImageRequest).build());
    }

    /**
     * <p>
     * Initiates an AMI copy operation. You can copy an AMI from one Region to another, or from a Region to an Outpost.
     * You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To
     * copy an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * When you copy an AMI from one Region to another, the destination Region is the current Region.
     * </p>
     * <p>
     * When you copy an AMI from a Region to an Outpost, specify the ARN of the Outpost as the destination. Backing
     * snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region or the
     * key that you specify. Outposts do not support unencrypted snapshots.
     * </p>
     * <p>
     * For information about the prerequisites when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copy an AMI</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     *
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @return Result of the CopyImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyImageResponse copyImage(CopyImageRequest copyImageRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates an AMI copy operation. You can copy an AMI from one Region to another, or from a Region to an Outpost.
     * You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To
     * copy an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * When you copy an AMI from one Region to another, the destination Region is the current Region.
     * </p>
     * <p>
     * When you copy an AMI from a Region to an Outpost, specify the ARN of the Outpost as the destination. Backing
     * snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region or the
     * key that you specify. Outposts do not support unencrypted snapshots.
     * </p>
     * <p>
     * For information about the prerequisites when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copy an AMI</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyImageRequest.Builder} avoiding the need to
     * create one manually via {@link CopyImageRequest#builder()}
     * </p>
     *
     * @param copyImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CopyImageRequest.Builder} to create a request. Contains
     *        the parameters for CopyImage.
     * @return Result of the CopyImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyImageResponse copyImage(Consumer<CopyImageRequest.Builder> copyImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return copyImage(CopyImageRequest.builder().applyMutation(copyImageRequest).build());
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default KMS key; however, you can specify a different KMS key. To copy an encrypted
     * snapshot that has been shared from another account, you must have permissions for the KMS key used to encrypt the
     * snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS local snapshots
     * on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html">Copy
     * an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param copySnapshotRequest
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default KMS key; however, you can specify a different KMS key. To copy an encrypted
     * snapshot that has been shared from another account, you must have permissions for the KMS key used to encrypt the
     * snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS local snapshots
     * on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html">Copy
     * an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopySnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopySnapshotRequest#builder()}
     * </p>
     *
     * @param copySnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CopySnapshotRequest.Builder} to create a request.
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopySnapshotResponse copySnapshot(Consumer<CopySnapshotRequest.Builder> copySnapshotRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return copySnapshot(CopySnapshotRequest.builder().applyMutation(copySnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes. Capacity Reservations enable you to reserve
     * capacity for your Amazon EC2 instances in a specific Availability Zone for any duration.
     * </p>
     * <p>
     * You can create a Capacity Reservation at any time, and you can choose when it starts. You can create a Capacity
     * Reservation for immediate use or you can request a Capacity Reservation for a future date.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html"> Reserve compute
     * capacity with On-Demand Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 does not have sufficient capacity. In this case, try again at a later time, try in a different
     * Availability Zone, or request a smaller Capacity Reservation. If your workload is flexible across instance types
     * and sizes, try with different instance attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested quantity exceeds your On-Demand Instance quota. In this case, increase your On-Demand Instance
     * quota for the requested instance type and try again. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html"> Amazon EC2 Service
     * Quotas</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param createCapacityReservationRequest
     * @return Result of the CreateCapacityReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCapacityReservationResponse createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes. Capacity Reservations enable you to reserve
     * capacity for your Amazon EC2 instances in a specific Availability Zone for any duration.
     * </p>
     * <p>
     * You can create a Capacity Reservation at any time, and you can choose when it starts. You can create a Capacity
     * Reservation for immediate use or you can request a Capacity Reservation for a future date.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html"> Reserve compute
     * capacity with On-Demand Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 does not have sufficient capacity. In this case, try again at a later time, try in a different
     * Availability Zone, or request a smaller Capacity Reservation. If your workload is flexible across instance types
     * and sizes, try with different instance attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested quantity exceeds your On-Demand Instance quota. In this case, increase your On-Demand Instance
     * quota for the requested instance type and try again. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html"> Amazon EC2 Service
     * Quotas</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapacityReservationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCapacityReservationRequest#builder()}
     * </p>
     *
     * @param createCapacityReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCapacityReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateCapacityReservationResponse createCapacityReservation(
            Consumer<CreateCapacityReservationRequest.Builder> createCapacityReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createCapacityReservation(CreateCapacityReservationRequest.builder()
                .applyMutation(createCapacityReservationRequest).build());
    }

    /**
     * <p>
     * Create a new Capacity Reservation by splitting the capacity of the source Capacity Reservation. The new Capacity
     * Reservation will have the same attributes as the source Capacity Reservation except for tags. The source Capacity
     * Reservation must be <code>active</code> and owned by your Amazon Web Services account.
     * </p>
     *
     * @param createCapacityReservationBySplittingRequest
     * @return Result of the CreateCapacityReservationBySplitting operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservationBySplitting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationBySplitting"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCapacityReservationBySplittingResponse createCapacityReservationBySplitting(
            CreateCapacityReservationBySplittingRequest createCapacityReservationBySplittingRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new Capacity Reservation by splitting the capacity of the source Capacity Reservation. The new Capacity
     * Reservation will have the same attributes as the source Capacity Reservation except for tags. The source Capacity
     * Reservation must be <code>active</code> and owned by your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCapacityReservationBySplittingRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCapacityReservationBySplittingRequest#builder()}
     * </p>
     *
     * @param createCapacityReservationBySplittingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateCapacityReservationBySplittingRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCapacityReservationBySplitting operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservationBySplitting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationBySplitting"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCapacityReservationBySplittingResponse createCapacityReservationBySplitting(
            Consumer<CreateCapacityReservationBySplittingRequest.Builder> createCapacityReservationBySplittingRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createCapacityReservationBySplitting(CreateCapacityReservationBySplittingRequest.builder()
                .applyMutation(createCapacityReservationBySplittingRequest).build());
    }

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createCapacityReservationFleetRequest
     * @return Result of the CreateCapacityReservationFleet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCapacityReservationFleetResponse createCapacityReservationFleet(
            CreateCapacityReservationFleetRequest createCapacityReservationFleetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapacityReservationFleetRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCapacityReservationFleetRequest#builder()}
     * </p>
     *
     * @param createCapacityReservationFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest.Builder} to create
     *        a request.
     * @return Result of the CreateCapacityReservationFleet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCapacityReservationFleetResponse createCapacityReservationFleet(
            Consumer<CreateCapacityReservationFleetRequest.Builder> createCapacityReservationFleetRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createCapacityReservationFleet(CreateCapacityReservationFleetRequest.builder()
                .applyMutation(createCapacityReservationFleetRequest).build());
    }

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     *
     * @param createCarrierGatewayRequest
     * @return Result of the CreateCarrierGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCarrierGatewayResponse createCarrierGateway(CreateCarrierGatewayRequest createCarrierGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCarrierGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCarrierGatewayRequest#builder()}
     * </p>
     *
     * @param createCarrierGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayRequest.Builder} to create a request.
     * @return Result of the CreateCarrierGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCarrierGatewayResponse createCarrierGateway(
            Consumer<CreateCarrierGatewayRequest.Builder> createCarrierGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createCarrierGateway(CreateCarrierGatewayRequest.builder().applyMutation(createCarrierGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     *
     * @param createClientVpnEndpointRequest
     * @return Result of the CreateClientVpnEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateClientVpnEndpointResponse createClientVpnEndpoint(CreateClientVpnEndpointRequest createClientVpnEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClientVpnEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateClientVpnEndpointRequest#builder()}
     * </p>
     *
     * @param createClientVpnEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateClientVpnEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateClientVpnEndpointResponse createClientVpnEndpoint(
            Consumer<CreateClientVpnEndpointRequest.Builder> createClientVpnEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createClientVpnEndpoint(CreateClientVpnEndpointRequest.builder().applyMutation(createClientVpnEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     *
     * @param createClientVpnRouteRequest
     * @return Result of the CreateClientVpnRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClientVpnRouteResponse createClientVpnRoute(CreateClientVpnRouteRequest createClientVpnRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClientVpnRouteRequest.Builder} avoiding the
     * need to create one manually via {@link CreateClientVpnRouteRequest#builder()}
     * </p>
     *
     * @param createClientVpnRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest.Builder} to create a request.
     * @return Result of the CreateClientVpnRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClientVpnRouteResponse createClientVpnRoute(
            Consumer<CreateClientVpnRouteRequest.Builder> createClientVpnRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createClientVpnRoute(CreateClientVpnRouteRequest.builder().applyMutation(createClientVpnRouteRequest).build());
    }

    /**
     * <p>
     * Creates a range of customer-owned IP addresses.
     * </p>
     *
     * @param createCoipCidrRequest
     * @return Result of the CreateCoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCoipCidrResponse createCoipCidr(CreateCoipCidrRequest createCoipCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a range of customer-owned IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoipCidrRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCoipCidrRequest#builder()}
     * </p>
     *
     * @param createCoipCidrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest.Builder} to create a request.
     * @return Result of the CreateCoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCoipCidrResponse createCoipCidr(Consumer<CreateCoipCidrRequest.Builder> createCoipCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createCoipCidr(CreateCoipCidrRequest.builder().applyMutation(createCoipCidrRequest).build());
    }

    /**
     * <p>
     * Creates a pool of customer-owned IP (CoIP) addresses.
     * </p>
     *
     * @param createCoipPoolRequest
     * @return Result of the CreateCoipPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCoipPoolResponse createCoipPool(CreateCoipPoolRequest createCoipPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pool of customer-owned IP (CoIP) addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCoipPoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCoipPoolRequest#builder()}
     * </p>
     *
     * @param createCoipPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest.Builder} to create a request.
     * @return Result of the CreateCoipPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCoipPoolResponse createCoipPool(Consumer<CreateCoipPoolRequest.Builder> createCoipPoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createCoipPool(CreateCoipPoolRequest.builder().applyMutation(createCoipPoolRequest).build());
    }

    /**
     * <p>
     * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is
     * the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     *
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @return Result of the CreateCustomerGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCustomerGatewayResponse createCustomerGateway(CreateCustomerGatewayRequest createCustomerGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is
     * the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomerGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param createCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest.Builder} to create a
     *        request. Contains the parameters for CreateCustomerGateway.
     * @return Result of the CreateCustomerGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCustomerGatewayResponse createCustomerGateway(
            Consumer<CreateCustomerGatewayRequest.Builder> createCustomerGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createCustomerGateway(CreateCustomerGatewayRequest.builder().applyMutation(createCustomerGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/work-with-default-vpc.html#create-default-subnet">Create a
     * default subnet</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createDefaultSubnetRequest
     * @return Result of the CreateDefaultSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDefaultSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDefaultSubnetResponse createDefaultSubnet(CreateDefaultSubnetRequest createDefaultSubnetRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/work-with-default-vpc.html#create-default-subnet">Create a
     * default subnet</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDefaultSubnetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDefaultSubnetRequest#builder()}
     * </p>
     *
     * @param createDefaultSubnetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest.Builder} to create a request.
     * @return Result of the CreateDefaultSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDefaultSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDefaultSubnetResponse createDefaultSubnet(
            Consumer<CreateDefaultSubnetRequest.Builder> createDefaultSubnetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createDefaultSubnet(CreateDefaultSubnetRequest.builder().applyMutation(createDefaultSubnetRequest).build());
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC
     * User Guide</i>. You cannot specify the components of the default VPC yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     *
     * @param createDefaultVpcRequest
     * @return Result of the CreateDefaultVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDefaultVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDefaultVpcResponse createDefaultVpc(CreateDefaultVpcRequest createDefaultVpcRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC
     * User Guide</i>. You cannot specify the components of the default VPC yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDefaultVpcRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDefaultVpcRequest#builder()}
     * </p>
     *
     * @param createDefaultVpcRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateDefaultVpcRequest.Builder} to create a request.
     * @return Result of the CreateDefaultVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDefaultVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDefaultVpcResponse createDefaultVpc(Consumer<CreateDefaultVpcRequest.Builder> createDefaultVpcRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createDefaultVpc(CreateDefaultVpcRequest.builder().applyMutation(createDefaultVpcRequest).build());
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC
     * User Guide</i>. You cannot specify the components of the default VPC yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     *
     * @return Result of the CreateDefaultVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDefaultVpc
     * @see #createDefaultVpc(CreateDefaultVpcRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDefaultVpcResponse createDefaultVpc() throws AwsServiceException, SdkClientException, Ec2Exception {
        return createDefaultVpc(CreateDefaultVpcRequest.builder().build());
    }

    /**
     * <p>
     * Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you
     * associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP
     * options.
     * </p>
     * <p>
     * The following are the individual DHCP options you can specify. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in any other Region, specify
     * <code>region.compute.internal</code>. Otherwise, specify a custom domain name. This value is used to complete
     * unqualified DNS hostnames.
     * </p>
     * <p>
     * Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux
     * operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP option
     * set is associated with a VPC that has instances running operating systems that treat the value as a single
     * domain, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four DNS servers, or AmazonProvidedDNS. To specify
     * multiple domain name servers in a single parameter, separate the IP addresses using commas. To have your
     * instances receive custom DNS hostnames as specified in <code>domain-name</code>, you must specify a custom DNS
     * server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to eight Network Time Protocol (NTP) servers (four IPv4
     * addresses and four IPv6 addresses).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2.
     * Broadcast and multicast are not supported. For more information about NetBIOS node types, see <a
     * href="https://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-address-preferred-lease-time</code> - A value (in seconds, minutes, hours, or years) for how
     * frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values
     * are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time
     * is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid
     * frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDhcpOptionsRequest
     * @return Result of the CreateDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDhcpOptionsResponse createDhcpOptions(CreateDhcpOptionsRequest createDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you
     * associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP
     * options.
     * </p>
     * <p>
     * The following are the individual DHCP options you can specify. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in any other Region, specify
     * <code>region.compute.internal</code>. Otherwise, specify a custom domain name. This value is used to complete
     * unqualified DNS hostnames.
     * </p>
     * <p>
     * Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux
     * operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP option
     * set is associated with a VPC that has instances running operating systems that treat the value as a single
     * domain, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four DNS servers, or AmazonProvidedDNS. To specify
     * multiple domain name servers in a single parameter, separate the IP addresses using commas. To have your
     * instances receive custom DNS hostnames as specified in <code>domain-name</code>, you must specify a custom DNS
     * server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to eight Network Time Protocol (NTP) servers (four IPv4
     * addresses and four IPv6 addresses).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2.
     * Broadcast and multicast are not supported. For more information about NetBIOS node types, see <a
     * href="https://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-address-preferred-lease-time</code> - A value (in seconds, minutes, hours, or years) for how
     * frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values
     * are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time
     * is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid
     * frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDhcpOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDhcpOptionsRequest#builder()}
     * </p>
     *
     * @param createDhcpOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest.Builder} to create a request.
     * @return Result of the CreateDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDhcpOptionsResponse createDhcpOptions(Consumer<CreateDhcpOptionsRequest.Builder> createDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createDhcpOptions(CreateDhcpOptionsRequest.builder().applyMutation(createDhcpOptionsRequest).build());
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     * @return Result of the CreateEgressOnlyInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEgressOnlyInternetGatewayResponse createEgressOnlyInternetGateway(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEgressOnlyInternetGatewayRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEgressOnlyInternetGatewayRequest#builder()}
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest.Builder} to create
     *        a request.
     * @return Result of the CreateEgressOnlyInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEgressOnlyInternetGatewayResponse createEgressOnlyInternetGateway(
            Consumer<CreateEgressOnlyInternetGatewayRequest.Builder> createEgressOnlyInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createEgressOnlyInternetGateway(CreateEgressOnlyInternetGatewayRequest.builder()
                .applyMutation(createEgressOnlyInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances.
     * Instances are launched immediately if there is available capacity.
     * </p>
     * <p>
     * A single EC2 Fleet can include multiple launch specifications that vary by instance type, AMI, Availability Zone,
     * or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances.
     * Instances are launched immediately if there is available capacity.
     * </p>
     * <p>
     * A single EC2 Fleet can include multiple launch specifications that vary by instance type, AMI, Availability Zone,
     * or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateFleetRequest.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-log-records.html">Flow log records</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createFlowLogsRequest
     * @return Result of the CreateFlowLogs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlowLogsResponse createFlowLogs(CreateFlowLogsRequest createFlowLogsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-log-records.html">Flow log records</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowLogsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFlowLogsRequest#builder()}
     * </p>
     *
     * @param createFlowLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest.Builder} to create a request.
     * @return Result of the CreateFlowLogs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFlowLogsResponse createFlowLogs(Consumer<CreateFlowLogsRequest.Builder> createFlowLogsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createFlowLogs(CreateFlowLogsRequest.builder().applyMutation(createFlowLogsRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     *
     * @param createFpgaImageRequest
     * @return Result of the CreateFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFpgaImageResponse createFpgaImage(CreateFpgaImageRequest createFpgaImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFpgaImageRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFpgaImageRequest#builder()}
     * </p>
     *
     * @param createFpgaImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest.Builder} to create a request.
     * @return Result of the CreateFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFpgaImageResponse createFpgaImage(Consumer<CreateFpgaImageRequest.Builder> createFpgaImageRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createFpgaImage(CreateFpgaImageRequest.builder().applyMutation(createFpgaImageRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Create an Amazon EBS-backed
     * Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createImageRequest
     * @return Result of the CreateImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImageResponse createImage(CreateImageRequest createImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Create an Amazon EBS-backed
     * Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateImageRequest#builder()}
     * </p>
     *
     * @param createImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateImageRequest.Builder} to create a request.
     * @return Result of the CreateImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateImageResponse createImage(Consumer<CreateImageRequest.Builder> createImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createImage(CreateImageRequest.builder().applyMutation(createImageRequest).build());
    }

    /**
     * <p>
     * Creates an EC2 Instance Connect Endpoint.
     * </p>
     * <p>
     * An EC2 Instance Connect Endpoint allows you to connect to an instance, without requiring the instance to have a
     * public IPv4 address. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html"
     * >Connect to your instances without requiring a public IPv4 address using EC2 Instance Connect Endpoint</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createInstanceConnectEndpointRequest
     * @return Result of the CreateInstanceConnectEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceConnectEndpointResponse createInstanceConnectEndpoint(
            CreateInstanceConnectEndpointRequest createInstanceConnectEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EC2 Instance Connect Endpoint.
     * </p>
     * <p>
     * An EC2 Instance Connect Endpoint allows you to connect to an instance, without requiring the instance to have a
     * public IPv4 address. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html"
     * >Connect to your instances without requiring a public IPv4 address using EC2 Instance Connect Endpoint</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceConnectEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link CreateInstanceConnectEndpointRequest#builder()}
     * </p>
     *
     * @param createInstanceConnectEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInstanceConnectEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInstanceConnectEndpointResponse createInstanceConnectEndpoint(
            Consumer<CreateInstanceConnectEndpointRequest.Builder> createInstanceConnectEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createInstanceConnectEndpoint(CreateInstanceConnectEndpointRequest.builder()
                .applyMutation(createInstanceConnectEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createInstanceEventWindowRequest
     * @return Result of the CreateInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInstanceEventWindowResponse createInstanceEventWindow(
            CreateInstanceEventWindowRequest createInstanceEventWindowRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceEventWindowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInstanceEventWindowRequest#builder()}
     * </p>
     *
     * @param createInstanceEventWindowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInstanceEventWindowResponse createInstanceEventWindow(
            Consumer<CreateInstanceEventWindowRequest.Builder> createInstanceEventWindowRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createInstanceEventWindow(CreateInstanceEventWindowRequest.builder()
                .applyMutation(createInstanceEventWindowRequest).build());
    }

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the prerequisites for your Amazon S3 bucket, supported operating systems, image formats,
     * and known limitations for the types of instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     *
     * @param createInstanceExportTaskRequest
     * @return Result of the CreateInstanceExportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInstanceExportTaskResponse createInstanceExportTask(
            CreateInstanceExportTaskRequest createInstanceExportTaskRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the prerequisites for your Amazon S3 bucket, supported operating systems, image formats,
     * and known limitations for the types of instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceExportTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInstanceExportTaskRequest#builder()}
     * </p>
     *
     * @param createInstanceExportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInstanceExportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInstanceExportTaskResponse createInstanceExportTask(
            Consumer<CreateInstanceExportTaskRequest.Builder> createInstanceExportTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createInstanceExportTask(CreateInstanceExportTaskRequest.builder().applyMutation(createInstanceExportTaskRequest)
                .build());
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createInternetGatewayRequest
     * @return Result of the CreateInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInternetGatewayResponse createInternetGateway(CreateInternetGatewayRequest createInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInternetGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInternetGatewayRequest#builder()}
     * </p>
     *
     * @param createInternetGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInternetGatewayResponse createInternetGateway(
            Consumer<CreateInternetGatewayRequest.Builder> createInternetGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createInternetGateway(CreateInternetGatewayRequest.builder().applyMutation(createInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @return Result of the CreateInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInternetGateway
     * @see #createInternetGateway(CreateInternetGatewayRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInternetGatewayResponse createInternetGateway() throws AwsServiceException, SdkClientException, Ec2Exception {
        return createInternetGateway(CreateInternetGatewayRequest.builder().build());
    }

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamRequest
     * @return Result of the CreateIpam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpamResponse createIpam(CreateIpamRequest createIpamRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpamRequest#builder()}
     * </p>
     *
     * @param createIpamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateIpamRequest.Builder} to create a request.
     * @return Result of the CreateIpam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpamResponse createIpam(Consumer<CreateIpamRequest.Builder> createIpamRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createIpam(CreateIpamRequest.builder().applyMutation(createIpamRequest).build());
    }

    /**
     * <p>
     * Create a verification token. A verification token is an Amazon Web Services-generated random value that you can
     * use to prove ownership of an external resource. For example, you can use a verification token to validate that
     * you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
     * </p>
     *
     * @param createIpamExternalResourceVerificationTokenRequest
     * @return Result of the CreateIpamExternalResourceVerificationToken operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamExternalResourceVerificationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamExternalResourceVerificationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIpamExternalResourceVerificationTokenResponse createIpamExternalResourceVerificationToken(
            CreateIpamExternalResourceVerificationTokenRequest createIpamExternalResourceVerificationTokenRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a verification token. A verification token is an Amazon Web Services-generated random value that you can
     * use to prove ownership of an external resource. For example, you can use a verification token to validate that
     * you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateIpamExternalResourceVerificationTokenRequest.Builder} avoiding the need to create one manually via
     * {@link CreateIpamExternalResourceVerificationTokenRequest#builder()}
     * </p>
     *
     * @param createIpamExternalResourceVerificationTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateIpamExternalResourceVerificationTokenRequest.Builder}
     *        to create a request.
     * @return Result of the CreateIpamExternalResourceVerificationToken operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamExternalResourceVerificationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamExternalResourceVerificationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIpamExternalResourceVerificationTokenResponse createIpamExternalResourceVerificationToken(
            Consumer<CreateIpamExternalResourceVerificationTokenRequest.Builder> createIpamExternalResourceVerificationTokenRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createIpamExternalResourceVerificationToken(CreateIpamExternalResourceVerificationTokenRequest.builder()
                .applyMutation(createIpamExternalResourceVerificationTokenRequest).build());
    }

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a
     * top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamPoolRequest
     * @return Result of the CreateIpamPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpamPoolResponse createIpamPool(CreateIpamPoolRequest createIpamPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a
     * top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpamPoolRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIpamPoolRequest#builder()}
     * </p>
     *
     * @param createIpamPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest.Builder} to create a request.
     * @return Result of the CreateIpamPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpamPoolResponse createIpamPool(Consumer<CreateIpamPoolRequest.Builder> createIpamPoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createIpamPool(CreateIpamPoolRequest.builder().applyMutation(createIpamPoolRequest).build());
    }

    /**
     * <p>
     * Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     *
     * @param createIpamResourceDiscoveryRequest
     * @return Result of the CreateIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIpamResourceDiscoveryResponse createIpamResourceDiscovery(
            CreateIpamResourceDiscoveryRequest createIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpamResourceDiscoveryRequest.Builder}
     * avoiding the need to create one manually via {@link CreateIpamResourceDiscoveryRequest#builder()}
     * </p>
     *
     * @param createIpamResourceDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIpamResourceDiscoveryResponse createIpamResourceDiscovery(
            Consumer<CreateIpamResourceDiscoveryRequest.Builder> createIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createIpamResourceDiscovery(CreateIpamResourceDiscoveryRequest.builder()
                .applyMutation(createIpamResourceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamScopeRequest
     * @return Result of the CreateIpamScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpamScopeResponse createIpamScope(CreateIpamScopeRequest createIpamScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpamScopeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIpamScopeRequest#builder()}
     * </p>
     *
     * @param createIpamScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateIpamScopeRequest.Builder} to create a request.
     * @return Result of the CreateIpamScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIpamScopeResponse createIpamScope(Consumer<CreateIpamScopeRequest.Builder> createIpamScopeRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createIpamScope(CreateIpamScopeRequest.builder().applyMutation(createIpamScopeRequest).build());
    }

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified format. Amazon EC2
     * stores the public key and displays the private key for you to save to a file. The private key is returned as an
     * unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use with PuTTY. If a
     * key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return Result of the CreateKeyPair operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKeyPairResponse createKeyPair(CreateKeyPairRequest createKeyPairRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified format. Amazon EC2
     * stores the public key and displays the private key for you to save to a file. The private key is returned as an
     * unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use with PuTTY. If a
     * key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKeyPairRequest#builder()}
     * </p>
     *
     * @param createKeyPairRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest.Builder} to create a request.
     * @return Result of the CreateKeyPair operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateKeyPairResponse createKeyPair(Consumer<CreateKeyPairRequest.Builder> createKeyPairRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createKeyPair(CreateKeyPairRequest.builder().applyMutation(createKeyPairRequest).build());
    }

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a
     * launch template</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * To clone an existing launch template as the basis for a new launch template, use the Amazon EC2 console. The API,
     * SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateRequest
     * @return Result of the CreateLaunchTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLaunchTemplateResponse createLaunchTemplate(CreateLaunchTemplateRequest createLaunchTemplateRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a
     * launch template</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * To clone an existing launch template as the basis for a new launch template, use the Amazon EC2 console. The API,
     * SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLaunchTemplateRequest#builder()}
     * </p>
     *
     * @param createLaunchTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest.Builder} to create a request.
     * @return Result of the CreateLaunchTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLaunchTemplateResponse createLaunchTemplate(
            Consumer<CreateLaunchTemplateRequest.Builder> createLaunchTemplateRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createLaunchTemplate(CreateLaunchTemplateRequest.builder().applyMutation(createLaunchTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new version of a launch template. You must specify an existing launch template, either by name or ID.
     * You can determine whether the new version inherits parameters from a source version, and add or overwrite
     * parameters as needed.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You can't specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create
     * a new version of the launch template that includes the changes that you require.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Modify a launch template (manage launch template versions)</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateVersionRequest
     * @return Result of the CreateLaunchTemplateVersion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLaunchTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchTemplateVersionResponse createLaunchTemplateVersion(
            CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of a launch template. You must specify an existing launch template, either by name or ID.
     * You can determine whether the new version inherits parameters from a source version, and add or overwrite
     * parameters as needed.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You can't specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create
     * a new version of the launch template that includes the changes that you require.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Modify a launch template (manage launch template versions)</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLaunchTemplateVersionRequest#builder()}
     * </p>
     *
     * @param createLaunchTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLaunchTemplateVersion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLaunchTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchTemplateVersionResponse createLaunchTemplateVersion(
            Consumer<CreateLaunchTemplateVersionRequest.Builder> createLaunchTemplateVersionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createLaunchTemplateVersion(CreateLaunchTemplateVersionRequest.builder()
                .applyMutation(createLaunchTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Creates a static route for the specified local gateway route table. You must specify one of the following
     * targets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LocalGatewayVirtualInterfaceGroupId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetworkInterfaceId</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param createLocalGatewayRouteRequest
     * @return Result of the CreateLocalGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocalGatewayRouteResponse createLocalGatewayRoute(CreateLocalGatewayRouteRequest createLocalGatewayRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a static route for the specified local gateway route table. You must specify one of the following
     * targets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LocalGatewayVirtualInterfaceGroupId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetworkInterfaceId</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocalGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link CreateLocalGatewayRouteRequest#builder()}
     * </p>
     *
     * @param createLocalGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocalGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateLocalGatewayRouteResponse createLocalGatewayRoute(
            Consumer<CreateLocalGatewayRouteRequest.Builder> createLocalGatewayRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createLocalGatewayRoute(CreateLocalGatewayRouteRequest.builder().applyMutation(createLocalGatewayRouteRequest)
                .build());
    }

    /**
     * <p>
     * Creates a local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableRequest
     * @return Result of the CreateLocalGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocalGatewayRouteTableResponse createLocalGatewayRouteTable(
            CreateLocalGatewayRouteTableRequest createLocalGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocalGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLocalGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param createLocalGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLocalGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocalGatewayRouteTableResponse createLocalGatewayRouteTable(
            Consumer<CreateLocalGatewayRouteTableRequest.Builder> createLocalGatewayRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createLocalGatewayRouteTable(CreateLocalGatewayRouteTableRequest.builder()
                .applyMutation(createLocalGatewayRouteTableRequest).build());
    }

    /**
     * <p>
     * Creates a local gateway route table virtual interface group association.
     * </p>
     *
     * @param createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return Result of the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation returned by the
     *         service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse createLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a local gateway route table virtual interface group association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.Builder} avoiding the need to create
     * one manually via {@link CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest#builder()}
     * </p>
     *
     * @param createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation returned by the
     *         service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse createLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            Consumer<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.Builder> createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createLocalGatewayRouteTableVirtualInterfaceGroupAssociation(CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
                .builder().applyMutation(createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest).build());
    }

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     * @return Result of the CreateLocalGatewayRouteTableVpcAssociation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocalGatewayRouteTableVpcAssociationResponse createLocalGatewayRouteTableVpcAssociation(
            CreateLocalGatewayRouteTableVpcAssociationRequest createLocalGatewayRouteTableVpcAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateLocalGatewayRouteTableVpcAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateLocalGatewayRouteTableVpcAssociationRequest#builder()}
     * </p>
     *
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateLocalGatewayRouteTableVpcAssociation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLocalGatewayRouteTableVpcAssociationResponse createLocalGatewayRouteTableVpcAssociation(
            Consumer<CreateLocalGatewayRouteTableVpcAssociationRequest.Builder> createLocalGatewayRouteTableVpcAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createLocalGatewayRouteTableVpcAssociation(CreateLocalGatewayRouteTableVpcAssociationRequest.builder()
                .applyMutation(createLocalGatewayRouteTableVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a
     * CIDR block and an optional description.
     * </p>
     *
     * @param createManagedPrefixListRequest
     * @return Result of the CreateManagedPrefixList operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateManagedPrefixListResponse createManagedPrefixList(CreateManagedPrefixListRequest createManagedPrefixListRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a
     * CIDR block and an optional description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateManagedPrefixListRequest.Builder} avoiding
     * the need to create one manually via {@link CreateManagedPrefixListRequest#builder()}
     * </p>
     *
     * @param createManagedPrefixListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest.Builder} to create a
     *        request.
     * @return Result of the CreateManagedPrefixList operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateManagedPrefixListResponse createManagedPrefixList(
            Consumer<CreateManagedPrefixListRequest.Builder> createManagedPrefixListRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createManagedPrefixList(CreateManagedPrefixListRequest.builder().applyMutation(createManagedPrefixListRequest)
                .build());
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you create a public NAT gateway and assign it an EIP or secondary EIPs, the network border group of the EIPs
     * must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not
     * the same, the NAT gateway will fail to launch. You can see the network border group for the subnet's AZ by
     * viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the
     * details of the EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html">Allocate an Elastic IP address</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     *
     * @param createNatGatewayRequest
     * @return Result of the CreateNatGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNatGatewayResponse createNatGateway(CreateNatGatewayRequest createNatGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you create a public NAT gateway and assign it an EIP or secondary EIPs, the network border group of the EIPs
     * must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not
     * the same, the NAT gateway will fail to launch. You can see the network border group for the subnet's AZ by
     * viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the
     * details of the EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html">Allocate an Elastic IP address</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNatGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNatGatewayRequest#builder()}
     * </p>
     *
     * @param createNatGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest.Builder} to create a request.
     * @return Result of the CreateNatGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNatGatewayResponse createNatGateway(Consumer<CreateNatGatewayRequest.Builder> createNatGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createNatGateway(CreateNatGatewayRequest.builder().applyMutation(createNatGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createNetworkAclRequest
     * @return Result of the CreateNetworkAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNetworkAclResponse createNetworkAcl(CreateNetworkAclRequest createNetworkAclRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkAclRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNetworkAclRequest#builder()}
     * </p>
     *
     * @param createNetworkAclRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateNetworkAclRequest.Builder} to create a request.
     * @return Result of the CreateNetworkAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNetworkAclResponse createNetworkAcl(Consumer<CreateNetworkAclRequest.Builder> createNetworkAclRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createNetworkAcl(CreateNetworkAclRequest.builder().applyMutation(createNetworkAclRequest).build());
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createNetworkAclEntryRequest
     * @return Result of the CreateNetworkAclEntry operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNetworkAclEntryResponse createNetworkAclEntry(CreateNetworkAclEntryRequest createNetworkAclEntryRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkAclEntryRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkAclEntryRequest#builder()}
     * </p>
     *
     * @param createNetworkAclEntryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNetworkAclEntry operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNetworkAclEntryResponse createNetworkAclEntry(
            Consumer<CreateNetworkAclEntryRequest.Builder> createNetworkAclEntryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createNetworkAclEntry(CreateNetworkAclEntryRequest.builder().applyMutation(createNetworkAclEntryRequest).build());
    }

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     *
     * @param createNetworkInsightsAccessScopeRequest
     * @return Result of the CreateNetworkInsightsAccessScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkInsightsAccessScopeResponse createNetworkInsightsAccessScope(
            CreateNetworkInsightsAccessScopeRequest createNetworkInsightsAccessScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInsightsAccessScopeRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNetworkInsightsAccessScopeRequest#builder()}
     * </p>
     *
     * @param createNetworkInsightsAccessScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest.Builder} to
     *        create a request.
     * @return Result of the CreateNetworkInsightsAccessScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkInsightsAccessScopeResponse createNetworkInsightsAccessScope(
            Consumer<CreateNetworkInsightsAccessScopeRequest.Builder> createNetworkInsightsAccessScopeRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createNetworkInsightsAccessScope(CreateNetworkInsightsAccessScopeRequest.builder()
                .applyMutation(createNetworkInsightsAccessScopeRequest).build());
    }

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">Reachability Analyzer Guide</a>.
     * </p>
     *
     * @param createNetworkInsightsPathRequest
     * @return Result of the CreateNetworkInsightsPath operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNetworkInsightsPathResponse createNetworkInsightsPath(
            CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">Reachability Analyzer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInsightsPathRequest.Builder} avoiding
     * the need to create one manually via {@link CreateNetworkInsightsPathRequest#builder()}
     * </p>
     *
     * @param createNetworkInsightsPathRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNetworkInsightsPath operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNetworkInsightsPathResponse createNetworkInsightsPath(
            Consumer<CreateNetworkInsightsPathRequest.Builder> createNetworkInsightsPathRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createNetworkInsightsPath(CreateNetworkInsightsPathRequest.builder()
                .applyMutation(createNetworkInsightsPathRequest).build());
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * The number of IP addresses you can assign to a network interface varies by instance type.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createNetworkInterfaceRequest
     * @return Result of the CreateNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNetworkInterfaceResponse createNetworkInterface(CreateNetworkInterfaceRequest createNetworkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * The number of IP addresses you can assign to a network interface varies by instance type.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param createNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateNetworkInterfaceResponse createNetworkInterface(
            Consumer<CreateNetworkInterfaceRequest.Builder> createNetworkInterfaceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createNetworkInterface(CreateNetworkInterfaceRequest.builder().applyMutation(createNetworkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @return Result of the CreateNetworkInterfacePermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkInterfacePermissionResponse createNetworkInterfacePermission(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkInterfacePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNetworkInterfacePermissionRequest#builder()}
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest.Builder} to
     *        create a request. Contains the parameters for CreateNetworkInterfacePermission.
     * @return Result of the CreateNetworkInterfacePermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkInterfacePermissionResponse createNetworkInterfacePermission(
            Consumer<CreateNetworkInterfacePermissionRequest.Builder> createNetworkInterfacePermissionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createNetworkInterfacePermission(CreateNetworkInterfacePermissionRequest.builder()
                .applyMutation(createNetworkInterfacePermissionRequest).build());
    }

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createPlacementGroupRequest
     * @return Result of the CreatePlacementGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreatePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePlacementGroupResponse createPlacementGroup(CreatePlacementGroupRequest createPlacementGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlacementGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlacementGroupRequest#builder()}
     * </p>
     *
     * @param createPlacementGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest.Builder} to create a request.
     * @return Result of the CreatePlacementGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreatePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePlacementGroupResponse createPlacementGroup(
            Consumer<CreatePlacementGroupRequest.Builder> createPlacementGroupRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createPlacementGroup(CreatePlacementGroupRequest.builder().applyMutation(createPlacementGroupRequest).build());
    }

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     *
     * @param createPublicIpv4PoolRequest
     * @return Result of the CreatePublicIpv4Pool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreatePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePublicIpv4PoolResponse createPublicIpv4Pool(CreatePublicIpv4PoolRequest createPublicIpv4PoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublicIpv4PoolRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePublicIpv4PoolRequest#builder()}
     * </p>
     *
     * @param createPublicIpv4PoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest.Builder} to create a request.
     * @return Result of the CreatePublicIpv4Pool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreatePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePublicIpv4PoolResponse createPublicIpv4Pool(
            Consumer<CreatePublicIpv4PoolRequest.Builder> createPublicIpv4PoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createPublicIpv4Pool(CreatePublicIpv4PoolRequest.builder().applyMutation(createPublicIpv4PoolRequest).build());
    }

    /**
     * <p>
     * Replaces the EBS-backed root volume for a <code>running</code> instance with a new volume that is restored to the
     * original root volume's launch state, that is restored to a specific snapshot taken from the original root volume,
     * or that is restored from an AMI that has the same key characteristics as that of the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace
     * a root volume</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createReplaceRootVolumeTaskRequest
     * @return Result of the CreateReplaceRootVolumeTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateReplaceRootVolumeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplaceRootVolumeTaskResponse createReplaceRootVolumeTask(
            CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the EBS-backed root volume for a <code>running</code> instance with a new volume that is restored to the
     * original root volume's launch state, that is restored to a specific snapshot taken from the original root volume,
     * or that is restored from an AMI that has the same key characteristics as that of the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace
     * a root volume</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplaceRootVolumeTaskRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReplaceRootVolumeTaskRequest#builder()}
     * </p>
     *
     * @param createReplaceRootVolumeTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CreateReplaceRootVolumeTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateReplaceRootVolumeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplaceRootVolumeTaskResponse createReplaceRootVolumeTask(
            Consumer<CreateReplaceRootVolumeTaskRequest.Builder> createReplaceRootVolumeTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createReplaceRootVolumeTask(CreateReplaceRootVolumeTaskRequest.builder()
                .applyMutation(createReplaceRootVolumeTaskRequest).build());
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @return Result of the CreateReservedInstancesListing operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReservedInstancesListingResponse createReservedInstancesListing(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReservedInstancesListingRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReservedInstancesListingRequest#builder()}
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest.Builder} to create
     *        a request. Contains the parameters for CreateReservedInstancesListing.
     * @return Result of the CreateReservedInstancesListing operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReservedInstancesListingResponse createReservedInstancesListing(
            Consumer<CreateReservedInstancesListingRequest.Builder> createReservedInstancesListingRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createReservedInstancesListing(CreateReservedInstancesListingRequest.builder()
                .applyMutation(createReservedInstancesListingRequest).build());
    }

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createRestoreImageTaskRequest
     * @return Result of the CreateRestoreImageTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRestoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRestoreImageTaskResponse createRestoreImageTask(CreateRestoreImageTaskRequest createRestoreImageTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRestoreImageTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRestoreImageTaskRequest#builder()}
     * </p>
     *
     * @param createRestoreImageTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRestoreImageTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRestoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRestoreImageTaskResponse createRestoreImageTask(
            Consumer<CreateRestoreImageTaskRequest.Builder> createRestoreImageTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createRestoreImageTask(CreateRestoreImageTaskRequest.builder().applyMutation(createRestoreImageTaskRequest)
                .build());
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the
     * resources from the parameter list.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createRouteRequest
     * @return Result of the CreateRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRouteResponse createRoute(CreateRouteRequest createRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the
     * resources from the parameter list.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRouteRequest#builder()}
     * </p>
     *
     * @param createRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateRouteRequest.Builder} to create a request.
     * @return Result of the CreateRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRouteResponse createRoute(Consumer<CreateRouteRequest.Builder> createRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createRoute(CreateRouteRequest.builder().applyMutation(createRouteRequest).build());
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createRouteTableRequest
     * @return Result of the CreateRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRouteTableResponse createRouteTable(CreateRouteTableRequest createRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRouteTableRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRouteTableRequest#builder()}
     * </p>
     *
     * @param createRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest.Builder} to create a request.
     * @return Result of the CreateRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRouteTableResponse createRouteTable(Consumer<CreateRouteTableRequest.Builder> createRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createRouteTable(CreateRouteTableRequest.builder().applyMutation(createRouteTableRequest).build());
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon EC2 User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can't have two security groups
     * for the same VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in your VPC. If you don't specify a security group when you launch an
     * instance, the instance is launched into the appropriate default security group. A default security group includes
     * a default rule that grants instances unrestricted network access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     *
     * @param createSecurityGroupRequest
     * @return Result of the CreateSecurityGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSecurityGroupResponse createSecurityGroup(CreateSecurityGroupRequest createSecurityGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon EC2 User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can't have two security groups
     * for the same VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in your VPC. If you don't specify a security group when you launch an
     * instance, the instance is launched into the appropriate default security group. A default security group includes
     * a default rule that grants instances unrestricted network access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest.Builder} to create a request.
     * @return Result of the CreateSecurityGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSecurityGroupResponse createSecurityGroup(
            Consumer<CreateSecurityGroupRequest.Builder> createSecurityGroupRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createSecurityGroup(CreateSecurityGroupRequest.builder().applyMutation(createSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * The location of the source EBS volume determines where you can create the snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source volume is in a Region, you must create the snapshot in the same Region as the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source volume is in a Local Zone, you can create the snapshot in the same Local Zone or in parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source volume is on an Outpost, you can create the snapshot on the same Outpost or in its parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * When you create a snapshot for an EBS volume that serves as a root device, we recommend that you stop the
     * instance before taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected. For more information, <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * The location of the source EBS volume determines where you can create the snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source volume is in a Region, you must create the snapshot in the same Region as the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source volume is in a Local Zone, you can create the snapshot in the same Local Zone or in parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source volume is on an Outpost, you can create the snapshot on the same Outpost or in its parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * When you create a snapshot for an EBS volume that serves as a root device, we recommend that you stop the
     * instance before taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected. For more information, <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest.Builder} to create a request.
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes attached to an Amazon EC2 instance. Volumes are chosen
     * by specifying an instance. Each volume attached to the specified instance will produce one snapshot that is
     * crash-consistent across the instance. You can include all of the volumes currently attached to the instance, or
     * you can exclude the root volume or specific data (non-root) volumes from the multi-volume snapshot set.
     * </p>
     * <p>
     * The location of the source instance determines where you can create the snapshots.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source instance is in a Region, you must create the snapshots in the same Region as the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source instance is in a Local Zone, you can create the snapshots in the same Local Zone or in parent
     * Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source instance is on an Outpost, you can create the snapshots on the same Outpost or in its parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * </ul>
     *
     * @param createSnapshotsRequest
     * @return Result of the CreateSnapshots operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotsResponse createSnapshots(CreateSnapshotsRequest createSnapshotsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes attached to an Amazon EC2 instance. Volumes are chosen
     * by specifying an instance. Each volume attached to the specified instance will produce one snapshot that is
     * crash-consistent across the instance. You can include all of the volumes currently attached to the instance, or
     * you can exclude the root volume or specific data (non-root) volumes from the multi-volume snapshot set.
     * </p>
     * <p>
     * The location of the source instance determines where you can create the snapshots.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source instance is in a Region, you must create the snapshots in the same Region as the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source instance is in a Local Zone, you can create the snapshots in the same Local Zone or in parent
     * Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source instance is on an Outpost, you can create the snapshots on the same Outpost or in its parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSnapshotsRequest#builder()}
     * </p>
     *
     * @param createSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest.Builder} to create a request.
     * @return Result of the CreateSnapshots operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotsResponse createSnapshots(Consumer<CreateSnapshotsRequest.Builder> createSnapshotsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createSnapshots(CreateSnapshotsRequest.builder().applyMutation(createSnapshotsRequest).build());
    }

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @return Result of the CreateSpotDatafeedSubscription operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSpotDatafeedSubscriptionResponse createSpotDatafeedSubscription(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSpotDatafeedSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSpotDatafeedSubscriptionRequest#builder()}
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest.Builder} to create
     *        a request. Contains the parameters for CreateSpotDatafeedSubscription.
     * @return Result of the CreateSpotDatafeedSubscription operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSpotDatafeedSubscriptionResponse createSpotDatafeedSubscription(
            Consumer<CreateSpotDatafeedSubscriptionRequest.Builder> createSpotDatafeedSubscriptionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createSpotDatafeedSubscription(CreateSpotDatafeedSubscriptionRequest.builder()
                .applyMutation(createSpotDatafeedSubscriptionRequest).build());
    }

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createStoreImageTaskRequest
     * @return Result of the CreateStoreImageTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateStoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStoreImageTaskResponse createStoreImageTask(CreateStoreImageTaskRequest createStoreImageTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStoreImageTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStoreImageTaskRequest#builder()}
     * </p>
     *
     * @param createStoreImageTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest.Builder} to create a request.
     * @return Result of the CreateStoreImageTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateStoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStoreImageTaskResponse createStoreImageTask(
            Consumer<CreateStoreImageTaskRequest.Builder> createStoreImageTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createStoreImageTask(CreateStoreImageTaskRequest.builder().applyMutation(createStoreImageTaskRequest).build());
    }

    /**
     * <p>
     * Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an
     * IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet,
     * specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.
     * </p>
     * <p>
     * A subnet CIDR block must not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet,
     * you can't change its CIDR block.
     * </p>
     * <p>
     * The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses) and a /16 netmask (65,536 IP
     * addresses). Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for your use.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can associate an IPv6 CIDR block with a subnet when
     * you create it.
     * </p>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     *
     * @param createSubnetRequest
     * @return Result of the CreateSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubnetResponse createSubnet(CreateSubnetRequest createSubnetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an
     * IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet,
     * specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.
     * </p>
     * <p>
     * A subnet CIDR block must not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet,
     * you can't change its CIDR block.
     * </p>
     * <p>
     * The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses) and a /16 netmask (65,536 IP
     * addresses). Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for your use.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can associate an IPv6 CIDR block with a subnet when
     * you create it.
     * </p>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubnetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSubnetRequest#builder()}
     * </p>
     *
     * @param createSubnetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateSubnetRequest.Builder} to create a request.
     * @return Result of the CreateSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubnetResponse createSubnet(Consumer<CreateSubnetRequest.Builder> createSubnetRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createSubnet(CreateSubnetRequest.builder().applyMutation(createSubnetRequest).build());
    }

    /**
     * <p>
     * Creates a subnet CIDR reservation. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon VPC User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-prefixes.html">Manage prefixes for your
     * network interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createSubnetCidrReservationRequest
     * @return Result of the CreateSubnetCidrReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubnetCidrReservationResponse createSubnetCidrReservation(
            CreateSubnetCidrReservationRequest createSubnetCidrReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subnet CIDR reservation. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon VPC User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-prefixes.html">Manage prefixes for your
     * network interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubnetCidrReservationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSubnetCidrReservationRequest#builder()}
     * </p>
     *
     * @param createSubnetCidrReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSubnetCidrReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSubnetCidrReservationResponse createSubnetCidrReservation(
            Consumer<CreateSubnetCidrReservationRequest.Builder> createSubnetCidrReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createSubnetCidrReservation(CreateSubnetCidrReservationRequest.builder()
                .applyMutation(createSubnetCidrReservationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * resource-level permissions for Amazon EC2 API actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * resource-level permissions for Amazon EC2 API actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTagsRequest.Builder} to create a request.
     * @return Result of the CreateTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     *
     * @param createTrafficMirrorFilterRequest
     * @return Result of the CreateTrafficMirrorFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrafficMirrorFilterResponse createTrafficMirrorFilter(
            CreateTrafficMirrorFilterRequest createTrafficMirrorFilterRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorFilterRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrafficMirrorFilterRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrafficMirrorFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrafficMirrorFilterResponse createTrafficMirrorFilter(
            Consumer<CreateTrafficMirrorFilterRequest.Builder> createTrafficMirrorFilterRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createTrafficMirrorFilter(CreateTrafficMirrorFilterRequest.builder()
                .applyMutation(createTrafficMirrorFilterRequest).build());
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     *
     * @param createTrafficMirrorFilterRuleRequest
     * @return Result of the CreateTrafficMirrorFilterRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficMirrorFilterRuleResponse createTrafficMirrorFilterRule(
            CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorFilterRuleRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTrafficMirrorFilterRuleRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorFilterRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrafficMirrorFilterRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficMirrorFilterRuleResponse createTrafficMirrorFilterRule(
            Consumer<CreateTrafficMirrorFilterRuleRequest.Builder> createTrafficMirrorFilterRuleRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTrafficMirrorFilterRule(CreateTrafficMirrorFilterRuleRequest.builder()
                .applyMutation(createTrafficMirrorFilterRuleRequest).build());
    }

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.html"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     *
     * @param createTrafficMirrorSessionRequest
     * @return Result of the CreateTrafficMirrorSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficMirrorSessionResponse createTrafficMirrorSession(
            CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.html"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorSessionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrafficMirrorSessionRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrafficMirrorSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficMirrorSessionResponse createTrafficMirrorSession(
            Consumer<CreateTrafficMirrorSessionRequest.Builder> createTrafficMirrorSessionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createTrafficMirrorSession(CreateTrafficMirrorSessionRequest.builder()
                .applyMutation(createTrafficMirrorSessionRequest).build());
    }

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     *
     * @param createTrafficMirrorTargetRequest
     * @return Result of the CreateTrafficMirrorTarget operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrafficMirrorTargetResponse createTrafficMirrorTarget(
            CreateTrafficMirrorTargetRequest createTrafficMirrorTargetRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficMirrorTargetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTrafficMirrorTargetRequest#builder()}
     * </p>
     *
     * @param createTrafficMirrorTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrafficMirrorTarget operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTrafficMirrorTargetResponse createTrafficMirrorTarget(
            Consumer<CreateTrafficMirrorTargetRequest.Builder> createTrafficMirrorTargetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createTrafficMirrorTarget(CreateTrafficMirrorTargetRequest.builder()
                .applyMutation(createTrafficMirrorTargetRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRequest
     * @return Result of the CreateTransitGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTransitGatewayResponse createTransitGateway(CreateTransitGatewayRequest createTransitGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTransitGatewayRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRequest.Builder} to create a request.
     * @return Result of the CreateTransitGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTransitGatewayResponse createTransitGateway(
            Consumer<CreateTransitGatewayRequest.Builder> createTransitGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createTransitGateway(CreateTransitGatewayRequest.builder().applyMutation(createTransitGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     *
     * @return Result of the CreateTransitGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGateway
     * @see #createTransitGateway(CreateTransitGatewayRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTransitGatewayResponse createTransitGateway() throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGateway(CreateTransitGatewayRequest.builder().build());
    }

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     *
     * @param createTransitGatewayConnectRequest
     * @return Result of the CreateTransitGatewayConnect operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayConnectResponse createTransitGatewayConnect(
            CreateTransitGatewayConnectRequest createTransitGatewayConnectRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayConnectRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayConnectRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTransitGatewayConnect operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayConnectResponse createTransitGatewayConnect(
            Consumer<CreateTransitGatewayConnectRequest.Builder> createTransitGatewayConnectRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createTransitGatewayConnect(CreateTransitGatewayConnectRequest.builder()
                .applyMutation(createTransitGatewayConnectRequest).build());
    }

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Amazon Web Services Transit Gateways Guide</i>.
     * </p>
     *
     * @param createTransitGatewayConnectPeerRequest
     * @return Result of the CreateTransitGatewayConnectPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayConnectPeerResponse createTransitGatewayConnectPeer(
            CreateTransitGatewayConnectPeerRequest createTransitGatewayConnectPeerRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Amazon Web Services Transit Gateways Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayConnectPeerRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest.Builder} to create
     *        a request.
     * @return Result of the CreateTransitGatewayConnectPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayConnectPeerResponse createTransitGatewayConnectPeer(
            Consumer<CreateTransitGatewayConnectPeerRequest.Builder> createTransitGatewayConnectPeerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayConnectPeer(CreateTransitGatewayConnectPeerRequest.builder()
                .applyMutation(createTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     *
     * @param createTransitGatewayMulticastDomainRequest
     * @return Result of the CreateTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayMulticastDomainResponse createTransitGatewayMulticastDomain(
            CreateTransitGatewayMulticastDomainRequest createTransitGatewayMulticastDomainRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayMulticastDomainRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayMulticastDomainRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayMulticastDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayMulticastDomainResponse createTransitGatewayMulticastDomain(
            Consumer<CreateTransitGatewayMulticastDomainRequest.Builder> createTransitGatewayMulticastDomainRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayMulticastDomain(CreateTransitGatewayMulticastDomainRequest.builder()
                .applyMutation(createTransitGatewayMulticastDomainRequest).build());
    }

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     *
     * @param createTransitGatewayPeeringAttachmentRequest
     * @return Result of the CreateTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPeeringAttachmentResponse createTransitGatewayPeeringAttachment(
            CreateTransitGatewayPeeringAttachmentRequest createTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTransitGatewayPeeringAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTransitGatewayPeeringAttachmentRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayPeeringAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPeeringAttachmentResponse createTransitGatewayPeeringAttachment(
            Consumer<CreateTransitGatewayPeeringAttachmentRequest.Builder> createTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayPeeringAttachment(CreateTransitGatewayPeeringAttachmentRequest.builder()
                .applyMutation(createTransitGatewayPeeringAttachmentRequest).build());
    }

    /**
     * <p>
     * Creates a transit gateway policy table.
     * </p>
     *
     * @param createTransitGatewayPolicyTableRequest
     * @return Result of the CreateTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPolicyTableResponse createTransitGatewayPolicyTable(
            CreateTransitGatewayPolicyTableRequest createTransitGatewayPolicyTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transit gateway policy table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayPolicyTableRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayPolicyTableRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayPolicyTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableRequest.Builder} to create
     *        a request.
     * @return Result of the CreateTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPolicyTableResponse createTransitGatewayPolicyTable(
            Consumer<CreateTransitGatewayPolicyTableRequest.Builder> createTransitGatewayPolicyTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayPolicyTable(CreateTransitGatewayPolicyTableRequest.builder()
                .applyMutation(createTransitGatewayPolicyTableRequest).build());
    }

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayPrefixListReferenceRequest
     * @return Result of the CreateTransitGatewayPrefixListReference operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPrefixListReferenceResponse createTransitGatewayPrefixListReference(
            CreateTransitGatewayPrefixListReferenceRequest createTransitGatewayPrefixListReferenceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTransitGatewayPrefixListReferenceRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTransitGatewayPrefixListReferenceRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayPrefixListReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest.Builder}
     *        to create a request.
     * @return Result of the CreateTransitGatewayPrefixListReference operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayPrefixListReferenceResponse createTransitGatewayPrefixListReference(
            Consumer<CreateTransitGatewayPrefixListReferenceRequest.Builder> createTransitGatewayPrefixListReferenceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayPrefixListReference(CreateTransitGatewayPrefixListReferenceRequest.builder()
                .applyMutation(createTransitGatewayPrefixListReferenceRequest).build());
    }

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteRequest
     * @return Result of the CreateTransitGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTransitGatewayRouteResponse createTransitGatewayRoute(
            CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTransitGatewayRouteRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTransitGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTransitGatewayRouteResponse createTransitGatewayRoute(
            Consumer<CreateTransitGatewayRouteRequest.Builder> createTransitGatewayRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createTransitGatewayRoute(CreateTransitGatewayRouteRequest.builder()
                .applyMutation(createTransitGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     *
     * @param createTransitGatewayRouteTableRequest
     * @return Result of the CreateTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayRouteTableResponse createTransitGatewayRouteTable(
            CreateTransitGatewayRouteTableRequest createTransitGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableRequest.Builder} to create
     *        a request.
     * @return Result of the CreateTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayRouteTableResponse createTransitGatewayRouteTable(
            Consumer<CreateTransitGatewayRouteTableRequest.Builder> createTransitGatewayRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayRouteTable(CreateTransitGatewayRouteTableRequest.builder()
                .applyMutation(createTransitGatewayRouteTableRequest).build());
    }

    /**
     * <p>
     * Advertises a new transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteTableAnnouncementRequest
     * @return Result of the CreateTransitGatewayRouteTableAnnouncement operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRouteTableAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayRouteTableAnnouncementResponse createTransitGatewayRouteTableAnnouncement(
            CreateTransitGatewayRouteTableAnnouncementRequest createTransitGatewayRouteTableAnnouncementRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Advertises a new transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateTransitGatewayRouteTableAnnouncementRequest.Builder} avoiding the need to create one manually via
     * {@link CreateTransitGatewayRouteTableAnnouncementRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayRouteTableAnnouncementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest.Builder}
     *        to create a request.
     * @return Result of the CreateTransitGatewayRouteTableAnnouncement operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRouteTableAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayRouteTableAnnouncementResponse createTransitGatewayRouteTableAnnouncement(
            Consumer<CreateTransitGatewayRouteTableAnnouncementRequest.Builder> createTransitGatewayRouteTableAnnouncementRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayRouteTableAnnouncement(CreateTransitGatewayRouteTableAnnouncementRequest.builder()
                .applyMutation(createTransitGatewayRouteTableAnnouncementRequest).build());
    }

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     *
     * @param createTransitGatewayVpcAttachmentRequest
     * @return Result of the CreateTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayVpcAttachmentResponse createTransitGatewayVpcAttachment(
            CreateTransitGatewayVpcAttachmentRequest createTransitGatewayVpcAttachmentRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransitGatewayVpcAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTransitGatewayVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param createTransitGatewayVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTransitGatewayVpcAttachmentResponse createTransitGatewayVpcAttachment(
            Consumer<CreateTransitGatewayVpcAttachmentRequest.Builder> createTransitGatewayVpcAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createTransitGatewayVpcAttachment(CreateTransitGatewayVpcAttachmentRequest.builder()
                .applyMutation(createTransitGatewayVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access endpoint is where you define your application along with an optional
     * endpoint-level access policy.
     * </p>
     *
     * @param createVerifiedAccessEndpointRequest
     * @return Result of the CreateVerifiedAccessEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedAccessEndpointResponse createVerifiedAccessEndpoint(
            CreateVerifiedAccessEndpointRequest createVerifiedAccessEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access endpoint is where you define your application along with an optional
     * endpoint-level access policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVerifiedAccessEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVerifiedAccessEndpointRequest#builder()}
     * </p>
     *
     * @param createVerifiedAccessEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVerifiedAccessEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedAccessEndpointResponse createVerifiedAccessEndpoint(
            Consumer<CreateVerifiedAccessEndpointRequest.Builder> createVerifiedAccessEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVerifiedAccessEndpoint(CreateVerifiedAccessEndpointRequest.builder()
                .applyMutation(createVerifiedAccessEndpointRequest).build());
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints
     * who's associated applications have similar security requirements. Each instance within a Verified Access group
     * shares an Verified Access policy. For example, you can group all Verified Access instances associated with
     * "sales" applications together and use one common Verified Access policy.
     * </p>
     *
     * @param createVerifiedAccessGroupRequest
     * @return Result of the CreateVerifiedAccessGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVerifiedAccessGroupResponse createVerifiedAccessGroup(
            CreateVerifiedAccessGroupRequest createVerifiedAccessGroupRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints
     * who's associated applications have similar security requirements. Each instance within a Verified Access group
     * shares an Verified Access policy. For example, you can group all Verified Access instances associated with
     * "sales" applications together and use one common Verified Access policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVerifiedAccessGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVerifiedAccessGroupRequest#builder()}
     * </p>
     *
     * @param createVerifiedAccessGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVerifiedAccessGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVerifiedAccessGroupResponse createVerifiedAccessGroup(
            Consumer<CreateVerifiedAccessGroupRequest.Builder> createVerifiedAccessGroupRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createVerifiedAccessGroup(CreateVerifiedAccessGroupRequest.builder()
                .applyMutation(createVerifiedAccessGroupRequest).build());
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and
     * grants access only when your security requirements are met.
     * </p>
     *
     * @param createVerifiedAccessInstanceRequest
     * @return Result of the CreateVerifiedAccessInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedAccessInstanceResponse createVerifiedAccessInstance(
            CreateVerifiedAccessInstanceRequest createVerifiedAccessInstanceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and
     * grants access only when your security requirements are met.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVerifiedAccessInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVerifiedAccessInstanceRequest#builder()}
     * </p>
     *
     * @param createVerifiedAccessInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVerifiedAccessInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedAccessInstanceResponse createVerifiedAccessInstance(
            Consumer<CreateVerifiedAccessInstanceRequest.Builder> createVerifiedAccessInstanceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVerifiedAccessInstance(CreateVerifiedAccessInstanceRequest.builder()
                .applyMutation(createVerifiedAccessInstanceRequest).build());
    }

    /**
     * <p>
     * A trust provider is a third-party entity that creates, maintains, and manages identity information for users and
     * devices. When an application request is made, the identity information sent by the trust provider is evaluated by
     * Verified Access before allowing or denying the application request.
     * </p>
     *
     * @param createVerifiedAccessTrustProviderRequest
     * @return Result of the CreateVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedAccessTrustProviderResponse createVerifiedAccessTrustProvider(
            CreateVerifiedAccessTrustProviderRequest createVerifiedAccessTrustProviderRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A trust provider is a third-party entity that creates, maintains, and manages identity information for users and
     * devices. When an application request is made, the identity information sent by the trust provider is evaluated by
     * Verified Access before allowing or denying the application request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVerifiedAccessTrustProviderRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVerifiedAccessTrustProviderRequest#builder()}
     * </p>
     *
     * @param createVerifiedAccessTrustProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest.Builder} to
     *        create a request.
     * @return Result of the CreateVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVerifiedAccessTrustProviderResponse createVerifiedAccessTrustProvider(
            Consumer<CreateVerifiedAccessTrustProviderRequest.Builder> createVerifiedAccessTrustProviderRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVerifiedAccessTrustProvider(CreateVerifiedAccessTrustProviderRequest.builder()
                .applyMutation(createVerifiedAccessTrustProviderRequest).build());
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html">Create an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param createVolumeRequest
     * @return Result of the CreateVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVolumeResponse createVolume(CreateVolumeRequest createVolumeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html">Create an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVolumeRequest#builder()}
     * </p>
     *
     * @param createVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVolumeRequest.Builder} to create a request.
     * @return Result of the CreateVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVolumeResponse createVolume(Consumer<CreateVolumeRequest.Builder> createVolumeRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVolume(CreateVolumeRequest.builder().applyMutation(createVolumeRequest).build());
    }

    /**
     * <p>
     * Creates a VPC with the specified CIDR blocks. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
     * bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance that you launch in the VPC has the default DHCP options, which include only a default
     * DNS server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createVpcRequest
     * @return Result of the CreateVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpcResponse createVpc(CreateVpcRequest createVpcRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC with the specified CIDR blocks. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
     * bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance that you launch in the VPC has the default DHCP options, which include only a default
     * DNS server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVpcRequest#builder()}
     * </p>
     *
     * @param createVpcRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpcRequest.Builder} to create a request.
     * @return Result of the CreateVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpcResponse createVpc(Consumer<CreateVpcRequest.Builder> createVpcRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createVpc(CreateVpcRequest.builder().applyMutation(createVpcRequest).build());
    }

    /**
     * <p>
     * Create a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single
     * VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You
     * can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there
     * is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createVpcBlockPublicAccessExclusionRequest
     * @return Result of the CreateVpcBlockPublicAccessExclusion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcBlockPublicAccessExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcBlockPublicAccessExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcBlockPublicAccessExclusionResponse createVpcBlockPublicAccessExclusion(
            CreateVpcBlockPublicAccessExclusionRequest createVpcBlockPublicAccessExclusionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single
     * VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You
     * can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there
     * is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcBlockPublicAccessExclusionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVpcBlockPublicAccessExclusionRequest#builder()}
     * </p>
     *
     * @param createVpcBlockPublicAccessExclusionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpcBlockPublicAccessExclusionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateVpcBlockPublicAccessExclusion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcBlockPublicAccessExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcBlockPublicAccessExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcBlockPublicAccessExclusionResponse createVpcBlockPublicAccessExclusion(
            Consumer<CreateVpcBlockPublicAccessExclusionRequest.Builder> createVpcBlockPublicAccessExclusionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVpcBlockPublicAccessExclusion(CreateVpcBlockPublicAccessExclusionRequest.builder()
                .applyMutation(createVpcBlockPublicAccessExclusionRequest).build());
    }

    /**
     * <p>
     * Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified
     * endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services
     * Marketplace Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink User Guide</a>.
     * </p>
     *
     * @param createVpcEndpointRequest
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpcEndpointResponse createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified
     * endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services
     * Marketplace Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest.Builder} to create a request.
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpcEndpointResponse createVpcEndpoint(Consumer<CreateVpcEndpointRequest.Builder> createVpcEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVpcEndpoint(CreateVpcEndpointRequest.builder().applyMutation(createVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Creating an Amazon SNS
     * topic</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     *
     * @param createVpcEndpointConnectionNotificationRequest
     * @return Result of the CreateVpcEndpointConnectionNotification operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpointConnectionNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointConnectionNotificationResponse createVpcEndpointConnectionNotification(
            CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Creating an Amazon SNS
     * topic</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateVpcEndpointConnectionNotificationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateVpcEndpointConnectionNotificationRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointConnectionNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateVpcEndpointConnectionNotification operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpointConnectionNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointConnectionNotificationResponse createVpcEndpointConnectionNotification(
            Consumer<CreateVpcEndpointConnectionNotificationRequest.Builder> createVpcEndpointConnectionNotificationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVpcEndpointConnectionNotification(CreateVpcEndpointConnectionNotificationRequest.builder()
                .applyMutation(createVpcEndpointConnectionNotificationRequest).build());
    }

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles)
     * can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     *
     * @param createVpcEndpointServiceConfigurationRequest
     * @return Result of the CreateVpcEndpointServiceConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpointServiceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointServiceConfigurationResponse createVpcEndpointServiceConfiguration(
            CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles)
     * can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateVpcEndpointServiceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateVpcEndpointServiceConfigurationRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointServiceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateVpcEndpointServiceConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpointServiceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointServiceConfigurationResponse createVpcEndpointServiceConfiguration(
            Consumer<CreateVpcEndpointServiceConfigurationRequest.Builder> createVpcEndpointServiceConfigurationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVpcEndpointServiceConfiguration(CreateVpcEndpointServiceConfigurationRequest.builder()
                .applyMutation(createVpcEndpointServiceConfigurationRequest).build());
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">VPC peering
     * limitations</a> in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return Result of the CreateVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcPeeringConnectionResponse createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">VPC peering
     * limitations</a> in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcPeeringConnectionResponse createVpcPeeringConnection(
            Consumer<CreateVpcPeeringConnectionRequest.Builder> createVpcPeeringConnectionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createVpcPeeringConnection(CreateVpcPeeringConnectionRequest.builder()
                .applyMutation(createVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @return Result of the CreateVpnConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpnConnectionResponse createVpnConnection(CreateVpnConnectionRequest createVpnConnectionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpnConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVpnConnectionRequest#builder()}
     * </p>
     *
     * @param createVpnConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest.Builder} to create a request.
     *        Contains the parameters for CreateVpnConnection.
     * @return Result of the CreateVpnConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpnConnectionResponse createVpnConnection(
            Consumer<CreateVpnConnectionRequest.Builder> createVpnConnectionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createVpnConnection(CreateVpnConnectionRequest.builder().applyMutation(createVpnConnectionRequest).build());
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @return Result of the CreateVpnConnectionRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVpnConnectionRouteResponse createVpnConnectionRoute(
            CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpnConnectionRouteRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpnConnectionRouteRequest#builder()}
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest.Builder} to create a
     *        request. Contains the parameters for CreateVpnConnectionRoute.
     * @return Result of the CreateVpnConnectionRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVpnConnectionRouteResponse createVpnConnectionRoute(
            Consumer<CreateVpnConnectionRouteRequest.Builder> createVpnConnectionRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return createVpnConnectionRoute(CreateVpnConnectionRouteRequest.builder().applyMutation(createVpnConnectionRouteRequest)
                .build());
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @return Result of the CreateVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpnGatewayResponse createVpnGateway(CreateVpnGatewayRequest createVpnGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpnGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpnGatewayRequest#builder()}
     * </p>
     *
     * @param createVpnGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest.Builder} to create a request.
     *        Contains the parameters for CreateVpnGateway.
     * @return Result of the CreateVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVpnGatewayResponse createVpnGateway(Consumer<CreateVpnGatewayRequest.Builder> createVpnGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return createVpnGateway(CreateVpnGatewayRequest.builder().applyMutation(createVpnGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important>
     *
     * @param deleteCarrierGatewayRequest
     * @return Result of the DeleteCarrierGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCarrierGatewayResponse deleteCarrierGateway(DeleteCarrierGatewayRequest deleteCarrierGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCarrierGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCarrierGatewayRequest#builder()}
     * </p>
     *
     * @param deleteCarrierGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest.Builder} to create a request.
     * @return Result of the DeleteCarrierGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCarrierGatewayResponse deleteCarrierGateway(
            Consumer<DeleteCarrierGatewayRequest.Builder> deleteCarrierGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteCarrierGateway(DeleteCarrierGatewayRequest.builder().applyMutation(deleteCarrierGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     *
     * @param deleteClientVpnEndpointRequest
     * @return Result of the DeleteClientVpnEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteClientVpnEndpointResponse deleteClientVpnEndpoint(DeleteClientVpnEndpointRequest deleteClientVpnEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientVpnEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClientVpnEndpointRequest#builder()}
     * </p>
     *
     * @param deleteClientVpnEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteClientVpnEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteClientVpnEndpointResponse deleteClientVpnEndpoint(
            Consumer<DeleteClientVpnEndpointRequest.Builder> deleteClientVpnEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteClientVpnEndpoint(DeleteClientVpnEndpointRequest.builder().applyMutation(deleteClientVpnEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     *
     * @param deleteClientVpnRouteRequest
     * @return Result of the DeleteClientVpnRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClientVpnRouteResponse deleteClientVpnRoute(DeleteClientVpnRouteRequest deleteClientVpnRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClientVpnRouteRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClientVpnRouteRequest#builder()}
     * </p>
     *
     * @param deleteClientVpnRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest.Builder} to create a request.
     * @return Result of the DeleteClientVpnRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClientVpnRouteResponse deleteClientVpnRoute(
            Consumer<DeleteClientVpnRouteRequest.Builder> deleteClientVpnRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteClientVpnRoute(DeleteClientVpnRouteRequest.builder().applyMutation(deleteClientVpnRouteRequest).build());
    }

    /**
     * <p>
     * Deletes a range of customer-owned IP addresses.
     * </p>
     *
     * @param deleteCoipCidrRequest
     * @return Result of the DeleteCoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCoipCidrResponse deleteCoipCidr(DeleteCoipCidrRequest deleteCoipCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a range of customer-owned IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoipCidrRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCoipCidrRequest#builder()}
     * </p>
     *
     * @param deleteCoipCidrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest.Builder} to create a request.
     * @return Result of the DeleteCoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCoipCidrResponse deleteCoipCidr(Consumer<DeleteCoipCidrRequest.Builder> deleteCoipCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteCoipCidr(DeleteCoipCidrRequest.builder().applyMutation(deleteCoipCidrRequest).build());
    }

    /**
     * <p>
     * Deletes a pool of customer-owned IP (CoIP) addresses.
     * </p>
     *
     * @param deleteCoipPoolRequest
     * @return Result of the DeleteCoipPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCoipPoolResponse deleteCoipPool(DeleteCoipPoolRequest deleteCoipPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a pool of customer-owned IP (CoIP) addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCoipPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCoipPoolRequest#builder()}
     * </p>
     *
     * @param deleteCoipPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest.Builder} to create a request.
     * @return Result of the DeleteCoipPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCoipPoolResponse deleteCoipPool(Consumer<DeleteCoipPoolRequest.Builder> deleteCoipPoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteCoipPool(DeleteCoipPoolRequest.builder().applyMutation(deleteCoipPoolRequest).build());
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @return Result of the DeleteCustomerGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCustomerGatewayResponse deleteCustomerGateway(DeleteCustomerGatewayRequest deleteCustomerGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomerGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomerGatewayRequest#builder()}
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest.Builder} to create a
     *        request. Contains the parameters for DeleteCustomerGateway.
     * @return Result of the DeleteCustomerGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCustomerGatewayResponse deleteCustomerGateway(
            Consumer<DeleteCustomerGatewayRequest.Builder> deleteCustomerGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteCustomerGateway(DeleteCustomerGatewayRequest.builder().applyMutation(deleteCustomerGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     * @return Result of the DeleteDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDhcpOptionsResponse deleteDhcpOptions(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDhcpOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDhcpOptionsRequest#builder()}
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest.Builder} to create a request.
     * @return Result of the DeleteDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDhcpOptionsResponse deleteDhcpOptions(Consumer<DeleteDhcpOptionsRequest.Builder> deleteDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteDhcpOptions(DeleteDhcpOptionsRequest.builder().applyMutation(deleteDhcpOptionsRequest).build());
    }

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     * @return Result of the DeleteEgressOnlyInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEgressOnlyInternetGatewayResponse deleteEgressOnlyInternetGateway(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEgressOnlyInternetGatewayRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEgressOnlyInternetGatewayRequest#builder()}
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteEgressOnlyInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEgressOnlyInternetGatewayResponse deleteEgressOnlyInternetGateway(
            Consumer<DeleteEgressOnlyInternetGatewayRequest.Builder> deleteEgressOnlyInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteEgressOnlyInternetGateway(DeleteEgressOnlyInternetGatewayRequest.builder()
                .applyMutation(deleteEgressOnlyInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified EC2 Fleets.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a deleted EC2 Fleet should terminate its instances. If you choose to terminate the
     * instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the
     * <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate
     * them manually.
     * </p>
     * <p>
     * For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. Up to 1000
     * instances can be terminated in a single request to delete <code>instant</code> fleets. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 fleets of type <code>instant</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 100 fleets of type <code>maintain</code> or <code>request</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 125 fleets in a single request, provided you do not exceed the quota for each fleet type, as
     * specified above.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you exceed the specified number of fleets to delete, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteFleetsRequest
     * @return Result of the DeleteFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetsResponse deleteFleets(DeleteFleetsRequest deleteFleetsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified EC2 Fleets.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a deleted EC2 Fleet should terminate its instances. If you choose to terminate the
     * instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the
     * <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate
     * them manually.
     * </p>
     * <p>
     * For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. Up to 1000
     * instances can be terminated in a single request to delete <code>instant</code> fleets. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 fleets of type <code>instant</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 100 fleets of type <code>maintain</code> or <code>request</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 125 fleets in a single request, provided you do not exceed the quota for each fleet type, as
     * specified above.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you exceed the specified number of fleets to delete, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetsRequest#builder()}
     * </p>
     *
     * @param deleteFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest.Builder} to create a request.
     * @return Result of the DeleteFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetsResponse deleteFleets(Consumer<DeleteFleetsRequest.Builder> deleteFleetsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteFleets(DeleteFleetsRequest.builder().applyMutation(deleteFleetsRequest).build());
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     *
     * @param deleteFlowLogsRequest
     * @return Result of the DeleteFlowLogs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlowLogsResponse deleteFlowLogs(DeleteFlowLogsRequest deleteFlowLogsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowLogsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFlowLogsRequest#builder()}
     * </p>
     *
     * @param deleteFlowLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest.Builder} to create a request.
     * @return Result of the DeleteFlowLogs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFlowLogsResponse deleteFlowLogs(Consumer<DeleteFlowLogsRequest.Builder> deleteFlowLogsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteFlowLogs(DeleteFlowLogsRequest.builder().applyMutation(deleteFlowLogsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param deleteFpgaImageRequest
     * @return Result of the DeleteFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFpgaImageResponse deleteFpgaImage(DeleteFpgaImageRequest deleteFpgaImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFpgaImageRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFpgaImageRequest#builder()}
     * </p>
     *
     * @param deleteFpgaImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest.Builder} to create a request.
     * @return Result of the DeleteFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFpgaImageResponse deleteFpgaImage(Consumer<DeleteFpgaImageRequest.Builder> deleteFpgaImageRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteFpgaImage(DeleteFpgaImageRequest.builder().applyMutation(deleteFpgaImageRequest).build());
    }

    /**
     * <p>
     * Deletes the specified EC2 Instance Connect Endpoint.
     * </p>
     *
     * @param deleteInstanceConnectEndpointRequest
     * @return Result of the DeleteInstanceConnectEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceConnectEndpointResponse deleteInstanceConnectEndpoint(
            DeleteInstanceConnectEndpointRequest deleteInstanceConnectEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified EC2 Instance Connect Endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceConnectEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInstanceConnectEndpointRequest#builder()}
     * </p>
     *
     * @param deleteInstanceConnectEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInstanceConnectEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInstanceConnectEndpointResponse deleteInstanceConnectEndpoint(
            Consumer<DeleteInstanceConnectEndpointRequest.Builder> deleteInstanceConnectEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteInstanceConnectEndpoint(DeleteInstanceConnectEndpointRequest.builder()
                .applyMutation(deleteInstanceConnectEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteInstanceEventWindowRequest
     * @return Result of the DeleteInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInstanceEventWindowResponse deleteInstanceEventWindow(
            DeleteInstanceEventWindowRequest deleteInstanceEventWindowRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceEventWindowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInstanceEventWindowRequest#builder()}
     * </p>
     *
     * @param deleteInstanceEventWindowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInstanceEventWindowResponse deleteInstanceEventWindow(
            Consumer<DeleteInstanceEventWindowRequest.Builder> deleteInstanceEventWindowRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteInstanceEventWindow(DeleteInstanceEventWindowRequest.builder()
                .applyMutation(deleteInstanceEventWindowRequest).build());
    }

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     *
     * @param deleteInternetGatewayRequest
     * @return Result of the DeleteInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInternetGatewayResponse deleteInternetGateway(DeleteInternetGatewayRequest deleteInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInternetGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInternetGatewayRequest#builder()}
     * </p>
     *
     * @param deleteInternetGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInternetGatewayResponse deleteInternetGateway(
            Consumer<DeleteInternetGatewayRequest.Builder> deleteInternetGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteInternetGateway(DeleteInternetGatewayRequest.builder().applyMutation(deleteInternetGatewayRequest).build());
    }

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html">Delete an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamRequest
     * @return Result of the DeleteIpam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpamResponse deleteIpam(DeleteIpamRequest deleteIpamRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html">Delete an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpamRequest#builder()}
     * </p>
     *
     * @param deleteIpamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteIpamRequest.Builder} to create a request.
     * @return Result of the DeleteIpam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpamResponse deleteIpam(Consumer<DeleteIpamRequest.Builder> deleteIpamRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteIpam(DeleteIpamRequest.builder().applyMutation(deleteIpamRequest).build());
    }

    /**
     * <p>
     * Delete a verification token. A verification token is an Amazon Web Services-generated random value that you can
     * use to prove ownership of an external resource. For example, you can use a verification token to validate that
     * you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
     * </p>
     *
     * @param deleteIpamExternalResourceVerificationTokenRequest
     * @return Result of the DeleteIpamExternalResourceVerificationToken operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamExternalResourceVerificationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamExternalResourceVerificationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIpamExternalResourceVerificationTokenResponse deleteIpamExternalResourceVerificationToken(
            DeleteIpamExternalResourceVerificationTokenRequest deleteIpamExternalResourceVerificationTokenRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a verification token. A verification token is an Amazon Web Services-generated random value that you can
     * use to prove ownership of an external resource. For example, you can use a verification token to validate that
     * you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteIpamExternalResourceVerificationTokenRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteIpamExternalResourceVerificationTokenRequest#builder()}
     * </p>
     *
     * @param deleteIpamExternalResourceVerificationTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteIpamExternalResourceVerificationTokenRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteIpamExternalResourceVerificationToken operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamExternalResourceVerificationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamExternalResourceVerificationToken"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIpamExternalResourceVerificationTokenResponse deleteIpamExternalResourceVerificationToken(
            Consumer<DeleteIpamExternalResourceVerificationTokenRequest.Builder> deleteIpamExternalResourceVerificationTokenRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteIpamExternalResourceVerificationToken(DeleteIpamExternalResourceVerificationTokenRequest.builder()
                .applyMutation(deleteIpamExternalResourceVerificationTokenRequest).build());
    }

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a
     * pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamPoolRequest
     * @return Result of the DeleteIpamPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpamPoolResponse deleteIpamPool(DeleteIpamPoolRequest deleteIpamPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a
     * pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpamPoolRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIpamPoolRequest#builder()}
     * </p>
     *
     * @param deleteIpamPoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest.Builder} to create a request.
     * @return Result of the DeleteIpamPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpamPoolResponse deleteIpamPool(Consumer<DeleteIpamPoolRequest.Builder> deleteIpamPoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteIpamPool(DeleteIpamPoolRequest.builder().applyMutation(deleteIpamPoolRequest).build());
    }

    /**
     * <p>
     * Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     *
     * @param deleteIpamResourceDiscoveryRequest
     * @return Result of the DeleteIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIpamResourceDiscoveryResponse deleteIpamResourceDiscovery(
            DeleteIpamResourceDiscoveryRequest deleteIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpamResourceDiscoveryRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteIpamResourceDiscoveryRequest#builder()}
     * </p>
     *
     * @param deleteIpamResourceDiscoveryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIpamResourceDiscoveryResponse deleteIpamResourceDiscovery(
            Consumer<DeleteIpamResourceDiscoveryRequest.Builder> deleteIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteIpamResourceDiscovery(DeleteIpamResourceDiscoveryRequest.builder()
                .applyMutation(deleteIpamResourceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html">Delete a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamScopeRequest
     * @return Result of the DeleteIpamScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpamScopeResponse deleteIpamScope(DeleteIpamScopeRequest deleteIpamScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html">Delete a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpamScopeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIpamScopeRequest#builder()}
     * </p>
     *
     * @param deleteIpamScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest.Builder} to create a request.
     * @return Result of the DeleteIpamScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIpamScopeResponse deleteIpamScope(Consumer<DeleteIpamScopeRequest.Builder> deleteIpamScopeRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteIpamScope(DeleteIpamScopeRequest.builder().applyMutation(deleteIpamScopeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return Result of the DeleteKeyPair operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKeyPairResponse deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyPairRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyPairRequest#builder()}
     * </p>
     *
     * @param deleteKeyPairRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest.Builder} to create a request.
     * @return Result of the DeleteKeyPair operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteKeyPairResponse deleteKeyPair(Consumer<DeleteKeyPairRequest.Builder> deleteKeyPairRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteKeyPair(DeleteKeyPairRequest.builder().applyMutation(deleteKeyPairRequest).build());
    }

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     *
     * @param deleteLaunchTemplateRequest
     * @return Result of the DeleteLaunchTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLaunchTemplateResponse deleteLaunchTemplate(DeleteLaunchTemplateRequest deleteLaunchTemplateRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLaunchTemplateRequest#builder()}
     * </p>
     *
     * @param deleteLaunchTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest.Builder} to create a request.
     * @return Result of the DeleteLaunchTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLaunchTemplateResponse deleteLaunchTemplate(
            Consumer<DeleteLaunchTemplateRequest.Builder> deleteLaunchTemplateRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteLaunchTemplate(DeleteLaunchTemplateRequest.builder().applyMutation(deleteLaunchTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes one or more versions of a launch template.
     * </p>
     * <p>
     * You can't delete the default version of a launch template; you must first assign a different version as the
     * default. If the default version is the only version for the launch template, you must delete the entire launch
     * template using <a>DeleteLaunchTemplate</a>.
     * </p>
     * <p>
     * You can delete up to 200 launch template versions in a single request. To delete more than 200 versions in a
     * single request, use <a>DeleteLaunchTemplate</a>, which deletes the launch template and all of its versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html#delete-launch-template-version"
     * >Delete a launch template version</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteLaunchTemplateVersionsRequest
     * @return Result of the DeleteLaunchTemplateVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLaunchTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchTemplateVersionsResponse deleteLaunchTemplateVersions(
            DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more versions of a launch template.
     * </p>
     * <p>
     * You can't delete the default version of a launch template; you must first assign a different version as the
     * default. If the default version is the only version for the launch template, you must delete the entire launch
     * template using <a>DeleteLaunchTemplate</a>.
     * </p>
     * <p>
     * You can delete up to 200 launch template versions in a single request. To delete more than 200 versions in a
     * single request, use <a>DeleteLaunchTemplate</a>, which deletes the launch template and all of its versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html#delete-launch-template-version"
     * >Delete a launch template version</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchTemplateVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLaunchTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param deleteLaunchTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLaunchTemplateVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLaunchTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchTemplateVersionsResponse deleteLaunchTemplateVersions(
            Consumer<DeleteLaunchTemplateVersionsRequest.Builder> deleteLaunchTemplateVersionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteLaunchTemplateVersions(DeleteLaunchTemplateVersionsRequest.builder()
                .applyMutation(deleteLaunchTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteRequest
     * @return Result of the DeleteLocalGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLocalGatewayRouteResponse deleteLocalGatewayRoute(DeleteLocalGatewayRouteRequest deleteLocalGatewayRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLocalGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteLocalGatewayRouteRequest#builder()}
     * </p>
     *
     * @param deleteLocalGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLocalGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteLocalGatewayRouteResponse deleteLocalGatewayRoute(
            Consumer<DeleteLocalGatewayRouteRequest.Builder> deleteLocalGatewayRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteLocalGatewayRoute(DeleteLocalGatewayRouteRequest.builder().applyMutation(deleteLocalGatewayRouteRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableRequest
     * @return Result of the DeleteLocalGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLocalGatewayRouteTableResponse deleteLocalGatewayRouteTable(
            DeleteLocalGatewayRouteTableRequest deleteLocalGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLocalGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLocalGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param deleteLocalGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLocalGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLocalGatewayRouteTableResponse deleteLocalGatewayRouteTable(
            Consumer<DeleteLocalGatewayRouteTableRequest.Builder> deleteLocalGatewayRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteLocalGatewayRouteTable(DeleteLocalGatewayRouteTableRequest.builder()
                .applyMutation(deleteLocalGatewayRouteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a local gateway route table virtual interface group association.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return Result of the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation returned by the
     *         service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a local gateway route table virtual interface group association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.Builder} avoiding the need to create
     * one manually via {@link DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest#builder()}
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation returned by the
     *         service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            Consumer<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.Builder> deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
                .builder().applyMutation(deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     * @return Result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLocalGatewayRouteTableVpcAssociationResponse deleteLocalGatewayRouteTableVpcAssociation(
            DeleteLocalGatewayRouteTableVpcAssociationRequest deleteLocalGatewayRouteTableVpcAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteLocalGatewayRouteTableVpcAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteLocalGatewayRouteTableVpcAssociationRequest#builder()}
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLocalGatewayRouteTableVpcAssociationResponse deleteLocalGatewayRouteTableVpcAssociation(
            Consumer<DeleteLocalGatewayRouteTableVpcAssociationRequest.Builder> deleteLocalGatewayRouteTableVpcAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteLocalGatewayRouteTableVpcAssociation(DeleteLocalGatewayRouteTableVpcAssociationRequest.builder()
                .applyMutation(deleteLocalGatewayRouteTableVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     *
     * @param deleteManagedPrefixListRequest
     * @return Result of the DeleteManagedPrefixList operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteManagedPrefixListResponse deleteManagedPrefixList(DeleteManagedPrefixListRequest deleteManagedPrefixListRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteManagedPrefixListRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteManagedPrefixListRequest#builder()}
     * </p>
     *
     * @param deleteManagedPrefixListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteManagedPrefixList operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteManagedPrefixListResponse deleteManagedPrefixList(
            Consumer<DeleteManagedPrefixListRequest.Builder> deleteManagedPrefixListRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteManagedPrefixList(DeleteManagedPrefixListRequest.builder().applyMutation(deleteManagedPrefixListRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     *
     * @param deleteNatGatewayRequest
     * @return Result of the DeleteNatGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNatGatewayResponse deleteNatGateway(DeleteNatGatewayRequest deleteNatGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNatGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNatGatewayRequest#builder()}
     * </p>
     *
     * @param deleteNatGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest.Builder} to create a request.
     * @return Result of the DeleteNatGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNatGatewayResponse deleteNatGateway(Consumer<DeleteNatGatewayRequest.Builder> deleteNatGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteNatGateway(DeleteNatGatewayRequest.builder().applyMutation(deleteNatGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     *
     * @param deleteNetworkAclRequest
     * @return Result of the DeleteNetworkAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNetworkAclResponse deleteNetworkAcl(DeleteNetworkAclRequest deleteNetworkAclRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkAclRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNetworkAclRequest#builder()}
     * </p>
     *
     * @param deleteNetworkAclRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest.Builder} to create a request.
     * @return Result of the DeleteNetworkAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNetworkAclResponse deleteNetworkAcl(Consumer<DeleteNetworkAclRequest.Builder> deleteNetworkAclRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteNetworkAcl(DeleteNetworkAclRequest.builder().applyMutation(deleteNetworkAclRequest).build());
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     * @return Result of the DeleteNetworkAclEntry operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNetworkAclEntryResponse deleteNetworkAclEntry(DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkAclEntryRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkAclEntryRequest#builder()}
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNetworkAclEntry operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNetworkAclEntryResponse deleteNetworkAclEntry(
            Consumer<DeleteNetworkAclEntryRequest.Builder> deleteNetworkAclEntryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteNetworkAclEntry(DeleteNetworkAclEntryRequest.builder().applyMutation(deleteNetworkAclEntryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeRequest
     * @return Result of the DeleteNetworkInsightsAccessScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInsightsAccessScopeResponse deleteNetworkInsightsAccessScope(
            DeleteNetworkInsightsAccessScopeRequest deleteNetworkInsightsAccessScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInsightsAccessScopeRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkInsightsAccessScopeRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteNetworkInsightsAccessScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInsightsAccessScopeResponse deleteNetworkInsightsAccessScope(
            Consumer<DeleteNetworkInsightsAccessScopeRequest.Builder> deleteNetworkInsightsAccessScopeRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteNetworkInsightsAccessScope(DeleteNetworkInsightsAccessScopeRequest.builder()
                .applyMutation(deleteNetworkInsightsAccessScopeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     * @return Result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInsightsAccessScopeAnalysisResponse deleteNetworkInsightsAccessScopeAnalysis(
            DeleteNetworkInsightsAccessScopeAnalysisRequest deleteNetworkInsightsAccessScopeAnalysisRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteNetworkInsightsAccessScopeAnalysisRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteNetworkInsightsAccessScopeAnalysisRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInsightsAccessScopeAnalysisResponse deleteNetworkInsightsAccessScopeAnalysis(
            Consumer<DeleteNetworkInsightsAccessScopeAnalysisRequest.Builder> deleteNetworkInsightsAccessScopeAnalysisRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteNetworkInsightsAccessScopeAnalysis(DeleteNetworkInsightsAccessScopeAnalysisRequest.builder()
                .applyMutation(deleteNetworkInsightsAccessScopeAnalysisRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAnalysisRequest
     * @return Result of the DeleteNetworkInsightsAnalysis operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInsightsAnalysisResponse deleteNetworkInsightsAnalysis(
            DeleteNetworkInsightsAnalysisRequest deleteNetworkInsightsAnalysisRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInsightsAnalysisRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkInsightsAnalysisRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNetworkInsightsAnalysis operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInsightsAnalysisResponse deleteNetworkInsightsAnalysis(
            Consumer<DeleteNetworkInsightsAnalysisRequest.Builder> deleteNetworkInsightsAnalysisRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteNetworkInsightsAnalysis(DeleteNetworkInsightsAnalysisRequest.builder()
                .applyMutation(deleteNetworkInsightsAnalysisRequest).build());
    }

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     *
     * @param deleteNetworkInsightsPathRequest
     * @return Result of the DeleteNetworkInsightsPath operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNetworkInsightsPathResponse deleteNetworkInsightsPath(
            DeleteNetworkInsightsPathRequest deleteNetworkInsightsPathRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInsightsPathRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteNetworkInsightsPathRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInsightsPathRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNetworkInsightsPath operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNetworkInsightsPathResponse deleteNetworkInsightsPath(
            Consumer<DeleteNetworkInsightsPathRequest.Builder> deleteNetworkInsightsPathRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteNetworkInsightsPath(DeleteNetworkInsightsPathRequest.builder()
                .applyMutation(deleteNetworkInsightsPathRequest).build());
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @return Result of the DeleteNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNetworkInterfaceResponse deleteNetworkInterface(DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInterfaceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkInterfaceRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest.Builder} to create a
     *        request. Contains the parameters for DeleteNetworkInterface.
     * @return Result of the DeleteNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNetworkInterfaceResponse deleteNetworkInterface(
            Consumer<DeleteNetworkInterfaceRequest.Builder> deleteNetworkInterfaceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteNetworkInterface(DeleteNetworkInterfaceRequest.builder().applyMutation(deleteNetworkInterfaceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @return Result of the DeleteNetworkInterfacePermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInterfacePermissionResponse deleteNetworkInterfacePermission(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkInterfacePermissionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNetworkInterfacePermissionRequest#builder()}
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest.Builder} to
     *        create a request. Contains the parameters for DeleteNetworkInterfacePermission.
     * @return Result of the DeleteNetworkInterfacePermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkInterfacePermissionResponse deleteNetworkInterfacePermission(
            Consumer<DeleteNetworkInterfacePermissionRequest.Builder> deleteNetworkInterfacePermissionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteNetworkInterfacePermission(DeleteNetworkInterfacePermissionRequest.builder()
                .applyMutation(deleteNetworkInterfacePermissionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deletePlacementGroupRequest
     * @return Result of the DeletePlacementGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeletePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePlacementGroupResponse deletePlacementGroup(DeletePlacementGroupRequest deletePlacementGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlacementGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePlacementGroupRequest#builder()}
     * </p>
     *
     * @param deletePlacementGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest.Builder} to create a request.
     * @return Result of the DeletePlacementGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeletePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePlacementGroupResponse deletePlacementGroup(
            Consumer<DeletePlacementGroupRequest.Builder> deletePlacementGroupRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deletePlacementGroup(DeletePlacementGroupRequest.builder().applyMutation(deletePlacementGroupRequest).build());
    }

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     *
     * @param deletePublicIpv4PoolRequest
     * @return Result of the DeletePublicIpv4Pool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeletePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePublicIpv4PoolResponse deletePublicIpv4Pool(DeletePublicIpv4PoolRequest deletePublicIpv4PoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublicIpv4PoolRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePublicIpv4PoolRequest#builder()}
     * </p>
     *
     * @param deletePublicIpv4PoolRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest.Builder} to create a request.
     * @return Result of the DeletePublicIpv4Pool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeletePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePublicIpv4PoolResponse deletePublicIpv4Pool(
            Consumer<DeletePublicIpv4PoolRequest.Builder> deletePublicIpv4PoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deletePublicIpv4Pool(DeletePublicIpv4PoolRequest.builder().applyMutation(deletePublicIpv4PoolRequest).build());
    }

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     *
     * @param deleteQueuedReservedInstancesRequest
     * @return Result of the DeleteQueuedReservedInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteQueuedReservedInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueuedReservedInstancesResponse deleteQueuedReservedInstances(
            DeleteQueuedReservedInstancesRequest deleteQueuedReservedInstancesRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueuedReservedInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteQueuedReservedInstancesRequest#builder()}
     * </p>
     *
     * @param deleteQueuedReservedInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteQueuedReservedInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteQueuedReservedInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteQueuedReservedInstancesResponse deleteQueuedReservedInstances(
            Consumer<DeleteQueuedReservedInstancesRequest.Builder> deleteQueuedReservedInstancesRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteQueuedReservedInstances(DeleteQueuedReservedInstancesRequest.builder()
                .applyMutation(deleteQueuedReservedInstancesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     *
     * @param deleteRouteRequest
     * @return Result of the DeleteRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRouteResponse deleteRoute(DeleteRouteRequest deleteRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRouteRequest#builder()}
     * </p>
     *
     * @param deleteRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteRouteRequest.Builder} to create a request.
     * @return Result of the DeleteRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRouteResponse deleteRoute(Consumer<DeleteRouteRequest.Builder> deleteRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteRoute(DeleteRouteRequest.builder().applyMutation(deleteRouteRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     *
     * @param deleteRouteTableRequest
     * @return Result of the DeleteRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRouteTableResponse deleteRouteTable(DeleteRouteTableRequest deleteRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRouteTableRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRouteTableRequest#builder()}
     * </p>
     *
     * @param deleteRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest.Builder} to create a request.
     * @return Result of the DeleteRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRouteTableResponse deleteRouteTable(Consumer<DeleteRouteTableRequest.Builder> deleteRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteRouteTable(DeleteRouteTableRequest.builder().applyMutation(deleteRouteTableRequest).build());
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance or network interface, is referenced
     * by another security group in the same VPC, or has a VPC association, the operation fails with
     * <code>DependencyViolation</code>.
     * </p>
     *
     * @param deleteSecurityGroupRequest
     * @return Result of the DeleteSecurityGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSecurityGroupResponse deleteSecurityGroup(DeleteSecurityGroupRequest deleteSecurityGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance or network interface, is referenced
     * by another security group in the same VPC, or has a VPC association, the operation fails with
     * <code>DependencyViolation</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest.Builder} to create a request.
     * @return Result of the DeleteSecurityGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSecurityGroupResponse deleteSecurityGroup(
            Consumer<DeleteSecurityGroupRequest.Builder> deleteSecurityGroupRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteSecurityGroup(DeleteSecurityGroupRequest.builder().applyMutation(deleteSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest.Builder} to create a request.
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSnapshotResponse deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return Result of the DeleteSpotDatafeedSubscription operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSpotDatafeedSubscriptionResponse deleteSpotDatafeedSubscription(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSpotDatafeedSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSpotDatafeedSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest.Builder} to create
     *        a request. Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return Result of the DeleteSpotDatafeedSubscription operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSpotDatafeedSubscriptionResponse deleteSpotDatafeedSubscription(
            Consumer<DeleteSpotDatafeedSubscriptionRequest.Builder> deleteSpotDatafeedSubscriptionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteSpotDatafeedSubscription(DeleteSpotDatafeedSubscriptionRequest.builder()
                .applyMutation(deleteSpotDatafeedSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     *
     * @return Result of the DeleteSpotDatafeedSubscription operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSpotDatafeedSubscription
     * @see #deleteSpotDatafeedSubscription(DeleteSpotDatafeedSubscriptionRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSpotDatafeedSubscriptionResponse deleteSpotDatafeedSubscription() throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteSpotDatafeedSubscription(DeleteSpotDatafeedSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     *
     * @param deleteSubnetRequest
     * @return Result of the DeleteSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSubnetResponse deleteSubnet(DeleteSubnetRequest deleteSubnetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubnetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSubnetRequest#builder()}
     * </p>
     *
     * @param deleteSubnetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest.Builder} to create a request.
     * @return Result of the DeleteSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSubnetResponse deleteSubnet(Consumer<DeleteSubnetRequest.Builder> deleteSubnetRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteSubnet(DeleteSubnetRequest.builder().applyMutation(deleteSubnetRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     *
     * @param deleteSubnetCidrReservationRequest
     * @return Result of the DeleteSubnetCidrReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubnetCidrReservationResponse deleteSubnetCidrReservation(
            DeleteSubnetCidrReservationRequest deleteSubnetCidrReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubnetCidrReservationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSubnetCidrReservationRequest#builder()}
     * </p>
     *
     * @param deleteSubnetCidrReservationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSubnetCidrReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSubnetCidrReservationResponse deleteSubnetCidrReservation(
            Consumer<DeleteSubnetCidrReservationRequest.Builder> deleteSubnetCidrReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteSubnetCidrReservation(DeleteSubnetCidrReservationRequest.builder()
                .applyMutation(deleteSubnetCidrReservationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRequest
     * @return Result of the DeleteTrafficMirrorFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTrafficMirrorFilterResponse deleteTrafficMirrorFilter(
            DeleteTrafficMirrorFilterRequest deleteTrafficMirrorFilterRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorFilterRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrafficMirrorFilterRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorFilterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTrafficMirrorFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTrafficMirrorFilterResponse deleteTrafficMirrorFilter(
            Consumer<DeleteTrafficMirrorFilterRequest.Builder> deleteTrafficMirrorFilterRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteTrafficMirrorFilter(DeleteTrafficMirrorFilterRequest.builder()
                .applyMutation(deleteTrafficMirrorFilterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRuleRequest
     * @return Result of the DeleteTrafficMirrorFilterRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficMirrorFilterRuleResponse deleteTrafficMirrorFilterRule(
            DeleteTrafficMirrorFilterRuleRequest deleteTrafficMirrorFilterRuleRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorFilterRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTrafficMirrorFilterRuleRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorFilterRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTrafficMirrorFilterRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficMirrorFilterRuleResponse deleteTrafficMirrorFilterRule(
            Consumer<DeleteTrafficMirrorFilterRuleRequest.Builder> deleteTrafficMirrorFilterRuleRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTrafficMirrorFilterRule(DeleteTrafficMirrorFilterRuleRequest.builder()
                .applyMutation(deleteTrafficMirrorFilterRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorSessionRequest
     * @return Result of the DeleteTrafficMirrorSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficMirrorSessionResponse deleteTrafficMirrorSession(
            DeleteTrafficMirrorSessionRequest deleteTrafficMirrorSessionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorSessionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrafficMirrorSessionRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTrafficMirrorSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficMirrorSessionResponse deleteTrafficMirrorSession(
            Consumer<DeleteTrafficMirrorSessionRequest.Builder> deleteTrafficMirrorSessionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteTrafficMirrorSession(DeleteTrafficMirrorSessionRequest.builder()
                .applyMutation(deleteTrafficMirrorSessionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorTargetRequest
     * @return Result of the DeleteTrafficMirrorTarget operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTrafficMirrorTargetResponse deleteTrafficMirrorTarget(
            DeleteTrafficMirrorTargetRequest deleteTrafficMirrorTargetRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficMirrorTargetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTrafficMirrorTargetRequest#builder()}
     * </p>
     *
     * @param deleteTrafficMirrorTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTrafficMirrorTarget operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTrafficMirrorTargetResponse deleteTrafficMirrorTarget(
            Consumer<DeleteTrafficMirrorTargetRequest.Builder> deleteTrafficMirrorTargetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteTrafficMirrorTarget(DeleteTrafficMirrorTargetRequest.builder()
                .applyMutation(deleteTrafficMirrorTargetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     *
     * @param deleteTransitGatewayRequest
     * @return Result of the DeleteTransitGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTransitGatewayResponse deleteTransitGateway(DeleteTransitGatewayRequest deleteTransitGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTransitGatewayRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest.Builder} to create a request.
     * @return Result of the DeleteTransitGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTransitGatewayResponse deleteTransitGateway(
            Consumer<DeleteTransitGatewayRequest.Builder> deleteTransitGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteTransitGateway(DeleteTransitGatewayRequest.builder().applyMutation(deleteTransitGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     *
     * @param deleteTransitGatewayConnectRequest
     * @return Result of the DeleteTransitGatewayConnect operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayConnectResponse deleteTransitGatewayConnect(
            DeleteTransitGatewayConnectRequest deleteTransitGatewayConnectRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayConnectRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayConnectRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTransitGatewayConnect operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayConnectResponse deleteTransitGatewayConnect(
            Consumer<DeleteTransitGatewayConnectRequest.Builder> deleteTransitGatewayConnectRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteTransitGatewayConnect(DeleteTransitGatewayConnectRequest.builder()
                .applyMutation(deleteTransitGatewayConnectRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     *
     * @param deleteTransitGatewayConnectPeerRequest
     * @return Result of the DeleteTransitGatewayConnectPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayConnectPeerResponse deleteTransitGatewayConnectPeer(
            DeleteTransitGatewayConnectPeerRequest deleteTransitGatewayConnectPeerRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayConnectPeerRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayConnectPeerRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayConnectPeerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteTransitGatewayConnectPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayConnectPeerResponse deleteTransitGatewayConnectPeer(
            Consumer<DeleteTransitGatewayConnectPeerRequest.Builder> deleteTransitGatewayConnectPeerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayConnectPeer(DeleteTransitGatewayConnectPeerRequest.builder()
                .applyMutation(deleteTransitGatewayConnectPeerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     *
     * @param deleteTransitGatewayMulticastDomainRequest
     * @return Result of the DeleteTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayMulticastDomainResponse deleteTransitGatewayMulticastDomain(
            DeleteTransitGatewayMulticastDomainRequest deleteTransitGatewayMulticastDomainRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayMulticastDomainRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayMulticastDomainRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayMulticastDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayMulticastDomainResponse deleteTransitGatewayMulticastDomain(
            Consumer<DeleteTransitGatewayMulticastDomainRequest.Builder> deleteTransitGatewayMulticastDomainRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayMulticastDomain(DeleteTransitGatewayMulticastDomainRequest.builder()
                .applyMutation(deleteTransitGatewayMulticastDomainRequest).build());
    }

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     *
     * @param deleteTransitGatewayPeeringAttachmentRequest
     * @return Result of the DeleteTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayPeeringAttachmentResponse deleteTransitGatewayPeeringAttachment(
            DeleteTransitGatewayPeeringAttachmentRequest deleteTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteTransitGatewayPeeringAttachmentRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteTransitGatewayPeeringAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayPeeringAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayPeeringAttachmentResponse deleteTransitGatewayPeeringAttachment(
            Consumer<DeleteTransitGatewayPeeringAttachmentRequest.Builder> deleteTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayPeeringAttachment(DeleteTransitGatewayPeeringAttachmentRequest.builder()
                .applyMutation(deleteTransitGatewayPeeringAttachmentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transit gateway policy table.
     * </p>
     *
     * @param deleteTransitGatewayPolicyTableRequest
     * @return Result of the DeleteTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayPolicyTableResponse deleteTransitGatewayPolicyTable(
            DeleteTransitGatewayPolicyTableRequest deleteTransitGatewayPolicyTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transit gateway policy table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayPolicyTableRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayPolicyTableRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayPolicyTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayPolicyTableResponse deleteTransitGatewayPolicyTable(
            Consumer<DeleteTransitGatewayPolicyTableRequest.Builder> deleteTransitGatewayPolicyTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayPolicyTable(DeleteTransitGatewayPolicyTableRequest.builder()
                .applyMutation(deleteTransitGatewayPolicyTableRequest).build());
    }

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayPrefixListReferenceRequest
     * @return Result of the DeleteTransitGatewayPrefixListReference operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayPrefixListReferenceResponse deleteTransitGatewayPrefixListReference(
            DeleteTransitGatewayPrefixListReferenceRequest deleteTransitGatewayPrefixListReferenceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteTransitGatewayPrefixListReferenceRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteTransitGatewayPrefixListReferenceRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayPrefixListReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteTransitGatewayPrefixListReference operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayPrefixListReferenceResponse deleteTransitGatewayPrefixListReference(
            Consumer<DeleteTransitGatewayPrefixListReferenceRequest.Builder> deleteTransitGatewayPrefixListReferenceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayPrefixListReference(DeleteTransitGatewayPrefixListReferenceRequest.builder()
                .applyMutation(deleteTransitGatewayPrefixListReferenceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayRouteRequest
     * @return Result of the DeleteTransitGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTransitGatewayRouteResponse deleteTransitGatewayRoute(
            DeleteTransitGatewayRouteRequest deleteTransitGatewayRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayRouteRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTransitGatewayRouteRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTransitGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTransitGatewayRouteResponse deleteTransitGatewayRoute(
            Consumer<DeleteTransitGatewayRouteRequest.Builder> deleteTransitGatewayRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteTransitGatewayRoute(DeleteTransitGatewayRouteRequest.builder()
                .applyMutation(deleteTransitGatewayRouteRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transit gateway route table. If there are any route tables associated with the transit
     * gateway route table, you must first run <a>DisassociateRouteTable</a> before you can delete the transit gateway
     * route table. This removes any route tables associated with the transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayRouteTableRequest
     * @return Result of the DeleteTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayRouteTableResponse deleteTransitGatewayRouteTable(
            DeleteTransitGatewayRouteTableRequest deleteTransitGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transit gateway route table. If there are any route tables associated with the transit
     * gateway route table, you must first run <a>DisassociateRouteTable</a> before you can delete the transit gateway
     * route table. This removes any route tables associated with the transit gateway route table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayRouteTableRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayRouteTableRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayRouteTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayRouteTableResponse deleteTransitGatewayRouteTable(
            Consumer<DeleteTransitGatewayRouteTableRequest.Builder> deleteTransitGatewayRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayRouteTable(DeleteTransitGatewayRouteTableRequest.builder()
                .applyMutation(deleteTransitGatewayRouteTableRequest).build());
    }

    /**
     * <p>
     * Advertises to the transit gateway that a transit gateway route table is deleted.
     * </p>
     *
     * @param deleteTransitGatewayRouteTableAnnouncementRequest
     * @return Result of the DeleteTransitGatewayRouteTableAnnouncement operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRouteTableAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayRouteTableAnnouncementResponse deleteTransitGatewayRouteTableAnnouncement(
            DeleteTransitGatewayRouteTableAnnouncementRequest deleteTransitGatewayRouteTableAnnouncementRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Advertises to the transit gateway that a transit gateway route table is deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteTransitGatewayRouteTableAnnouncementRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteTransitGatewayRouteTableAnnouncementRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayRouteTableAnnouncementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteTransitGatewayRouteTableAnnouncement operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRouteTableAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayRouteTableAnnouncementResponse deleteTransitGatewayRouteTableAnnouncement(
            Consumer<DeleteTransitGatewayRouteTableAnnouncementRequest.Builder> deleteTransitGatewayRouteTableAnnouncementRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayRouteTableAnnouncement(DeleteTransitGatewayRouteTableAnnouncementRequest.builder()
                .applyMutation(deleteTransitGatewayRouteTableAnnouncementRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     *
     * @param deleteTransitGatewayVpcAttachmentRequest
     * @return Result of the DeleteTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayVpcAttachmentResponse deleteTransitGatewayVpcAttachment(
            DeleteTransitGatewayVpcAttachmentRequest deleteTransitGatewayVpcAttachmentRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransitGatewayVpcAttachmentRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTransitGatewayVpcAttachmentRequest#builder()}
     * </p>
     *
     * @param deleteTransitGatewayVpcAttachmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTransitGatewayVpcAttachmentResponse deleteTransitGatewayVpcAttachment(
            Consumer<DeleteTransitGatewayVpcAttachmentRequest.Builder> deleteTransitGatewayVpcAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteTransitGatewayVpcAttachment(DeleteTransitGatewayVpcAttachmentRequest.builder()
                .applyMutation(deleteTransitGatewayVpcAttachmentRequest).build());
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access endpoint.
     * </p>
     *
     * @param deleteVerifiedAccessEndpointRequest
     * @return Result of the DeleteVerifiedAccessEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedAccessEndpointResponse deleteVerifiedAccessEndpoint(
            DeleteVerifiedAccessEndpointRequest deleteVerifiedAccessEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedAccessEndpointRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVerifiedAccessEndpointRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedAccessEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVerifiedAccessEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedAccessEndpointResponse deleteVerifiedAccessEndpoint(
            Consumer<DeleteVerifiedAccessEndpointRequest.Builder> deleteVerifiedAccessEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVerifiedAccessEndpoint(DeleteVerifiedAccessEndpointRequest.builder()
                .applyMutation(deleteVerifiedAccessEndpointRequest).build());
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access group.
     * </p>
     *
     * @param deleteVerifiedAccessGroupRequest
     * @return Result of the DeleteVerifiedAccessGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVerifiedAccessGroupResponse deleteVerifiedAccessGroup(
            DeleteVerifiedAccessGroupRequest deleteVerifiedAccessGroupRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedAccessGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVerifiedAccessGroupRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedAccessGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVerifiedAccessGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVerifiedAccessGroupResponse deleteVerifiedAccessGroup(
            Consumer<DeleteVerifiedAccessGroupRequest.Builder> deleteVerifiedAccessGroupRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteVerifiedAccessGroup(DeleteVerifiedAccessGroupRequest.builder()
                .applyMutation(deleteVerifiedAccessGroupRequest).build());
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access instance.
     * </p>
     *
     * @param deleteVerifiedAccessInstanceRequest
     * @return Result of the DeleteVerifiedAccessInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedAccessInstanceResponse deleteVerifiedAccessInstance(
            DeleteVerifiedAccessInstanceRequest deleteVerifiedAccessInstanceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedAccessInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVerifiedAccessInstanceRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedAccessInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVerifiedAccessInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedAccessInstanceResponse deleteVerifiedAccessInstance(
            Consumer<DeleteVerifiedAccessInstanceRequest.Builder> deleteVerifiedAccessInstanceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVerifiedAccessInstance(DeleteVerifiedAccessInstanceRequest.builder()
                .applyMutation(deleteVerifiedAccessInstanceRequest).build());
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access trust provider.
     * </p>
     *
     * @param deleteVerifiedAccessTrustProviderRequest
     * @return Result of the DeleteVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedAccessTrustProviderResponse deleteVerifiedAccessTrustProvider(
            DeleteVerifiedAccessTrustProviderRequest deleteVerifiedAccessTrustProviderRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access trust provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVerifiedAccessTrustProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVerifiedAccessTrustProviderRequest#builder()}
     * </p>
     *
     * @param deleteVerifiedAccessTrustProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVerifiedAccessTrustProviderResponse deleteVerifiedAccessTrustProvider(
            Consumer<DeleteVerifiedAccessTrustProviderRequest.Builder> deleteVerifiedAccessTrustProviderRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVerifiedAccessTrustProvider(DeleteVerifiedAccessTrustProviderRequest.builder()
                .applyMutation(deleteVerifiedAccessTrustProviderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-volume.html">Delete an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param deleteVolumeRequest
     * @return Result of the DeleteVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVolumeResponse deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-volume.html">Delete an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVolumeRequest#builder()}
     * </p>
     *
     * @param deleteVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest.Builder} to create a request.
     * @return Result of the DeleteVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVolumeResponse deleteVolume(Consumer<DeleteVolumeRequest.Builder> deleteVolumeRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVolume(DeleteVolumeRequest.builder().applyMutation(deleteVolumeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on. When you delete the VPC, it deletes the default security group, network ACL, and
     * route table for the VPC.
     * </p>
     * <p>
     * If you created a flow log for the VPC that you are deleting, note that flow logs for deleted VPCs are eventually
     * automatically removed.
     * </p>
     *
     * @param deleteVpcRequest
     * @return Result of the DeleteVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpcResponse deleteVpc(DeleteVpcRequest deleteVpcRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on. When you delete the VPC, it deletes the default security group, network ACL, and
     * route table for the VPC.
     * </p>
     * <p>
     * If you created a flow log for the VPC that you are deleting, note that flow logs for deleted VPCs are eventually
     * automatically removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVpcRequest#builder()}
     * </p>
     *
     * @param deleteVpcRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpcRequest.Builder} to create a request.
     * @return Result of the DeleteVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpcResponse deleteVpc(Consumer<DeleteVpcRequest.Builder> deleteVpcRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteVpc(DeleteVpcRequest.builder().applyMutation(deleteVpcRequest).build());
    }

    /**
     * <p>
     * Delete a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single
     * VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You
     * can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there
     * is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param deleteVpcBlockPublicAccessExclusionRequest
     * @return Result of the DeleteVpcBlockPublicAccessExclusion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcBlockPublicAccessExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcBlockPublicAccessExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcBlockPublicAccessExclusionResponse deleteVpcBlockPublicAccessExclusion(
            DeleteVpcBlockPublicAccessExclusionRequest deleteVpcBlockPublicAccessExclusionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single
     * VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You
     * can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there
     * is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcBlockPublicAccessExclusionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVpcBlockPublicAccessExclusionRequest#builder()}
     * </p>
     *
     * @param deleteVpcBlockPublicAccessExclusionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpcBlockPublicAccessExclusionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteVpcBlockPublicAccessExclusion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcBlockPublicAccessExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcBlockPublicAccessExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcBlockPublicAccessExclusionResponse deleteVpcBlockPublicAccessExclusion(
            Consumer<DeleteVpcBlockPublicAccessExclusionRequest.Builder> deleteVpcBlockPublicAccessExclusionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVpcBlockPublicAccessExclusion(DeleteVpcBlockPublicAccessExclusionRequest.builder()
                .applyMutation(deleteVpcBlockPublicAccessExclusionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPC endpoint connection notifications.
     * </p>
     *
     * @param deleteVpcEndpointConnectionNotificationsRequest
     * @return Result of the DeleteVpcEndpointConnectionNotifications operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpointConnectionNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointConnectionNotificationsResponse deleteVpcEndpointConnectionNotifications(
            DeleteVpcEndpointConnectionNotificationsRequest deleteVpcEndpointConnectionNotificationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPC endpoint connection notifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVpcEndpointConnectionNotificationsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVpcEndpointConnectionNotificationsRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointConnectionNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteVpcEndpointConnectionNotifications operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpointConnectionNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointConnectionNotificationsResponse deleteVpcEndpointConnectionNotifications(
            Consumer<DeleteVpcEndpointConnectionNotificationsRequest.Builder> deleteVpcEndpointConnectionNotificationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVpcEndpointConnectionNotifications(DeleteVpcEndpointConnectionNotificationsRequest.builder()
                .applyMutation(deleteVpcEndpointConnectionNotificationsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPC endpoint service configurations. Before you can delete an endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     *
     * @param deleteVpcEndpointServiceConfigurationsRequest
     * @return Result of the DeleteVpcEndpointServiceConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpointServiceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointServiceConfigurationsResponse deleteVpcEndpointServiceConfigurations(
            DeleteVpcEndpointServiceConfigurationsRequest deleteVpcEndpointServiceConfigurationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPC endpoint service configurations. Before you can delete an endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVpcEndpointServiceConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVpcEndpointServiceConfigurationsRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointServiceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteVpcEndpointServiceConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpointServiceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointServiceConfigurationsResponse deleteVpcEndpointServiceConfigurations(
            Consumer<DeleteVpcEndpointServiceConfigurationsRequest.Builder> deleteVpcEndpointServiceConfigurationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVpcEndpointServiceConfigurations(DeleteVpcEndpointServiceConfigurationsRequest.builder()
                .applyMutation(deleteVpcEndpointServiceConfigurationsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPC endpoints.
     * </p>
     * <p>
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables for the endpoint.
     * </p>
     * <p>
     * When you delete a Gateway Load Balancer endpoint, we delete its endpoint network interfaces. You can only delete
     * Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * </p>
     * <p>
     * When you delete an interface endpoint, we delete its endpoint network interfaces.
     * </p>
     *
     * @param deleteVpcEndpointsRequest
     * @return Result of the DeleteVpcEndpoints operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpcEndpointsResponse deleteVpcEndpoints(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPC endpoints.
     * </p>
     * <p>
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables for the endpoint.
     * </p>
     * <p>
     * When you delete a Gateway Load Balancer endpoint, we delete its endpoint network interfaces. You can only delete
     * Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * </p>
     * <p>
     * When you delete an interface endpoint, we delete its endpoint network interfaces.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest.Builder} to create a request.
     * @return Result of the DeleteVpcEndpoints operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpcEndpointsResponse deleteVpcEndpoints(Consumer<DeleteVpcEndpointsRequest.Builder> deleteVpcEndpointsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVpcEndpoints(DeleteVpcEndpointsRequest.builder().applyMutation(deleteVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> or <code>rejected</code> state.
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     * @return Result of the DeleteVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> or <code>rejected</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnection(
            Consumer<DeleteVpcPeeringConnectionRequest.Builder> deleteVpcPeeringConnectionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest.builder()
                .applyMutation(deleteVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the
     * Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     *
     * @param deleteVpnConnectionRequest
     *        Contains the parameters for DeleteVpnConnection.
     * @return Result of the DeleteVpnConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpnConnectionResponse deleteVpnConnection(DeleteVpnConnectionRequest deleteVpnConnectionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the
     * Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpnConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVpnConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpnConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest.Builder} to create a request.
     *        Contains the parameters for DeleteVpnConnection.
     * @return Result of the DeleteVpnConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpnConnectionResponse deleteVpnConnection(
            Consumer<DeleteVpnConnectionRequest.Builder> deleteVpnConnectionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteVpnConnection(DeleteVpnConnectionRequest.builder().applyMutation(deleteVpnConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     *
     * @param deleteVpnConnectionRouteRequest
     *        Contains the parameters for DeleteVpnConnectionRoute.
     * @return Result of the DeleteVpnConnectionRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVpnConnectionRouteResponse deleteVpnConnectionRoute(
            DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpnConnectionRouteRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpnConnectionRouteRequest#builder()}
     * </p>
     *
     * @param deleteVpnConnectionRouteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest.Builder} to create a
     *        request. Contains the parameters for DeleteVpnConnectionRoute.
     * @return Result of the DeleteVpnConnectionRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVpnConnectionRouteResponse deleteVpnConnectionRoute(
            Consumer<DeleteVpnConnectionRouteRequest.Builder> deleteVpnConnectionRouteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deleteVpnConnectionRoute(DeleteVpnConnectionRouteRequest.builder().applyMutation(deleteVpnConnectionRouteRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     *
     * @param deleteVpnGatewayRequest
     *        Contains the parameters for DeleteVpnGateway.
     * @return Result of the DeleteVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpnGatewayResponse deleteVpnGateway(DeleteVpnGatewayRequest deleteVpnGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpnGatewayRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVpnGatewayRequest#builder()}
     * </p>
     *
     * @param deleteVpnGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest.Builder} to create a request.
     *        Contains the parameters for DeleteVpnGateway.
     * @return Result of the DeleteVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVpnGatewayResponse deleteVpnGateway(Consumer<DeleteVpnGatewayRequest.Builder> deleteVpnGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deleteVpnGateway(DeleteVpnGatewayRequest.builder().applyMutation(deleteVpnGatewayRequest).build());
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return Result of the DeprovisionByoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default DeprovisionByoipCidrResponse deprovisionByoipCidr(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionByoipCidrRequest.Builder} avoiding the
     * need to create one manually via {@link DeprovisionByoipCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest.Builder} to create a request.
     * @return Result of the DeprovisionByoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    default DeprovisionByoipCidrResponse deprovisionByoipCidr(
            Consumer<DeprovisionByoipCidrRequest.Builder> deprovisionByoipCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deprovisionByoipCidr(DeprovisionByoipCidrRequest.builder().applyMutation(deprovisionByoipCidrRequest).build());
    }

    /**
     * <p>
     * Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account. This action can only be
     * called after any BYOIP CIDR associations are removed from your Amazon Web Services account with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamByoasn.html"
     * >DisassociateIpamByoasn</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     *
     * @param deprovisionIpamByoasnRequest
     * @return Result of the DeprovisionIpamByoasn operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionIpamByoasn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    default DeprovisionIpamByoasnResponse deprovisionIpamByoasn(DeprovisionIpamByoasnRequest deprovisionIpamByoasnRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account. This action can only be
     * called after any BYOIP CIDR associations are removed from your Amazon Web Services account with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamByoasn.html"
     * >DisassociateIpamByoasn</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionIpamByoasnRequest.Builder} avoiding the
     * need to create one manually via {@link DeprovisionIpamByoasnRequest#builder()}
     * </p>
     *
     * @param deprovisionIpamByoasnRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeprovisionIpamByoasnRequest.Builder} to create a
     *        request.
     * @return Result of the DeprovisionIpamByoasn operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionIpamByoasn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    default DeprovisionIpamByoasnResponse deprovisionIpamByoasn(
            Consumer<DeprovisionIpamByoasnRequest.Builder> deprovisionIpamByoasnRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deprovisionIpamByoasn(DeprovisionIpamByoasnRequest.builder().applyMutation(deprovisionIpamByoasnRequest).build());
    }

    /**
     * <p>
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool,
     * the CIDR is recycled back into the source pool. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deprovisionIpamPoolCidrRequest
     * @return Result of the DeprovisionIpamPoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr" target="_top">AWS
     *      API Documentation</a>
     */
    default DeprovisionIpamPoolCidrResponse deprovisionIpamPoolCidr(DeprovisionIpamPoolCidrRequest deprovisionIpamPoolCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool,
     * the CIDR is recycled back into the source pool. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionIpamPoolCidrRequest.Builder} avoiding
     * the need to create one manually via {@link DeprovisionIpamPoolCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionIpamPoolCidrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest.Builder} to create a
     *        request.
     * @return Result of the DeprovisionIpamPoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr" target="_top">AWS
     *      API Documentation</a>
     */
    default DeprovisionIpamPoolCidrResponse deprovisionIpamPoolCidr(
            Consumer<DeprovisionIpamPoolCidrRequest.Builder> deprovisionIpamPoolCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        return deprovisionIpamPoolCidr(DeprovisionIpamPoolCidrRequest.builder().applyMutation(deprovisionIpamPoolCidrRequest)
                .build());
    }

    /**
     * <p>
     * Deprovision a CIDR from a public IPv4 pool.
     * </p>
     *
     * @param deprovisionPublicIpv4PoolCidrRequest
     * @return Result of the DeprovisionPublicIpv4PoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionPublicIpv4PoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprovisionPublicIpv4PoolCidrResponse deprovisionPublicIpv4PoolCidr(
            DeprovisionPublicIpv4PoolCidrRequest deprovisionPublicIpv4PoolCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprovision a CIDR from a public IPv4 pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprovisionPublicIpv4PoolCidrRequest.Builder}
     * avoiding the need to create one manually via {@link DeprovisionPublicIpv4PoolCidrRequest#builder()}
     * </p>
     *
     * @param deprovisionPublicIpv4PoolCidrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest.Builder} to create a
     *        request.
     * @return Result of the DeprovisionPublicIpv4PoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionPublicIpv4PoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprovisionPublicIpv4PoolCidrResponse deprovisionPublicIpv4PoolCidr(
            Consumer<DeprovisionPublicIpv4PoolCidrRequest.Builder> deprovisionPublicIpv4PoolCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {
        return deprovisionPublicIpv4PoolCidr(DeprovisionPublicIpv4PoolCidrRequest.builder()
                .applyMutation(deprovisionPublicIpv4PoolCidrRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances.
     * </p>
     * <p>
     * If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for
     * the specified retention period. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     * <p>
     * When you deregister an AMI, it doesn't affect any instances that you've already launched from the AMI. You'll
     * continue to incur usage costs for those instances until you terminate them.
     * </p>
     * <p>
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume
     * of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
     * affect the files that you uploaded to Amazon S3 when you created the AMI.
     * </p>
     *
     * @param deregisterImageRequest
     *        Contains the parameters for DeregisterImage.
     * @return Result of the DeregisterImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeregisterImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeregisterImageResponse deregisterImage(DeregisterImageRequest deregisterImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances.
     * </p>
     * <p>
     * If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for
     * the specified retention period. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     