/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateIpamResourceDiscoveryResponse extends Ec2Response implements
        ToCopyableBuilder<AssociateIpamResourceDiscoveryResponse.Builder, AssociateIpamResourceDiscoveryResponse> {
    private static final SdkField<IpamResourceDiscoveryAssociation> IPAM_RESOURCE_DISCOVERY_ASSOCIATION_FIELD = SdkField
            .<IpamResourceDiscoveryAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("IpamResourceDiscoveryAssociation")
            .getter(getter(AssociateIpamResourceDiscoveryResponse::ipamResourceDiscoveryAssociation))
            .setter(setter(Builder::ipamResourceDiscoveryAssociation))
            .constructor(IpamResourceDiscoveryAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryAssociation")
                    .unmarshallLocationName("ipamResourceDiscoveryAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IPAM_RESOURCE_DISCOVERY_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpamResourceDiscoveryAssociation ipamResourceDiscoveryAssociation;

    private AssociateIpamResourceDiscoveryResponse(BuilderImpl builder) {
        super(builder);
        this.ipamResourceDiscoveryAssociation = builder.ipamResourceDiscoveryAssociation;
    }

    /**
     * <p>
     * A resource discovery association. An associated resource discovery is a resource discovery that has been
     * associated with an IPAM.
     * </p>
     * 
     * @return A resource discovery association. An associated resource discovery is a resource discovery that has been
     *         associated with an IPAM.
     */
    public final IpamResourceDiscoveryAssociation ipamResourceDiscoveryAssociation() {
        return ipamResourceDiscoveryAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipamResourceDiscoveryAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateIpamResourceDiscoveryResponse)) {
            return false;
        }
        AssociateIpamResourceDiscoveryResponse other = (AssociateIpamResourceDiscoveryResponse) obj;
        return Objects.equals(ipamResourceDiscoveryAssociation(), other.ipamResourceDiscoveryAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateIpamResourceDiscoveryResponse")
                .add("IpamResourceDiscoveryAssociation", ipamResourceDiscoveryAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamResourceDiscoveryAssociation":
            return Optional.ofNullable(clazz.cast(ipamResourceDiscoveryAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamResourceDiscoveryAssociation", IPAM_RESOURCE_DISCOVERY_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateIpamResourceDiscoveryResponse, T> g) {
        return obj -> g.apply((AssociateIpamResourceDiscoveryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateIpamResourceDiscoveryResponse> {
        /**
         * <p>
         * A resource discovery association. An associated resource discovery is a resource discovery that has been
         * associated with an IPAM.
         * </p>
         * 
         * @param ipamResourceDiscoveryAssociation
         *        A resource discovery association. An associated resource discovery is a resource discovery that has
         *        been associated with an IPAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamResourceDiscoveryAssociation(IpamResourceDiscoveryAssociation ipamResourceDiscoveryAssociation);

        /**
         * <p>
         * A resource discovery association. An associated resource discovery is a resource discovery that has been
         * associated with an IPAM.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamResourceDiscoveryAssociation.Builder}
         * avoiding the need to create one manually via {@link IpamResourceDiscoveryAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamResourceDiscoveryAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #ipamResourceDiscoveryAssociation(IpamResourceDiscoveryAssociation)}.
         * 
         * @param ipamResourceDiscoveryAssociation
         *        a consumer that will call methods on {@link IpamResourceDiscoveryAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamResourceDiscoveryAssociation(IpamResourceDiscoveryAssociation)
         */
        default Builder ipamResourceDiscoveryAssociation(
                Consumer<IpamResourceDiscoveryAssociation.Builder> ipamResourceDiscoveryAssociation) {
            return ipamResourceDiscoveryAssociation(IpamResourceDiscoveryAssociation.builder()
                    .applyMutation(ipamResourceDiscoveryAssociation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private IpamResourceDiscoveryAssociation ipamResourceDiscoveryAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateIpamResourceDiscoveryResponse model) {
            super(model);
            ipamResourceDiscoveryAssociation(model.ipamResourceDiscoveryAssociation);
        }

        public final IpamResourceDiscoveryAssociation.Builder getIpamResourceDiscoveryAssociation() {
            return ipamResourceDiscoveryAssociation != null ? ipamResourceDiscoveryAssociation.toBuilder() : null;
        }

        public final void setIpamResourceDiscoveryAssociation(
                IpamResourceDiscoveryAssociation.BuilderImpl ipamResourceDiscoveryAssociation) {
            this.ipamResourceDiscoveryAssociation = ipamResourceDiscoveryAssociation != null ? ipamResourceDiscoveryAssociation
                    .build() : null;
        }

        @Override
        public final Builder ipamResourceDiscoveryAssociation(IpamResourceDiscoveryAssociation ipamResourceDiscoveryAssociation) {
            this.ipamResourceDiscoveryAssociation = ipamResourceDiscoveryAssociation;
            return this;
        }

        @Override
        public AssociateIpamResourceDiscoveryResponse build() {
            return new AssociateIpamResourceDiscoveryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
