/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClientVpnEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<CreateClientVpnEndpointRequest.Builder, CreateClientVpnEndpointRequest> {
    private static final SdkField<String> CLIENT_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientCidrBlock")
            .getter(getter(CreateClientVpnEndpointRequest::clientCidrBlock))
            .setter(setter(Builder::clientCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCidrBlock")
                    .unmarshallLocationName("ClientCidrBlock").build()).build();

    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerCertificateArn")
            .getter(getter(CreateClientVpnEndpointRequest::serverCertificateArn))
            .setter(setter(Builder::serverCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn")
                    .unmarshallLocationName("ServerCertificateArn").build()).build();

    private static final SdkField<List<ClientVpnAuthenticationRequest>> AUTHENTICATION_OPTIONS_FIELD = SdkField
            .<List<ClientVpnAuthenticationRequest>> builder(MarshallingType.LIST)
            .memberName("AuthenticationOptions")
            .getter(getter(CreateClientVpnEndpointRequest::authenticationOptions))
            .setter(setter(Builder::authenticationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication")
                    .unmarshallLocationName("Authentication").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClientVpnAuthenticationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClientVpnAuthenticationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<ConnectionLogOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField
            .<ConnectionLogOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionLogOptions")
            .getter(getter(CreateClientVpnEndpointRequest::connectionLogOptions))
            .setter(setter(Builder::connectionLogOptions))
            .constructor(ConnectionLogOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions")
                    .unmarshallLocationName("ConnectionLogOptions").build()).build();

    private static final SdkField<List<String>> DNS_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsServers")
            .getter(getter(CreateClientVpnEndpointRequest::dnsServers))
            .setter(setter(Builder::dnsServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers")
                    .unmarshallLocationName("DnsServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> TRANSPORT_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransportProtocol")
            .getter(getter(CreateClientVpnEndpointRequest::transportProtocolAsString))
            .setter(setter(Builder::transportProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportProtocol")
                    .unmarshallLocationName("TransportProtocol").build()).build();

    private static final SdkField<Integer> VPN_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VpnPort")
            .getter(getter(CreateClientVpnEndpointRequest::vpnPort))
            .setter(setter(Builder::vpnPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnPort")
                    .unmarshallLocationName("VpnPort").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateClientVpnEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> SPLIT_TUNNEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SplitTunnel")
            .getter(getter(CreateClientVpnEndpointRequest::splitTunnel))
            .setter(setter(Builder::splitTunnel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitTunnel")
                    .unmarshallLocationName("SplitTunnel").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateClientVpnEndpointRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateClientVpnEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateClientVpnEndpointRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateClientVpnEndpointRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId")
                    .unmarshallLocationName("SecurityGroupId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(CreateClientVpnEndpointRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final SdkField<String> SELF_SERVICE_PORTAL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SelfServicePortal")
            .getter(getter(CreateClientVpnEndpointRequest::selfServicePortalAsString))
            .setter(setter(Builder::selfServicePortal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServicePortal")
                    .unmarshallLocationName("SelfServicePortal").build()).build();

    private static final SdkField<ClientConnectOptions> CLIENT_CONNECT_OPTIONS_FIELD = SdkField
            .<ClientConnectOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ClientConnectOptions")
            .getter(getter(CreateClientVpnEndpointRequest::clientConnectOptions))
            .setter(setter(Builder::clientConnectOptions))
            .constructor(ClientConnectOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConnectOptions")
                    .unmarshallLocationName("ClientConnectOptions").build()).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionTimeoutHours")
            .getter(getter(CreateClientVpnEndpointRequest::sessionTimeoutHours))
            .setter(setter(Builder::sessionTimeoutHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutHours")
                    .unmarshallLocationName("SessionTimeoutHours").build()).build();

    private static final SdkField<ClientLoginBannerOptions> CLIENT_LOGIN_BANNER_OPTIONS_FIELD = SdkField
            .<ClientLoginBannerOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ClientLoginBannerOptions")
            .getter(getter(CreateClientVpnEndpointRequest::clientLoginBannerOptions))
            .setter(setter(Builder::clientLoginBannerOptions))
            .constructor(ClientLoginBannerOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientLoginBannerOptions")
                    .unmarshallLocationName("ClientLoginBannerOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CIDR_BLOCK_FIELD,
            SERVER_CERTIFICATE_ARN_FIELD, AUTHENTICATION_OPTIONS_FIELD, CONNECTION_LOG_OPTIONS_FIELD, DNS_SERVERS_FIELD,
            TRANSPORT_PROTOCOL_FIELD, VPN_PORT_FIELD, DESCRIPTION_FIELD, SPLIT_TUNNEL_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD,
            TAG_SPECIFICATIONS_FIELD, SECURITY_GROUP_IDS_FIELD, VPC_ID_FIELD, SELF_SERVICE_PORTAL_FIELD,
            CLIENT_CONNECT_OPTIONS_FIELD, SESSION_TIMEOUT_HOURS_FIELD, CLIENT_LOGIN_BANNER_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientCidrBlock;

    private final String serverCertificateArn;

    private final List<ClientVpnAuthenticationRequest> authenticationOptions;

    private final ConnectionLogOptions connectionLogOptions;

    private final List<String> dnsServers;

    private final String transportProtocol;

    private final Integer vpnPort;

    private final String description;

    private final Boolean splitTunnel;

    private final Boolean dryRun;

    private final String clientToken;

    private final List<TagSpecification> tagSpecifications;

    private final List<String> securityGroupIds;

    private final String vpcId;

    private final String selfServicePortal;

    private final ClientConnectOptions clientConnectOptions;

    private final Integer sessionTimeoutHours;

    private final ClientLoginBannerOptions clientLoginBannerOptions;

    private CreateClientVpnEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.clientCidrBlock = builder.clientCidrBlock;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.authenticationOptions = builder.authenticationOptions;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.dnsServers = builder.dnsServers;
        this.transportProtocol = builder.transportProtocol;
        this.vpnPort = builder.vpnPort;
        this.description = builder.description;
        this.splitTunnel = builder.splitTunnel;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
        this.selfServicePortal = builder.selfServicePortal;
        this.clientConnectOptions = builder.clientConnectOptions;
        this.sessionTimeoutHours = builder.sessionTimeoutHours;
        this.clientLoginBannerOptions = builder.clientLoginBannerOptions;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot
     * overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add
     * manually. The address range cannot be changed after the Client VPN endpoint has been created. Client CIDR range
     * must have a size of at least /22 and must not be greater than /12.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range
     *         cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes
     *         that you add manually. The address range cannot be changed after the Client VPN endpoint has been
     *         created. Client CIDR range must have a size of at least /22 and must not be greater than /12.
     */
    public final String clientCidrBlock() {
        return clientCidrBlock;
    }

    /**
     * <p>
     * The ARN of the server certificate. For more information, see the <a
     * href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.
     * </p>
     * 
     * @return The ARN of the server certificate. For more information, see the <a
     *         href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.
     */
    public final String serverCertificateArn() {
        return serverCertificateArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticationOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthenticationOptions() {
        return authenticationOptions != null && !(authenticationOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the authentication method to be used to authenticate clients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationOptions} method.
     * </p>
     * 
     * @return Information about the authentication method to be used to authenticate clients.
     */
    public final List<ClientVpnAuthenticationRequest> authenticationOptions() {
        return authenticationOptions;
    }

    /**
     * <p>
     * Information about the client connection logging options.
     * </p>
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream.
     * The following information is logged:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection results (successful and unsuccessful)
     * </p>
     * </li>
     * <li>
     * <p>
     * Reasons for unsuccessful client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection termination time
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the client connection logging options.</p>
     *         <p>
     *         If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
     *         stream. The following information is logged:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection results (successful and unsuccessful)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reasons for unsuccessful client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection termination time
     *         </p>
     *         </li>
     */
    public final ConnectionLogOptions connectionLogOptions() {
        return connectionLogOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsServers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDnsServers() {
        return dnsServers != null && !(dnsServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS
     * servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsServers} method.
     * </p>
     * 
     * @return Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two
     *         DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS
     *         server.
     */
    public final List<String> dnsServers() {
        return dnsServers;
    }

    /**
     * <p>
     * The transport protocol to be used by the VPN session.
     * </p>
     * <p>
     * Default value: <code>udp</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transportProtocol}
     * will return {@link TransportProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transportProtocolAsString}.
     * </p>
     * 
     * @return The transport protocol to be used by the VPN session.</p>
     *         <p>
     *         Default value: <code>udp</code>
     * @see TransportProtocol
     */
    public final TransportProtocol transportProtocol() {
        return TransportProtocol.fromValue(transportProtocol);
    }

    /**
     * <p>
     * The transport protocol to be used by the VPN session.
     * </p>
     * <p>
     * Default value: <code>udp</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transportProtocol}
     * will return {@link TransportProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transportProtocolAsString}.
     * </p>
     * 
     * @return The transport protocol to be used by the VPN session.</p>
     *         <p>
     *         Default value: <code>udp</code>
     * @see TransportProtocol
     */
    public final String transportProtocolAsString() {
        return transportProtocol;
    }

    /**
     * <p>
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     * </p>
     * <p>
     * Valid Values: <code>443</code> | <code>1194</code>
     * </p>
     * <p>
     * Default Value: <code>443</code>
     * </p>
     * 
     * @return The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
     *         <p>
     *         Valid Values: <code>443</code> | <code>1194</code>
     *         </p>
     *         <p>
     *         Default Value: <code>443</code>
     */
    public final Integer vpnPort() {
        return vpnPort;
    }

    /**
     * <p>
     * A brief description of the Client VPN endpoint.
     * </p>
     * 
     * @return A brief description of the Client VPN endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether split-tunnel is enabled on the Client VPN endpoint.
     * </p>
     * <p>
     * By default, split-tunnel on a VPN endpoint is disabled.
     * </p>
     * <p>
     * For information about split-tunnel VPN endpoints, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN
     * endpoint</a> in the <i>Client VPN Administrator Guide</i>.
     * </p>
     * 
     * @return Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p>
     *         <p>
     *         By default, split-tunnel on a VPN endpoint is disabled.
     *         </p>
     *         <p>
     *         For information about split-tunnel VPN endpoints, see <a
     *         href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client
     *         VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.
     */
    public final Boolean splitTunnel() {
        return splitTunnel;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the Client VPN endpoint during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the Client VPN endpoint during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC
     * that contains the security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of one or more security groups to apply to the target network. You must also specify the ID of
     *         the VPC that contains the security groups.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the
     * request, the default security group for the VPC is applied.
     * </p>
     * 
     * @return The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in
     *         the request, the default security group for the VPC is applied.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * </p>
     * <p>
     * Default Value: <code>enabled</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selfServicePortal}
     * will return {@link SelfServicePortal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selfServicePortalAsString}.
     * </p>
     * 
     * @return Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
     *         <p>
     *         Default Value: <code>enabled</code>
     * @see SelfServicePortal
     */
    public final SelfServicePortal selfServicePortal() {
        return SelfServicePortal.fromValue(selfServicePortal);
    }

    /**
     * <p>
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * </p>
     * <p>
     * Default Value: <code>enabled</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selfServicePortal}
     * will return {@link SelfServicePortal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selfServicePortalAsString}.
     * </p>
     * 
     * @return Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
     *         <p>
     *         Default Value: <code>enabled</code>
     * @see SelfServicePortal
     */
    public final String selfServicePortalAsString() {
        return selfServicePortal;
    }

    /**
     * <p>
     * The options for managing connection authorization for new client connections.
     * </p>
     * 
     * @return The options for managing connection authorization for new client connections.
     */
    public final ClientConnectOptions clientConnectOptions() {
        return clientConnectOptions;
    }

    /**
     * <p>
     * The maximum VPN session duration time in hours.
     * </p>
     * <p>
     * Valid values: <code>8 | 10 | 12 | 24</code>
     * </p>
     * <p>
     * Default value: <code>24</code>
     * </p>
     * 
     * @return The maximum VPN session duration time in hours.</p>
     *         <p>
     *         Valid values: <code>8 | 10 | 12 | 24</code>
     *         </p>
     *         <p>
     *         Default value: <code>24</code>
     */
    public final Integer sessionTimeoutHours() {
        return sessionTimeoutHours;
    }

    /**
     * <p>
     * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients
     * when a VPN session is established.
     * </p>
     * 
     * @return Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
     *         clients when a VPN session is established.
     */
    public final ClientLoginBannerOptions clientLoginBannerOptions() {
        return clientLoginBannerOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticationOptions() ? authenticationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsServers() ? dnsServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transportProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpnPort());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(splitTunnel());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(selfServicePortalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientConnectOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutHours());
        hashCode = 31 * hashCode + Objects.hashCode(clientLoginBannerOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClientVpnEndpointRequest)) {
            return false;
        }
        CreateClientVpnEndpointRequest other = (CreateClientVpnEndpointRequest) obj;
        return Objects.equals(clientCidrBlock(), other.clientCidrBlock())
                && Objects.equals(serverCertificateArn(), other.serverCertificateArn())
                && hasAuthenticationOptions() == other.hasAuthenticationOptions()
                && Objects.equals(authenticationOptions(), other.authenticationOptions())
                && Objects.equals(connectionLogOptions(), other.connectionLogOptions())
                && hasDnsServers() == other.hasDnsServers() && Objects.equals(dnsServers(), other.dnsServers())
                && Objects.equals(transportProtocolAsString(), other.transportProtocolAsString())
                && Objects.equals(vpnPort(), other.vpnPort()) && Objects.equals(description(), other.description())
                && Objects.equals(splitTunnel(), other.splitTunnel()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(clientToken(), other.clientToken()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(selfServicePortalAsString(), other.selfServicePortalAsString())
                && Objects.equals(clientConnectOptions(), other.clientConnectOptions())
                && Objects.equals(sessionTimeoutHours(), other.sessionTimeoutHours())
                && Objects.equals(clientLoginBannerOptions(), other.clientLoginBannerOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClientVpnEndpointRequest").add("ClientCidrBlock", clientCidrBlock())
                .add("ServerCertificateArn", serverCertificateArn())
                .add("AuthenticationOptions", hasAuthenticationOptions() ? authenticationOptions() : null)
                .add("ConnectionLogOptions", connectionLogOptions()).add("DnsServers", hasDnsServers() ? dnsServers() : null)
                .add("TransportProtocol", transportProtocolAsString()).add("VpnPort", vpnPort())
                .add("Description", description()).add("SplitTunnel", splitTunnel()).add("DryRun", dryRun())
                .add("ClientToken", clientToken()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("VpcId", vpcId())
                .add("SelfServicePortal", selfServicePortalAsString()).add("ClientConnectOptions", clientConnectOptions())
                .add("SessionTimeoutHours", sessionTimeoutHours()).add("ClientLoginBannerOptions", clientLoginBannerOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientCidrBlock":
            return Optional.ofNullable(clazz.cast(clientCidrBlock()));
        case "ServerCertificateArn":
            return Optional.ofNullable(clazz.cast(serverCertificateArn()));
        case "AuthenticationOptions":
            return Optional.ofNullable(clazz.cast(authenticationOptions()));
        case "ConnectionLogOptions":
            return Optional.ofNullable(clazz.cast(connectionLogOptions()));
        case "DnsServers":
            return Optional.ofNullable(clazz.cast(dnsServers()));
        case "TransportProtocol":
            return Optional.ofNullable(clazz.cast(transportProtocolAsString()));
        case "VpnPort":
            return Optional.ofNullable(clazz.cast(vpnPort()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SplitTunnel":
            return Optional.ofNullable(clazz.cast(splitTunnel()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SelfServicePortal":
            return Optional.ofNullable(clazz.cast(selfServicePortalAsString()));
        case "ClientConnectOptions":
            return Optional.ofNullable(clazz.cast(clientConnectOptions()));
        case "SessionTimeoutHours":
            return Optional.ofNullable(clazz.cast(sessionTimeoutHours()));
        case "ClientLoginBannerOptions":
            return Optional.ofNullable(clazz.cast(clientLoginBannerOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientCidrBlock", CLIENT_CIDR_BLOCK_FIELD);
        map.put("ServerCertificateArn", SERVER_CERTIFICATE_ARN_FIELD);
        map.put("Authentication", AUTHENTICATION_OPTIONS_FIELD);
        map.put("ConnectionLogOptions", CONNECTION_LOG_OPTIONS_FIELD);
        map.put("DnsServers", DNS_SERVERS_FIELD);
        map.put("TransportProtocol", TRANSPORT_PROTOCOL_FIELD);
        map.put("VpnPort", VPN_PORT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SplitTunnel", SPLIT_TUNNEL_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SelfServicePortal", SELF_SERVICE_PORTAL_FIELD);
        map.put("ClientConnectOptions", CLIENT_CONNECT_OPTIONS_FIELD);
        map.put("SessionTimeoutHours", SESSION_TIMEOUT_HOURS_FIELD);
        map.put("ClientLoginBannerOptions", CLIENT_LOGIN_BANNER_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClientVpnEndpointRequest, T> g) {
        return obj -> g.apply((CreateClientVpnEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateClientVpnEndpointRequest> {
        /**
         * <p>
         * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot
         * overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add
         * manually. The address range cannot be changed after the Client VPN endpoint has been created. Client CIDR
         * range must have a size of at least /22 and must not be greater than /12.
         * </p>
         * 
         * @param clientCidrBlock
         *        The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range
         *        cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes
         *        that you add manually. The address range cannot be changed after the Client VPN endpoint has been
         *        created. Client CIDR range must have a size of at least /22 and must not be greater than /12.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCidrBlock(String clientCidrBlock);

        /**
         * <p>
         * The ARN of the server certificate. For more information, see the <a
         * href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.
         * </p>
         * 
         * @param serverCertificateArn
         *        The ARN of the server certificate. For more information, see the <a
         *        href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateArn(String serverCertificateArn);

        /**
         * <p>
         * Information about the authentication method to be used to authenticate clients.
         * </p>
         * 
         * @param authenticationOptions
         *        Information about the authentication method to be used to authenticate clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationOptions(Collection<ClientVpnAuthenticationRequest> authenticationOptions);

        /**
         * <p>
         * Information about the authentication method to be used to authenticate clients.
         * </p>
         * 
         * @param authenticationOptions
         *        Information about the authentication method to be used to authenticate clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationOptions(ClientVpnAuthenticationRequest... authenticationOptions);

        /**
         * <p>
         * Information about the authentication method to be used to authenticate clients.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationOptions(List<ClientVpnAuthenticationRequest>)}.
         * 
         * @param authenticationOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationOptions(java.util.Collection<ClientVpnAuthenticationRequest>)
         */
        Builder authenticationOptions(Consumer<ClientVpnAuthenticationRequest.Builder>... authenticationOptions);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionLogOptions
         *        Information about the client connection logging options.</p>
         *        <p>
         *        If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs
         *        log stream. The following information is logged:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection results (successful and unsuccessful)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reasons for unsuccessful client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection termination time
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ConnectionLogOptions.Builder} avoiding
         * the need to create one manually via {@link ConnectionLogOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionLogOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionLogOptions(ConnectionLogOptions)}.
         * 
         * @param connectionLogOptions
         *        a consumer that will call methods on {@link ConnectionLogOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionLogOptions(ConnectionLogOptions)
         */
        default Builder connectionLogOptions(Consumer<ConnectionLogOptions.Builder> connectionLogOptions) {
            return connectionLogOptions(ConnectionLogOptions.builder().applyMutation(connectionLogOptions).build());
        }

        /**
         * <p>
         * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS
         * servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
         * </p>
         * 
         * @param dnsServers
         *        Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to
         *        two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for
         *        the DNS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(Collection<String> dnsServers);

        /**
         * <p>
         * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS
         * servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
         * </p>
         * 
         * @param dnsServers
         *        Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to
         *        two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for
         *        the DNS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(String... dnsServers);

        /**
         * <p>
         * The transport protocol to be used by the VPN session.
         * </p>
         * <p>
         * Default value: <code>udp</code>
         * </p>
         * 
         * @param transportProtocol
         *        The transport protocol to be used by the VPN session.</p>
         *        <p>
         *        Default value: <code>udp</code>
         * @see TransportProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransportProtocol
         */
        Builder transportProtocol(String transportProtocol);

        /**
         * <p>
         * The transport protocol to be used by the VPN session.
         * </p>
         * <p>
         * Default value: <code>udp</code>
         * </p>
         * 
         * @param transportProtocol
         *        The transport protocol to be used by the VPN session.</p>
         *        <p>
         *        Default value: <code>udp</code>
         * @see TransportProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransportProtocol
         */
        Builder transportProtocol(TransportProtocol transportProtocol);

        /**
         * <p>
         * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         * </p>
         * <p>
         * Valid Values: <code>443</code> | <code>1194</code>
         * </p>
         * <p>
         * Default Value: <code>443</code>
         * </p>
         * 
         * @param vpnPort
         *        The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
         *        <p>
         *        Valid Values: <code>443</code> | <code>1194</code>
         *        </p>
         *        <p>
         *        Default Value: <code>443</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnPort(Integer vpnPort);

        /**
         * <p>
         * A brief description of the Client VPN endpoint.
         * </p>
         * 
         * @param description
         *        A brief description of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether split-tunnel is enabled on the Client VPN endpoint.
         * </p>
         * <p>
         * By default, split-tunnel on a VPN endpoint is disabled.
         * </p>
         * <p>
         * For information about split-tunnel VPN endpoints, see <a
         * href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN
         * endpoint</a> in the <i>Client VPN Administrator Guide</i>.
         * </p>
         * 
         * @param splitTunnel
         *        Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p>
         *        <p>
         *        By default, split-tunnel on a VPN endpoint is disabled.
         *        </p>
         *        <p>
         *        For information about split-tunnel VPN endpoints, see <a
         *        href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel
         *        Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitTunnel(Boolean splitTunnel);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to apply to the Client VPN endpoint during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Client VPN endpoint during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Client VPN endpoint during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Client VPN endpoint during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Client VPN endpoint during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the
         * VPC that contains the security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups to apply to the target network. You must also specify the ID of
         *        the VPC that contains the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the
         * VPC that contains the security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups to apply to the target network. You must also specify the ID of
         *        the VPC that contains the security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the
         * request, the default security group for the VPC is applied.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in
         *        the request, the default security group for the VPC is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         * </p>
         * <p>
         * Default Value: <code>enabled</code>
         * </p>
         * 
         * @param selfServicePortal
         *        Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
         *        <p>
         *        Default Value: <code>enabled</code>
         * @see SelfServicePortal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfServicePortal
         */
        Builder selfServicePortal(String selfServicePortal);

        /**
         * <p>
         * Specify whether to enable the self-service portal for the Client VPN endpoint.
         * </p>
         * <p>
         * Default Value: <code>enabled</code>
         * </p>
         * 
         * @param selfServicePortal
         *        Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
         *        <p>
         *        Default Value: <code>enabled</code>
         * @see SelfServicePortal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfServicePortal
         */
        Builder selfServicePortal(SelfServicePortal selfServicePortal);

        /**
         * <p>
         * The options for managing connection authorization for new client connections.
         * </p>
         * 
         * @param clientConnectOptions
         *        The options for managing connection authorization for new client connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConnectOptions(ClientConnectOptions clientConnectOptions);

        /**
         * <p>
         * The options for managing connection authorization for new client connections.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientConnectOptions.Builder} avoiding
         * the need to create one manually via {@link ClientConnectOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientConnectOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #clientConnectOptions(ClientConnectOptions)}.
         * 
         * @param clientConnectOptions
         *        a consumer that will call methods on {@link ClientConnectOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientConnectOptions(ClientConnectOptions)
         */
        default Builder clientConnectOptions(Consumer<ClientConnectOptions.Builder> clientConnectOptions) {
            return clientConnectOptions(ClientConnectOptions.builder().applyMutation(clientConnectOptions).build());
        }

        /**
         * <p>
         * The maximum VPN session duration time in hours.
         * </p>
         * <p>
         * Valid values: <code>8 | 10 | 12 | 24</code>
         * </p>
         * <p>
         * Default value: <code>24</code>
         * </p>
         * 
         * @param sessionTimeoutHours
         *        The maximum VPN session duration time in hours.</p>
         *        <p>
         *        Valid values: <code>8 | 10 | 12 | 24</code>
         *        </p>
         *        <p>
         *        Default value: <code>24</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutHours(Integer sessionTimeoutHours);

        /**
         * <p>
         * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         * clients when a VPN session is established.
         * </p>
         * 
         * @param clientLoginBannerOptions
         *        Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         *        clients when a VPN session is established.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientLoginBannerOptions(ClientLoginBannerOptions clientLoginBannerOptions);

        /**
         * <p>
         * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         * clients when a VPN session is established.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientLoginBannerOptions.Builder}
         * avoiding the need to create one manually via {@link ClientLoginBannerOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientLoginBannerOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #clientLoginBannerOptions(ClientLoginBannerOptions)}.
         * 
         * @param clientLoginBannerOptions
         *        a consumer that will call methods on {@link ClientLoginBannerOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientLoginBannerOptions(ClientLoginBannerOptions)
         */
        default Builder clientLoginBannerOptions(Consumer<ClientLoginBannerOptions.Builder> clientLoginBannerOptions) {
            return clientLoginBannerOptions(ClientLoginBannerOptions.builder().applyMutation(clientLoginBannerOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientCidrBlock;

        private String serverCertificateArn;

        private List<ClientVpnAuthenticationRequest> authenticationOptions = DefaultSdkAutoConstructList.getInstance();

        private ConnectionLogOptions connectionLogOptions;

        private List<String> dnsServers = DefaultSdkAutoConstructList.getInstance();

        private String transportProtocol;

        private Integer vpnPort;

        private String description;

        private Boolean splitTunnel;

        private Boolean dryRun;

        private String clientToken;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private String selfServicePortal;

        private ClientConnectOptions clientConnectOptions;

        private Integer sessionTimeoutHours;

        private ClientLoginBannerOptions clientLoginBannerOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClientVpnEndpointRequest model) {
            super(model);
            clientCidrBlock(model.clientCidrBlock);
            serverCertificateArn(model.serverCertificateArn);
            authenticationOptions(model.authenticationOptions);
            connectionLogOptions(model.connectionLogOptions);
            dnsServers(model.dnsServers);
            transportProtocol(model.transportProtocol);
            vpnPort(model.vpnPort);
            description(model.description);
            splitTunnel(model.splitTunnel);
            dryRun(model.dryRun);
            clientToken(model.clientToken);
            tagSpecifications(model.tagSpecifications);
            securityGroupIds(model.securityGroupIds);
            vpcId(model.vpcId);
            selfServicePortal(model.selfServicePortal);
            clientConnectOptions(model.clientConnectOptions);
            sessionTimeoutHours(model.sessionTimeoutHours);
            clientLoginBannerOptions(model.clientLoginBannerOptions);
        }

        public final String getClientCidrBlock() {
            return clientCidrBlock;
        }

        public final void setClientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
        }

        @Override
        public final Builder clientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public final String getServerCertificateArn() {
            return serverCertificateArn;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final List<ClientVpnAuthenticationRequest.Builder> getAuthenticationOptions() {
            List<ClientVpnAuthenticationRequest.Builder> result = ClientVpnAuthenticationRequestListCopier
                    .copyToBuilder(this.authenticationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationOptions(Collection<ClientVpnAuthenticationRequest.BuilderImpl> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationRequestListCopier.copyFromBuilder(authenticationOptions);
        }

        @Override
        public final Builder authenticationOptions(Collection<ClientVpnAuthenticationRequest> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationRequestListCopier.copy(authenticationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(ClientVpnAuthenticationRequest... authenticationOptions) {
            authenticationOptions(Arrays.asList(authenticationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(Consumer<ClientVpnAuthenticationRequest.Builder>... authenticationOptions) {
            authenticationOptions(Stream.of(authenticationOptions)
                    .map(c -> ClientVpnAuthenticationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConnectionLogOptions.Builder getConnectionLogOptions() {
            return connectionLogOptions != null ? connectionLogOptions.toBuilder() : null;
        }

        public final void setConnectionLogOptions(ConnectionLogOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final Collection<String> getDnsServers() {
            if (dnsServers instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsServers;
        }

        public final void setDnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
        }

        @Override
        public final Builder dnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServers(String... dnsServers) {
            dnsServers(Arrays.asList(dnsServers));
            return this;
        }

        public final String getTransportProtocol() {
            return transportProtocol;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        @Override
        public final Builder transportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol(transportProtocol == null ? null : transportProtocol.toString());
            return this;
        }

        public final Integer getVpnPort() {
            return vpnPort;
        }

        public final void setVpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
        }

        @Override
        public final Builder vpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getSplitTunnel() {
            return splitTunnel;
        }

        public final void setSplitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
        }

        @Override
        public final Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ClientVpnSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ClientVpnSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSelfServicePortal() {
            return selfServicePortal;
        }

        public final void setSelfServicePortal(String selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
        }

        @Override
        public final Builder selfServicePortal(String selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
            return this;
        }

        @Override
        public final Builder selfServicePortal(SelfServicePortal selfServicePortal) {
            this.selfServicePortal(selfServicePortal == null ? null : selfServicePortal.toString());
            return this;
        }

        public final ClientConnectOptions.Builder getClientConnectOptions() {
            return clientConnectOptions != null ? clientConnectOptions.toBuilder() : null;
        }

        public final void setClientConnectOptions(ClientConnectOptions.BuilderImpl clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions != null ? clientConnectOptions.build() : null;
        }

        @Override
        public final Builder clientConnectOptions(ClientConnectOptions clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions;
            return this;
        }

        public final Integer getSessionTimeoutHours() {
            return sessionTimeoutHours;
        }

        public final void setSessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
        }

        @Override
        public final Builder sessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        public final ClientLoginBannerOptions.Builder getClientLoginBannerOptions() {
            return clientLoginBannerOptions != null ? clientLoginBannerOptions.toBuilder() : null;
        }

        public final void setClientLoginBannerOptions(ClientLoginBannerOptions.BuilderImpl clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions != null ? clientLoginBannerOptions.build() : null;
        }

        @Override
        public final Builder clientLoginBannerOptions(ClientLoginBannerOptions clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClientVpnEndpointRequest build() {
            return new CreateClientVpnEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
