/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplaceRootVolumeTaskRequest extends Ec2Request implements
        ToCopyableBuilder<CreateReplaceRootVolumeTaskRequest.Builder, CreateReplaceRootVolumeTaskRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(CreateReplaceRootVolumeTaskRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(CreateReplaceRootVolumeTaskRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateReplaceRootVolumeTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateReplaceRootVolumeTaskRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateReplaceRootVolumeTaskRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(CreateReplaceRootVolumeTaskRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<Boolean> DELETE_REPLACED_ROOT_VOLUME_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteReplacedRootVolume")
            .getter(getter(CreateReplaceRootVolumeTaskRequest::deleteReplacedRootVolume))
            .setter(setter(Builder::deleteReplacedRootVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteReplacedRootVolume")
                    .unmarshallLocationName("DeleteReplacedRootVolume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            SNAPSHOT_ID_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD, IMAGE_ID_FIELD,
            DELETE_REPLACED_ROOT_VOLUME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String snapshotId;

    private final String clientToken;

    private final Boolean dryRun;

    private final List<TagSpecification> tagSpecifications;

    private final String imageId;

    private final Boolean deleteReplacedRootVolume;

    private CreateReplaceRootVolumeTaskRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
        this.imageId = builder.imageId;
        this.deleteReplacedRootVolume = builder.deleteReplacedRootVolume;
    }

    /**
     * <p>
     * The ID of the instance for which to replace the root volume.
     * </p>
     * 
     * @return The ID of the instance for which to replace the root volume.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the snapshot from which to restore the replacement root volume. The specified snapshot must be a
     * snapshot that you previously created from the original root volume.
     * </p>
     * <p>
     * If you want to restore the replacement root volume to the initial launch state, or if you want to restore the
     * replacement root volume from an AMI, omit this parameter.
     * </p>
     * 
     * @return The ID of the snapshot from which to restore the replacement root volume. The specified snapshot must be
     *         a snapshot that you previously created from the original root volume.</p>
     *         <p>
     *         If you want to restore the replacement root volume to the initial launch state, or if you want to restore
     *         the replacement root volume from an AMI, omit this parameter.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a
     * client token, a randomly generated token is used for the request to ensure idempotency. For more information, see
     * <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not
     *         specify a client token, a randomly generated token is used for the request to ensure idempotency. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the root volume replacement task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the root volume replacement task.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * The ID of the AMI to use to restore the root volume. The specified AMI must have the same product code, billing
     * information, architecture type, and virtualization type as that of the instance.
     * </p>
     * <p>
     * If you want to restore the replacement volume from a specific snapshot, or if you want to restore it to its
     * launch state, omit this parameter.
     * </p>
     * 
     * @return The ID of the AMI to use to restore the root volume. The specified AMI must have the same product code,
     *         billing information, architecture type, and virtualization type as that of the instance.</p>
     *         <p>
     *         If you want to restore the replacement volume from a specific snapshot, or if you want to restore it to
     *         its launch state, omit this parameter.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Indicates whether to automatically delete the original root volume after the root volume replacement task
     * completes. To delete the original root volume, specify <code>true</code>. If you choose to keep the original root
     * volume after the replacement task completes, you must manually delete it when you no longer need it.
     * </p>
     * 
     * @return Indicates whether to automatically delete the original root volume after the root volume replacement task
     *         completes. To delete the original root volume, specify <code>true</code>. If you choose to keep the
     *         original root volume after the replacement task completes, you must manually delete it when you no longer
     *         need it.
     */
    public final Boolean deleteReplacedRootVolume() {
        return deleteReplacedRootVolume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteReplacedRootVolume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplaceRootVolumeTaskRequest)) {
            return false;
        }
        CreateReplaceRootVolumeTaskRequest other = (CreateReplaceRootVolumeTaskRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(dryRun(), other.dryRun())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(deleteReplacedRootVolume(), other.deleteReplacedRootVolume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplaceRootVolumeTaskRequest").add("InstanceId", instanceId())
                .add("SnapshotId", snapshotId()).add("ClientToken", clientToken()).add("DryRun", dryRun())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ImageId", imageId())
                .add("DeleteReplacedRootVolume", deleteReplacedRootVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "DeleteReplacedRootVolume":
            return Optional.ofNullable(clazz.cast(deleteReplacedRootVolume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("DeleteReplacedRootVolume", DELETE_REPLACED_ROOT_VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplaceRootVolumeTaskRequest, T> g) {
        return obj -> g.apply((CreateReplaceRootVolumeTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplaceRootVolumeTaskRequest> {
        /**
         * <p>
         * The ID of the instance for which to replace the root volume.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance for which to replace the root volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the snapshot from which to restore the replacement root volume. The specified snapshot must be a
         * snapshot that you previously created from the original root volume.
         * </p>
         * <p>
         * If you want to restore the replacement root volume to the initial launch state, or if you want to restore the
         * replacement root volume from an AMI, omit this parameter.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot from which to restore the replacement root volume. The specified snapshot must
         *        be a snapshot that you previously created from the original root volume.</p>
         *        <p>
         *        If you want to restore the replacement root volume to the initial launch state, or if you want to
         *        restore the replacement root volume from an AMI, omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify
         * a client token, a randomly generated token is used for the request to ensure idempotency. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not
         *        specify a client token, a randomly generated token is used for the request to ensure idempotency. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The tags to apply to the root volume replacement task.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the root volume replacement task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the root volume replacement task.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the root volume replacement task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the root volume replacement task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The ID of the AMI to use to restore the root volume. The specified AMI must have the same product code,
         * billing information, architecture type, and virtualization type as that of the instance.
         * </p>
         * <p>
         * If you want to restore the replacement volume from a specific snapshot, or if you want to restore it to its
         * launch state, omit this parameter.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI to use to restore the root volume. The specified AMI must have the same product
         *        code, billing information, architecture type, and virtualization type as that of the instance.</p>
         *        <p>
         *        If you want to restore the replacement volume from a specific snapshot, or if you want to restore it
         *        to its launch state, omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Indicates whether to automatically delete the original root volume after the root volume replacement task
         * completes. To delete the original root volume, specify <code>true</code>. If you choose to keep the original
         * root volume after the replacement task completes, you must manually delete it when you no longer need it.
         * </p>
         * 
         * @param deleteReplacedRootVolume
         *        Indicates whether to automatically delete the original root volume after the root volume replacement
         *        task completes. To delete the original root volume, specify <code>true</code>. If you choose to keep
         *        the original root volume after the replacement task completes, you must manually delete it when you no
         *        longer need it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteReplacedRootVolume(Boolean deleteReplacedRootVolume);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceId;

        private String snapshotId;

        private String clientToken;

        private Boolean dryRun;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String imageId;

        private Boolean deleteReplacedRootVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplaceRootVolumeTaskRequest model) {
            super(model);
            instanceId(model.instanceId);
            snapshotId(model.snapshotId);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
            tagSpecifications(model.tagSpecifications);
            imageId(model.imageId);
            deleteReplacedRootVolume(model.deleteReplacedRootVolume);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Boolean getDeleteReplacedRootVolume() {
            return deleteReplacedRootVolume;
        }

        public final void setDeleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
        }

        @Override
        public final Builder deleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplaceRootVolumeTaskRequest build() {
            return new CreateReplaceRootVolumeTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
