/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Condensed information about a trust provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessTrustProviderCondensed implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessTrustProviderCondensed.Builder, VerifiedAccessTrustProviderCondensed> {
    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessTrustProviderId")
            .getter(getter(VerifiedAccessTrustProviderCondensed::verifiedAccessTrustProviderId))
            .setter(setter(Builder::verifiedAccessTrustProviderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId")
                    .unmarshallLocationName("verifiedAccessTrustProviderId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(VerifiedAccessTrustProviderCondensed::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrustProviderType")
            .getter(getter(VerifiedAccessTrustProviderCondensed::trustProviderTypeAsString))
            .setter(setter(Builder::trustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustProviderType")
                    .unmarshallLocationName("trustProviderType").build()).build();

    private static final SdkField<String> USER_TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserTrustProviderType")
            .getter(getter(VerifiedAccessTrustProviderCondensed::userTrustProviderTypeAsString))
            .setter(setter(Builder::userTrustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTrustProviderType")
                    .unmarshallLocationName("userTrustProviderType").build()).build();

    private static final SdkField<String> DEVICE_TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceTrustProviderType")
            .getter(getter(VerifiedAccessTrustProviderCondensed::deviceTrustProviderTypeAsString))
            .setter(setter(Builder::deviceTrustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTrustProviderType")
                    .unmarshallLocationName("deviceTrustProviderType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, DESCRIPTION_FIELD, TRUST_PROVIDER_TYPE_FIELD,
            USER_TRUST_PROVIDER_TYPE_FIELD, DEVICE_TRUST_PROVIDER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String verifiedAccessTrustProviderId;

    private final String description;

    private final String trustProviderType;

    private final String userTrustProviderType;

    private final String deviceTrustProviderType;

    private VerifiedAccessTrustProviderCondensed(BuilderImpl builder) {
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.description = builder.description;
        this.trustProviderType = builder.trustProviderType;
        this.userTrustProviderType = builder.userTrustProviderType;
        this.deviceTrustProviderType = builder.deviceTrustProviderType;
    }

    /**
     * <p>
     * The ID of the trust provider.
     * </p>
     * 
     * @return The ID of the trust provider.
     */
    public final String verifiedAccessTrustProviderId() {
        return verifiedAccessTrustProviderId;
    }

    /**
     * <p>
     * The description of trust provider.
     * </p>
     * 
     * @return The description of trust provider.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of trust provider (user- or device-based).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustProviderType}
     * will return {@link TrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of trust provider (user- or device-based).
     * @see TrustProviderType
     */
    public final TrustProviderType trustProviderType() {
        return TrustProviderType.fromValue(trustProviderType);
    }

    /**
     * <p>
     * The type of trust provider (user- or device-based).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustProviderType}
     * will return {@link TrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of trust provider (user- or device-based).
     * @see TrustProviderType
     */
    public final String trustProviderTypeAsString() {
        return trustProviderType;
    }

    /**
     * <p>
     * The type of user-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userTrustProviderType} will return {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of user-based trust provider.
     * @see UserTrustProviderType
     */
    public final UserTrustProviderType userTrustProviderType() {
        return UserTrustProviderType.fromValue(userTrustProviderType);
    }

    /**
     * <p>
     * The type of user-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userTrustProviderType} will return {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of user-based trust provider.
     * @see UserTrustProviderType
     */
    public final String userTrustProviderTypeAsString() {
        return userTrustProviderType;
    }

    /**
     * <p>
     * The type of device-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTrustProviderType} will return {@link DeviceTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of device-based trust provider.
     * @see DeviceTrustProviderType
     */
    public final DeviceTrustProviderType deviceTrustProviderType() {
        return DeviceTrustProviderType.fromValue(deviceTrustProviderType);
    }

    /**
     * <p>
     * The type of device-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTrustProviderType} will return {@link DeviceTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of device-based trust provider.
     * @see DeviceTrustProviderType
     */
    public final String deviceTrustProviderTypeAsString() {
        return deviceTrustProviderType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(trustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTrustProviderTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessTrustProviderCondensed)) {
            return false;
        }
        VerifiedAccessTrustProviderCondensed other = (VerifiedAccessTrustProviderCondensed) obj;
        return Objects.equals(verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId())
                && Objects.equals(description(), other.description())
                && Objects.equals(trustProviderTypeAsString(), other.trustProviderTypeAsString())
                && Objects.equals(userTrustProviderTypeAsString(), other.userTrustProviderTypeAsString())
                && Objects.equals(deviceTrustProviderTypeAsString(), other.deviceTrustProviderTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessTrustProviderCondensed")
                .add("VerifiedAccessTrustProviderId", verifiedAccessTrustProviderId()).add("Description", description())
                .add("TrustProviderType", trustProviderTypeAsString())
                .add("UserTrustProviderType", userTrustProviderTypeAsString())
                .add("DeviceTrustProviderType", deviceTrustProviderTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessTrustProviderId":
            return Optional.ofNullable(clazz.cast(verifiedAccessTrustProviderId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TrustProviderType":
            return Optional.ofNullable(clazz.cast(trustProviderTypeAsString()));
        case "UserTrustProviderType":
            return Optional.ofNullable(clazz.cast(userTrustProviderTypeAsString()));
        case "DeviceTrustProviderType":
            return Optional.ofNullable(clazz.cast(deviceTrustProviderTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedAccessTrustProviderId", VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TrustProviderType", TRUST_PROVIDER_TYPE_FIELD);
        map.put("UserTrustProviderType", USER_TRUST_PROVIDER_TYPE_FIELD);
        map.put("DeviceTrustProviderType", DEVICE_TRUST_PROVIDER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessTrustProviderCondensed, T> g) {
        return obj -> g.apply((VerifiedAccessTrustProviderCondensed) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessTrustProviderCondensed> {
        /**
         * <p>
         * The ID of the trust provider.
         * </p>
         * 
         * @param verifiedAccessTrustProviderId
         *        The ID of the trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId);

        /**
         * <p>
         * The description of trust provider.
         * </p>
         * 
         * @param description
         *        The description of trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of trust provider (user- or device-based).
         * </p>
         * 
         * @param trustProviderType
         *        The type of trust provider (user- or device-based).
         * @see TrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustProviderType
         */
        Builder trustProviderType(String trustProviderType);

        /**
         * <p>
         * The type of trust provider (user- or device-based).
         * </p>
         * 
         * @param trustProviderType
         *        The type of trust provider (user- or device-based).
         * @see TrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustProviderType
         */
        Builder trustProviderType(TrustProviderType trustProviderType);

        /**
         * <p>
         * The type of user-based trust provider.
         * </p>
         * 
         * @param userTrustProviderType
         *        The type of user-based trust provider.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder userTrustProviderType(String userTrustProviderType);

        /**
         * <p>
         * The type of user-based trust provider.
         * </p>
         * 
         * @param userTrustProviderType
         *        The type of user-based trust provider.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder userTrustProviderType(UserTrustProviderType userTrustProviderType);

        /**
         * <p>
         * The type of device-based trust provider.
         * </p>
         * 
         * @param deviceTrustProviderType
         *        The type of device-based trust provider.
         * @see DeviceTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceTrustProviderType
         */
        Builder deviceTrustProviderType(String deviceTrustProviderType);

        /**
         * <p>
         * The type of device-based trust provider.
         * </p>
         * 
         * @param deviceTrustProviderType
         *        The type of device-based trust provider.
         * @see DeviceTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceTrustProviderType
         */
        Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType);
    }

    static final class BuilderImpl implements Builder {
        private String verifiedAccessTrustProviderId;

        private String description;

        private String trustProviderType;

        private String userTrustProviderType;

        private String deviceTrustProviderType;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessTrustProviderCondensed model) {
            verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            description(model.description);
            trustProviderType(model.trustProviderType);
            userTrustProviderType(model.userTrustProviderType);
            deviceTrustProviderType(model.deviceTrustProviderType);
        }

        public final String getVerifiedAccessTrustProviderId() {
            return verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTrustProviderType() {
            return trustProviderType;
        }

        public final void setTrustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
        }

        @Override
        public final Builder trustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
            return this;
        }

        @Override
        public final Builder trustProviderType(TrustProviderType trustProviderType) {
            this.trustProviderType(trustProviderType == null ? null : trustProviderType.toString());
            return this;
        }

        public final String getUserTrustProviderType() {
            return userTrustProviderType;
        }

        public final void setUserTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
        }

        @Override
        public final Builder userTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
            return this;
        }

        @Override
        public final Builder userTrustProviderType(UserTrustProviderType userTrustProviderType) {
            this.userTrustProviderType(userTrustProviderType == null ? null : userTrustProviderType.toString());
            return this;
        }

        public final String getDeviceTrustProviderType() {
            return deviceTrustProviderType;
        }

        public final void setDeviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
        }

        @Override
        public final Builder deviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
            return this;
        }

        @Override
        public final Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType) {
            this.deviceTrustProviderType(deviceTrustProviderType == null ? null : deviceTrustProviderType.toString());
            return this;
        }

        @Override
        public VerifiedAccessTrustProviderCondensed build() {
            return new VerifiedAccessTrustProviderCondensed(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
