/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayConnectPeerResponse extends Ec2Response implements
        ToCopyableBuilder<CreateTransitGatewayConnectPeerResponse.Builder, CreateTransitGatewayConnectPeerResponse> {
    private static final SdkField<TransitGatewayConnectPeer> TRANSIT_GATEWAY_CONNECT_PEER_FIELD = SdkField
            .<TransitGatewayConnectPeer> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayConnectPeer")
            .getter(getter(CreateTransitGatewayConnectPeerResponse::transitGatewayConnectPeer))
            .setter(setter(Builder::transitGatewayConnectPeer))
            .constructor(TransitGatewayConnectPeer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeer")
                    .unmarshallLocationName("transitGatewayConnectPeer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_CONNECT_PEER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransitGatewayConnectPeer transitGatewayConnectPeer;

    private CreateTransitGatewayConnectPeerResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnectPeer = builder.transitGatewayConnectPeer;
    }

    /**
     * <p>
     * Information about the Connect peer.
     * </p>
     * 
     * @return Information about the Connect peer.
     */
    public final TransitGatewayConnectPeer transitGatewayConnectPeer() {
        return transitGatewayConnectPeer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConnectPeer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayConnectPeerResponse)) {
            return false;
        }
        CreateTransitGatewayConnectPeerResponse other = (CreateTransitGatewayConnectPeerResponse) obj;
        return Objects.equals(transitGatewayConnectPeer(), other.transitGatewayConnectPeer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayConnectPeerResponse")
                .add("TransitGatewayConnectPeer", transitGatewayConnectPeer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayConnectPeer":
            return Optional.ofNullable(clazz.cast(transitGatewayConnectPeer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayConnectPeer", TRANSIT_GATEWAY_CONNECT_PEER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayConnectPeerResponse, T> g) {
        return obj -> g.apply((CreateTransitGatewayConnectPeerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayConnectPeerResponse> {
        /**
         * <p>
         * Information about the Connect peer.
         * </p>
         * 
         * @param transitGatewayConnectPeer
         *        Information about the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeer(TransitGatewayConnectPeer transitGatewayConnectPeer);

        /**
         * <p>
         * Information about the Connect peer.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayConnectPeer.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayConnectPeer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayConnectPeer.Builder#build()} is called immediately
         * and its result is passed to {@link #transitGatewayConnectPeer(TransitGatewayConnectPeer)}.
         * 
         * @param transitGatewayConnectPeer
         *        a consumer that will call methods on {@link TransitGatewayConnectPeer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayConnectPeer(TransitGatewayConnectPeer)
         */
        default Builder transitGatewayConnectPeer(Consumer<TransitGatewayConnectPeer.Builder> transitGatewayConnectPeer) {
            return transitGatewayConnectPeer(TransitGatewayConnectPeer.builder().applyMutation(transitGatewayConnectPeer).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayConnectPeer transitGatewayConnectPeer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayConnectPeerResponse model) {
            super(model);
            transitGatewayConnectPeer(model.transitGatewayConnectPeer);
        }

        public final TransitGatewayConnectPeer.Builder getTransitGatewayConnectPeer() {
            return transitGatewayConnectPeer != null ? transitGatewayConnectPeer.toBuilder() : null;
        }

        public final void setTransitGatewayConnectPeer(TransitGatewayConnectPeer.BuilderImpl transitGatewayConnectPeer) {
            this.transitGatewayConnectPeer = transitGatewayConnectPeer != null ? transitGatewayConnectPeer.build() : null;
        }

        @Override
        public final Builder transitGatewayConnectPeer(TransitGatewayConnectPeer transitGatewayConnectPeer) {
            this.transitGatewayConnectPeer = transitGatewayConnectPeer;
            return this;
        }

        @Override
        public CreateTransitGatewayConnectPeerResponse build() {
            return new CreateTransitGatewayConnectPeerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
