/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityBlockExtensionHistoryResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeCapacityBlockExtensionHistoryResponse.Builder, DescribeCapacityBlockExtensionHistoryResponse> {
    private static final SdkField<List<CapacityBlockExtension>> CAPACITY_BLOCK_EXTENSIONS_FIELD = SdkField
            .<List<CapacityBlockExtension>> builder(MarshallingType.LIST)
            .memberName("CapacityBlockExtensions")
            .getter(getter(DescribeCapacityBlockExtensionHistoryResponse::capacityBlockExtensions))
            .setter(setter(Builder::capacityBlockExtensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionSet")
                    .unmarshallLocationName("capacityBlockExtensionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityBlockExtension> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityBlockExtension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityBlockExtensionHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_BLOCK_EXTENSIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CapacityBlockExtension> capacityBlockExtensions;

    private final String nextToken;

    private DescribeCapacityBlockExtensionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.capacityBlockExtensions = builder.capacityBlockExtensions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityBlockExtensions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityBlockExtensions() {
        return capacityBlockExtensions != null && !(capacityBlockExtensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes one or more of your Capacity Block extensions. The results describe only the Capacity Block extensions
     * in the Amazon Web Services Region that you're currently using.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityBlockExtensions} method.
     * </p>
     * 
     * @return Describes one or more of your Capacity Block extensions. The results describe only the Capacity Block
     *         extensions in the Amazon Web Services Region that you're currently using.
     */
    public final List<CapacityBlockExtension> capacityBlockExtensions() {
        return capacityBlockExtensions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityBlockExtensions() ? capacityBlockExtensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockExtensionHistoryResponse)) {
            return false;
        }
        DescribeCapacityBlockExtensionHistoryResponse other = (DescribeCapacityBlockExtensionHistoryResponse) obj;
        return hasCapacityBlockExtensions() == other.hasCapacityBlockExtensions()
                && Objects.equals(capacityBlockExtensions(), other.capacityBlockExtensions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityBlockExtensionHistoryResponse")
                .add("CapacityBlockExtensions", hasCapacityBlockExtensions() ? capacityBlockExtensions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityBlockExtensions":
            return Optional.ofNullable(clazz.cast(capacityBlockExtensions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityBlockExtensionSet", CAPACITY_BLOCK_EXTENSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockExtensionHistoryResponse, T> g) {
        return obj -> g.apply((DescribeCapacityBlockExtensionHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCapacityBlockExtensionHistoryResponse> {
        /**
         * <p>
         * Describes one or more of your Capacity Block extensions. The results describe only the Capacity Block
         * extensions in the Amazon Web Services Region that you're currently using.
         * </p>
         * 
         * @param capacityBlockExtensions
         *        Describes one or more of your Capacity Block extensions. The results describe only the Capacity Block
         *        extensions in the Amazon Web Services Region that you're currently using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensions(Collection<CapacityBlockExtension> capacityBlockExtensions);

        /**
         * <p>
         * Describes one or more of your Capacity Block extensions. The results describe only the Capacity Block
         * extensions in the Amazon Web Services Region that you're currently using.
         * </p>
         * 
         * @param capacityBlockExtensions
         *        Describes one or more of your Capacity Block extensions. The results describe only the Capacity Block
         *        extensions in the Amazon Web Services Region that you're currently using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockExtensions(CapacityBlockExtension... capacityBlockExtensions);

        /**
         * <p>
         * Describes one or more of your Capacity Block extensions. The results describe only the Capacity Block
         * extensions in the Amazon Web Services Region that you're currently using.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtension.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtension.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityBlockExtensions(List<CapacityBlockExtension>)}.
         * 
         * @param capacityBlockExtensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityBlockExtension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityBlockExtensions(java.util.Collection<CapacityBlockExtension>)
         */
        Builder capacityBlockExtensions(Consumer<CapacityBlockExtension.Builder>... capacityBlockExtensions);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CapacityBlockExtension> capacityBlockExtensions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockExtensionHistoryResponse model) {
            super(model);
            capacityBlockExtensions(model.capacityBlockExtensions);
            nextToken(model.nextToken);
        }

        public final List<CapacityBlockExtension.Builder> getCapacityBlockExtensions() {
            List<CapacityBlockExtension.Builder> result = CapacityBlockExtensionSetCopier
                    .copyToBuilder(this.capacityBlockExtensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlockExtensions(Collection<CapacityBlockExtension.BuilderImpl> capacityBlockExtensions) {
            this.capacityBlockExtensions = CapacityBlockExtensionSetCopier.copyFromBuilder(capacityBlockExtensions);
        }

        @Override
        public final Builder capacityBlockExtensions(Collection<CapacityBlockExtension> capacityBlockExtensions) {
            this.capacityBlockExtensions = CapacityBlockExtensionSetCopier.copy(capacityBlockExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensions(CapacityBlockExtension... capacityBlockExtensions) {
            capacityBlockExtensions(Arrays.asList(capacityBlockExtensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensions(Consumer<CapacityBlockExtension.Builder>... capacityBlockExtensions) {
            capacityBlockExtensions(Stream.of(capacityBlockExtensions)
                    .map(c -> CapacityBlockExtension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityBlockExtensionHistoryResponse build() {
            return new DescribeCapacityBlockExtensionHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
