/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes Amazon Kinesis Data Firehose logging options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessLogKinesisDataFirehoseDestinationOptions
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<VerifiedAccessLogKinesisDataFirehoseDestinationOptions.Builder, VerifiedAccessLogKinesisDataFirehoseDestinationOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(VerifiedAccessLogKinesisDataFirehoseDestinationOptions::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> DELIVERY_STREAM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStream")
            .getter(getter(VerifiedAccessLogKinesisDataFirehoseDestinationOptions::deliveryStream))
            .setter(setter(Builder::deliveryStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStream")
                    .unmarshallLocationName("DeliveryStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            DELIVERY_STREAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String deliveryStream;

    private VerifiedAccessLogKinesisDataFirehoseDestinationOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.deliveryStream = builder.deliveryStream;
    }

    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     * 
     * @return Indicates whether logging is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The ID of the delivery stream.
     * </p>
     * 
     * @return The ID of the delivery stream.
     */
    public final String deliveryStream() {
        return deliveryStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessLogKinesisDataFirehoseDestinationOptions)) {
            return false;
        }
        VerifiedAccessLogKinesisDataFirehoseDestinationOptions other = (VerifiedAccessLogKinesisDataFirehoseDestinationOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(deliveryStream(), other.deliveryStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessLogKinesisDataFirehoseDestinationOptions").add("Enabled", enabled())
                .add("DeliveryStream", deliveryStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "DeliveryStream":
            return Optional.ofNullable(clazz.cast(deliveryStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("DeliveryStream", DELIVERY_STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessLogKinesisDataFirehoseDestinationOptions, T> g) {
        return obj -> g.apply((VerifiedAccessLogKinesisDataFirehoseDestinationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessLogKinesisDataFirehoseDestinationOptions> {
        /**
         * <p>
         * Indicates whether logging is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The ID of the delivery stream.
         * </p>
         * 
         * @param deliveryStream
         *        The ID of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStream(String deliveryStream);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String deliveryStream;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessLogKinesisDataFirehoseDestinationOptions model) {
            enabled(model.enabled);
            deliveryStream(model.deliveryStream);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getDeliveryStream() {
            return deliveryStream;
        }

        public final void setDeliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        @Override
        public final Builder deliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        @Override
        public VerifiedAccessLogKinesisDataFirehoseDestinationOptions build() {
            return new VerifiedAccessLogKinesisDataFirehoseDestinationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
