/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotPlacementScore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotPlacementScore> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(SpotPlacementScore.getter(SpotPlacementScore::region)).setter(SpotPlacementScore.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("region").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(SpotPlacementScore.getter(SpotPlacementScore::availabilityZoneId)).setter(SpotPlacementScore.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<Integer> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Score").getter(SpotPlacementScore.getter(SpotPlacementScore::score)).setter(SpotPlacementScore.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").unmarshallLocationName("score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, AVAILABILITY_ZONE_ID_FIELD, SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpotPlacementScore.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String availabilityZoneId;
    private final Integer score;

    private SpotPlacementScore(BuilderImpl builder) {
        this.region = builder.region;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.score = builder.score;
    }

    public final String region() {
        return this.region;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Integer score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPlacementScore)) {
            return false;
        }
        SpotPlacementScore other = (SpotPlacementScore)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"SpotPlacementScore").add("Region", (Object)this.region()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Region", REGION_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("Score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpotPlacementScore, T> g) {
        return obj -> g.apply((SpotPlacementScore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String availabilityZoneId;
        private Integer score;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPlacementScore model) {
            this.region(model.region);
            this.availabilityZoneId(model.availabilityZoneId);
            this.score(model.score);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Integer getScore() {
            return this.score;
        }

        public final void setScore(Integer score) {
            this.score = score;
        }

        @Override
        public final Builder score(Integer score) {
            this.score = score;
            return this;
        }

        public SpotPlacementScore build() {
            return new SpotPlacementScore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotPlacementScore> {
        public Builder region(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder score(Integer var1);
    }
}

