/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessNativeApplicationOidcOptions;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderDeviceOptions;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderOidcOptions;
import software.amazon.awssdk.services.ec2.model.DeviceTrustProviderType;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TrustProviderType;
import software.amazon.awssdk.services.ec2.model.UserTrustProviderType;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessSseSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVerifiedAccessTrustProviderRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVerifiedAccessTrustProviderRequest> {
    private static final SdkField<String> TRUST_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustProviderType").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::trustProviderTypeAsString)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::trustProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustProviderType").unmarshallLocationName("TrustProviderType").build()}).build();
    private static final SdkField<String> USER_TRUST_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserTrustProviderType").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::userTrustProviderTypeAsString)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::userTrustProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTrustProviderType").unmarshallLocationName("UserTrustProviderType").build()}).build();
    private static final SdkField<String> DEVICE_TRUST_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceTrustProviderType").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::deviceTrustProviderTypeAsString)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::deviceTrustProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTrustProviderType").unmarshallLocationName("DeviceTrustProviderType").build()}).build();
    private static final SdkField<CreateVerifiedAccessTrustProviderOidcOptions> OIDC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OidcOptions").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::oidcOptions)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::oidcOptions)).constructor(CreateVerifiedAccessTrustProviderOidcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcOptions").unmarshallLocationName("OidcOptions").build()}).build();
    private static final SdkField<CreateVerifiedAccessTrustProviderDeviceOptions> DEVICE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceOptions").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::deviceOptions)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::deviceOptions)).constructor(CreateVerifiedAccessTrustProviderDeviceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOptions").unmarshallLocationName("DeviceOptions").build()}).build();
    private static final SdkField<String> POLICY_REFERENCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyReferenceName").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::policyReferenceName)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::policyReferenceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReferenceName").unmarshallLocationName("PolicyReferenceName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::description)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::tagSpecifications)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::clientToken)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::dryRun)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<VerifiedAccessSseSpecificationRequest> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseSpecification").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::sseSpecification)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::sseSpecification)).constructor(VerifiedAccessSseSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification").unmarshallLocationName("SseSpecification").build()}).build();
    private static final SdkField<CreateVerifiedAccessNativeApplicationOidcOptions> NATIVE_APPLICATION_OIDC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NativeApplicationOidcOptions").getter(CreateVerifiedAccessTrustProviderRequest.getter(CreateVerifiedAccessTrustProviderRequest::nativeApplicationOidcOptions)).setter(CreateVerifiedAccessTrustProviderRequest.setter(Builder::nativeApplicationOidcOptions)).constructor(CreateVerifiedAccessNativeApplicationOidcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NativeApplicationOidcOptions").unmarshallLocationName("NativeApplicationOidcOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_PROVIDER_TYPE_FIELD, USER_TRUST_PROVIDER_TYPE_FIELD, DEVICE_TRUST_PROVIDER_TYPE_FIELD, OIDC_OPTIONS_FIELD, DEVICE_OPTIONS_FIELD, POLICY_REFERENCE_NAME_FIELD, DESCRIPTION_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, SSE_SPECIFICATION_FIELD, NATIVE_APPLICATION_OIDC_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVerifiedAccessTrustProviderRequest.memberNameToFieldInitializer();
    private final String trustProviderType;
    private final String userTrustProviderType;
    private final String deviceTrustProviderType;
    private final CreateVerifiedAccessTrustProviderOidcOptions oidcOptions;
    private final CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions;
    private final String policyReferenceName;
    private final String description;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final Boolean dryRun;
    private final VerifiedAccessSseSpecificationRequest sseSpecification;
    private final CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions;

    private CreateVerifiedAccessTrustProviderRequest(BuilderImpl builder) {
        super(builder);
        this.trustProviderType = builder.trustProviderType;
        this.userTrustProviderType = builder.userTrustProviderType;
        this.deviceTrustProviderType = builder.deviceTrustProviderType;
        this.oidcOptions = builder.oidcOptions;
        this.deviceOptions = builder.deviceOptions;
        this.policyReferenceName = builder.policyReferenceName;
        this.description = builder.description;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.sseSpecification = builder.sseSpecification;
        this.nativeApplicationOidcOptions = builder.nativeApplicationOidcOptions;
    }

    public final TrustProviderType trustProviderType() {
        return TrustProviderType.fromValue(this.trustProviderType);
    }

    public final String trustProviderTypeAsString() {
        return this.trustProviderType;
    }

    public final UserTrustProviderType userTrustProviderType() {
        return UserTrustProviderType.fromValue(this.userTrustProviderType);
    }

    public final String userTrustProviderTypeAsString() {
        return this.userTrustProviderType;
    }

    public final DeviceTrustProviderType deviceTrustProviderType() {
        return DeviceTrustProviderType.fromValue(this.deviceTrustProviderType);
    }

    public final String deviceTrustProviderTypeAsString() {
        return this.deviceTrustProviderType;
    }

    public final CreateVerifiedAccessTrustProviderOidcOptions oidcOptions() {
        return this.oidcOptions;
    }

    public final CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions() {
        return this.deviceOptions;
    }

    public final String policyReferenceName() {
        return this.policyReferenceName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final VerifiedAccessSseSpecificationRequest sseSpecification() {
        return this.sseSpecification;
    }

    public final CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions() {
        return this.nativeApplicationOidcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyReferenceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.nativeApplicationOidcOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessTrustProviderRequest)) {
            return false;
        }
        CreateVerifiedAccessTrustProviderRequest other = (CreateVerifiedAccessTrustProviderRequest)((Object)obj);
        return Objects.equals(this.trustProviderTypeAsString(), other.trustProviderTypeAsString()) && Objects.equals(this.userTrustProviderTypeAsString(), other.userTrustProviderTypeAsString()) && Objects.equals(this.deviceTrustProviderTypeAsString(), other.deviceTrustProviderTypeAsString()) && Objects.equals(this.oidcOptions(), other.oidcOptions()) && Objects.equals(this.deviceOptions(), other.deviceOptions()) && Objects.equals(this.policyReferenceName(), other.policyReferenceName()) && Objects.equals(this.description(), other.description()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.sseSpecification(), other.sseSpecification()) && Objects.equals(this.nativeApplicationOidcOptions(), other.nativeApplicationOidcOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVerifiedAccessTrustProviderRequest").add("TrustProviderType", (Object)this.trustProviderTypeAsString()).add("UserTrustProviderType", (Object)this.userTrustProviderTypeAsString()).add("DeviceTrustProviderType", (Object)this.deviceTrustProviderTypeAsString()).add("OidcOptions", (Object)this.oidcOptions()).add("DeviceOptions", (Object)this.deviceOptions()).add("PolicyReferenceName", (Object)this.policyReferenceName()).add("Description", (Object)this.description()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("SseSpecification", (Object)this.sseSpecification()).add("NativeApplicationOidcOptions", (Object)this.nativeApplicationOidcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustProviderType": {
                return Optional.ofNullable(clazz.cast(this.trustProviderTypeAsString()));
            }
            case "UserTrustProviderType": {
                return Optional.ofNullable(clazz.cast(this.userTrustProviderTypeAsString()));
            }
            case "DeviceTrustProviderType": {
                return Optional.ofNullable(clazz.cast(this.deviceTrustProviderTypeAsString()));
            }
            case "OidcOptions": {
                return Optional.ofNullable(clazz.cast(this.oidcOptions()));
            }
            case "DeviceOptions": {
                return Optional.ofNullable(clazz.cast(this.deviceOptions()));
            }
            case "PolicyReferenceName": {
                return Optional.ofNullable(clazz.cast(this.policyReferenceName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SseSpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
            case "NativeApplicationOidcOptions": {
                return Optional.ofNullable(clazz.cast(this.nativeApplicationOidcOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustProviderType", TRUST_PROVIDER_TYPE_FIELD);
        map.put("UserTrustProviderType", USER_TRUST_PROVIDER_TYPE_FIELD);
        map.put("DeviceTrustProviderType", DEVICE_TRUST_PROVIDER_TYPE_FIELD);
        map.put("OidcOptions", OIDC_OPTIONS_FIELD);
        map.put("DeviceOptions", DEVICE_OPTIONS_FIELD);
        map.put("PolicyReferenceName", POLICY_REFERENCE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        map.put("NativeApplicationOidcOptions", NATIVE_APPLICATION_OIDC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessTrustProviderRequest, T> g) {
        return obj -> g.apply((CreateVerifiedAccessTrustProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String trustProviderType;
        private String userTrustProviderType;
        private String deviceTrustProviderType;
        private CreateVerifiedAccessTrustProviderOidcOptions oidcOptions;
        private CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions;
        private String policyReferenceName;
        private String description;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Boolean dryRun;
        private VerifiedAccessSseSpecificationRequest sseSpecification;
        private CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessTrustProviderRequest model) {
            super(model);
            this.trustProviderType(model.trustProviderType);
            this.userTrustProviderType(model.userTrustProviderType);
            this.deviceTrustProviderType(model.deviceTrustProviderType);
            this.oidcOptions(model.oidcOptions);
            this.deviceOptions(model.deviceOptions);
            this.policyReferenceName(model.policyReferenceName);
            this.description(model.description);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.sseSpecification(model.sseSpecification);
            this.nativeApplicationOidcOptions(model.nativeApplicationOidcOptions);
        }

        public final String getTrustProviderType() {
            return this.trustProviderType;
        }

        public final void setTrustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
        }

        @Override
        public final Builder trustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
            return this;
        }

        @Override
        public final Builder trustProviderType(TrustProviderType trustProviderType) {
            this.trustProviderType(trustProviderType == null ? null : trustProviderType.toString());
            return this;
        }

        public final String getUserTrustProviderType() {
            return this.userTrustProviderType;
        }

        public final void setUserTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
        }

        @Override
        public final Builder userTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
            return this;
        }

        @Override
        public final Builder userTrustProviderType(UserTrustProviderType userTrustProviderType) {
            this.userTrustProviderType(userTrustProviderType == null ? null : userTrustProviderType.toString());
            return this;
        }

        public final String getDeviceTrustProviderType() {
            return this.deviceTrustProviderType;
        }

        public final void setDeviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
        }

        @Override
        public final Builder deviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
            return this;
        }

        @Override
        public final Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType) {
            this.deviceTrustProviderType(deviceTrustProviderType == null ? null : deviceTrustProviderType.toString());
            return this;
        }

        public final CreateVerifiedAccessTrustProviderOidcOptions.Builder getOidcOptions() {
            return this.oidcOptions != null ? this.oidcOptions.toBuilder() : null;
        }

        public final void setOidcOptions(CreateVerifiedAccessTrustProviderOidcOptions.BuilderImpl oidcOptions) {
            this.oidcOptions = oidcOptions != null ? oidcOptions.build() : null;
        }

        @Override
        public final Builder oidcOptions(CreateVerifiedAccessTrustProviderOidcOptions oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        public final CreateVerifiedAccessTrustProviderDeviceOptions.Builder getDeviceOptions() {
            return this.deviceOptions != null ? this.deviceOptions.toBuilder() : null;
        }

        public final void setDeviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions.BuilderImpl deviceOptions) {
            this.deviceOptions = deviceOptions != null ? deviceOptions.build() : null;
        }

        @Override
        public final Builder deviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        public final String getPolicyReferenceName() {
            return this.policyReferenceName;
        }

        public final void setPolicyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
        }

        @Override
        public final Builder policyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final VerifiedAccessSseSpecificationRequest.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationRequest.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final CreateVerifiedAccessNativeApplicationOidcOptions.Builder getNativeApplicationOidcOptions() {
            return this.nativeApplicationOidcOptions != null ? this.nativeApplicationOidcOptions.toBuilder() : null;
        }

        public final void setNativeApplicationOidcOptions(CreateVerifiedAccessNativeApplicationOidcOptions.BuilderImpl nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions != null ? nativeApplicationOidcOptions.build() : null;
        }

        @Override
        public final Builder nativeApplicationOidcOptions(CreateVerifiedAccessNativeApplicationOidcOptions nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVerifiedAccessTrustProviderRequest build() {
            return new CreateVerifiedAccessTrustProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVerifiedAccessTrustProviderRequest> {
        public Builder trustProviderType(String var1);

        public Builder trustProviderType(TrustProviderType var1);

        public Builder userTrustProviderType(String var1);

        public Builder userTrustProviderType(UserTrustProviderType var1);

        public Builder deviceTrustProviderType(String var1);

        public Builder deviceTrustProviderType(DeviceTrustProviderType var1);

        public Builder oidcOptions(CreateVerifiedAccessTrustProviderOidcOptions var1);

        default public Builder oidcOptions(Consumer<CreateVerifiedAccessTrustProviderOidcOptions.Builder> oidcOptions) {
            return this.oidcOptions((CreateVerifiedAccessTrustProviderOidcOptions)((CreateVerifiedAccessTrustProviderOidcOptions.Builder)CreateVerifiedAccessTrustProviderOidcOptions.builder().applyMutation(oidcOptions)).build());
        }

        public Builder deviceOptions(CreateVerifiedAccessTrustProviderDeviceOptions var1);

        default public Builder deviceOptions(Consumer<CreateVerifiedAccessTrustProviderDeviceOptions.Builder> deviceOptions) {
            return this.deviceOptions((CreateVerifiedAccessTrustProviderDeviceOptions)((CreateVerifiedAccessTrustProviderDeviceOptions.Builder)CreateVerifiedAccessTrustProviderDeviceOptions.builder().applyMutation(deviceOptions)).build());
        }

        public Builder policyReferenceName(String var1);

        public Builder description(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder sseSpecification(VerifiedAccessSseSpecificationRequest var1);

        default public Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationRequest.Builder> sseSpecification) {
            return this.sseSpecification((VerifiedAccessSseSpecificationRequest)((VerifiedAccessSseSpecificationRequest.Builder)VerifiedAccessSseSpecificationRequest.builder().applyMutation(sseSpecification)).build());
        }

        public Builder nativeApplicationOidcOptions(CreateVerifiedAccessNativeApplicationOidcOptions var1);

        default public Builder nativeApplicationOidcOptions(Consumer<CreateVerifiedAccessNativeApplicationOidcOptions.Builder> nativeApplicationOidcOptions) {
            return this.nativeApplicationOidcOptions((CreateVerifiedAccessNativeApplicationOidcOptions)((CreateVerifiedAccessNativeApplicationOidcOptions.Builder)CreateVerifiedAccessNativeApplicationOidcOptions.builder().applyMutation(nativeApplicationOidcOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

