/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionField;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorSessionFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTrafficMirrorSessionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyTrafficMirrorSessionRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorSessionId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::trafficMirrorSessionId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::trafficMirrorSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSessionId").unmarshallLocationName("TrafficMirrorSessionId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorTargetId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::trafficMirrorTargetId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::trafficMirrorTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId").unmarshallLocationName("TrafficMirrorTargetId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::trafficMirrorFilterId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("TrafficMirrorFilterId").build()}).build();
    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PacketLength").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::packetLength)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::packetLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength").unmarshallLocationName("PacketLength").build()}).build();
    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionNumber").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::sessionNumber)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::sessionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber").unmarshallLocationName("SessionNumber").build()}).build();
    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VirtualNetworkId").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::virtualNetworkId)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::virtualNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId").unmarshallLocationName("VirtualNetworkId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::description)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<String>> REMOVE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveFields").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::removeFieldsAsStrings)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::removeFieldsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveField").unmarshallLocationName("RemoveField").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyTrafficMirrorSessionRequest.getter(ModifyTrafficMirrorSessionRequest::dryRun)).setter(ModifyTrafficMirrorSessionRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_SESSION_ID_FIELD, TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, PACKET_LENGTH_FIELD, SESSION_NUMBER_FIELD, VIRTUAL_NETWORK_ID_FIELD, DESCRIPTION_FIELD, REMOVE_FIELDS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyTrafficMirrorSessionRequest.memberNameToFieldInitializer();
    private final String trafficMirrorSessionId;
    private final String trafficMirrorTargetId;
    private final String trafficMirrorFilterId;
    private final Integer packetLength;
    private final Integer sessionNumber;
    private final Integer virtualNetworkId;
    private final String description;
    private final List<String> removeFields;
    private final Boolean dryRun;

    private ModifyTrafficMirrorSessionRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorSessionId = builder.trafficMirrorSessionId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.removeFields = builder.removeFields;
        this.dryRun = builder.dryRun;
    }

    public final String trafficMirrorSessionId() {
        return this.trafficMirrorSessionId;
    }

    public final String trafficMirrorTargetId() {
        return this.trafficMirrorTargetId;
    }

    public final String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public final Integer packetLength() {
        return this.packetLength;
    }

    public final Integer sessionNumber() {
        return this.sessionNumber;
    }

    public final Integer virtualNetworkId() {
        return this.virtualNetworkId;
    }

    public final String description() {
        return this.description;
    }

    public final List<TrafficMirrorSessionField> removeFields() {
        return TrafficMirrorSessionFieldListCopier.copyStringToEnum(this.removeFields);
    }

    public final boolean hasRemoveFields() {
        return this.removeFields != null && !(this.removeFields instanceof SdkAutoConstructList);
    }

    public final List<String> removeFieldsAsStrings() {
        return this.removeFields;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveFields() ? this.removeFieldsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorSessionRequest)) {
            return false;
        }
        ModifyTrafficMirrorSessionRequest other = (ModifyTrafficMirrorSessionRequest)((Object)obj);
        return Objects.equals(this.trafficMirrorSessionId(), other.trafficMirrorSessionId()) && Objects.equals(this.trafficMirrorTargetId(), other.trafficMirrorTargetId()) && Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.packetLength(), other.packetLength()) && Objects.equals(this.sessionNumber(), other.sessionNumber()) && Objects.equals(this.virtualNetworkId(), other.virtualNetworkId()) && Objects.equals(this.description(), other.description()) && this.hasRemoveFields() == other.hasRemoveFields() && Objects.equals(this.removeFieldsAsStrings(), other.removeFieldsAsStrings()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyTrafficMirrorSessionRequest").add("TrafficMirrorSessionId", (Object)this.trafficMirrorSessionId()).add("TrafficMirrorTargetId", (Object)this.trafficMirrorTargetId()).add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("PacketLength", (Object)this.packetLength()).add("SessionNumber", (Object)this.sessionNumber()).add("VirtualNetworkId", (Object)this.virtualNetworkId()).add("Description", (Object)this.description()).add("RemoveFields", this.hasRemoveFields() ? this.removeFieldsAsStrings() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorSessionId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorSessionId()));
            }
            case "TrafficMirrorTargetId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorTargetId()));
            }
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "PacketLength": {
                return Optional.ofNullable(clazz.cast(this.packetLength()));
            }
            case "SessionNumber": {
                return Optional.ofNullable(clazz.cast(this.sessionNumber()));
            }
            case "VirtualNetworkId": {
                return Optional.ofNullable(clazz.cast(this.virtualNetworkId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RemoveFields": {
                return Optional.ofNullable(clazz.cast(this.removeFieldsAsStrings()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrafficMirrorSessionId", TRAFFIC_MIRROR_SESSION_ID_FIELD);
        map.put("TrafficMirrorTargetId", TRAFFIC_MIRROR_TARGET_ID_FIELD);
        map.put("TrafficMirrorFilterId", TRAFFIC_MIRROR_FILTER_ID_FIELD);
        map.put("PacketLength", PACKET_LENGTH_FIELD);
        map.put("SessionNumber", SESSION_NUMBER_FIELD);
        map.put("VirtualNetworkId", VIRTUAL_NETWORK_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RemoveField", REMOVE_FIELDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorSessionRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String trafficMirrorSessionId;
        private String trafficMirrorTargetId;
        private String trafficMirrorFilterId;
        private Integer packetLength;
        private Integer sessionNumber;
        private Integer virtualNetworkId;
        private String description;
        private List<String> removeFields = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorSessionRequest model) {
            super(model);
            this.trafficMirrorSessionId(model.trafficMirrorSessionId);
            this.trafficMirrorTargetId(model.trafficMirrorTargetId);
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.packetLength(model.packetLength);
            this.sessionNumber(model.sessionNumber);
            this.virtualNetworkId(model.virtualNetworkId);
            this.description(model.description);
            this.removeFieldsWithStrings(model.removeFields);
            this.dryRun(model.dryRun);
        }

        public final String getTrafficMirrorSessionId() {
            return this.trafficMirrorSessionId;
        }

        public final void setTrafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
        }

        @Override
        public final Builder trafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
            return this;
        }

        public final String getTrafficMirrorTargetId() {
            return this.trafficMirrorTargetId;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final Integer getPacketLength() {
            return this.packetLength;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final Integer getSessionNumber() {
            return this.sessionNumber;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final Integer getVirtualNetworkId() {
            return this.virtualNetworkId;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getRemoveFields() {
            if (this.removeFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeFields;
        }

        public final void setRemoveFields(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
        }

        @Override
        public final Builder removeFieldsWithStrings(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFieldsWithStrings(String ... removeFields) {
            this.removeFieldsWithStrings(Arrays.asList(removeFields));
            return this;
        }

        @Override
        public final Builder removeFields(Collection<TrafficMirrorSessionField> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copyEnumToString(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFields(TrafficMirrorSessionField ... removeFields) {
            this.removeFields(Arrays.asList(removeFields));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorSessionRequest build() {
            return new ModifyTrafficMirrorSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTrafficMirrorSessionRequest> {
        public Builder trafficMirrorSessionId(String var1);

        public Builder trafficMirrorTargetId(String var1);

        public Builder trafficMirrorFilterId(String var1);

        public Builder packetLength(Integer var1);

        public Builder sessionNumber(Integer var1);

        public Builder virtualNetworkId(Integer var1);

        public Builder description(String var1);

        public Builder removeFieldsWithStrings(Collection<String> var1);

        public Builder removeFieldsWithStrings(String ... var1);

        public Builder removeFields(Collection<TrafficMirrorSessionField> var1);

        public Builder removeFields(TrafficMirrorSessionField ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

