/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationTarget;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowState;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceEventWindow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceEventWindow> {
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceEventWindowId").getter(InstanceEventWindow.getter(InstanceEventWindow::instanceEventWindowId)).setter(InstanceEventWindow.setter(Builder::instanceEventWindowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId").unmarshallLocationName("instanceEventWindowId").build()}).build();
    private static final SdkField<List<InstanceEventWindowTimeRange>> TIME_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeRanges").getter(InstanceEventWindow.getter(InstanceEventWindow::timeRanges)).setter(InstanceEventWindow.setter(Builder::timeRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeSet").unmarshallLocationName("timeRangeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceEventWindowTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InstanceEventWindow.getter(InstanceEventWindow::name)).setter(InstanceEventWindow.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CronExpression").getter(InstanceEventWindow.getter(InstanceEventWindow::cronExpression)).setter(InstanceEventWindow.setter(Builder::cronExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").unmarshallLocationName("cronExpression").build()}).build();
    private static final SdkField<InstanceEventWindowAssociationTarget> ASSOCIATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationTarget").getter(InstanceEventWindow.getter(InstanceEventWindow::associationTarget)).setter(InstanceEventWindow.setter(Builder::associationTarget)).constructor(InstanceEventWindowAssociationTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTarget").unmarshallLocationName("associationTarget").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(InstanceEventWindow.getter(InstanceEventWindow::stateAsString)).setter(InstanceEventWindow.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(InstanceEventWindow.getter(InstanceEventWindow::tags)).setter(InstanceEventWindow.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_WINDOW_ID_FIELD, TIME_RANGES_FIELD, NAME_FIELD, CRON_EXPRESSION_FIELD, ASSOCIATION_TARGET_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceEventWindow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceEventWindowId;
    private final List<InstanceEventWindowTimeRange> timeRanges;
    private final String name;
    private final String cronExpression;
    private final InstanceEventWindowAssociationTarget associationTarget;
    private final String state;
    private final List<Tag> tags;

    private InstanceEventWindow(BuilderImpl builder) {
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.timeRanges = builder.timeRanges;
        this.name = builder.name;
        this.cronExpression = builder.cronExpression;
        this.associationTarget = builder.associationTarget;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String instanceEventWindowId() {
        return this.instanceEventWindowId;
    }

    public final boolean hasTimeRanges() {
        return this.timeRanges != null && !(this.timeRanges instanceof SdkAutoConstructList);
    }

    public final List<InstanceEventWindowTimeRange> timeRanges() {
        return this.timeRanges;
    }

    public final String name() {
        return this.name;
    }

    public final String cronExpression() {
        return this.cronExpression;
    }

    public final InstanceEventWindowAssociationTarget associationTarget() {
        return this.associationTarget;
    }

    public final InstanceEventWindowState state() {
        return InstanceEventWindowState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeRanges() ? this.timeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.cronExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindow)) {
            return false;
        }
        InstanceEventWindow other = (InstanceEventWindow)obj;
        return Objects.equals(this.instanceEventWindowId(), other.instanceEventWindowId()) && this.hasTimeRanges() == other.hasTimeRanges() && Objects.equals(this.timeRanges(), other.timeRanges()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.cronExpression(), other.cronExpression()) && Objects.equals(this.associationTarget(), other.associationTarget()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceEventWindow").add("InstanceEventWindowId", (Object)this.instanceEventWindowId()).add("TimeRanges", this.hasTimeRanges() ? this.timeRanges() : null).add("Name", (Object)this.name()).add("CronExpression", (Object)this.cronExpression()).add("AssociationTarget", (Object)this.associationTarget()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceEventWindowId": {
                return Optional.ofNullable(clazz.cast(this.instanceEventWindowId()));
            }
            case "TimeRanges": {
                return Optional.ofNullable(clazz.cast(this.timeRanges()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CronExpression": {
                return Optional.ofNullable(clazz.cast(this.cronExpression()));
            }
            case "AssociationTarget": {
                return Optional.ofNullable(clazz.cast(this.associationTarget()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceEventWindowId", INSTANCE_EVENT_WINDOW_ID_FIELD);
        map.put("TimeRangeSet", TIME_RANGES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CronExpression", CRON_EXPRESSION_FIELD);
        map.put("AssociationTarget", ASSOCIATION_TARGET_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindow, T> g) {
        return obj -> g.apply((InstanceEventWindow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceEventWindowId;
        private List<InstanceEventWindowTimeRange> timeRanges = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String cronExpression;
        private InstanceEventWindowAssociationTarget associationTarget;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindow model) {
            this.instanceEventWindowId(model.instanceEventWindowId);
            this.timeRanges(model.timeRanges);
            this.name(model.name);
            this.cronExpression(model.cronExpression);
            this.associationTarget(model.associationTarget);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getInstanceEventWindowId() {
            return this.instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final List<InstanceEventWindowTimeRange.Builder> getTimeRanges() {
            List<InstanceEventWindowTimeRange.Builder> result = InstanceEventWindowTimeRangeListCopier.copyToBuilder(this.timeRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeRanges(Collection<InstanceEventWindowTimeRange.BuilderImpl> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeListCopier.copyFromBuilder(timeRanges);
        }

        @Override
        public final Builder timeRanges(Collection<InstanceEventWindowTimeRange> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeListCopier.copy(timeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(InstanceEventWindowTimeRange ... timeRanges) {
            this.timeRanges(Arrays.asList(timeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(Consumer<InstanceEventWindowTimeRange.Builder> ... timeRanges) {
            this.timeRanges(Stream.of(timeRanges).map(c -> (InstanceEventWindowTimeRange)((InstanceEventWindowTimeRange.Builder)InstanceEventWindowTimeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCronExpression() {
            return this.cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final InstanceEventWindowAssociationTarget.Builder getAssociationTarget() {
            return this.associationTarget != null ? this.associationTarget.toBuilder() : null;
        }

        public final void setAssociationTarget(InstanceEventWindowAssociationTarget.BuilderImpl associationTarget) {
            this.associationTarget = associationTarget != null ? associationTarget.build() : null;
        }

        @Override
        public final Builder associationTarget(InstanceEventWindowAssociationTarget associationTarget) {
            this.associationTarget = associationTarget;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceEventWindowState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InstanceEventWindow build() {
            return new InstanceEventWindow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceEventWindow> {
        public Builder instanceEventWindowId(String var1);

        public Builder timeRanges(Collection<InstanceEventWindowTimeRange> var1);

        public Builder timeRanges(InstanceEventWindowTimeRange ... var1);

        public Builder timeRanges(Consumer<InstanceEventWindowTimeRange.Builder> ... var1);

        public Builder name(String var1);

        public Builder cronExpression(String var1);

        public Builder associationTarget(InstanceEventWindowAssociationTarget var1);

        default public Builder associationTarget(Consumer<InstanceEventWindowAssociationTarget.Builder> associationTarget) {
            return this.associationTarget((InstanceEventWindowAssociationTarget)((InstanceEventWindowAssociationTarget.Builder)InstanceEventWindowAssociationTarget.builder().applyMutation(associationTarget)).build());
        }

        public Builder state(String var1);

        public Builder state(InstanceEventWindowState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

