/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnassignPrivateNatGatewayAddressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, UnassignPrivateNatGatewayAddressRequest> {
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(UnassignPrivateNatGatewayAddressRequest.getter(UnassignPrivateNatGatewayAddressRequest::natGatewayId)).setter(UnassignPrivateNatGatewayAddressRequest.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("NatGatewayId").build()}).build();
    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(UnassignPrivateNatGatewayAddressRequest.getter(UnassignPrivateNatGatewayAddressRequest::privateIpAddresses)).setter(UnassignPrivateNatGatewayAddressRequest.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_DRAIN_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDrainDurationSeconds").getter(UnassignPrivateNatGatewayAddressRequest.getter(UnassignPrivateNatGatewayAddressRequest::maxDrainDurationSeconds)).setter(UnassignPrivateNatGatewayAddressRequest.setter(Builder::maxDrainDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDrainDurationSeconds").unmarshallLocationName("MaxDrainDurationSeconds").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(UnassignPrivateNatGatewayAddressRequest.getter(UnassignPrivateNatGatewayAddressRequest::dryRun)).setter(UnassignPrivateNatGatewayAddressRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAT_GATEWAY_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD, MAX_DRAIN_DURATION_SECONDS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnassignPrivateNatGatewayAddressRequest.memberNameToFieldInitializer();
    private final String natGatewayId;
    private final List<String> privateIpAddresses;
    private final Integer maxDrainDurationSeconds;
    private final Boolean dryRun;

    private UnassignPrivateNatGatewayAddressRequest(BuilderImpl builder) {
        super(builder);
        this.natGatewayId = builder.natGatewayId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.maxDrainDurationSeconds = builder.maxDrainDurationSeconds;
        this.dryRun = builder.dryRun;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Integer maxDrainDurationSeconds() {
        return this.maxDrainDurationSeconds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDrainDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignPrivateNatGatewayAddressRequest)) {
            return false;
        }
        UnassignPrivateNatGatewayAddressRequest other = (UnassignPrivateNatGatewayAddressRequest)((Object)obj);
        return Objects.equals(this.natGatewayId(), other.natGatewayId()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.maxDrainDurationSeconds(), other.maxDrainDurationSeconds()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"UnassignPrivateNatGatewayAddressRequest").add("NatGatewayId", (Object)this.natGatewayId()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("MaxDrainDurationSeconds", (Object)this.maxDrainDurationSeconds()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "MaxDrainDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxDrainDurationSeconds()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NatGatewayId", NAT_GATEWAY_ID_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("MaxDrainDurationSeconds", MAX_DRAIN_DURATION_SECONDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnassignPrivateNatGatewayAddressRequest, T> g) {
        return obj -> g.apply((UnassignPrivateNatGatewayAddressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String natGatewayId;
        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer maxDrainDurationSeconds;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignPrivateNatGatewayAddressRequest model) {
            super(model);
            this.natGatewayId(model.natGatewayId);
            this.privateIpAddresses(model.privateIpAddresses);
            this.maxDrainDurationSeconds(model.maxDrainDurationSeconds);
            this.dryRun(model.dryRun);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final Collection<String> getPrivateIpAddresses() {
            if (this.privateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.privateIpAddresses;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = IpListCopier.copy(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = IpListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final Integer getMaxDrainDurationSeconds() {
            return this.maxDrainDurationSeconds;
        }

        public final void setMaxDrainDurationSeconds(Integer maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
        }

        @Override
        public final Builder maxDrainDurationSeconds(Integer maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnassignPrivateNatGatewayAddressRequest build() {
            return new UnassignPrivateNatGatewayAddressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UnassignPrivateNatGatewayAddressRequest> {
        public Builder natGatewayId(String var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder maxDrainDurationSeconds(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

