/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteRouteRequest> {
    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPrefixListId").getter(DeleteRouteRequest.getter(DeleteRouteRequest::destinationPrefixListId)).setter(DeleteRouteRequest.setter(Builder::destinationPrefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").unmarshallLocationName("DestinationPrefixListId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteRouteRequest.getter(DeleteRouteRequest::dryRun)).setter(DeleteRouteRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(DeleteRouteRequest.getter(DeleteRouteRequest::routeTableId)).setter(DeleteRouteRequest.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("routeTableId").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(DeleteRouteRequest.getter(DeleteRouteRequest::destinationCidrBlock)).setter(DeleteRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIpv6CidrBlock").getter(DeleteRouteRequest.getter(DeleteRouteRequest::destinationIpv6CidrBlock)).setter(DeleteRouteRequest.setter(Builder::destinationIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").unmarshallLocationName("destinationIpv6CidrBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PREFIX_LIST_ID_FIELD, DRY_RUN_FIELD, ROUTE_TABLE_ID_FIELD, DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteRouteRequest.memberNameToFieldInitializer();
    private final String destinationPrefixListId;
    private final Boolean dryRun;
    private final String routeTableId;
    private final String destinationCidrBlock;
    private final String destinationIpv6CidrBlock;

    private DeleteRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.dryRun = builder.dryRun;
        this.routeTableId = builder.routeTableId;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
    }

    public final String destinationPrefixListId() {
        return this.destinationPrefixListId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteRequest)) {
            return false;
        }
        DeleteRouteRequest other = (DeleteRouteRequest)((Object)obj);
        return Objects.equals(this.destinationPrefixListId(), other.destinationPrefixListId()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRouteRequest").add("DestinationPrefixListId", (Object)this.destinationPrefixListId()).add("DryRun", (Object)this.dryRun()).add("RouteTableId", (Object)this.routeTableId()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPrefixListId": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixListId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationIpv6CidrBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationPrefixListId", DESTINATION_PREFIX_LIST_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("DestinationIpv6CidrBlock", DESTINATION_IPV6_CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteRequest, T> g) {
        return obj -> g.apply((DeleteRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationPrefixListId;
        private Boolean dryRun;
        private String routeTableId;
        private String destinationCidrBlock;
        private String destinationIpv6CidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteRequest model) {
            super(model);
            this.destinationPrefixListId(model.destinationPrefixListId);
            this.dryRun(model.dryRun);
            this.routeTableId(model.routeTableId);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
        }

        public final String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteRequest build() {
            return new DeleteRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRouteRequest> {
        public Builder destinationPrefixListId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder routeTableId(String var1);

        public Builder destinationCidrBlock(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

