/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping, which defines the EBS volumes and instance store volumes to attach to an instance
 * at launch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockDeviceMappingResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockDeviceMappingResponse.Builder, BlockDeviceMappingResponse> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceName")
            .getter(getter(BlockDeviceMappingResponse::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName")
                    .unmarshallLocationName("deviceName").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VirtualName")
            .getter(getter(BlockDeviceMappingResponse::virtualName))
            .setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName")
                    .unmarshallLocationName("virtualName").build()).build();

    private static final SdkField<EbsBlockDeviceResponse> EBS_FIELD = SdkField
            .<EbsBlockDeviceResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Ebs")
            .getter(getter(BlockDeviceMappingResponse::ebs))
            .setter(setter(Builder::ebs))
            .constructor(EbsBlockDeviceResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").unmarshallLocationName("ebs")
                    .build()).build();

    private static final SdkField<String> NO_DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NoDevice")
            .getter(getter(BlockDeviceMappingResponse::noDevice))
            .setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice")
                    .unmarshallLocationName("noDevice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            VIRTUAL_NAME_FIELD, EBS_FIELD, NO_DEVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String virtualName;

    private final EbsBlockDeviceResponse ebs;

    private final String noDevice;

    private BlockDeviceMappingResponse(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    /**
     * <p>
     * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The virtual device name.
     * </p>
     * 
     * @return The virtual device name.
     */
    public final String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     * </p>
     * 
     * @return Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    public final EbsBlockDeviceResponse ebs() {
        return ebs;
    }

    /**
     * <p>
     * Suppresses the specified device included in the block device mapping.
     * </p>
     * 
     * @return Suppresses the specified device included in the block device mapping.
     */
    public final String noDevice() {
        return noDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMappingResponse)) {
            return false;
        }
        BlockDeviceMappingResponse other = (BlockDeviceMappingResponse) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(virtualName(), other.virtualName())
                && Objects.equals(ebs(), other.ebs()) && Objects.equals(noDevice(), other.noDevice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockDeviceMappingResponse").add("DeviceName", deviceName()).add("VirtualName", virtualName())
                .add("Ebs", ebs()).add("NoDevice", noDevice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("VirtualName", VIRTUAL_NAME_FIELD);
        map.put("Ebs", EBS_FIELD);
        map.put("NoDevice", NO_DEVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockDeviceMappingResponse, T> g) {
        return obj -> g.apply((BlockDeviceMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockDeviceMappingResponse> {
        /**
         * <p>
         * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The virtual device name.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up EBS volumes when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsBlockDeviceResponse ebs);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * This is a convenience method that creates an instance of the {@link EbsBlockDeviceResponse.Builder} avoiding
         * the need to create one manually via {@link EbsBlockDeviceResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EbsBlockDeviceResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #ebs(EbsBlockDeviceResponse)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsBlockDeviceResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsBlockDeviceResponse)
         */
        default Builder ebs(Consumer<EbsBlockDeviceResponse.Builder> ebs) {
            return ebs(EbsBlockDeviceResponse.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * Suppresses the specified device included in the block device mapping.
         * </p>
         * 
         * @param noDevice
         *        Suppresses the specified device included in the block device mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String virtualName;

        private EbsBlockDeviceResponse ebs;

        private String noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMappingResponse model) {
            deviceName(model.deviceName);
            virtualName(model.virtualName);
            ebs(model.ebs);
            noDevice(model.noDevice);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final EbsBlockDeviceResponse.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        public final void setEbs(EbsBlockDeviceResponse.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDeviceResponse ebs) {
            this.ebs = ebs;
            return this;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        @Override
        public BlockDeviceMappingResponse build() {
            return new BlockDeviceMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
