/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the network interface options when creating an Amazon Web Services Verified Access endpoint using the
 * <code>network-interface</code> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVerifiedAccessEndpointEniOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateVerifiedAccessEndpointEniOptions.Builder, CreateVerifiedAccessEndpointEniOptions> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(CreateVerifiedAccessEndpointEniOptions::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("NetworkInterfaceId").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(CreateVerifiedAccessEndpointEniOptions::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Port")
            .getter(getter(CreateVerifiedAccessEndpointEniOptions::port))
            .setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port")
                    .unmarshallLocationName("Port").build()).build();

    private static final SdkField<List<CreateVerifiedAccessEndpointPortRange>> PORT_RANGES_FIELD = SdkField
            .<List<CreateVerifiedAccessEndpointPortRange>> builder(MarshallingType.LIST)
            .memberName("PortRanges")
            .getter(getter(CreateVerifiedAccessEndpointEniOptions::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange")
                    .unmarshallLocationName("PortRange").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CreateVerifiedAccessEndpointPortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateVerifiedAccessEndpointPortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD,
            PROTOCOL_FIELD, PORT_FIELD, PORT_RANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String networkInterfaceId;

    private final String protocol;

    private final Integer port;

    private final List<CreateVerifiedAccessEndpointPortRange> portRanges;

    private CreateVerifiedAccessEndpointEniOptions(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.portRanges = builder.portRanges;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The IP protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VerifiedAccessEndpointProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The IP protocol.
     * @see VerifiedAccessEndpointProtocol
     */
    public final VerifiedAccessEndpointProtocol protocol() {
        return VerifiedAccessEndpointProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The IP protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link VerifiedAccessEndpointProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The IP protocol.
     * @see VerifiedAccessEndpointProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The IP port number.
     * </p>
     * 
     * @return The IP port number.
     */
    public final Integer port() {
        return port;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRanges} method.
     * </p>
     * 
     * @return The port ranges.
     */
    public final List<CreateVerifiedAccessEndpointPortRange> portRanges() {
        return portRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessEndpointEniOptions)) {
            return false;
        }
        CreateVerifiedAccessEndpointEniOptions other = (CreateVerifiedAccessEndpointEniOptions) obj;
        return Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(port(), other.port())
                && hasPortRanges() == other.hasPortRanges() && Objects.equals(portRanges(), other.portRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVerifiedAccessEndpointEniOptions").add("NetworkInterfaceId", networkInterfaceId())
                .add("Protocol", protocolAsString()).add("Port", port()).add("PortRanges", hasPortRanges() ? portRanges() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "PortRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("PortRange", PORT_RANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVerifiedAccessEndpointEniOptions, T> g) {
        return obj -> g.apply((CreateVerifiedAccessEndpointEniOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateVerifiedAccessEndpointEniOptions> {
        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IP protocol.
         * </p>
         * 
         * @param protocol
         *        The IP protocol.
         * @see VerifiedAccessEndpointProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifiedAccessEndpointProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The IP protocol.
         * </p>
         * 
         * @param protocol
         *        The IP protocol.
         * @see VerifiedAccessEndpointProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerifiedAccessEndpointProtocol
         */
        Builder protocol(VerifiedAccessEndpointProtocol protocol);

        /**
         * <p>
         * The IP port number.
         * </p>
         * 
         * @param port
         *        The IP port number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The port ranges.
         * </p>
         * 
         * @param portRanges
         *        The port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<CreateVerifiedAccessEndpointPortRange> portRanges);

        /**
         * <p>
         * The port ranges.
         * </p>
         * 
         * @param portRanges
         *        The port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(CreateVerifiedAccessEndpointPortRange... portRanges);

        /**
         * <p>
         * The port ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRange.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRange.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #portRanges(List<CreateVerifiedAccessEndpointPortRange>)}.
         * 
         * @param portRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRanges(java.util.Collection<CreateVerifiedAccessEndpointPortRange>)
         */
        Builder portRanges(Consumer<CreateVerifiedAccessEndpointPortRange.Builder>... portRanges);
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfaceId;

        private String protocol;

        private Integer port;

        private List<CreateVerifiedAccessEndpointPortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVerifiedAccessEndpointEniOptions model) {
            networkInterfaceId(model.networkInterfaceId);
            protocol(model.protocol);
            port(model.port);
            portRanges(model.portRanges);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(VerifiedAccessEndpointProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final List<CreateVerifiedAccessEndpointPortRange.Builder> getPortRanges() {
            List<CreateVerifiedAccessEndpointPortRange.Builder> result = CreateVerifiedAccessEndpointPortRangeListCopier
                    .copyToBuilder(this.portRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortRanges(Collection<CreateVerifiedAccessEndpointPortRange.BuilderImpl> portRanges) {
            this.portRanges = CreateVerifiedAccessEndpointPortRangeListCopier.copyFromBuilder(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<CreateVerifiedAccessEndpointPortRange> portRanges) {
            this.portRanges = CreateVerifiedAccessEndpointPortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(CreateVerifiedAccessEndpointPortRange... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<CreateVerifiedAccessEndpointPortRange.Builder>... portRanges) {
            portRanges(Stream.of(portRanges).map(c -> CreateVerifiedAccessEndpointPortRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateVerifiedAccessEndpointEniOptions build() {
            return new CreateVerifiedAccessEndpointEniOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
